/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.I2PSocketAddress;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.socks.SOCKSHeader;
import net.i2p.i2ptunnel.udp.Sink;
import net.i2p.i2ptunnel.udp.Source;
import net.i2p.util.Log;

public class SOCKSUDPWrapper
implements Source,
Sink {
    private Sink sink;
    private final Map<I2PSocketAddress, SOCKSHeader> cache;

    public SOCKSUDPWrapper(Map<I2PSocketAddress, SOCKSHeader> cache) {
        this.cache = cache;
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
    }

    @Override
    public void start() {
    }

    @Override
    public void send(Destination from, int fromPort, int toPort, byte[] data) {
        if (this.sink == null) {
            return;
        }
        if (from == null) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(SOCKSUDPWrapper.class);
            if (log.shouldWarn()) {
                log.warn("No support for raw datagrams, from port " + fromPort + " to port " + toPort);
            }
            return;
        }
        SOCKSHeader h = this.cache.get(new I2PSocketAddress(from, fromPort));
        if (h == null) {
            return;
        }
        byte[] header = h.getBytes();
        byte[] wrapped = new byte[header.length + data.length];
        System.arraycopy(header, 0, wrapped, 0, header.length);
        System.arraycopy(data, 0, wrapped, header.length, data.length);
        this.sink.send(from, fromPort, toPort, wrapped);
    }
}

