/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;

public class HuabaoFrameEncoder
extends MessageToByteEncoder<ByteBuf> {
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) {
        boolean alternative = msg.getUnsignedByte(msg.readerIndex()) == 231;
        int startIndex = msg.readerIndex();
        while (msg.isReadable()) {
            int index = msg.readerIndex();
            short b = msg.readUnsignedByte();
            if (alternative && (b == 230 || b == 61 || b == 62)) {
                out.writeByte(b == 230 ? 230 : 62);
                out.writeByte(b == 61 ? 2 : 1);
                continue;
            }
            if (alternative && b == 231 && index != startIndex && msg.isReadable()) {
                out.writeByte(230);
                out.writeByte(2);
                continue;
            }
            if (!alternative && b == 125) {
                out.writeByte(125);
                out.writeByte(1);
                continue;
            }
            if (!alternative && b == 126 && index != startIndex && msg.isReadable()) {
                out.writeByte(125);
                out.writeByte(2);
                continue;
            }
            out.writeByte((int)b);
        }
    }
}

