/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SchemaRegistry;
import com.networknt.schema.SchemaRegistryConfig;
import com.networknt.schema.dialect.Dialect;
import com.networknt.schema.keyword.KeywordValidator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SchemaContext {
    private final Dialect dialect;
    private final SchemaRegistry schemaRegistry;
    private final ConcurrentMap<String, Schema> schemaReferences;
    private final ConcurrentMap<String, Schema> schemaResources;
    private final ConcurrentMap<String, Schema> dynamicAnchors;
    private final boolean discriminatorKeywordEnabled;
    private final boolean nullableKeywordEnabled;

    public SchemaContext(Dialect dialect, SchemaRegistry schemaRegistry) {
        this(dialect, schemaRegistry, new ConcurrentHashMap<String, Schema>(), new ConcurrentHashMap<String, Schema>(), new ConcurrentHashMap<String, Schema>());
    }

    public SchemaContext(Dialect dialect, SchemaRegistry schemaRegistry, ConcurrentMap<String, Schema> schemaReferences, ConcurrentMap<String, Schema> schemaResources, ConcurrentMap<String, Schema> dynamicAnchors) {
        if (dialect == null) {
            throw new IllegalArgumentException("Dialect must not be null");
        }
        if (schemaRegistry == null) {
            throw new IllegalArgumentException("SchemaRegistry must not be null");
        }
        this.dialect = dialect;
        this.schemaRegistry = schemaRegistry;
        this.schemaReferences = schemaReferences;
        this.schemaResources = schemaResources;
        this.dynamicAnchors = dynamicAnchors;
        this.discriminatorKeywordEnabled = dialect.getKeywords().containsKey("discriminator");
        this.nullableKeywordEnabled = dialect.getKeywords().containsKey("nullable");
    }

    public Schema newSchema(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema) {
        return this.getSchemaRegistry().create(this, schemaLocation, schemaNode, parentSchema);
    }

    public KeywordValidator newValidator(SchemaLocation schemaLocation, String keyword, JsonNode schemaNode, Schema parentSchema) {
        return this.dialect.newValidator(this, schemaLocation, keyword, schemaNode, parentSchema);
    }

    public String resolveSchemaId(JsonNode schemaNode) {
        return this.dialect.readId(schemaNode);
    }

    public SchemaRegistry getSchemaRegistry() {
        return this.schemaRegistry;
    }

    public SchemaRegistryConfig getSchemaRegistryConfig() {
        return this.schemaRegistry.getSchemaRegistryConfig();
    }

    public ConcurrentMap<String, Schema> getSchemaReferences() {
        return this.schemaReferences;
    }

    public ConcurrentMap<String, Schema> getSchemaResources() {
        return this.schemaResources;
    }

    public ConcurrentMap<String, Schema> getDynamicAnchors() {
        return this.dynamicAnchors;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public boolean isDiscriminatorKeywordEnabled() {
        return this.discriminatorKeywordEnabled;
    }

    public boolean isNullableKeywordEnabled() {
        return this.nullableKeywordEnabled;
    }
}

