/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.callback.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.AbstractPanel;
import org.zaproxy.zap.extension.callback.ExtensionCallback;
import org.zaproxy.zap.extension.callback.ui.CallbackRequest;
import org.zaproxy.zap.extension.callback.ui.CallbackTable;
import org.zaproxy.zap.extension.callback.ui.CallbackTableModel;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.FontUtils;

@Deprecated
public class CallbackPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    private JToolBar mainToolBar;
    private JPanel mainPanel = null;
    private JScrollPane scrollPane = null;
    private CallbackTable resultsTable = null;
    private CallbackTableModel model = null;
    private ExtensionCallback extensionCallback;

    public CallbackPanel(ExtensionCallback extensionCallback) {
        this.extensionCallback = extensionCallback;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("callback.panel.name"));
        this.setIcon(new ImageIcon(CallbackPanel.class.getResource("/resource/icon/16/callbacks.png")));
        this.add((Component)this.getMainPanel(), this.getMainPanel().getName());
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new BorderLayout());
            this.mainPanel.setName("CallbackPanel");
            this.mainPanel.add((Component)this.getToolBar(), "First");
            this.mainPanel.add((Component)this.getJScrollPane(), "Center");
        }
        return this.mainPanel;
    }

    private JToolBar getToolBar() {
        if (this.mainToolBar == null) {
            this.mainToolBar = new JToolBar();
            this.mainToolBar.setEnabled(true);
            this.mainToolBar.setFloatable(false);
            this.mainToolBar.setRollover(true);
            this.mainToolBar.setName("Callback Toolbar");
            this.mainToolBar.add(this.getClearButton());
            this.mainToolBar.add(Box.createHorizontalGlue());
            this.mainToolBar.add(this.getOptionsButton());
        }
        return this.mainToolBar;
    }

    private JButton getClearButton() {
        JButton clearButton = new JButton(Constant.messages.getString("callback.panel.clear.button.label"));
        clearButton.setToolTipText(Constant.messages.getString("callback.panel.clear.button.toolTip"));
        clearButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(CallbackPanel.class.getResource("/resource/icon/fugue/broom.png"))));
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CallbackPanel.this.deleteAllCallbacks();
            }
        });
        return clearButton;
    }

    private void deleteAllCallbacks() {
        this.extensionCallback.deleteCallbacks();
    }

    private JButton getOptionsButton() {
        JButton optionsButton = new JButton();
        optionsButton.setToolTipText(Constant.messages.getString("callback.panel.options.button.label"));
        optionsButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(CallbackPanel.class.getResource("/resource/icon/16/041.png"))));
        optionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Control.getSingleton().getMenuToolsControl().options(Constant.messages.getString("callback.options.title"));
            }
        });
        return optionsButton;
    }

    private JScrollPane getJScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setFont(FontUtils.getFont("Dialog"));
            this.scrollPane.setHorizontalScrollBarPolicy(30);
            this.scrollPane.setViewportView((Component)((Object)this.getResultsTable()));
        }
        return this.scrollPane;
    }

    private CallbackTable getResultsTable() {
        if (this.resultsTable == null) {
            this.model = new CallbackTableModel();
            this.resultsTable = new CallbackTable(this.model);
        }
        return this.resultsTable;
    }

    public void addCallbackRequest(CallbackRequest callbackRequest) {
        this.model.addEntry(callbackRequest);
    }

    public void clearCallbackRequests() {
        this.model.clear();
    }
}

