/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.ui.GradientPaintTransformer;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.StandardGradientPaintTransformer;
import org.jfree.chart.util.Args;
import org.jfree.data.xy.XYDataset;

public class XYBezierRenderer
extends XYLineAndShapeRenderer {
    private int precision;
    private double tension;
    private FillType fillType;
    private GradientPaintTransformer gradientPaintTransformer;

    public XYBezierRenderer() {
        this(5, 25.0, FillType.NONE);
    }

    public XYBezierRenderer(int precision, double tension) {
        this(precision, tension, FillType.NONE);
    }

    public XYBezierRenderer(int precision, double tension, FillType fillType) {
        if (precision <= 0) {
            throw new IllegalArgumentException("Requires precision > 0.");
        }
        if (tension <= 0.0) {
            throw new IllegalArgumentException("Requires precision > 0.");
        }
        Args.nullNotPermitted((Object)fillType, "fillType");
        this.precision = precision;
        this.tension = tension;
        this.fillType = fillType;
        this.gradientPaintTransformer = new StandardGradientPaintTransformer();
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int p) {
        if (p <= 0) {
            throw new IllegalArgumentException("Requires p > 0.");
        }
        this.precision = p;
        this.fireChangeEvent();
    }

    public double getTension() {
        return this.tension;
    }

    public void setTension(double t) {
        if (t <= 0.0) {
            throw new IllegalArgumentException("Requires tension > 0.");
        }
        this.tension = t;
        this.fireChangeEvent();
    }

    public FillType getFillType() {
        return this.fillType;
    }

    public void setFillType(FillType fillType) {
        this.fillType = fillType;
        this.fireChangeEvent();
    }

    public GradientPaintTransformer getGradientPaintTransformer() {
        return this.gradientPaintTransformer;
    }

    public void setGradientPaintTransformer(GradientPaintTransformer gpt) {
        this.gradientPaintTransformer = gpt;
        this.fireChangeEvent();
    }

    @Override
    public XYItemRendererState initialise(Graphics2D g2, Rectangle2D dataArea, XYPlot plot, XYDataset data, PlotRenderingInfo info) {
        this.setDrawSeriesLineAsPath(true);
        XYBezierState state = new XYBezierState(info);
        state.setProcessVisibleItemsOnly(false);
        return state;
    }

    @Override
    protected void drawPrimaryLineAsPath(XYItemRendererState state, Graphics2D g2, XYPlot plot, XYDataset dataset, int pass, int series, int item, ValueAxis xAxis, ValueAxis yAxis, Rectangle2D dataArea) {
        XYBezierState s = (XYBezierState)state;
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double x1 = dataset.getXValue(series, item);
        double y1 = dataset.getYValue(series, item);
        double transX1 = xAxis.valueToJava2D(x1, dataArea, xAxisLocation);
        double transY1 = yAxis.valueToJava2D(y1, dataArea, yAxisLocation);
        if (!Double.isNaN(transX1) && !Double.isNaN(transY1)) {
            Point2D.Float p;
            Point2D.Float float_ = p = plot.getOrientation() == PlotOrientation.HORIZONTAL ? new Point2D.Float((float)transY1, (float)transX1) : new Point2D.Float((float)transX1, (float)transY1);
            if (!s.points.contains(p)) {
                s.points.add(p);
            }
        }
        if (item == dataset.getItemCount(series) - 1) {
            if (s.points.size() > 1) {
                Point2D.Float origin;
                if (this.fillType == FillType.TO_ZERO) {
                    float xz = (float)xAxis.valueToJava2D(0.0, dataArea, yAxisLocation);
                    float yz = (float)yAxis.valueToJava2D(0.0, dataArea, yAxisLocation);
                    origin = plot.getOrientation() == PlotOrientation.HORIZONTAL ? new Point2D.Float(yz, xz) : new Point2D.Float(xz, yz);
                } else if (this.fillType == FillType.TO_LOWER_BOUND) {
                    float xlb = (float)xAxis.valueToJava2D(xAxis.getLowerBound(), dataArea, xAxisLocation);
                    float ylb = (float)yAxis.valueToJava2D(yAxis.getLowerBound(), dataArea, yAxisLocation);
                    origin = plot.getOrientation() == PlotOrientation.HORIZONTAL ? new Point2D.Float(ylb, xlb) : new Point2D.Float(xlb, ylb);
                } else {
                    float xub = (float)xAxis.valueToJava2D(xAxis.getUpperBound(), dataArea, xAxisLocation);
                    float yub = (float)yAxis.valueToJava2D(yAxis.getUpperBound(), dataArea, yAxisLocation);
                    origin = plot.getOrientation() == PlotOrientation.HORIZONTAL ? new Point2D.Float(yub, xub) : new Point2D.Float(xub, yub);
                }
                Point2D cp0 = s.points.get(0);
                s.seriesPath.moveTo(cp0.getX(), cp0.getY());
                if (this.fillType != FillType.NONE) {
                    if (plot.getOrientation() == PlotOrientation.HORIZONTAL) {
                        s.fillArea.moveTo(((Point2D)origin).getX(), cp0.getY());
                    } else {
                        s.fillArea.moveTo(cp0.getX(), ((Point2D)origin).getY());
                    }
                    s.fillArea.lineTo(cp0.getX(), cp0.getY());
                }
                if (s.points.size() == 2) {
                    Point2D cp1 = s.points.get(1);
                    if (this.fillType != FillType.NONE) {
                        s.fillArea.lineTo(cp1.getX(), cp1.getY());
                        s.fillArea.lineTo(cp1.getX(), ((Point2D)origin).getY());
                        s.fillArea.closePath();
                    }
                    s.seriesPath.lineTo(cp1.getX(), cp1.getY());
                } else if (s.points.size() == 3) {
                    Point2D[] pInitial = this.getInitalPoints(s);
                    this.addBezierPointsToSeriesPath(pInitial, s);
                    Point2D[] pFinal = this.getFinalPoints(s);
                    this.addBezierPointsToSeriesPath(pFinal, s);
                } else {
                    int np = s.points.size();
                    for (int i = 0; i < np - 1; ++i) {
                        if (i == 0) {
                            Point2D[] initial3Points = new Point2D[]{s.points.get(0), s.points.get(1), s.points.get(2)};
                            Point2D[] pInitial = this.calcSegmentPointsInitial(initial3Points);
                            this.addBezierPointsToSeriesPath(pInitial, s);
                        }
                        if (i == np - 2) {
                            Point2D[] final3Points = new Point2D[4];
                            final3Points[1] = s.points.get(np - 3);
                            final3Points[2] = s.points.get(np - 2);
                            final3Points[3] = s.points.get(np - 1);
                            Point2D[] pFinal = this.calcSegmentPointsFinal(final3Points);
                            this.addBezierPointsToSeriesPath(pFinal, s);
                        }
                        if (i == 0 || i == np - 2) continue;
                        Point2D[] original4Points = new Point2D[]{s.points.get(i - 1), s.points.get(i), s.points.get(i + 1), s.points.get(i + 2)};
                        Point2D[] pMedium = this.calculateSegmentPoints(original4Points);
                        this.addBezierPointsToSeriesPath(pMedium, s);
                    }
                }
                if (this.fillType != FillType.NONE) {
                    if (plot.getOrientation() == PlotOrientation.HORIZONTAL) {
                        s.fillArea.lineTo(((Point2D)origin).getX(), s.points.get(s.points.size() - 1).getY());
                    } else {
                        s.fillArea.lineTo(s.points.get(s.points.size() - 1).getX(), ((Point2D)origin).getY());
                    }
                    s.fillArea.closePath();
                }
                if (this.fillType != FillType.NONE) {
                    Paint fp = this.getSeriesFillPaint(series);
                    if (this.gradientPaintTransformer != null && fp instanceof GradientPaint) {
                        GradientPaint gp = this.gradientPaintTransformer.transform((GradientPaint)fp, s.fillArea);
                        g2.setPaint(gp);
                    } else {
                        g2.setPaint(fp);
                    }
                    g2.fill(s.fillArea);
                    s.fillArea.reset();
                }
                this.drawFirstPassShape(g2, pass, series, item, s.seriesPath);
            }
            s.points = new ArrayList<Point2D>();
        }
    }

    private void addBezierPointsToSeriesPath(Point2D[] segmentPoints, XYBezierState s) {
        for (int t = 0; t <= this.precision; ++t) {
            double k = (double)t / (double)this.precision;
            double r = 1.0 - k;
            double x = Math.pow(r, 3.0) * segmentPoints[0].getX() + 3.0 * k * Math.pow(r, 2.0) * segmentPoints[1].getX() + 3.0 * Math.pow(k, 2.0) * (1.0 - k) * segmentPoints[2].getX() + Math.pow(k, 3.0) * segmentPoints[3].getX();
            double y = Math.pow(r, 3.0) * segmentPoints[0].getY() + 3.0 * k * Math.pow(r, 2.0) * segmentPoints[1].getY() + 3.0 * Math.pow(k, 2.0) * (1.0 - k) * segmentPoints[2].getY() + Math.pow(k, 3.0) * segmentPoints[3].getY();
            s.seriesPath.lineTo(x, y);
            if (this.fillType == FillType.NONE) continue;
            s.fillArea.lineTo(x, y);
        }
    }

    private Point2D[] getFinalPoints(XYBezierState s) {
        Point2D[] final3Points = new Point2D[4];
        final3Points[1] = s.points.get(0);
        final3Points[2] = s.points.get(1);
        final3Points[3] = s.points.get(2);
        Point2D[] pFinal = this.calcSegmentPointsFinal(final3Points);
        return pFinal;
    }

    private Point2D[] getInitalPoints(XYBezierState s) {
        Point2D[] initial3Points = new Point2D[]{s.points.get(0), s.points.get(1), s.points.get(2)};
        Point2D[] pInitial = this.calcSegmentPointsInitial(initial3Points);
        return pInitial;
    }

    private Point2D[] calculateSegmentPoints(Point2D[] original4Points) {
        Point2D[] points = new Point2D[4];
        points[0] = original4Points[1];
        points[3] = original4Points[2];
        for (int i = 1; i < 3; ++i) {
            Point2D aux1 = this.calcUnitaryVector(original4Points[i - 1], original4Points[i]);
            Point2D aux2 = this.calcUnitaryVector(original4Points[i + 1], original4Points[i]);
            Point2D aux3 = this.calcUnitaryVector(aux2, aux1);
            double x = original4Points[i].getX() + Math.pow(-1.0, i + 1) * this.tension * aux3.getX();
            double y = original4Points[i].getY() + Math.pow(-1.0, i + 1) * this.tension * aux3.getY();
            points[i] = new Point2D.Double(x, y);
        }
        return points;
    }

    private Point2D[] calcSegmentPointsInitial(Point2D[] original3P) {
        Point2D[] points = new Point2D[4];
        points[0] = original3P[0];
        points[3] = original3P[1];
        Point2D auxInitial = this.calcUnitaryVector(original3P[0], original3P[1]);
        points[1] = original3P[0];
        Point2D aux2 = this.calcUnitaryVector(original3P[2], original3P[1]);
        Point2D aux3 = this.calcUnitaryVector(auxInitial, aux2);
        double x = original3P[1].getX() + this.tension * aux3.getX();
        double y = original3P[1].getY() + this.tension * aux3.getY();
        points[2] = new Point2D.Double(x, y);
        return points;
    }

    private Point2D[] calcSegmentPointsFinal(Point2D[] original3P) {
        Point2D[] points = new Point2D[4];
        points[0] = original3P[2];
        points[3] = original3P[3];
        Point2D auxInitial = this.calcUnitaryVector(original3P[3], original3P[2]);
        points[2] = original3P[3];
        Point2D aux1 = this.calcUnitaryVector(original3P[3], original3P[2]);
        Point2D aux2 = this.calcUnitaryVector(original3P[1], original3P[2]);
        Point2D aux3 = this.calcUnitaryVector(aux1, aux2);
        double x = original3P[2].getX() + this.tension * aux3.getX();
        double y = original3P[2].getY() + this.tension * aux3.getY();
        points[1] = new Point2D.Double(x, y);
        return points;
    }

    private Point2D calcUnitaryVector(Point2D pOrigin, Point2D pEnd) {
        double module = Math.sqrt(Math.pow(pEnd.getX() - pOrigin.getX(), 2.0) + Math.pow(pEnd.getY() - pOrigin.getY(), 2.0));
        if (module == 0.0) {
            return null;
        }
        return new Point2D.Double((pEnd.getX() - pOrigin.getX()) / module, (pEnd.getY() - pOrigin.getY()) / module);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYBezierRenderer)) {
            return false;
        }
        XYBezierRenderer that = (XYBezierRenderer)obj;
        if (this.precision != that.precision) {
            return false;
        }
        if (this.fillType != that.fillType) {
            return false;
        }
        if (!Objects.equals(this.gradientPaintTransformer, that.gradientPaintTransformer)) {
            return false;
        }
        return super.equals(obj);
    }

    public static enum FillType {
        NONE,
        TO_ZERO,
        TO_LOWER_BOUND,
        TO_UPPER_BOUND;

    }

    public static class XYBezierState
    extends XYLineAndShapeRenderer.State {
        public GeneralPath fillArea = new GeneralPath();
        public List<Point2D> points = new ArrayList<Point2D>();

        public XYBezierState(PlotRenderingInfo info) {
            super(info);
        }
    }
}

