/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.settings.wizards.impl;

import com.almworks.tracklink.settings.wizards.PatternSettingsWizard;
import com.almworks.tracklink.util.StringBundle;
import com.almworks.tracklink.util.Utils;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.MalformedURLException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JIRASettingsWizard
implements PatternSettingsWizard {
    @Override
    @Nullable
    public Pair<String, String> requestUser(@NotNull Component dialogInvoker) {
        if (dialogInvoker == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/almworks/tracklink/settings/wizards/impl/JIRASettingsWizard.requestUser must not be null");
        }
        JIRADialogWrapper jiraDialogWrapper = new JIRADialogWrapper(dialogInvoker);
        jiraDialogWrapper.show();
        if (jiraDialogWrapper.getExitCode() == 0) {
            try {
                return JIRASettingsWizard.createPatterns(jiraDialogWrapper.getURL(), jiraDialogWrapper.getProjectName());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Pair<String, String> createPatterns(String url) throws MalformedURLException {
        return JIRASettingsWizard.createPatterns(url, null);
    }

    private static Pair<String, String> createPatterns(String url, String projectName) throws MalformedURLException {
        String jiraURL = Utils.normalizeJIRAURL(url);
        String replacePattern = jiraURL + "browse/$1";
        String searchPattern = projectName != null ? "\\b(\\Q" + projectName + "\\E\\-\\d+)\\b" : "\\b(\\p{Upper}{2,}\\-\\d+)\\b";
        return Pair.create((Object)searchPattern, (Object)replacePattern);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getName() {
        String string = StringBundle.get("codelink.edit.jira.button", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/almworks/tracklink/settings/wizards/impl/JIRASettingsWizard.getName must not return null");
        }
        return string;
    }

    private static class JIRAForm {
        private JTextField myUrlTextField;
        private JTextField myProjectField;
        private JCheckBox myCheckBox;
        private JLabel myIconLabel;
        private JPanel myWholePanel;
        private JLabel myUrlLabel;
        private JButton myButton1;

        public JIRAForm() {
            this.$$$setupUI$$$();
            this.myIconLabel.setIcon(Messages.getQuestionIcon());
            this.myCheckBox.setSelected(false);
            this.myProjectField.setEnabled(false);
            this.myUrlLabel.setLabelFor(this.myUrlTextField);
            this.myCheckBox.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    JIRAForm.this.myProjectField.setEnabled(JIRAForm.this.myCheckBox.isSelected());
                }
            });
        }

        public String getURL() {
            return this.myUrlTextField.getText();
        }

        @Nullable
        public String getProjectName() {
            return this.myProjectField.isEnabled() && this.myProjectField.getText().length() > 0 ? this.myProjectField.getText() : null;
        }

        public JPanel getWholePanel() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JTextField jTextField;
            JLabel jLabel;
            JTextField jTextField2;
            JCheckBox jCheckBox;
            JLabel jLabel2;
            JPanel jPanel;
            this.myWholePanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myIconLabel = jLabel2 = new JLabel();
            jLabel2.setText("");
            jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 3, 0, 0, null, null, null));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myCheckBox = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("codelink.edit.jira.project"));
            jPanel4.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myProjectField = jTextField2 = new JTextField();
            jPanel4.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            JLabel jLabel3 = new JLabel();
            this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("codelink.edit.jira.helptext"));
            jPanel4.add((Component)jLabel3, new GridConstraints(1, 0, 1, 2, 8, 1, 0, 0, null, null, null));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel3.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myUrlLabel = jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/almworks/tracklink/util/StringBundle").getString("codelink.edit.jira.url"));
            jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myUrlTextField = jTextField = new JTextField();
            jPanel5.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private class JIRADialogWrapper
    extends DialogWrapper {
        private final JIRAForm myForm;

        public JIRADialogWrapper(Component parent) {
            super(parent, false);
            this.myForm = new JIRAForm();
            this.setTitle(StringBundle.get("codelink.edit.jira.title", new Object[0]));
            this.init();
            this.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        JIRADialogWrapper.this.close(1);
                    }
                }
            });
        }

        protected JComponent createCenterPanel() {
            return this.myForm.getWholePanel();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myForm.myUrlTextField;
        }

        public String getURL() {
            return this.myForm.getURL();
        }

        @Nullable
        public String getProjectName() {
            return this.myForm.getProjectName();
        }
    }
}

