/*
 * Decompiled with CFR 0.152.
 */
package org.fife.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;

public class UnicodeReader
extends Reader {
    private InputStreamReader internalIn = null;
    private String encoding;
    private static final int BOM_SIZE = 4;

    public UnicodeReader(String string) throws IOException, FileNotFoundException, SecurityException {
        this(new File(string));
    }

    public UnicodeReader(File file) throws IOException, FileNotFoundException, SecurityException {
        this(new FileInputStream(file));
    }

    public UnicodeReader(File file, String string) throws IOException, FileNotFoundException, SecurityException {
        this(new FileInputStream(file), string);
    }

    public UnicodeReader(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public UnicodeReader(InputStream inputStream, String string) throws IOException {
        this.init(inputStream, string);
    }

    public void close() throws IOException {
        this.internalIn.close();
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected void init(InputStream inputStream, String string) throws IOException {
        int n;
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 4);
        byte[] byArray = new byte[4];
        int n2 = pushbackInputStream.read(byArray, 0, byArray.length);
        if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            this.encoding = "UTF-8";
            n = n2 - 3;
        } else if (byArray[0] == -2 && byArray[1] == -1) {
            this.encoding = "UTF-16BE";
            n = n2 - 2;
        } else if (byArray[0] == -1 && byArray[1] == -2) {
            this.encoding = "UTF-16LE";
            n = n2 - 2;
        } else if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
            this.encoding = "UTF-32BE";
            n = n2 - 4;
        } else if (byArray[0] == -1 && byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0) {
            this.encoding = "UTF-32LE";
            n = n2 - 4;
        } else {
            this.encoding = string;
            n = n2;
        }
        if (n > 0) {
            pushbackInputStream.unread(byArray, n2 - n, n);
        } else if (n < -1) {
            pushbackInputStream.unread(byArray, 0, 0);
        }
        if (this.encoding == null) {
            this.internalIn = new InputStreamReader(pushbackInputStream);
            this.encoding = this.internalIn.getEncoding();
        } else {
            this.internalIn = new InputStreamReader((InputStream)pushbackInputStream, this.encoding);
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        return this.internalIn.read(cArray, n, n2);
    }
}

