# This file was automatically generated by running:
#
#   scripts/generate_windows_zone_names.cr
#
# DO NOT EDIT

module Crystal::System::Time
  # These mappings from IANA to Windows time zone names are based on
  # https://raw.githubusercontent.com/unicode-org/cldr/817409270794bb1538fe6b4aa3e9c79aff2c34d2/common/supplemental/windowsZones.xml
  private class_getter iana_to_windows : Hash(String, String) do
    data = Hash(String, String).new(initial_capacity: 460)
    put(data, "Africa/Abidjan", "Greenwich Standard Time")
    put(data, "Africa/Accra", "Greenwich Standard Time")
    put(data, "Africa/Addis_Ababa", "E. Africa Standard Time")
    put(data, "Africa/Algiers", "W. Central Africa Standard Time")
    put(data, "Africa/Asmera", "E. Africa Standard Time")
    put(data, "Africa/Bamako", "Greenwich Standard Time")
    put(data, "Africa/Bangui", "W. Central Africa Standard Time")
    put(data, "Africa/Banjul", "Greenwich Standard Time")
    put(data, "Africa/Bissau", "Greenwich Standard Time")
    put(data, "Africa/Blantyre", "South Africa Standard Time")
    put(data, "Africa/Brazzaville", "W. Central Africa Standard Time")
    put(data, "Africa/Bujumbura", "South Africa Standard Time")
    put(data, "Africa/Cairo", "Egypt Standard Time")
    put(data, "Africa/Casablanca", "Morocco Standard Time")
    put(data, "Africa/Ceuta", "Romance Standard Time")
    put(data, "Africa/Conakry", "Greenwich Standard Time")
    put(data, "Africa/Dakar", "Greenwich Standard Time")
    put(data, "Africa/Dar_es_Salaam", "E. Africa Standard Time")
    put(data, "Africa/Djibouti", "E. Africa Standard Time")
    put(data, "Africa/Douala", "W. Central Africa Standard Time")
    put(data, "Africa/El_Aaiun", "Morocco Standard Time")
    put(data, "Africa/Freetown", "Greenwich Standard Time")
    put(data, "Africa/Gaborone", "South Africa Standard Time")
    put(data, "Africa/Harare", "South Africa Standard Time")
    put(data, "Africa/Johannesburg", "South Africa Standard Time")
    put(data, "Africa/Juba", "South Sudan Standard Time")
    put(data, "Africa/Kampala", "E. Africa Standard Time")
    put(data, "Africa/Khartoum", "Sudan Standard Time")
    put(data, "Africa/Kigali", "South Africa Standard Time")
    put(data, "Africa/Kinshasa", "W. Central Africa Standard Time")
    put(data, "Africa/Lagos", "W. Central Africa Standard Time")
    put(data, "Africa/Libreville", "W. Central Africa Standard Time")
    put(data, "Africa/Lome", "Greenwich Standard Time")
    put(data, "Africa/Luanda", "W. Central Africa Standard Time")
    put(data, "Africa/Lubumbashi", "South Africa Standard Time")
    put(data, "Africa/Lusaka", "South Africa Standard Time")
    put(data, "Africa/Malabo", "W. Central Africa Standard Time")
    put(data, "Africa/Maputo", "South Africa Standard Time")
    put(data, "Africa/Maseru", "South Africa Standard Time")
    put(data, "Africa/Mbabane", "South Africa Standard Time")
    put(data, "Africa/Mogadishu", "E. Africa Standard Time")
    put(data, "Africa/Monrovia", "Greenwich Standard Time")
    put(data, "Africa/Nairobi", "E. Africa Standard Time")
    put(data, "Africa/Ndjamena", "W. Central Africa Standard Time")
    put(data, "Africa/Niamey", "W. Central Africa Standard Time")
    put(data, "Africa/Nouakchott", "Greenwich Standard Time")
    put(data, "Africa/Ouagadougou", "Greenwich Standard Time")
    put(data, "Africa/Porto-Novo", "W. Central Africa Standard Time")
    put(data, "Africa/Sao_Tome", "Sao Tome Standard Time")
    put(data, "Africa/Tripoli", "Libya Standard Time")
    put(data, "Africa/Tunis", "W. Central Africa Standard Time")
    put(data, "Africa/Windhoek", "Namibia Standard Time")
    put(data, "America/Adak", "Aleutian Standard Time")
    put(data, "America/Anchorage", "Alaskan Standard Time")
    put(data, "America/Anguilla", "SA Western Standard Time")
    put(data, "America/Antigua", "SA Western Standard Time")
    put(data, "America/Araguaina", "Tocantins Standard Time")
    put(data, "America/Argentina/La_Rioja", "Argentina Standard Time")
    put(data, "America/Argentina/Rio_Gallegos", "Argentina Standard Time")
    put(data, "America/Argentina/Salta", "Argentina Standard Time")
    put(data, "America/Argentina/San_Juan", "Argentina Standard Time")
    put(data, "America/Argentina/San_Luis", "Argentina Standard Time")
    put(data, "America/Argentina/Tucuman", "Argentina Standard Time")
    put(data, "America/Argentina/Ushuaia", "Argentina Standard Time")
    put(data, "America/Aruba", "SA Western Standard Time")
    put(data, "America/Asuncion", "Paraguay Standard Time")
    put(data, "America/Bahia", "Bahia Standard Time")
    put(data, "America/Bahia_Banderas", "Central Standard Time (Mexico)")
    put(data, "America/Barbados", "SA Western Standard Time")
    put(data, "America/Belem", "SA Eastern Standard Time")
    put(data, "America/Belize", "Central America Standard Time")
    put(data, "America/Blanc-Sablon", "SA Western Standard Time")
    put(data, "America/Boa_Vista", "SA Western Standard Time")
    put(data, "America/Bogota", "SA Pacific Standard Time")
    put(data, "America/Boise", "Mountain Standard Time")
    put(data, "America/Buenos_Aires", "Argentina Standard Time")
    put(data, "America/Cambridge_Bay", "Mountain Standard Time")
    put(data, "America/Campo_Grande", "Central Brazilian Standard Time")
    put(data, "America/Cancun", "Eastern Standard Time (Mexico)")
    put(data, "America/Caracas", "Venezuela Standard Time")
    put(data, "America/Catamarca", "Argentina Standard Time")
    put(data, "America/Cayenne", "SA Eastern Standard Time")
    put(data, "America/Cayman", "SA Pacific Standard Time")
    put(data, "America/Chicago", "Central Standard Time")
    put(data, "America/Chihuahua", "Central Standard Time (Mexico)")
    put(data, "America/Ciudad_Juarez", "Mountain Standard Time")
    put(data, "America/Coral_Harbour", "SA Pacific Standard Time")
    put(data, "America/Cordoba", "Argentina Standard Time")
    put(data, "America/Costa_Rica", "Central America Standard Time")
    put(data, "America/Creston", "US Mountain Standard Time")
    put(data, "America/Cuiaba", "Central Brazilian Standard Time")
    put(data, "America/Curacao", "SA Western Standard Time")
    put(data, "America/Danmarkshavn", "Greenwich Standard Time")
    put(data, "America/Dawson", "Yukon Standard Time")
    put(data, "America/Dawson_Creek", "US Mountain Standard Time")
    put(data, "America/Denver", "Mountain Standard Time")
    put(data, "America/Detroit", "Eastern Standard Time")
    put(data, "America/Dominica", "SA Western Standard Time")
    put(data, "America/Edmonton", "Mountain Standard Time")
    put(data, "America/Eirunepe", "SA Pacific Standard Time")
    put(data, "America/El_Salvador", "Central America Standard Time")
    put(data, "America/Fort_Nelson", "US Mountain Standard Time")
    put(data, "America/Fortaleza", "SA Eastern Standard Time")
    put(data, "America/Glace_Bay", "Atlantic Standard Time")
    put(data, "America/Godthab", "Greenland Standard Time")
    put(data, "America/Goose_Bay", "Atlantic Standard Time")
    put(data, "America/Grand_Turk", "Turks And Caicos Standard Time")
    put(data, "America/Grenada", "SA Western Standard Time")
    put(data, "America/Guadeloupe", "SA Western Standard Time")
    put(data, "America/Guatemala", "Central America Standard Time")
    put(data, "America/Guayaquil", "SA Pacific Standard Time")
    put(data, "America/Guyana", "SA Western Standard Time")
    put(data, "America/Halifax", "Atlantic Standard Time")
    put(data, "America/Havana", "Cuba Standard Time")
    put(data, "America/Hermosillo", "US Mountain Standard Time")
    put(data, "America/Indiana/Knox", "Central Standard Time")
    put(data, "America/Indiana/Marengo", "US Eastern Standard Time")
    put(data, "America/Indiana/Petersburg", "Eastern Standard Time")
    put(data, "America/Indiana/Tell_City", "Central Standard Time")
    put(data, "America/Indiana/Vevay", "US Eastern Standard Time")
    put(data, "America/Indiana/Vincennes", "Eastern Standard Time")
    put(data, "America/Indiana/Winamac", "Eastern Standard Time")
    put(data, "America/Indianapolis", "US Eastern Standard Time")
    put(data, "America/Inuvik", "Mountain Standard Time")
    put(data, "America/Iqaluit", "Eastern Standard Time")
    put(data, "America/Jamaica", "SA Pacific Standard Time")
    put(data, "America/Jujuy", "Argentina Standard Time")
    put(data, "America/Juneau", "Alaskan Standard Time")
    put(data, "America/Kentucky/Monticello", "Eastern Standard Time")
    put(data, "America/Kralendijk", "SA Western Standard Time")
    put(data, "America/La_Paz", "SA Western Standard Time")
    put(data, "America/Lima", "SA Pacific Standard Time")
    put(data, "America/Los_Angeles", "Pacific Standard Time")
    put(data, "America/Louisville", "Eastern Standard Time")
    put(data, "America/Lower_Princes", "SA Western Standard Time")
    put(data, "America/Maceio", "SA Eastern Standard Time")
    put(data, "America/Managua", "Central America Standard Time")
    put(data, "America/Manaus", "SA Western Standard Time")
    put(data, "America/Marigot", "SA Western Standard Time")
    put(data, "America/Martinique", "SA Western Standard Time")
    put(data, "America/Matamoros", "Central Standard Time")
    put(data, "America/Mazatlan", "Mountain Standard Time (Mexico)")
    put(data, "America/Mendoza", "Argentina Standard Time")
    put(data, "America/Menominee", "Central Standard Time")
    put(data, "America/Merida", "Central Standard Time (Mexico)")
    put(data, "America/Metlakatla", "Alaskan Standard Time")
    put(data, "America/Mexico_City", "Central Standard Time (Mexico)")
    put(data, "America/Miquelon", "Saint Pierre Standard Time")
    put(data, "America/Moncton", "Atlantic Standard Time")
    put(data, "America/Monterrey", "Central Standard Time (Mexico)")
    put(data, "America/Montevideo", "Montevideo Standard Time")
    put(data, "America/Montreal", "Eastern Standard Time")
    put(data, "America/Montserrat", "SA Western Standard Time")
    put(data, "America/Nassau", "Eastern Standard Time")
    put(data, "America/New_York", "Eastern Standard Time")
    put(data, "America/Nipigon", "Eastern Standard Time")
    put(data, "America/Nome", "Alaskan Standard Time")
    put(data, "America/Noronha", "UTC-02")
    put(data, "America/North_Dakota/Beulah", "Central Standard Time")
    put(data, "America/North_Dakota/Center", "Central Standard Time")
    put(data, "America/North_Dakota/New_Salem", "Central Standard Time")
    put(data, "America/Ojinaga", "Central Standard Time")
    put(data, "America/Panama", "SA Pacific Standard Time")
    put(data, "America/Pangnirtung", "Eastern Standard Time")
    put(data, "America/Paramaribo", "SA Eastern Standard Time")
    put(data, "America/Phoenix", "US Mountain Standard Time")
    put(data, "America/Port-au-Prince", "Haiti Standard Time")
    put(data, "America/Port_of_Spain", "SA Western Standard Time")
    put(data, "America/Porto_Velho", "SA Western Standard Time")
    put(data, "America/Puerto_Rico", "SA Western Standard Time")
    put(data, "America/Punta_Arenas", "Magallanes Standard Time")
    put(data, "America/Rainy_River", "Central Standard Time")
    put(data, "America/Rankin_Inlet", "Central Standard Time")
    put(data, "America/Recife", "SA Eastern Standard Time")
    put(data, "America/Regina", "Canada Central Standard Time")
    put(data, "America/Resolute", "Central Standard Time")
    put(data, "America/Rio_Branco", "SA Pacific Standard Time")
    put(data, "America/Santa_Isabel", "Pacific Standard Time (Mexico)")
    put(data, "America/Santarem", "SA Eastern Standard Time")
    put(data, "America/Santiago", "Pacific SA Standard Time")
    put(data, "America/Santo_Domingo", "SA Western Standard Time")
    put(data, "America/Sao_Paulo", "E. South America Standard Time")
    put(data, "America/Scoresbysund", "Azores Standard Time")
    put(data, "America/Sitka", "Alaskan Standard Time")
    put(data, "America/St_Barthelemy", "SA Western Standard Time")
    put(data, "America/St_Johns", "Newfoundland Standard Time")
    put(data, "America/St_Kitts", "SA Western Standard Time")
    put(data, "America/St_Lucia", "SA Western Standard Time")
    put(data, "America/St_Thomas", "SA Western Standard Time")
    put(data, "America/St_Vincent", "SA Western Standard Time")
    put(data, "America/Swift_Current", "Canada Central Standard Time")
    put(data, "America/Tegucigalpa", "Central America Standard Time")
    put(data, "America/Thule", "Atlantic Standard Time")
    put(data, "America/Thunder_Bay", "Eastern Standard Time")
    put(data, "America/Tijuana", "Pacific Standard Time (Mexico)")
    put(data, "America/Toronto", "Eastern Standard Time")
    put(data, "America/Tortola", "SA Western Standard Time")
    put(data, "America/Vancouver", "Pacific Standard Time")
    put(data, "America/Whitehorse", "Yukon Standard Time")
    put(data, "America/Winnipeg", "Central Standard Time")
    put(data, "America/Yakutat", "Alaskan Standard Time")
    put(data, "America/Yellowknife", "Mountain Standard Time")
    put(data, "Antarctica/Casey", "Central Pacific Standard Time")
    put(data, "Antarctica/Davis", "SE Asia Standard Time")
    put(data, "Antarctica/DumontDUrville", "West Pacific Standard Time")
    put(data, "Antarctica/Macquarie", "Tasmania Standard Time")
    put(data, "Antarctica/Mawson", "West Asia Standard Time")
    put(data, "Antarctica/McMurdo", "New Zealand Standard Time")
    put(data, "Antarctica/Palmer", "SA Eastern Standard Time")
    put(data, "Antarctica/Rothera", "SA Eastern Standard Time")
    put(data, "Antarctica/Syowa", "E. Africa Standard Time")
    put(data, "Antarctica/Vostok", "Central Asia Standard Time")
    put(data, "Arctic/Longyearbyen", "W. Europe Standard Time")
    put(data, "Asia/Aden", "Arab Standard Time")
    put(data, "Asia/Almaty", "Central Asia Standard Time")
    put(data, "Asia/Amman", "Jordan Standard Time")
    put(data, "Asia/Anadyr", "Russia Time Zone 11")
    put(data, "Asia/Aqtau", "West Asia Standard Time")
    put(data, "Asia/Aqtobe", "West Asia Standard Time")
    put(data, "Asia/Ashgabat", "West Asia Standard Time")
    put(data, "Asia/Atyrau", "West Asia Standard Time")
    put(data, "Asia/Baghdad", "Arabic Standard Time")
    put(data, "Asia/Bahrain", "Arab Standard Time")
    put(data, "Asia/Baku", "Azerbaijan Standard Time")
    put(data, "Asia/Bangkok", "SE Asia Standard Time")
    put(data, "Asia/Barnaul", "Altai Standard Time")
    put(data, "Asia/Beirut", "Middle East Standard Time")
    put(data, "Asia/Bishkek", "Central Asia Standard Time")
    put(data, "Asia/Brunei", "Singapore Standard Time")
    put(data, "Asia/Calcutta", "India Standard Time")
    put(data, "Asia/Chita", "Transbaikal Standard Time")
    put(data, "Asia/Choibalsan", "Ulaanbaatar Standard Time")
    put(data, "Asia/Colombo", "Sri Lanka Standard Time")
    put(data, "Asia/Damascus", "Syria Standard Time")
    put(data, "Asia/Dhaka", "Bangladesh Standard Time")
    put(data, "Asia/Dili", "Tokyo Standard Time")
    put(data, "Asia/Dubai", "Arabian Standard Time")
    put(data, "Asia/Dushanbe", "West Asia Standard Time")
    put(data, "Asia/Famagusta", "GTB Standard Time")
    put(data, "Asia/Gaza", "West Bank Standard Time")
    put(data, "Asia/Hebron", "West Bank Standard Time")
    put(data, "Asia/Hong_Kong", "China Standard Time")
    put(data, "Asia/Hovd", "W. Mongolia Standard Time")
    put(data, "Asia/Irkutsk", "North Asia East Standard Time")
    put(data, "Asia/Jakarta", "SE Asia Standard Time")
    put(data, "Asia/Jayapura", "Tokyo Standard Time")
    put(data, "Asia/Jerusalem", "Israel Standard Time")
    put(data, "Asia/Kabul", "Afghanistan Standard Time")
    put(data, "Asia/Kamchatka", "Russia Time Zone 11")
    put(data, "Asia/Karachi", "Pakistan Standard Time")
    put(data, "Asia/Katmandu", "Nepal Standard Time")
    put(data, "Asia/Khandyga", "Yakutsk Standard Time")
    put(data, "Asia/Krasnoyarsk", "North Asia Standard Time")
    put(data, "Asia/Kuala_Lumpur", "Singapore Standard Time")
    put(data, "Asia/Kuching", "Singapore Standard Time")
    put(data, "Asia/Kuwait", "Arab Standard Time")
    put(data, "Asia/Macau", "China Standard Time")
    put(data, "Asia/Magadan", "Magadan Standard Time")
    put(data, "Asia/Makassar", "Singapore Standard Time")
    put(data, "Asia/Manila", "Singapore Standard Time")
    put(data, "Asia/Muscat", "Arabian Standard Time")
    put(data, "Asia/Nicosia", "GTB Standard Time")
    put(data, "Asia/Novokuznetsk", "North Asia Standard Time")
    put(data, "Asia/Novosibirsk", "N. Central Asia Standard Time")
    put(data, "Asia/Omsk", "Omsk Standard Time")
    put(data, "Asia/Oral", "West Asia Standard Time")
    put(data, "Asia/Phnom_Penh", "SE Asia Standard Time")
    put(data, "Asia/Pontianak", "SE Asia Standard Time")
    put(data, "Asia/Pyongyang", "North Korea Standard Time")
    put(data, "Asia/Qatar", "Arab Standard Time")
    put(data, "Asia/Qostanay", "Central Asia Standard Time")
    put(data, "Asia/Qyzylorda", "Qyzylorda Standard Time")
    put(data, "Asia/Rangoon", "Myanmar Standard Time")
    put(data, "Asia/Riyadh", "Arab Standard Time")
    put(data, "Asia/Saigon", "SE Asia Standard Time")
    put(data, "Asia/Sakhalin", "Sakhalin Standard Time")
    put(data, "Asia/Samarkand", "West Asia Standard Time")
    put(data, "Asia/Seoul", "Korea Standard Time")
    put(data, "Asia/Shanghai", "China Standard Time")
    put(data, "Asia/Singapore", "Singapore Standard Time")
    put(data, "Asia/Srednekolymsk", "Russia Time Zone 10")
    put(data, "Asia/Taipei", "Taipei Standard Time")
    put(data, "Asia/Tashkent", "West Asia Standard Time")
    put(data, "Asia/Tbilisi", "Georgian Standard Time")
    put(data, "Asia/Tehran", "Iran Standard Time")
    put(data, "Asia/Thimphu", "Bangladesh Standard Time")
    put(data, "Asia/Tokyo", "Tokyo Standard Time")
    put(data, "Asia/Tomsk", "Tomsk Standard Time")
    put(data, "Asia/Ulaanbaatar", "Ulaanbaatar Standard Time")
    put(data, "Asia/Urumqi", "Central Asia Standard Time")
    put(data, "Asia/Ust-Nera", "Vladivostok Standard Time")
    put(data, "Asia/Vientiane", "SE Asia Standard Time")
    put(data, "Asia/Vladivostok", "Vladivostok Standard Time")
    put(data, "Asia/Yakutsk", "Yakutsk Standard Time")
    put(data, "Asia/Yekaterinburg", "Ekaterinburg Standard Time")
    put(data, "Asia/Yerevan", "Caucasus Standard Time")
    put(data, "Atlantic/Azores", "Azores Standard Time")
    put(data, "Atlantic/Bermuda", "Atlantic Standard Time")
    put(data, "Atlantic/Canary", "GMT Standard Time")
    put(data, "Atlantic/Cape_Verde", "Cape Verde Standard Time")
    put(data, "Atlantic/Faeroe", "GMT Standard Time")
    put(data, "Atlantic/Madeira", "GMT Standard Time")
    put(data, "Atlantic/Reykjavik", "Greenwich Standard Time")
    put(data, "Atlantic/South_Georgia", "UTC-02")
    put(data, "Atlantic/St_Helena", "Greenwich Standard Time")
    put(data, "Atlantic/Stanley", "SA Eastern Standard Time")
    put(data, "Australia/Adelaide", "Cen. Australia Standard Time")
    put(data, "Australia/Brisbane", "E. Australia Standard Time")
    put(data, "Australia/Broken_Hill", "Cen. Australia Standard Time")
    put(data, "Australia/Currie", "Tasmania Standard Time")
    put(data, "Australia/Darwin", "AUS Central Standard Time")
    put(data, "Australia/Eucla", "Aus Central W. Standard Time")
    put(data, "Australia/Hobart", "Tasmania Standard Time")
    put(data, "Australia/Lindeman", "E. Australia Standard Time")
    put(data, "Australia/Lord_Howe", "Lord Howe Standard Time")
    put(data, "Australia/Melbourne", "AUS Eastern Standard Time")
    put(data, "Australia/Perth", "W. Australia Standard Time")
    put(data, "Australia/Sydney", "AUS Eastern Standard Time")
    put(data, "CST6CDT", "Central Standard Time")
    put(data, "EST5EDT", "Eastern Standard Time")
    put(data, "Etc/GMT", "UTC")
    put(data, "Etc/GMT+1", "Cape Verde Standard Time")
    put(data, "Etc/GMT+10", "Hawaiian Standard Time")
    put(data, "Etc/GMT+11", "UTC-11")
    put(data, "Etc/GMT+12", "Dateline Standard Time")
    put(data, "Etc/GMT+2", "UTC-02")
    put(data, "Etc/GMT+3", "SA Eastern Standard Time")
    put(data, "Etc/GMT+4", "SA Western Standard Time")
    put(data, "Etc/GMT+5", "SA Pacific Standard Time")
    put(data, "Etc/GMT+6", "Central America Standard Time")
    put(data, "Etc/GMT+7", "US Mountain Standard Time")
    put(data, "Etc/GMT+8", "UTC-08")
    put(data, "Etc/GMT+9", "UTC-09")
    put(data, "Etc/GMT-1", "W. Central Africa Standard Time")
    put(data, "Etc/GMT-10", "West Pacific Standard Time")
    put(data, "Etc/GMT-11", "Central Pacific Standard Time")
    put(data, "Etc/GMT-12", "UTC+12")
    put(data, "Etc/GMT-13", "UTC+13")
    put(data, "Etc/GMT-14", "Line Islands Standard Time")
    put(data, "Etc/GMT-2", "South Africa Standard Time")
    put(data, "Etc/GMT-3", "E. Africa Standard Time")
    put(data, "Etc/GMT-4", "Arabian Standard Time")
    put(data, "Etc/GMT-5", "West Asia Standard Time")
    put(data, "Etc/GMT-6", "Central Asia Standard Time")
    put(data, "Etc/GMT-7", "SE Asia Standard Time")
    put(data, "Etc/GMT-8", "Singapore Standard Time")
    put(data, "Etc/GMT-9", "Tokyo Standard Time")
    put(data, "Etc/UTC", "UTC")
    put(data, "Europe/Amsterdam", "W. Europe Standard Time")
    put(data, "Europe/Andorra", "W. Europe Standard Time")
    put(data, "Europe/Astrakhan", "Astrakhan Standard Time")
    put(data, "Europe/Athens", "GTB Standard Time")
    put(data, "Europe/Belgrade", "Central Europe Standard Time")
    put(data, "Europe/Berlin", "W. Europe Standard Time")
    put(data, "Europe/Bratislava", "Central Europe Standard Time")
    put(data, "Europe/Brussels", "Romance Standard Time")
    put(data, "Europe/Bucharest", "GTB Standard Time")
    put(data, "Europe/Budapest", "Central Europe Standard Time")
    put(data, "Europe/Busingen", "W. Europe Standard Time")
    put(data, "Europe/Chisinau", "E. Europe Standard Time")
    put(data, "Europe/Copenhagen", "Romance Standard Time")
    put(data, "Europe/Dublin", "GMT Standard Time")
    put(data, "Europe/Gibraltar", "W. Europe Standard Time")
    put(data, "Europe/Guernsey", "GMT Standard Time")
    put(data, "Europe/Helsinki", "FLE Standard Time")
    put(data, "Europe/Isle_of_Man", "GMT Standard Time")
    put(data, "Europe/Istanbul", "Turkey Standard Time")
    put(data, "Europe/Jersey", "GMT Standard Time")
    put(data, "Europe/Kaliningrad", "Kaliningrad Standard Time")
    put(data, "Europe/Kiev", "FLE Standard Time")
    put(data, "Europe/Kirov", "Russian Standard Time")
    put(data, "Europe/Lisbon", "GMT Standard Time")
    put(data, "Europe/Ljubljana", "Central Europe Standard Time")
    put(data, "Europe/London", "GMT Standard Time")
    put(data, "Europe/Luxembourg", "W. Europe Standard Time")
    put(data, "Europe/Madrid", "Romance Standard Time")
    put(data, "Europe/Malta", "W. Europe Standard Time")
    put(data, "Europe/Mariehamn", "FLE Standard Time")
    put(data, "Europe/Minsk", "Belarus Standard Time")
    put(data, "Europe/Monaco", "W. Europe Standard Time")
    put(data, "Europe/Moscow", "Russian Standard Time")
    put(data, "Europe/Oslo", "W. Europe Standard Time")
    put(data, "Europe/Paris", "Romance Standard Time")
    put(data, "Europe/Podgorica", "Central Europe Standard Time")
    put(data, "Europe/Prague", "Central Europe Standard Time")
    put(data, "Europe/Riga", "FLE Standard Time")
    put(data, "Europe/Rome", "W. Europe Standard Time")
    put(data, "Europe/Samara", "Russia Time Zone 3")
    put(data, "Europe/San_Marino", "W. Europe Standard Time")
    put(data, "Europe/Sarajevo", "Central European Standard Time")
    put(data, "Europe/Saratov", "Saratov Standard Time")
    put(data, "Europe/Simferopol", "Russian Standard Time")
    put(data, "Europe/Skopje", "Central European Standard Time")
    put(data, "Europe/Sofia", "FLE Standard Time")
    put(data, "Europe/Stockholm", "W. Europe Standard Time")
    put(data, "Europe/Tallinn", "FLE Standard Time")
    put(data, "Europe/Tirane", "Central Europe Standard Time")
    put(data, "Europe/Ulyanovsk", "Astrakhan Standard Time")
    put(data, "Europe/Uzhgorod", "FLE Standard Time")
    put(data, "Europe/Vaduz", "W. Europe Standard Time")
    put(data, "Europe/Vatican", "W. Europe Standard Time")
    put(data, "Europe/Vienna", "W. Europe Standard Time")
    put(data, "Europe/Vilnius", "FLE Standard Time")
    put(data, "Europe/Volgograd", "Volgograd Standard Time")
    put(data, "Europe/Warsaw", "Central European Standard Time")
    put(data, "Europe/Zagreb", "Central European Standard Time")
    put(data, "Europe/Zaporozhye", "FLE Standard Time")
    put(data, "Europe/Zurich", "W. Europe Standard Time")
    put(data, "Indian/Antananarivo", "E. Africa Standard Time")
    put(data, "Indian/Chagos", "Central Asia Standard Time")
    put(data, "Indian/Christmas", "SE Asia Standard Time")
    put(data, "Indian/Cocos", "Myanmar Standard Time")
    put(data, "Indian/Comoro", "E. Africa Standard Time")
    put(data, "Indian/Kerguelen", "West Asia Standard Time")
    put(data, "Indian/Mahe", "Mauritius Standard Time")
    put(data, "Indian/Maldives", "West Asia Standard Time")
    put(data, "Indian/Mauritius", "Mauritius Standard Time")
    put(data, "Indian/Mayotte", "E. Africa Standard Time")
    put(data, "Indian/Reunion", "Mauritius Standard Time")
    put(data, "MST7MDT", "Mountain Standard Time")
    put(data, "PST8PDT", "Pacific Standard Time")
    put(data, "Pacific/Apia", "Samoa Standard Time")
    put(data, "Pacific/Auckland", "New Zealand Standard Time")
    put(data, "Pacific/Bougainville", "Bougainville Standard Time")
    put(data, "Pacific/Chatham", "Chatham Islands Standard Time")
    put(data, "Pacific/Easter", "Easter Island Standard Time")
    put(data, "Pacific/Efate", "Central Pacific Standard Time")
    put(data, "Pacific/Enderbury", "UTC+13")
    put(data, "Pacific/Fakaofo", "UTC+13")
    put(data, "Pacific/Fiji", "Fiji Standard Time")
    put(data, "Pacific/Funafuti", "UTC+12")
    put(data, "Pacific/Galapagos", "Central America Standard Time")
    put(data, "Pacific/Gambier", "UTC-09")
    put(data, "Pacific/Guadalcanal", "Central Pacific Standard Time")
    put(data, "Pacific/Guam", "West Pacific Standard Time")
    put(data, "Pacific/Honolulu", "Hawaiian Standard Time")
    put(data, "Pacific/Johnston", "Hawaiian Standard Time")
    put(data, "Pacific/Kiritimati", "Line Islands Standard Time")
    put(data, "Pacific/Kosrae", "Central Pacific Standard Time")
    put(data, "Pacific/Kwajalein", "UTC+12")
    put(data, "Pacific/Majuro", "UTC+12")
    put(data, "Pacific/Marquesas", "Marquesas Standard Time")
    put(data, "Pacific/Midway", "UTC-11")
    put(data, "Pacific/Nauru", "UTC+12")
    put(data, "Pacific/Niue", "UTC-11")
    put(data, "Pacific/Norfolk", "Norfolk Standard Time")
    put(data, "Pacific/Noumea", "Central Pacific Standard Time")
    put(data, "Pacific/Pago_Pago", "UTC-11")
    put(data, "Pacific/Palau", "Tokyo Standard Time")
    put(data, "Pacific/Pitcairn", "UTC-08")
    put(data, "Pacific/Ponape", "Central Pacific Standard Time")
    put(data, "Pacific/Port_Moresby", "West Pacific Standard Time")
    put(data, "Pacific/Rarotonga", "Hawaiian Standard Time")
    put(data, "Pacific/Saipan", "West Pacific Standard Time")
    put(data, "Pacific/Tahiti", "Hawaiian Standard Time")
    put(data, "Pacific/Tarawa", "UTC+12")
    put(data, "Pacific/Tongatapu", "Tonga Standard Time")
    put(data, "Pacific/Truk", "West Pacific Standard Time")
    put(data, "Pacific/Wake", "UTC+12")
    put(data, "Pacific/Wallis", "UTC+12")
    data
  end

  # These mappings from Windows time zone names to tzdata abbreviations are based on
  # https://raw.githubusercontent.com/unicode-org/cldr/817409270794bb1538fe6b4aa3e9c79aff2c34d2/common/supplemental/windowsZones.xml
  private class_getter windows_zone_names : Hash(String, {String, String}) do
    data = Hash(String, {String, String}).new(initial_capacity: 139)
    put(data, "Egypt Standard Time", "EET", "EEST")              # Africa/Cairo
    put(data, "Morocco Standard Time", "+01", "+01")             # Africa/Casablanca
    put(data, "South Africa Standard Time", "SAST", "SAST")      # Africa/Johannesburg
    put(data, "South Sudan Standard Time", "CAT", "CAT")         # Africa/Juba
    put(data, "Sudan Standard Time", "CAT", "CAT")               # Africa/Khartoum
    put(data, "W. Central Africa Standard Time", "WAT", "WAT")   # Africa/Lagos
    put(data, "E. Africa Standard Time", "EAT", "EAT")           # Africa/Nairobi
    put(data, "Sao Tome Standard Time", "GMT", "GMT")            # Africa/Sao_Tome
    put(data, "Libya Standard Time", "EET", "EET")               # Africa/Tripoli
    put(data, "Namibia Standard Time", "CAT", "CAT")             # Africa/Windhoek
    put(data, "Aleutian Standard Time", "HST", "HDT")            # America/Adak
    put(data, "Alaskan Standard Time", "AKST", "AKDT")           # America/Anchorage
    put(data, "Tocantins Standard Time", "-03", "-03")           # America/Araguaina
    put(data, "Paraguay Standard Time", "-04", "-03")            # America/Asuncion
    put(data, "Bahia Standard Time", "-03", "-03")               # America/Bahia
    put(data, "SA Pacific Standard Time", "-05", "-05")          # America/Bogota
    put(data, "Argentina Standard Time", "-03", "-03")           # America/Buenos_Aires
    put(data, "Eastern Standard Time (Mexico)", "EST", "EST")    # America/Cancun
    put(data, "Venezuela Standard Time", "-04", "-04")           # America/Caracas
    put(data, "SA Eastern Standard Time", "-03", "-03")          # America/Cayenne
    put(data, "Central Standard Time", "CST", "CDT")             # America/Chicago
    put(data, "Central Brazilian Standard Time", "-04", "-04")   # America/Cuiaba
    put(data, "Mountain Standard Time", "MST", "MDT")            # America/Denver
    put(data, "Greenland Standard Time", "-03", "-02")           # America/Godthab
    put(data, "Turks And Caicos Standard Time", "EST", "EDT")    # America/Grand_Turk
    put(data, "Central America Standard Time", "CST", "CST")     # America/Guatemala
    put(data, "Atlantic Standard Time", "AST", "ADT")            # America/Halifax
    put(data, "Cuba Standard Time", "CST", "CDT")                # America/Havana
    put(data, "US Eastern Standard Time", "EST", "EDT")          # America/Indianapolis
    put(data, "SA Western Standard Time", "-04", "-04")          # America/La_Paz
    put(data, "Pacific Standard Time", "PST", "PDT")             # America/Los_Angeles
    put(data, "Mountain Standard Time (Mexico)", "MST", "MST")   # America/Mazatlan
    put(data, "Central Standard Time (Mexico)", "CST", "CST")    # America/Mexico_City
    put(data, "Saint Pierre Standard Time", "-03", "-02")        # America/Miquelon
    put(data, "Montevideo Standard Time", "-03", "-03")          # America/Montevideo
    put(data, "Eastern Standard Time", "EST", "EDT")             # America/New_York
    put(data, "US Mountain Standard Time", "MST", "MST")         # America/Phoenix
    put(data, "Haiti Standard Time", "EST", "EDT")               # America/Port-au-Prince
    put(data, "Magallanes Standard Time", "-03", "-03")          # America/Punta_Arenas
    put(data, "Canada Central Standard Time", "CST", "CST")      # America/Regina
    put(data, "Pacific SA Standard Time", "-04", "-03")          # America/Santiago
    put(data, "E. South America Standard Time", "-03", "-03")    # America/Sao_Paulo
    put(data, "Newfoundland Standard Time", "NST", "NDT")        # America/St_Johns
    put(data, "Pacific Standard Time (Mexico)", "PST", "PDT")    # America/Tijuana
    put(data, "Yukon Standard Time", "MST", "MST")               # America/Whitehorse
    put(data, "Central Asia Standard Time", "+06", "+06")        # Asia/Almaty
    put(data, "Jordan Standard Time", "+03", "+03")              # Asia/Amman
    put(data, "Arabic Standard Time", "+03", "+03")              # Asia/Baghdad
    put(data, "Azerbaijan Standard Time", "+04", "+04")          # Asia/Baku
    put(data, "SE Asia Standard Time", "+07", "+07")             # Asia/Bangkok
    put(data, "Altai Standard Time", "+07", "+07")               # Asia/Barnaul
    put(data, "Middle East Standard Time", "EET", "EEST")        # Asia/Beirut
    put(data, "India Standard Time", "IST", "IST")               # Asia/Calcutta
    put(data, "Transbaikal Standard Time", "+09", "+09")         # Asia/Chita
    put(data, "Sri Lanka Standard Time", "+0530", "+0530")       # Asia/Colombo
    put(data, "Syria Standard Time", "+03", "+03")               # Asia/Damascus
    put(data, "Bangladesh Standard Time", "+06", "+06")          # Asia/Dhaka
    put(data, "Arabian Standard Time", "+04", "+04")             # Asia/Dubai
    put(data, "West Bank Standard Time", "EET", "EEST")          # Asia/Hebron
    put(data, "W. Mongolia Standard Time", "+07", "+07")         # Asia/Hovd
    put(data, "North Asia East Standard Time", "+08", "+08")     # Asia/Irkutsk
    put(data, "Israel Standard Time", "IST", "IDT")              # Asia/Jerusalem
    put(data, "Afghanistan Standard Time", "+0430", "+0430")     # Asia/Kabul
    put(data, "Russia Time Zone 11", "+12", "+12")               # Asia/Kamchatka
    put(data, "Pakistan Standard Time", "PKT", "PKT")            # Asia/Karachi
    put(data, "Nepal Standard Time", "+0545", "+0545")           # Asia/Katmandu
    put(data, "North Asia Standard Time", "+07", "+07")          # Asia/Krasnoyarsk
    put(data, "Magadan Standard Time", "+11", "+11")             # Asia/Magadan
    put(data, "N. Central Asia Standard Time", "+07", "+07")     # Asia/Novosibirsk
    put(data, "Omsk Standard Time", "+06", "+06")                # Asia/Omsk
    put(data, "North Korea Standard Time", "KST", "KST")         # Asia/Pyongyang
    put(data, "Qyzylorda Standard Time", "+05", "+05")           # Asia/Qyzylorda
    put(data, "Myanmar Standard Time", "+0630", "+0630")         # Asia/Rangoon
    put(data, "Arab Standard Time", "+03", "+03")                # Asia/Riyadh
    put(data, "Sakhalin Standard Time", "+11", "+11")            # Asia/Sakhalin
    put(data, "Korea Standard Time", "KST", "KST")               # Asia/Seoul
    put(data, "China Standard Time", "CST", "CST")               # Asia/Shanghai
    put(data, "Singapore Standard Time", "+08", "+08")           # Asia/Singapore
    put(data, "Russia Time Zone 10", "+11", "+11")               # Asia/Srednekolymsk
    put(data, "Taipei Standard Time", "CST", "CST")              # Asia/Taipei
    put(data, "West Asia Standard Time", "+05", "+05")           # Asia/Tashkent
    put(data, "Georgian Standard Time", "+04", "+04")            # Asia/Tbilisi
    put(data, "Iran Standard Time", "+0330", "+0330")            # Asia/Tehran
    put(data, "Tokyo Standard Time", "JST", "JST")               # Asia/Tokyo
    put(data, "Tomsk Standard Time", "+07", "+07")               # Asia/Tomsk
    put(data, "Ulaanbaatar Standard Time", "+08", "+08")         # Asia/Ulaanbaatar
    put(data, "Vladivostok Standard Time", "+10", "+10")         # Asia/Vladivostok
    put(data, "Yakutsk Standard Time", "+09", "+09")             # Asia/Yakutsk
    put(data, "Ekaterinburg Standard Time", "+05", "+05")        # Asia/Yekaterinburg
    put(data, "Caucasus Standard Time", "+04", "+04")            # Asia/Yerevan
    put(data, "Azores Standard Time", "-01", "+00")              # Atlantic/Azores
    put(data, "Cape Verde Standard Time", "-01", "-01")          # Atlantic/Cape_Verde
    put(data, "Greenwich Standard Time", "GMT", "GMT")           # Atlantic/Reykjavik
    put(data, "Cen. Australia Standard Time", "ACST", "ACDT")    # Australia/Adelaide
    put(data, "E. Australia Standard Time", "AEST", "AEST")      # Australia/Brisbane
    put(data, "AUS Central Standard Time", "ACST", "ACST")       # Australia/Darwin
    put(data, "Aus Central W. Standard Time", "+0845", "+0845")  # Australia/Eucla
    put(data, "Tasmania Standard Time", "AEST", "AEDT")          # Australia/Hobart
    put(data, "Lord Howe Standard Time", "+1030", "+11")         # Australia/Lord_Howe
    put(data, "W. Australia Standard Time", "AWST", "AWST")      # Australia/Perth
    put(data, "AUS Eastern Standard Time", "AEST", "AEDT")       # Australia/Sydney
    put(data, "UTC-11", "-11", "-11")                            # Etc/GMT+11
    put(data, "Dateline Standard Time", "-12", "-12")            # Etc/GMT+12
    put(data, "UTC-02", "-02", "-02")                            # Etc/GMT+2
    put(data, "UTC-08", "-08", "-08")                            # Etc/GMT+8
    put(data, "UTC-09", "-09", "-09")                            # Etc/GMT+9
    put(data, "UTC+12", "+12", "+12")                            # Etc/GMT-12
    put(data, "UTC+13", "+13", "+13")                            # Etc/GMT-13
    put(data, "UTC", "UTC", "UTC")                               # Etc/UTC
    put(data, "Astrakhan Standard Time", "+04", "+04")           # Europe/Astrakhan
    put(data, "W. Europe Standard Time", "CET", "CEST")          # Europe/Berlin
    put(data, "GTB Standard Time", "EET", "EEST")                # Europe/Bucharest
    put(data, "Central Europe Standard Time", "CET", "CEST")     # Europe/Budapest
    put(data, "E. Europe Standard Time", "EET", "EEST")          # Europe/Chisinau
    put(data, "Turkey Standard Time", "+03", "+03")              # Europe/Istanbul
    put(data, "Kaliningrad Standard Time", "EET", "EET")         # Europe/Kaliningrad
    put(data, "FLE Standard Time", "EET", "EEST")                # Europe/Kiev
    put(data, "GMT Standard Time", "GMT", "BST")                 # Europe/London
    put(data, "Belarus Standard Time", "+03", "+03")             # Europe/Minsk
    put(data, "Russian Standard Time", "MSK", "MSK")             # Europe/Moscow
    put(data, "Romance Standard Time", "CET", "CEST")            # Europe/Paris
    put(data, "Russia Time Zone 3", "+04", "+04")                # Europe/Samara
    put(data, "Saratov Standard Time", "+04", "+04")             # Europe/Saratov
    put(data, "Volgograd Standard Time", "MSK", "MSK")           # Europe/Volgograd
    put(data, "Central European Standard Time", "CET", "CEST")   # Europe/Warsaw
    put(data, "Mauritius Standard Time", "+04", "+04")           # Indian/Mauritius
    put(data, "Samoa Standard Time", "+13", "+13")               # Pacific/Apia
    put(data, "New Zealand Standard Time", "NZST", "NZDT")       # Pacific/Auckland
    put(data, "Bougainville Standard Time", "+11", "+11")        # Pacific/Bougainville
    put(data, "Chatham Islands Standard Time", "+1245", "+1345") # Pacific/Chatham
    put(data, "Easter Island Standard Time", "-06", "-05")       # Pacific/Easter
    put(data, "Fiji Standard Time", "+12", "+12")                # Pacific/Fiji
    put(data, "Central Pacific Standard Time", "+11", "+11")     # Pacific/Guadalcanal
    put(data, "Hawaiian Standard Time", "HST", "HST")            # Pacific/Honolulu
    put(data, "Line Islands Standard Time", "+14", "+14")        # Pacific/Kiritimati
    put(data, "Marquesas Standard Time", "-0930", "-0930")       # Pacific/Marquesas
    put(data, "Norfolk Standard Time", "+11", "+12")             # Pacific/Norfolk
    put(data, "West Pacific Standard Time", "+10", "+10")        # Pacific/Port_Moresby
    put(data, "Tonga Standard Time", "+13", "+13")               # Pacific/Tongatapu
    data
  end

  # TODO: this is needed to avoid generating lots of allocas
  # in LLVM, which makes LLVM really slow. The compiler should
  # try to avoid/reuse temporary allocas.
  # Explanation: https://github.com/crystal-lang/crystal/issues/4516#issuecomment-306226171
  private def self.put(hash : Hash, key, value) : Nil
    hash[key] = value
  end

  private def self.put(hash : Hash, key, *values) : Nil
    hash[key] = values
  end
end
