/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import java.util.Arrays;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssFontSynthesis
extends org.w3c.css.properties.css.CssFontSynthesis {
    public static final CssIdent[] allowedValues;

    public static final CssIdent getAllowedValue(CssIdent ident) {
        for (CssIdent id : allowedValues) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssFontSynthesis() {
        this.value = initial;
    }

    public CssFontSynthesis(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > allowedValues.length) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        ArrayList<CssIdent> ids = new ArrayList<CssIdent>();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (val.getType() != 0) {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
            CssIdent id = val.getIdent();
            if (CssIdent.isCssWide(id) || none.equals(id)) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                this.value = val;
            } else {
                CssIdent okIdent = CssFontSynthesis.getAllowedValue(id);
                if (okIdent == null) {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                if (ids.contains(okIdent)) {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                values.add(val);
                ids.add(okIdent);
            }
            expression.next();
            if (expression.end() || op == ' ') continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        if (!values.isEmpty()) {
            this.value = values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
        }
    }

    public CssFontSynthesis(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        String[] _allowedValues = new String[]{"weight", "style", "small-caps"};
        allowedValues = new CssIdent[_allowedValues.length];
        for (int i = 0; i < allowedValues.length; ++i) {
            CssFontSynthesis.allowedValues[i] = CssIdent.getIdent(_allowedValues[i]);
        }
        Arrays.sort(allowedValues);
    }
}

