/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.textfileinput;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.gui.TextFileInputFieldInterface;
import org.pentaho.di.core.row.ValueMeta;

public class TextFileInputField
implements Cloneable,
TextFileInputFieldInterface {
    private String name;
    private int position;
    private int length;
    private int type;
    private boolean ignore;
    private String format;
    private int trimtype;
    private int precision;
    private String currencySymbol;
    private String decimalSymbol;
    private String groupSymbol;
    private boolean repeat;
    private String nullString;
    private String ifNullValue;
    private String[] samples;
    private NumberFormat nf;
    private DecimalFormat df;
    private DecimalFormatSymbols dfs;
    private SimpleDateFormat daf;
    private static final String[] date_formats = new String[]{"yyyy/MM/dd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm:ss", "dd/MM/yyyy", "dd-MM-yyyy", "yyyy/MM/dd", "yyyy-MM-dd", "yyyyMMdd", "ddMMyyyy", "d-M-yyyy", "d/M/yyyy", "d-M-yy", "d/M/yy"};
    private static final String[] number_formats = new String[]{"", "#", Const.DEFAULT_NUMBER_FORMAT, "0.00", "0000000000000", "###,###,###.#######", "###############.###############", "#####.###############%"};

    public TextFileInputField(String fieldname, int position, int length) {
        this.name = fieldname;
        this.position = position;
        this.length = length;
        this.type = 2;
        this.ignore = false;
        this.format = "";
        this.trimtype = 0;
        this.groupSymbol = "";
        this.decimalSymbol = "";
        this.currencySymbol = "";
        this.precision = -1;
        this.repeat = false;
        this.nullString = "";
        this.ifNullValue = "";
    }

    public TextFileInputField() {
        this(null, -1, -1);
    }

    public int compare(Object obj) {
        TextFileInputField field = (TextFileInputField)obj;
        return this.position - field.getPosition();
    }

    public int compareTo(TextFileInputFieldInterface field) {
        return this.position - field.getPosition();
    }

    public boolean equal(Object obj) {
        TextFileInputField field = (TextFileInputField)obj;
        return this.position == field.getPosition();
    }

    public Object clone() {
        try {
            Object retval = super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String fieldname) {
        this.name = fieldname;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return ValueMeta.getTypeDesc((int)this.type);
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isIgnored() {
        return this.ignore;
    }

    public void setIgnored(boolean ignore) {
        this.ignore = ignore;
    }

    public void flipIgnored() {
        this.ignore = !this.ignore;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSamples(String[] samples) {
        this.samples = samples;
    }

    public int getTrimType() {
        return this.trimtype;
    }

    public String getTrimTypeCode() {
        return ValueMeta.getTrimTypeCode((int)this.trimtype);
    }

    public String getTrimTypeDesc() {
        return ValueMeta.getTrimTypeDesc((int)this.trimtype);
    }

    public void setTrimType(int trimtype) {
        this.trimtype = trimtype;
    }

    public String getGroupSymbol() {
        return this.groupSymbol;
    }

    public void setGroupSymbol(String group_symbol) {
        this.groupSymbol = group_symbol;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimal_symbol) {
        this.decimalSymbol = decimal_symbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currency_symbol) {
        this.currencySymbol = currency_symbol;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public boolean isRepeated() {
        return this.repeat;
    }

    public void setRepeated(boolean repeat) {
        this.repeat = repeat;
    }

    public void flipRepeated() {
        this.repeat = !this.repeat;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String null_string) {
        this.nullString = null_string;
    }

    public String getIfNullValue() {
        return this.ifNullValue;
    }

    public void setIfNullValue(String ifNullValue) {
        this.ifNullValue = ifNullValue;
    }

    public String toString() {
        return this.name + "@" + this.position + ":" + this.length;
    }

    public void guess() {
        this.guessTrimType();
        this.guessType();
        this.guessIgnore();
    }

    public void guessTrimType() {
        boolean spaces_before = false;
        boolean spaces_after = false;
        for (int i = 0; i < this.samples.length; ++i) {
            spaces_before |= Const.nrSpacesBefore((String)this.samples[i]) > 0;
            spaces_after |= Const.nrSpacesAfter((String)this.samples[i]) > 0;
            this.samples[i] = Const.trim((String)this.samples[i]);
        }
        this.trimtype = 0;
        if (spaces_before) {
            this.trimtype |= 1;
        }
        if (spaces_after) {
            this.trimtype |= 2;
        }
    }

    public void guessType() {
        this.nf = NumberFormat.getInstance();
        this.df = (DecimalFormat)this.nf;
        this.dfs = new DecimalFormatSymbols();
        this.daf = new SimpleDateFormat();
        this.daf.setLenient(false);
        this.type = 2;
        if (this.samples == null) {
            return;
        }
        int datefmt_cnt = date_formats.length;
        boolean[] datefmt = new boolean[date_formats.length];
        for (int i = 0; i < date_formats.length; ++i) {
            datefmt[i] = true;
        }
        int datenul = 0;
        for (int i = 0; i < this.samples.length; ++i) {
            if (this.samples[i].length() > 0 && this.samples[i].equalsIgnoreCase(this.nullString)) {
                ++datenul;
                continue;
            }
            for (int x = 0; x < date_formats.length; ++x) {
                if (this.samples[i] == null || Const.onlySpaces((String)this.samples[i]) || this.samples[i].length() == 0) {
                    datefmt[x] = false;
                    --datefmt_cnt;
                }
                if (!datefmt[x]) continue;
                try {
                    this.daf.applyPattern(date_formats[x]);
                    Date date = this.daf.parse(this.samples[i]);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    int year = cal.get(1);
                    if (year >= 1800 && year <= 2200) continue;
                    datefmt[x] = false;
                    --datefmt_cnt;
                    continue;
                }
                catch (Exception e) {
                    datefmt[x] = false;
                    --datefmt_cnt;
                }
            }
        }
        if (datefmt_cnt > 0 && datenul != this.samples.length) {
            int first = -1;
            for (int i = 0; i < date_formats.length && first < 0; ++i) {
                if (!datefmt[i]) continue;
                first = i;
            }
            this.type = 3;
            this.format = date_formats[first];
            return;
        }
        boolean isnumber = true;
        this.decimalSymbol = "" + this.dfs.getDecimalSeparator();
        this.groupSymbol = "" + this.dfs.getGroupingSeparator();
        boolean[] numfmt = new boolean[number_formats.length];
        int[] maxprecision = new int[number_formats.length];
        for (int i = 0; i < numfmt.length; ++i) {
            numfmt[i] = true;
            maxprecision[i] = -1;
        }
        int numfmt_cnt = number_formats.length;
        int numnul = 0;
        for (int i = 0; i < this.samples.length && isnumber; ++i) {
            int x;
            boolean contains_dot = false;
            boolean contains_comma = false;
            String field = this.samples[i];
            if (field.length() > 0 && field.equalsIgnoreCase(this.nullString)) {
                ++numnul;
                continue;
            }
            for (x = 0; x < field.length() && isnumber; ++x) {
                char ch = field.charAt(x);
                if (!(Character.isDigit(ch) || ch == '.' || ch == ',' || ch == '-' && x <= 0 || ch == 'E' || ch == 'e')) {
                    isnumber = false;
                    numfmt_cnt = 0;
                    continue;
                }
                if (ch == '.') {
                    contains_dot = true;
                }
                if (ch != ',') continue;
                contains_comma = true;
            }
            if (!isnumber) continue;
            if (contains_dot && !contains_comma) {
                this.dfs.setDecimalSeparator('.');
                this.decimalSymbol = ".";
                this.dfs.setGroupingSeparator(',');
                this.groupSymbol = ",";
            } else if (!contains_dot && contains_comma) {
                this.dfs.setDecimalSeparator(',');
                this.decimalSymbol = ",";
                this.dfs.setGroupingSeparator('.');
                this.groupSymbol = ".";
            } else if (contains_dot && contains_comma) {
                int idx_com;
                int idx_dot = field.indexOf(46);
                if (idx_dot > (idx_com = field.indexOf(44))) {
                    this.dfs.setDecimalSeparator('.');
                    this.decimalSymbol = ".";
                    this.dfs.setGroupingSeparator(',');
                    this.groupSymbol = ",";
                } else {
                    this.dfs.setDecimalSeparator(',');
                    this.decimalSymbol = ",";
                    this.dfs.setGroupingSeparator('.');
                    this.groupSymbol = ".";
                }
            }
            for (x = 0; x < number_formats.length; ++x) {
                if (!numfmt[x]) continue;
                boolean islong = true;
                try {
                    int prec = -1;
                    if (!contains_dot && !contains_comma) {
                        try {
                            Long.parseLong(field);
                            prec = 0;
                        }
                        catch (Exception e) {
                            islong = false;
                        }
                    }
                    if (!islong) {
                        this.df.setDecimalFormatSymbols(this.dfs);
                        this.df.applyPattern(number_formats[x]);
                        double d = this.df.parse(field).doubleValue();
                        prec = TextFileInputField.guessPrecision(d);
                    }
                    if (prec <= maxprecision[x]) continue;
                    maxprecision[x] = prec;
                    continue;
                }
                catch (Exception e) {
                    numfmt[x] = false;
                    --numfmt_cnt;
                }
            }
        }
        if (numfmt_cnt > 0 && numnul != this.samples.length) {
            int first = -1;
            for (int i = 0; i < number_formats.length && first < 0; ++i) {
                if (!numfmt[i]) continue;
                first = i;
            }
            this.type = 1;
            this.format = number_formats[first];
            this.precision = maxprecision[first];
            return;
        }
        this.type = 2;
        this.format = "";
        this.precision = -1;
        this.decimalSymbol = "";
        this.groupSymbol = "";
        this.currencySymbol = "";
    }

    public static final int guessPrecision(double d) {
        int maxprec = 4;
        double maxdiff = 5.0E-5;
        double diff = Math.abs(Math.floor(d) - d);
        if (diff < maxdiff) {
            return 0;
        }
        for (int i = 1; i < maxprec; ++i) {
            double factor = Math.pow(10.0, i);
            diff = Math.abs(Math.floor(d * factor) - d * factor);
            if (diff < maxdiff) {
                return i;
            }
            factor *= 10.0;
        }
        return -1;
    }

    public void guessIgnore() {
        int i;
        boolean stop = false;
        for (i = 0; i < this.samples.length && !stop; ++i) {
            if (Const.onlySpaces((String)this.samples[i])) continue;
            stop = true;
        }
        if (!stop) {
            this.ignore = true;
            return;
        }
        stop = false;
        for (i = 0; i < this.samples.length && !stop; ++i) {
            if (this.samples[i].length() <= 0) continue;
            stop = true;
        }
        if (!stop) {
            this.ignore = true;
            return;
        }
        stop = false;
        for (i = 0; i < this.samples.length && !stop; ++i) {
            if (this.samples[i].equalsIgnoreCase(this.nullString)) continue;
            stop = true;
        }
        if (!stop) {
            this.ignore = true;
            return;
        }
    }

    public TextFileInputFieldInterface createNewInstance(String newFieldname, int x, int newlength) {
        return new TextFileInputField(newFieldname, x, newlength);
    }
}

