/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.RecordComponent;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.JavaFeature;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ExternalAnnotationSuperimposer;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RecordComponentBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeCollisionException;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;

public class ClassScope
extends Scope {
    public TypeDeclaration referenceContext;
    public TypeReference superTypeReference;
    ArrayList<TypeReference> deferredBoundChecks;
    public boolean resolvingPolyExpressionArguments = false;
    public boolean insideEarlyConstructionContext = false;

    public ClassScope(Scope parent, TypeDeclaration context) {
        super(3, parent);
        this.referenceContext = context;
        this.deferredBoundChecks = null;
    }

    void buildAnonymousTypeBinding(SourceTypeBinding enclosingType, ReferenceBinding supertype) {
        AbstractMethodDeclaration[] methods;
        LocalTypeBinding anonymousType = this.buildLocalType(enclosingType, enclosingType.fPackage);
        anonymousType.modifiers |= 0x8000000;
        int inheritedBits = supertype.typeBits;
        if ((inheritedBits & 4) != 0 && (methods = this.referenceContext.methods) != null) {
            AbstractMethodDeclaration[] abstractMethodDeclarationArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractMethodDeclaration method = abstractMethodDeclarationArray[n2];
                if (CharOperation.equals(TypeConstants.CLOSE, method.selector) && method.arguments == null) {
                    inheritedBits &= 0x713;
                    break;
                }
                ++n2;
            }
        }
        anonymousType.typeBits |= inheritedBits;
        anonymousType.setPermittedTypes(Binding.NO_PERMITTED_TYPES);
        if (supertype.isInterface()) {
            anonymousType.setSuperClass(this.getJavaLangObject());
            anonymousType.setSuperInterfaces(new ReferenceBinding[]{supertype});
            typeReference = this.referenceContext.allocation.type;
            if (typeReference != null) {
                this.referenceContext.superInterfaces = new TypeReference[]{typeReference};
                if ((supertype.tagBits & 0x40000000L) != 0L) {
                    this.problemReporter().superTypeCannotUseWildcard(anonymousType, typeReference, supertype);
                    anonymousType.tagBits |= 0x20000L;
                    anonymousType.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
                }
                if (supertype.isSealed()) {
                    this.problemReporter().anonymousClassCannotExtendSealedType(typeReference, supertype);
                    anonymousType.tagBits |= 0x20000L;
                    anonymousType.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
                }
            }
        } else {
            anonymousType.setSuperClass(supertype);
            anonymousType.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
            typeReference = this.referenceContext.allocation.type;
            if (typeReference != null) {
                this.referenceContext.superclass = typeReference;
                if (supertype.erasure().id == 41) {
                    this.problemReporter().cannotExtendEnum(anonymousType, typeReference, supertype);
                    anonymousType.tagBits |= 0x20000L;
                    anonymousType.setSuperClass(this.getJavaLangObject());
                } else if (supertype.erasure().id == 93) {
                    this.problemReporter().recordCannotExtendRecord(anonymousType, typeReference, supertype);
                    anonymousType.tagBits |= 0x20000L;
                    anonymousType.setSuperClass(this.getJavaLangObject());
                } else if (supertype.isFinal()) {
                    this.problemReporter().anonymousClassCannotExtendFinalClass(typeReference, supertype);
                    anonymousType.tagBits |= 0x20000L;
                    anonymousType.setSuperClass(this.getJavaLangObject());
                } else if ((supertype.tagBits & 0x40000000L) != 0L) {
                    this.problemReporter().superTypeCannotUseWildcard(anonymousType, typeReference, supertype);
                    anonymousType.tagBits |= 0x20000L;
                    anonymousType.setSuperClass(this.getJavaLangObject());
                } else if (supertype.isSealed()) {
                    this.problemReporter().anonymousClassCannotExtendSealedType(typeReference, supertype);
                    anonymousType.tagBits |= 0x20000L;
                    anonymousType.setSuperClass(this.getJavaLangObject());
                }
            }
        }
        anonymousType.tagBits |= 0x200L;
        this.connectMemberTypes();
        this.buildFieldsAndMethods();
        anonymousType.faultInTypesForFieldsAndMethods();
        anonymousType.verifyMethods(this.environment().methodVerifier());
    }

    void buildComponents() {
        int size;
        SourceTypeBinding sourceType = this.referenceContext.binding;
        if (!sourceType.isRecord()) {
            return;
        }
        if (sourceType.areComponentsInitialized()) {
            return;
        }
        if (this.referenceContext.recordComponents.length == 0) {
            sourceType.setComponents(Binding.NO_COMPONENTS);
            return;
        }
        RecordComponent[] components = this.referenceContext.recordComponents;
        int count = size = components.length;
        RecordComponentBinding[] componentBindings = new RecordComponentBinding[count];
        HashtableOfObject knownComponentNames = new HashtableOfObject(count);
        count = 0;
        int i = 0;
        while (i < size) {
            RecordComponent component = components[i];
            RecordComponentBinding componentBinding = new RecordComponentBinding(sourceType, component, null, component.modifiers | 0x2000000);
            componentBinding.id = count;
            if ((componentBinding.modifiers & 0xFFFF) != 0) {
                this.problemReporter().recordComponentsCannotHaveModifiers(component);
            }
            if (knownComponentNames.containsKey(component.name)) {
                RecordComponentBinding previousBinding = (RecordComponentBinding)knownComponentNames.get(component.name);
                if (previousBinding != null) {
                    int f = 0;
                    while (f < i) {
                        RecordComponent previousComponent = components[f];
                        if (previousComponent.binding == previousBinding) {
                            this.problemReporter().recordDuplicateComponent(previousComponent);
                            break;
                        }
                        ++f;
                    }
                }
                knownComponentNames.put(component.name, null);
                this.problemReporter().recordDuplicateComponent(component);
                component.binding = null;
            } else {
                knownComponentNames.put(component.name, componentBinding);
                componentBindings[count++] = componentBinding;
            }
            ++i;
        }
        if (count != componentBindings.length) {
            RecordComponentBinding[] recordComponentBindingArray = componentBindings;
            componentBindings = new RecordComponentBinding[count];
            System.arraycopy(recordComponentBindingArray, 0, componentBindings, 0, count);
        }
        sourceType.setComponents(componentBindings);
    }

    void buildFields() {
        SourceTypeBinding sourceType = this.referenceContext.binding;
        if (sourceType.areFieldsInitialized()) {
            return;
        }
        FieldDeclaration[] fields = this.referenceContext.fields == null ? ASTNode.NO_FIELD_DECLARATIONS : this.referenceContext.fields;
        int size = fields.length;
        int count = 0;
        int i = 0;
        while (i < size) {
            switch (fields[i].getKind()) {
                case 1: 
                case 3: {
                    ++count;
                }
            }
            ++i;
        }
        RecordComponent[] recordComponents = this.referenceContext.recordComponents;
        if ((count += recordComponents.length) == 0) {
            sourceType.setFields(Binding.NO_FIELDS);
            return;
        }
        FieldBinding[] fieldBindings = new FieldBinding[count];
        HashtableOfObject knownFieldNames = new HashtableOfObject(count);
        count = 0;
        AbstractVariableDeclaration[] variableDeclarartions = this.referenceContext.protoFieldDeclarations();
        int i2 = -1;
        AbstractVariableDeclaration[] abstractVariableDeclarationArray = variableDeclarartions;
        int n = variableDeclarartions.length;
        int n2 = 0;
        while (n2 < n) {
            block19: {
                AbstractVariableDeclaration variableDeclaration = abstractVariableDeclarationArray[n2];
                ++i2;
                if (variableDeclaration.getKind() != 2) {
                    FieldBinding fieldBinding;
                    if (variableDeclaration instanceof FieldDeclaration) {
                        FieldDeclaration field = (FieldDeclaration)variableDeclaration;
                        fieldBinding = new FieldBinding(field, null, field.modifiers | 0x2000000, sourceType);
                        this.checkAndSetModifiersForField(fieldBinding, field);
                    } else {
                        fieldBinding = new SyntheticFieldBinding(variableDeclaration.name, null, 100663314, sourceType, Constant.NotAConstant);
                    }
                    fieldBinding.id = count;
                    if (knownFieldNames.containsKey(variableDeclaration.name)) {
                        FieldBinding previousBinding = (FieldBinding)knownFieldNames.get(variableDeclaration.name);
                        if (previousBinding != null) {
                            int f = 0;
                            while (f < i2) {
                                AbstractVariableDeclaration previousField = variableDeclarartions[f];
                                if (CharOperation.equals(previousField.name, variableDeclaration.name)) {
                                    if (previousField.getKind() != 7 || variableDeclaration.getKind() != 7) {
                                        this.problemReporter().duplicateFieldInType(sourceType, previousField);
                                        break;
                                    }
                                    break block19;
                                }
                                ++f;
                            }
                        }
                        knownFieldNames.put(variableDeclaration.name, null);
                        this.problemReporter().duplicateFieldInType(sourceType, variableDeclaration);
                        variableDeclaration.setBinding(null);
                    } else {
                        knownFieldNames.put(variableDeclaration.name, fieldBinding);
                        fieldBindings[count++] = fieldBinding;
                        if (variableDeclaration instanceof RecordComponent) {
                            RecordComponent componentDecl = (RecordComponent)variableDeclaration;
                            if (fieldBinding instanceof SyntheticFieldBinding) {
                                sourceType.addSyntheticRecordState(componentDecl, fieldBinding);
                            }
                        }
                    }
                }
            }
            ++n2;
        }
        if (count != fieldBindings.length) {
            FieldBinding[] fieldBindingArray = fieldBindings;
            fieldBindings = new FieldBinding[count];
            System.arraycopy(fieldBindingArray, 0, fieldBindings, 0, count);
        }
        sourceType.tagBits &= 0xFFFFFFFFFFFFCFFFL;
        sourceType.setFields(fieldBindings);
    }

    void buildFieldsAndMethods() {
        ReferenceBinding[] memberTypes;
        this.buildComponents();
        this.buildFields();
        this.buildMethods();
        SourceTypeBinding sourceType = this.referenceContext.binding;
        if (!sourceType.isPrivate() && sourceType.superclass instanceof SourceTypeBinding && sourceType.superclass.isPrivate()) {
            ((SourceTypeBinding)sourceType.superclass).tagIndirectlyAccessibleMembers();
        }
        if (sourceType.isMemberType() && !sourceType.isLocalType()) {
            ((MemberTypeBinding)sourceType).checkSyntheticArgsAndFields();
        }
        ReferenceBinding[] referenceBindingArray = memberTypes = sourceType.memberTypes;
        int n = memberTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceBinding memberType = referenceBindingArray[n2];
            ((SourceTypeBinding)memberType).scope.buildFieldsAndMethods();
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private LocalTypeBinding buildLocalType(SourceTypeBinding enclosingType, PackageBinding packageBinding) {
        ReferenceBinding[] memberTypeBindings;
        LocalTypeBinding localType;
        block10: {
            this.referenceContext.scope = this;
            this.referenceContext.staticInitializerScope = new MethodScope(this, this.referenceContext, true);
            this.referenceContext.initializerScope = new MethodScope(this, this.referenceContext, false);
            localType = new LocalTypeBinding(this, enclosingType, this.enclosingSwitchLabel());
            this.referenceContext.binding = localType;
            this.checkAndSetModifiers();
            this.buildTypeVariables();
            memberTypeBindings = Binding.NO_MEMBER_TYPES;
            if (this.referenceContext.memberTypes == null) break block10;
            int size = this.referenceContext.memberTypes.length;
            memberTypeBindings = new ReferenceBinding[size];
            int count = 0;
            int i = 0;
            while (i < size) {
                block9: {
                    void var9_9;
                    ReferenceBinding referenceBinding;
                    TypeDeclaration memberContext = this.referenceContext.memberTypes[i];
                    switch (TypeDeclaration.kind(memberContext.modifiers)) {
                        case 2: {
                            if (this.compilerOptions().sourceLevel >= 0x3C0000L) break;
                        }
                        case 4: {
                            this.problemReporter().illegalLocalTypeDeclaration(memberContext);
                            break block9;
                        }
                    }
                    LocalTypeBinding localTypeBinding = localType;
                    do {
                        if (!CharOperation.equals(var9_9.sourceName, memberContext.name)) continue;
                        this.problemReporter().typeCollidesWithEnclosingType(memberContext);
                        break block9;
                    } while ((referenceBinding = var9_9.enclosingType()) != null);
                    int j = 0;
                    while (j < i) {
                        if (CharOperation.equals(this.referenceContext.memberTypes[j].name, memberContext.name)) {
                            this.problemReporter().duplicateNestedType(memberContext);
                            break block9;
                        }
                        ++j;
                    }
                    ClassScope memberScope = new ClassScope(this, this.referenceContext.memberTypes[i]);
                    LocalTypeBinding memberBinding = memberScope.buildLocalType(localType, packageBinding);
                    memberBinding.setAsMemberType();
                    memberTypeBindings[count++] = memberBinding;
                }
                ++i;
            }
            if (count != size) {
                ReferenceBinding[] referenceBindingArray = memberTypeBindings;
                memberTypeBindings = new ReferenceBinding[count];
                System.arraycopy(referenceBindingArray, 0, memberTypeBindings, 0, count);
            }
        }
        localType.setMemberTypes(memberTypeBindings);
        return localType;
    }

    void buildLocalTypeBinding(SourceTypeBinding enclosingType) {
        LocalTypeBinding localType = this.buildLocalType(enclosingType, enclosingType.fPackage);
        this.connectTypeHierarchy();
        this.checkParameterizedTypeBounds();
        this.checkParameterizedSuperTypeCollisions();
        this.referenceContext.updateSupertypesWithAnnotations(Collections.emptyMap());
        this.buildFieldsAndMethods();
        localType.faultInTypesForFieldsAndMethods();
        this.referenceContext.binding.verifyMethods(this.environment().methodVerifier());
    }

    private void buildMemberTypes(AccessRestriction accessRestriction) {
        SourceTypeBinding sourceType = this.referenceContext.binding;
        ReferenceBinding[] memberTypeBindings = Binding.NO_MEMBER_TYPES;
        if (this.referenceContext.memberTypes != null) {
            int length = this.referenceContext.memberTypes.length;
            memberTypeBindings = new ReferenceBinding[length];
            int count = 0;
            int i = 0;
            while (i < length) {
                TypeDeclaration memberContext = this.referenceContext.memberTypes[i];
                if (this.environment().root.isProcessingAnnotations && this.environment().isMissingType(memberContext.name)) {
                    throw new SourceTypeCollisionException();
                }
                block0 : switch (TypeDeclaration.kind(memberContext.modifiers)) {
                    case 2: 
                    case 4: {
                        if (this.compilerOptions().sourceLevel < 0x3C0000L && sourceType.isNestedType() && sourceType.isClass() && !sourceType.isStatic()) {
                            this.problemReporter().illegalLocalTypeDeclaration(memberContext);
                            break;
                        }
                    }
                    default: {
                        ReferenceBinding type = sourceType;
                        while (!this.referenceContext.isImplicitType()) {
                            if (CharOperation.equals(type.sourceName, memberContext.name)) {
                                this.problemReporter().typeCollidesWithEnclosingType(memberContext);
                                break block0;
                            }
                            if ((type = type.enclosingType()) != null) continue;
                        }
                        int j = 0;
                        while (j < i) {
                            if (CharOperation.equals(this.referenceContext.memberTypes[j].name, memberContext.name)) {
                                this.problemReporter().duplicateNestedType(memberContext);
                                break block0;
                            }
                            ++j;
                        }
                        ClassScope memberScope = new ClassScope(this, memberContext);
                        memberTypeBindings[count++] = memberScope.buildType(sourceType, sourceType.fPackage, accessRestriction);
                    }
                }
                ++i;
            }
            if (count != length) {
                ReferenceBinding[] referenceBindingArray = memberTypeBindings;
                memberTypeBindings = new ReferenceBinding[count];
                System.arraycopy(referenceBindingArray, 0, memberTypeBindings, 0, count);
            }
        }
        sourceType.setMemberTypes(memberTypeBindings);
    }

    void buildMethods() {
        int i;
        boolean isEnum;
        SourceTypeBinding sourceType = this.referenceContext.binding;
        if (sourceType.areMethodsInitialized()) {
            return;
        }
        boolean bl = isEnum = TypeDeclaration.kind(this.referenceContext.modifiers) == 3;
        if (this.referenceContext.methods == null && !isEnum && !sourceType.isRecord()) {
            this.referenceContext.binding.setMethods(Binding.NO_METHODS);
            return;
        }
        AbstractMethodDeclaration[] methods = this.referenceContext.methods;
        int size = methods == null ? 0 : methods.length;
        int clinitIndex = -1;
        int i2 = 0;
        while (i2 < size) {
            if (methods[i2].isClinit()) {
                clinitIndex = i2;
                break;
            }
            ++i2;
        }
        int count = isEnum ? 2 : 0;
        MethodBinding[] methodBindings = new MethodBinding[(clinitIndex == -1 ? size : size - 1) + count];
        if (isEnum) {
            methodBindings[0] = sourceType.addSyntheticEnumMethod(TypeConstants.VALUES);
            methodBindings[1] = sourceType.addSyntheticEnumMethod(TypeConstants.VALUEOF);
        }
        boolean hasNativeMethods = false;
        if (sourceType.isAbstract()) {
            i = 0;
            while (i < size) {
                MethodScope scope;
                MethodBinding methodBinding;
                if (i != clinitIndex && (methodBinding = (scope = new MethodScope(this, methods[i], false)).createMethod(methods[i])) != null) {
                    methodBindings[count++] = methodBinding;
                    hasNativeMethods = hasNativeMethods || methodBinding.isNative();
                }
                ++i;
            }
        } else {
            boolean hasAbstractMethods = false;
            int i3 = 0;
            while (i3 < size) {
                MethodScope scope;
                MethodBinding methodBinding;
                if (i3 != clinitIndex && (methodBinding = (scope = new MethodScope(this, methods[i3], false)).createMethod(methods[i3])) != null) {
                    methodBindings[count++] = methodBinding;
                    hasAbstractMethods = hasAbstractMethods || methodBinding.isAbstract();
                    boolean bl2 = hasNativeMethods = hasNativeMethods || methodBinding.isNative();
                    if (methods[i3].isCanonicalConstructor()) {
                        methodBinding.extendedTagBits |= 8;
                    }
                }
                ++i3;
            }
            if (hasAbstractMethods) {
                this.problemReporter().abstractMethodInConcreteClass(sourceType);
            }
        }
        if (count != methodBindings.length) {
            MethodBinding[] methodBindingArray = methodBindings;
            methodBindings = new MethodBinding[count];
            System.arraycopy(methodBindingArray, 0, methodBindings, 0, count);
        }
        sourceType.tagBits &= 0xFFFFFFFFFFFF3FFFL;
        sourceType.setMethods(methodBindings);
        if (hasNativeMethods) {
            i = 0;
            while (i < methodBindings.length) {
                methodBindings[i].modifiers |= 0x8000000;
                ++i;
            }
            FieldBinding[] fields = sourceType.unResolvedFields();
            int i4 = 0;
            while (i4 < fields.length) {
                fields[i4].modifiers |= 0x8000000;
                ++i4;
            }
        }
        if (isEnum && this.compilerOptions().isAnnotationBasedNullAnalysisEnabled) {
            LookupEnvironment environment = this.environment();
            ((SyntheticMethodBinding)methodBindings[0]).markNonNull(environment);
            ((SyntheticMethodBinding)methodBindings[1]).markNonNull(environment);
        }
    }

    SourceTypeBinding buildType(SourceTypeBinding enclosingType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        TypeParameter[] typeParameters;
        String externalAnnotationPath;
        this.referenceContext.scope = this;
        this.referenceContext.staticInitializerScope = new MethodScope(this, this.referenceContext, true);
        this.referenceContext.initializerScope = new MethodScope(this, this.referenceContext, false);
        if (enclosingType == null) {
            className = CharOperation.arrayConcat(packageBinding.compoundName, this.referenceContext.name);
            this.referenceContext.binding = new SourceTypeBinding(className, packageBinding, this);
        } else {
            className = CharOperation.deepCopy(enclosingType.compoundName);
            className[className.length - 1] = CharOperation.concat(className[className.length - 1], this.referenceContext.name, '$');
            if (packageBinding.hasType0Any(className[className.length - 1])) {
                this.parent.problemReporter().duplicateNestedType(this.referenceContext);
            }
            this.referenceContext.binding = new MemberTypeBinding(className, this, enclosingType);
        }
        SourceTypeBinding sourceType = this.referenceContext.binding;
        sourceType.module = this.module();
        this.environment().setAccessRestriction(sourceType, accessRestriction);
        ICompilationUnit compilationUnit = this.referenceContext.compilationResult.getCompilationUnit();
        if (compilationUnit != null && this.compilerOptions().isAnnotationBasedNullAnalysisEnabled && (externalAnnotationPath = compilationUnit.getExternalAnnotationPath(CharOperation.toString(sourceType.compoundName))) != null) {
            ExternalAnnotationSuperimposer.apply(sourceType, externalAnnotationPath);
        }
        sourceType.typeVariables = (typeParameters = this.referenceContext.typeParameters) == null || typeParameters.length == 0 ? Binding.NO_TYPE_VARIABLES : null;
        sourceType.fPackage.addType(sourceType);
        this.checkAndSetModifiers();
        this.buildTypeVariables();
        this.buildMemberTypes(accessRestriction);
        return sourceType;
    }

    private void buildTypeVariables() {
        SourceTypeBinding sourceType = this.referenceContext.binding;
        TypeParameter[] typeParameters = this.referenceContext.typeParameters;
        if (typeParameters == null || typeParameters.length == 0) {
            sourceType.setTypeVariables(Binding.NO_TYPE_VARIABLES);
            return;
        }
        sourceType.setTypeVariables(Binding.NO_TYPE_VARIABLES);
        if (sourceType.id == 1) {
            this.problemReporter().objectCannotBeGeneric(this.referenceContext);
            return;
        }
        sourceType.setTypeVariables(this.createTypeVariables(typeParameters, sourceType));
        sourceType.modifiers |= 0x40000000;
    }

    @Override
    void resolveTypeParameter(TypeParameter typeParameter) {
        typeParameter.resolve(this);
    }

    private void checkAndSetModifiers() {
        SourceTypeBinding sourceType = this.referenceContext.binding;
        int modifiers = sourceType.modifiers;
        CompilerOptions options = this.compilerOptions();
        boolean is16Plus = this.compilerOptions().sourceLevel >= 0x3C0000L;
        boolean isSealedSupported = JavaFeature.SEALED_CLASSES.isSupported(options);
        boolean hierarchySealed = (modifiers & 0x14000000) != 0;
        switch (modifiers & 0x14000010) {
            case 0: 
            case 16: 
            case 0x4000000: 
            case 0x10000000: {
                break;
            }
            default: {
                this.problemReporter().illegalModifierCombinationForType(sourceType);
            }
        }
        if (sourceType.isRecord()) {
            modifiers |= 0x10;
        }
        if ((modifiers & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForType(sourceType);
        }
        ReferenceBinding enclosingType = sourceType.enclosingType();
        boolean isMemberType = sourceType.isMemberType();
        if (isMemberType) {
            if (sourceType.hasEnclosingInstanceContext()) {
                modifiers |= enclosingType.modifiers & 0x40000000;
            }
            modifiers |= enclosingType.modifiers & 0x800;
            if (enclosingType.isInterface()) {
                modifiers |= 1;
            }
            if (sourceType.isEnum()) {
                if (!is16Plus && !enclosingType.isStatic()) {
                    this.problemReporter().nonStaticContextForEnumMemberType(sourceType);
                } else {
                    modifiers |= 8;
                }
            } else if (sourceType.isInterface()) {
                modifiers |= 8;
            } else if (sourceType.isRecord()) {
                modifiers |= 8;
            }
        } else if (sourceType.isLocalType()) {
            MethodScope methodScope;
            if (sourceType.isEnum()) {
                if (!is16Plus) {
                    this.problemReporter().illegalLocalTypeDeclaration(this.referenceContext);
                    sourceType.modifiers = 0;
                    return;
                }
                int UNEXPECTED_MODIFIERS = -18433;
                if ((modifiers & 0xFFFF & 0xFFFFB7FF) != 0 || hierarchySealed) {
                    this.problemReporter().illegalModifierForLocalEnumDeclaration(sourceType);
                    return;
                }
                modifiers |= 8;
            } else if (sourceType.isRecord()) {
                if ((modifiers & 8) != 0) {
                    if (!(this.parent instanceof ClassScope)) {
                        this.problemReporter().recordIllegalStaticModifierForLocalClassOrInterface(sourceType);
                    }
                    return;
                }
                modifiers |= 8;
            }
            if (sourceType.isAnonymousType()) {
                if (this.compilerOptions().complianceLevel < 0x350000L) {
                    modifiers |= 0x10;
                }
                if (this.referenceContext.allocation.type == null) {
                    modifiers |= 0x4000;
                    Scope scope = this;
                    while ((scope = scope.parent) != null) {
                        if (!(scope instanceof MethodScope)) continue;
                        methodScope = (MethodScope)scope;
                        if (methodScope.referenceContext instanceof TypeDeclaration) continue;
                        modifiers |= 8;
                        break;
                    }
                }
            } else if (this.parent.referenceContext() instanceof TypeDeclaration) {
                TypeDeclaration typeDecl = (TypeDeclaration)this.parent.referenceContext();
                if (TypeDeclaration.kind(typeDecl.modifiers) == 2) {
                    modifiers |= 8;
                }
            }
            Scope scope = this;
            block8: do {
                switch (scope.kind) {
                    case 2: {
                        methodScope = (MethodScope)scope;
                        if (methodScope.isLambdaScope()) {
                            methodScope = methodScope.namedMethodScope();
                        }
                        if (methodScope.isInsideInitializer()) {
                            SourceTypeBinding type = ((TypeDeclaration)methodScope.referenceContext).binding;
                            if (methodScope.initializedField != null) {
                                if (!methodScope.initializedField.isViewedAsDeprecated() || sourceType.isDeprecated()) continue block8;
                                modifiers |= 0x200000;
                                break;
                            }
                            if (type.isStrictfp()) {
                                modifiers |= 0x800;
                            }
                            if (!type.isViewedAsDeprecated() || sourceType.isDeprecated()) continue block8;
                            modifiers |= 0x200000;
                            break;
                        }
                        MethodBinding method = ((AbstractMethodDeclaration)methodScope.referenceContext).binding;
                        if (method == null) break;
                        if (method.isStrictfp()) {
                            modifiers |= 0x800;
                        }
                        if (!method.isViewedAsDeprecated() || sourceType.isDeprecated()) continue block8;
                        modifiers |= 0x200000;
                        break;
                    }
                    case 3: {
                        if (enclosingType.isStrictfp()) {
                            modifiers |= 0x800;
                        }
                        if (!enclosingType.isViewedAsDeprecated() || sourceType.isDeprecated()) continue block8;
                        modifiers |= 0x200000;
                        sourceType.tagBits |= enclosingType.tagBits & 0x4000000000000000L;
                    }
                }
            } while ((scope = scope.parent) != null);
        }
        int realModifiers = modifiers & 0xFFFF;
        if ((realModifiers & 0x200) != 0) {
            if (isMemberType) {
                UNEXPECTED_MODIFIERS = -11792;
                if ((realModifiers & 0xFFFFD1F0) != 0) {
                    if ((realModifiers & 0x2000) != 0) {
                        this.problemReporter().illegalModifierForAnnotationMemberType(sourceType);
                    } else {
                        this.problemReporter().illegalModifierForMemberInterface(sourceType);
                    }
                }
            } else if (sourceType.isLocalType()) {
                UNEXPECTED_MODIFIERS = ~(0x2E00 | (is16Plus && this.parent instanceof ClassScope ? 8 : 0));
                if ((realModifiers & UNEXPECTED_MODIFIERS) != 0 || hierarchySealed) {
                    this.problemReporter().localStaticsIllegalVisibilityModifierForInterfaceLocalType(sourceType);
                }
                modifiers |= 8;
            } else {
                UNEXPECTED_MODIFIERS = -11778;
                if ((realModifiers & 0xFFFFD1FE) != 0) {
                    if ((realModifiers & 0x2000) != 0) {
                        this.problemReporter().illegalModifierForAnnotationType(sourceType);
                    } else {
                        this.problemReporter().illegalModifierForInterface(sourceType);
                    }
                }
            }
            if (sourceType.sourceName == TypeConstants.PACKAGE_INFO_NAME) {
                modifiers |= 0x1000;
            }
            modifiers |= 0x400;
        } else if ((realModifiers & 0x4000) != 0) {
            if (isMemberType) {
                int UNEXPECTED_MODIFIERS = -18448;
                if ((realModifiers & 0xFFFFB7F0) != 0 || hierarchySealed) {
                    this.problemReporter().illegalModifierForMemberEnum(sourceType);
                    modifiers &= 0xFFFFFBFF;
                    realModifiers &= 0xFFFFFBFF;
                }
            } else if (!sourceType.isLocalType()) {
                int UNEXPECTED_MODIFIERS = -18434;
                if ((realModifiers & 0xFFFFB7FE) != 0 || hierarchySealed) {
                    this.problemReporter().illegalModifierForEnum(sourceType);
                }
            }
            if (!sourceType.isAnonymousType()) {
                FieldDeclaration[] fields;
                block113: {
                    if ((this.referenceContext.bits & 0x800) != 0) {
                        modifiers |= 0x400;
                    } else {
                        int fieldsLength;
                        TypeDeclaration typeDeclaration = this.referenceContext;
                        fields = typeDeclaration.fields;
                        int n = fieldsLength = fields == null ? 0 : fields.length;
                        if (fieldsLength != 0) {
                            AbstractMethodDeclaration[] methods = typeDeclaration.methods;
                            int methodsLength = methods == null ? 0 : methods.length;
                            boolean definesAbstractMethod = typeDeclaration.superInterfaces != null;
                            int i = 0;
                            while (i < methodsLength && !definesAbstractMethod) {
                                definesAbstractMethod = methods[i].isAbstract();
                                ++i;
                            }
                            if (definesAbstractMethod) {
                                boolean needAbstractBit = false;
                                int i2 = 0;
                                while (i2 < fieldsLength) {
                                    FieldDeclaration fieldDecl = fields[i2];
                                    if (fieldDecl.getKind() == 3) {
                                        if (!(fieldDecl.initialization instanceof QualifiedAllocationExpression)) break block113;
                                        needAbstractBit = true;
                                    }
                                    ++i2;
                                }
                                if (needAbstractBit) {
                                    modifiers |= 0x400;
                                }
                            }
                        }
                    }
                }
                TypeDeclaration typeDeclaration = this.referenceContext;
                fields = typeDeclaration.fields;
                if (fields != null) {
                    int i = 0;
                    int fieldsLength = fields.length;
                    while (i < fieldsLength) {
                        FieldDeclaration fieldDecl = fields[i];
                        if (fieldDecl.getKind() != 3 || !(fieldDecl.initialization instanceof QualifiedAllocationExpression)) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                } else {
                    modifiers |= 0x10;
                }
                if (isSealedSupported && (modifiers & 0x10) == 0) {
                    modifiers |= 0x10000000;
                }
            }
        } else if (sourceType.isRecord()) {
            int UNEXPECTED_MODIFIERS = 0x14000000;
            if (isMemberType) {
                int EXPECTED_MODIFIERS = 2079;
                if ((realModifiers & 0xFFFFF7E0) != 0 || (modifiers & UNEXPECTED_MODIFIERS) != 0) {
                    this.problemReporter().illegalModifierForInnerRecord(sourceType);
                }
            } else if (sourceType.isLocalType()) {
                int EXPECTED_MODIFIERS = 2072;
                if ((realModifiers & 0xFFFFF7E7) != 0 || (modifiers & UNEXPECTED_MODIFIERS) != 0) {
                    this.problemReporter().illegalModifierForLocalRecord(sourceType);
                }
            } else {
                int EXPECTED_MODIFIERS = 2065;
                if ((realModifiers & 0xFFFFF7EE) != 0 || (modifiers & UNEXPECTED_MODIFIERS) != 0) {
                    this.problemReporter().illegalModifierForRecord(sourceType);
                }
            }
        } else {
            if (isMemberType) {
                UNEXPECTED_MODIFIERS = -3104;
                if ((realModifiers & 0xFFFFF3E0) != 0) {
                    this.problemReporter().illegalModifierForMemberClass(sourceType);
                }
            } else if (sourceType.isLocalType()) {
                UNEXPECTED_MODIFIERS = ~(0xC10 | (is16Plus && this.parent instanceof ClassScope ? 8 : 0));
                if ((realModifiers & UNEXPECTED_MODIFIERS) != 0 || hierarchySealed) {
                    this.problemReporter().illegalModifierForLocalClass(sourceType);
                }
            } else {
                UNEXPECTED_MODIFIERS = -3090;
                if ((realModifiers & 0xFFFFF3EE) != 0) {
                    this.problemReporter().illegalModifierForClass(sourceType);
                }
            }
            if ((realModifiers & 0x410) == 1040) {
                this.problemReporter().illegalModifierCombinationFinalAbstractForClass(sourceType);
            }
        }
        if (isMemberType) {
            if (enclosingType.isInterface()) {
                if ((realModifiers & 6) != 0) {
                    this.problemReporter().illegalVisibilityModifierForInterfaceMemberType(sourceType);
                    if ((realModifiers & 4) != 0) {
                        modifiers &= 0xFFFFFFFB;
                    }
                    if ((realModifiers & 2) != 0) {
                        modifiers &= 0xFFFFFFFD;
                    }
                }
            } else {
                int accessorBits = realModifiers & 7;
                if ((accessorBits & accessorBits - 1) > 1) {
                    this.problemReporter().illegalVisibilityModifierCombinationForMemberType(sourceType);
                    if ((accessorBits & 1) != 0) {
                        if ((accessorBits & 4) != 0) {
                            modifiers &= 0xFFFFFFFB;
                        }
                        if ((accessorBits & 2) != 0) {
                            modifiers &= 0xFFFFFFFD;
                        }
                    } else if ((accessorBits & 4) != 0 && (accessorBits & 2) != 0) {
                        modifiers &= 0xFFFFFFFD;
                    }
                }
            }
            if ((realModifiers & 8) == 0) {
                if (enclosingType.isInterface()) {
                    modifiers |= 8;
                }
            } else if (!enclosingType.isStatic() && !is16Plus) {
                this.problemReporter().illegalStaticModifierForMemberType(sourceType);
            }
        }
        sourceType.modifiers = modifiers;
    }

    private void checkAndSetModifiersForField(FieldBinding fieldBinding, FieldDeclaration fieldDecl) {
        int accessorBits;
        int modifiers = fieldBinding.modifiers;
        ReferenceBinding declaringClass = fieldBinding.declaringClass;
        if ((modifiers & 0x400000) != 0) {
            this.problemReporter().duplicateModifierForField(declaringClass, fieldDecl);
        }
        if (declaringClass.isInterface()) {
            int IMPLICIT_MODIFIERS = 25;
            if (((modifiers |= 0x19) & 0xFFFF) != 25) {
                if ((declaringClass.modifiers & 0x2000) != 0) {
                    this.problemReporter().illegalModifierForAnnotationField(fieldDecl);
                } else {
                    this.problemReporter().illegalModifierForInterfaceField(fieldDecl);
                }
            }
            fieldBinding.modifiers = modifiers;
            return;
        }
        if (fieldDecl.getKind() == 3) {
            if ((modifiers & 0xFFFF) != 0) {
                this.problemReporter().illegalModifierForEnumConstant(declaringClass, fieldDecl);
            }
            int IMPLICIT_MODIFIERS = 134234137;
            fieldBinding.modifiers |= 0x8004019;
            return;
        }
        int realModifiers = modifiers & 0xFFFF;
        int UNEXPECTED_MODIFIERS = -224;
        if ((realModifiers & 0xFFFFFF20) != 0) {
            this.problemReporter().illegalModifierForField(declaringClass, fieldDecl);
            modifiers &= 0xFFFF00DF;
        }
        if (((accessorBits = realModifiers & 7) & accessorBits - 1) > 1) {
            this.problemReporter().illegalVisibilityModifierCombinationForField(declaringClass, fieldDecl);
            if ((accessorBits & 1) != 0) {
                if ((accessorBits & 4) != 0) {
                    modifiers &= 0xFFFFFFFB;
                }
                if ((accessorBits & 2) != 0) {
                    modifiers &= 0xFFFFFFFD;
                }
            } else if ((accessorBits & 4) != 0 && (accessorBits & 2) != 0) {
                modifiers &= 0xFFFFFFFD;
            }
        }
        if ((realModifiers & 0x50) == 80) {
            this.problemReporter().illegalModifierCombinationFinalVolatileForField(declaringClass, fieldDecl);
        }
        if (fieldDecl.initialization == null && (modifiers & 0x10) != 0) {
            modifiers |= 0x4000000;
        }
        fieldBinding.modifiers = modifiers;
    }

    public void checkParameterizedSuperTypeCollisions() {
        SourceTypeBinding sourceType = this.referenceContext.binding;
        ReferenceBinding[] interfaces = sourceType.superInterfaces;
        HashMap<TypeBinding, Object> invocations = new HashMap<TypeBinding, Object>(2);
        ReferenceBinding itsSuperclass = sourceType.isInterface() ? null : sourceType.superclass;
        int i = 0;
        int length = interfaces.length;
        while (i < length) {
            ReferenceBinding one = interfaces[i];
            if (!(one == null || itsSuperclass != null && this.hasErasedCandidatesCollisions(itsSuperclass, one, invocations, sourceType, this.referenceContext))) {
                int j = 0;
                while (j < i) {
                    ReferenceBinding two = interfaces[j];
                    if (two != null && this.hasErasedCandidatesCollisions(one, two, invocations, sourceType, this.referenceContext)) break;
                    ++j;
                }
            }
            ++i;
        }
        TypeParameter[] typeParameters = this.referenceContext.typeParameters;
        int i2 = 0;
        int paramLength = typeParameters == null ? 0 : typeParameters.length;
        while (i2 < paramLength) {
            TypeReference[] boundRefs;
            TypeParameter typeParameter = typeParameters[i2];
            TypeVariableBinding typeVariable = typeParameter.binding;
            if (typeVariable != null && typeVariable.isValidBinding() && (boundRefs = typeParameter.bounds) != null) {
                boolean checkSuperclass = TypeBinding.equalsEquals(typeVariable.firstBound, typeVariable.superclass);
                TypeReference[] typeReferenceArray = boundRefs;
                int n = boundRefs.length;
                int n2 = 0;
                block3: while (n2 < n) {
                    TypeReference typeRef = typeReferenceArray[n2];
                    TypeBinding superType = typeRef.resolvedType;
                    if (superType != null && superType.isValidBinding()) {
                        if (checkSuperclass && this.hasErasedCandidatesCollisions(superType, typeVariable.superclass, invocations, typeVariable, typeRef)) break;
                        int index = typeVariable.superInterfaces.length;
                        while (--index >= 0) {
                            if (this.hasErasedCandidatesCollisions(superType, typeVariable.superInterfaces[index], invocations, typeVariable, typeRef)) break block3;
                        }
                    }
                    ++n2;
                }
            }
            ++i2;
        }
        ReferenceBinding[] memberTypes = this.referenceContext.binding.memberTypes;
        if (memberTypes != null && memberTypes != Binding.NO_MEMBER_TYPES) {
            ReferenceBinding[] referenceBindingArray = memberTypes;
            int n = memberTypes.length;
            int n3 = 0;
            while (n3 < n) {
                ReferenceBinding memberType = referenceBindingArray[n3];
                ((SourceTypeBinding)memberType).scope.checkParameterizedSuperTypeCollisions();
                ++n3;
            }
        }
    }

    private void checkForInheritedMemberTypes(SourceTypeBinding sourceType) {
        ReferenceBinding currentType = sourceType;
        ReferenceBinding[] interfacesToVisit = null;
        int nextPosition = 0;
        do {
            if (currentType.hasMemberTypes()) {
                return;
            }
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces == null || itsInterfaces == Binding.NO_SUPERINTERFACES) continue;
            if (interfacesToVisit == null) {
                interfacesToVisit = itsInterfaces;
                nextPosition = interfacesToVisit.length;
                continue;
            }
            int itsLength = itsInterfaces.length;
            if (nextPosition + itsLength >= interfacesToVisit.length) {
                ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
            }
            int a = 0;
            while (a < itsLength) {
                block19: {
                    ReferenceBinding next = itsInterfaces[a];
                    int b = 0;
                    while (b < nextPosition) {
                        if (!TypeBinding.equalsEquals(next, interfacesToVisit[b])) {
                            ++b;
                            continue;
                        }
                        break block19;
                    }
                    interfacesToVisit[nextPosition++] = next;
                }
                ++a;
            }
        } while ((currentType = currentType.superclass()) != null && (currentType.tagBits & 0x10000L) == 0L);
        if (interfacesToVisit != null) {
            boolean needToTag = false;
            int i = 0;
            while (i < nextPosition) {
                ReferenceBinding anInterface = interfacesToVisit[i];
                if ((anInterface.tagBits & 0x10000L) == 0L) {
                    if (anInterface.hasMemberTypes()) {
                        return;
                    }
                    needToTag = true;
                    ReferenceBinding[] itsInterfaces = anInterface.superInterfaces();
                    if (itsInterfaces != null && itsInterfaces != Binding.NO_SUPERINTERFACES) {
                        int itsLength = itsInterfaces.length;
                        if (nextPosition + itsLength >= interfacesToVisit.length) {
                            ReferenceBinding[] referenceBindingArray = interfacesToVisit;
                            interfacesToVisit = new ReferenceBinding[nextPosition + itsLength + 5];
                            System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, nextPosition);
                        }
                        int a = 0;
                        while (a < itsLength) {
                            block20: {
                                ReferenceBinding next = itsInterfaces[a];
                                int b = 0;
                                while (b < nextPosition) {
                                    if (!TypeBinding.equalsEquals(next, interfacesToVisit[b])) {
                                        ++b;
                                        continue;
                                    }
                                    break block20;
                                }
                                interfacesToVisit[nextPosition++] = next;
                            }
                            ++a;
                        }
                    }
                }
                ++i;
            }
            if (needToTag) {
                i = 0;
                while (i < nextPosition) {
                    interfacesToVisit[i].tagBits |= 0x10000L;
                    ++i;
                }
            }
        }
        currentType = sourceType;
        do {
            currentType.tagBits |= 0x10000L;
        } while ((currentType = currentType.superclass()) != null && (currentType.tagBits & 0x10000L) == 0L);
    }

    public void checkParameterizedTypeBounds() {
        int i = 0;
        int l = this.deferredBoundChecks == null ? 0 : this.deferredBoundChecks.size();
        while (i < l) {
            this.deferredBoundChecks.get(i).checkBounds(this);
            ++i;
        }
        this.deferredBoundChecks = null;
        ReferenceBinding[] memberTypes = this.referenceContext.binding.memberTypes;
        if (memberTypes != null && memberTypes != Binding.NO_MEMBER_TYPES) {
            ReferenceBinding[] referenceBindingArray = memberTypes;
            int n = memberTypes.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceBinding memberType = referenceBindingArray[n2];
                ((SourceTypeBinding)memberType).scope.checkParameterizedTypeBounds();
                ++n2;
            }
        }
    }

    private void connectMemberTypes() {
        SourceTypeBinding sourceType = this.referenceContext.binding;
        ReferenceBinding[] memberTypes = sourceType.memberTypes;
        if (memberTypes != null && memberTypes != Binding.NO_MEMBER_TYPES) {
            ReferenceBinding[] referenceBindingArray = memberTypes;
            int n = memberTypes.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceBinding memberType = referenceBindingArray[n2];
                ((SourceTypeBinding)memberType).scope.connectTypeHierarchy();
                ++n2;
            }
        }
    }

    private boolean connectSuperclass() {
        SourceTypeBinding sourceType = this.referenceContext.binding;
        if (sourceType.id == 1) {
            sourceType.setSuperClass(null);
            sourceType.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
            sourceType.setPermittedTypes(Binding.NO_PERMITTED_TYPES);
            if (!sourceType.isClass()) {
                this.problemReporter().objectMustBeClass(sourceType);
            }
            if (this.referenceContext.superclass != null || this.referenceContext.superInterfaces != null && this.referenceContext.superInterfaces.length > 0) {
                this.problemReporter().objectCannotHaveSuperTypes(sourceType);
            }
            return true;
        }
        if (this.referenceContext.superclass == null) {
            if (sourceType.isEnum()) {
                return this.connectEnumSuperclass();
            }
            if (sourceType.isRecord()) {
                return this.connectRecordSuperclass();
            }
            sourceType.setSuperClass(this.getJavaLangObject());
            return !this.detectHierarchyCycle(sourceType, sourceType.superclass, null);
        }
        TypeReference superclassRef = this.referenceContext.superclass;
        ReferenceBinding superclass = this.findSupertype(superclassRef);
        if (superclass != null) {
            if (!superclass.isClass() && (superclass.tagBits & 0x80L) == 0L) {
                this.problemReporter().superclassMustBeAClass(sourceType, superclassRef, superclass);
            } else if (superclass.isFinal() && !superclass.isSealed()) {
                if (superclass.isRecord()) {
                    this.problemReporter().classExtendFinalRecord(sourceType, superclassRef, superclass);
                } else {
                    this.problemReporter().classExtendFinalClass(sourceType, superclassRef, superclass);
                }
            } else if ((superclass.tagBits & 0x40000000L) != 0L) {
                this.problemReporter().superTypeCannotUseWildcard(sourceType, superclassRef, superclass);
            } else if (superclass.erasure().id == 41) {
                this.problemReporter().cannotExtendEnum(sourceType, superclassRef, superclass);
            } else if (superclass.erasure().id == 93) {
                this.problemReporter().recordCannotExtendRecord(sourceType, superclassRef, superclass);
            } else {
                if (superclass.isSealed() && sourceType.isLocalType()) {
                    sourceType.setSuperClass(superclass);
                    this.problemReporter().localTypeMayNotBePermittedType(sourceType, superclassRef, superclass);
                    return false;
                }
                if (superclass.isSealed() && !sourceType.isFinal() && !sourceType.isSealed() && !sourceType.isNonSealed()) {
                    sourceType.setSuperClass(superclass);
                    this.problemReporter().permittedTypeNeedsModifier(sourceType, this.referenceContext, superclass);
                    return false;
                }
                if ((superclass.tagBits & 0x20000L) != 0L || !superclassRef.resolvedType.isValidBinding()) {
                    sourceType.setSuperClass(superclass);
                    sourceType.tagBits |= 0x20000L;
                    return superclassRef.resolvedType.isValidBinding();
                }
                sourceType.setSuperClass(superclass);
                sourceType.typeBits |= superclass.typeBits & 0x713;
                return true;
            }
        }
        sourceType.tagBits |= 0x20000L;
        sourceType.setSuperClass(this.getJavaLangObject());
        if ((sourceType.superclass.tagBits & 0x100L) == 0L) {
            this.detectHierarchyCycle(sourceType, sourceType.superclass, null);
        }
        return false;
    }

    private boolean connectEnumSuperclass() {
        SourceTypeBinding sourceType = this.referenceContext.binding;
        ReferenceBinding rootEnumType = this.getJavaLangEnum();
        if ((rootEnumType.tagBits & 0x80L) != 0L) {
            sourceType.tagBits |= 0x20000L;
            sourceType.setSuperClass(rootEnumType);
            return false;
        }
        boolean foundCycle = this.detectHierarchyCycle(sourceType, rootEnumType, null);
        TypeVariableBinding[] refTypeVariables = rootEnumType.typeVariables();
        if (refTypeVariables == Binding.NO_TYPE_VARIABLES) {
            this.problemReporter().nonGenericTypeCannotBeParameterized(0, null, rootEnumType, new TypeBinding[]{sourceType});
            return false;
        }
        if (1 != refTypeVariables.length) {
            this.problemReporter().incorrectArityForParameterizedType(null, rootEnumType, new TypeBinding[]{sourceType});
            return false;
        }
        ParameterizedTypeBinding superType = this.environment().createParameterizedType(rootEnumType, new TypeBinding[]{this.environment().convertToRawType(sourceType, false)}, null);
        sourceType.tagBits |= superType.tagBits & 0x20000L;
        sourceType.setSuperClass(superType);
        if (!refTypeVariables[0].boundCheck(superType, sourceType, this, null).isOKbyJLS()) {
            this.problemReporter().typeMismatchError((TypeBinding)rootEnumType, refTypeVariables[0], sourceType, null);
        }
        return !foundCycle;
    }

    private boolean checkSealingProximity(ReferenceBinding subType, TypeReference subTypeReference, ReferenceBinding sealedType) {
        PackageBinding sealedTypePackage = sealedType.getPackage();
        ModuleBinding sealedTypeModule = sealedType.module();
        if (subType.getPackage() != sealedTypePackage) {
            if (sealedTypeModule.isUnnamed()) {
                this.problemReporter().permittedTypeOutsideOfPackage(subType, sealedType, subTypeReference, sealedTypePackage);
            } else if (subType.module() != sealedTypeModule) {
                this.problemReporter().permittedTypeOutsideOfModule(subType, sealedType, subTypeReference, sealedTypeModule);
            }
        }
        return true;
    }

    void connectPermittedTypes() {
        ReferenceBinding[] memberTypes;
        SourceTypeBinding sourceType = this.referenceContext.binding;
        if (this.referenceContext.permittedTypes != null) {
            sourceType.setPermittedTypes(Binding.NO_PERMITTED_TYPES);
            try {
                sourceType.tagBits |= 0x80000L;
                if (!sourceType.isSealed()) {
                    this.problemReporter().missingSealedModifier(sourceType, this.referenceContext);
                }
                int length = this.referenceContext.permittedTypes.length;
                ReferenceBinding[] permittedTypeBindings = new ReferenceBinding[length];
                int count = 0;
                int i = 0;
                while (i < length) {
                    block24: {
                        TypeReference permittedTypeRef = this.referenceContext.permittedTypes[i];
                        ReferenceBinding permittedType = this.findPermittedtype(permittedTypeRef);
                        if (permittedType != null && permittedType.isValidBinding()) {
                            if (sourceType.isClass()) {
                                ReferenceBinding superClass = permittedType.superclass();
                                ReferenceBinding referenceBinding = superClass = superClass == null ? null : superClass.actualType();
                                if (!TypeBinding.equalsEquals(sourceType, superClass)) {
                                    this.problemReporter().sealedClassNotDirectSuperClassOf(permittedType, permittedTypeRef, sourceType);
                                }
                            } else if (sourceType.isInterface()) {
                                ReferenceBinding[] superInterfaces = permittedType.superInterfaces();
                                boolean hierarchyOK = false;
                                if (superInterfaces != null) {
                                    ReferenceBinding[] referenceBindingArray = superInterfaces;
                                    int n = superInterfaces.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        ReferenceBinding superInterface = referenceBindingArray[n2];
                                        ReferenceBinding referenceBinding = superInterface = superInterface == null ? null : superInterface.actualType();
                                        if (TypeBinding.equalsEquals(sourceType, superInterface)) {
                                            hierarchyOK = true;
                                            break;
                                        }
                                        ++n2;
                                    }
                                    if (!hierarchyOK) {
                                        this.problemReporter().sealedInterfaceNotDirectSuperInterfaceOf(permittedType, permittedTypeRef, sourceType);
                                    }
                                }
                            }
                            this.checkSealingProximity(permittedType, permittedTypeRef, sourceType);
                            int j = 0;
                            while (j < i) {
                                if (TypeBinding.equalsEquals(permittedTypeBindings[j], permittedType)) {
                                    this.problemReporter().duplicatePermittedType(permittedTypeRef, permittedType);
                                    break block24;
                                }
                                ++j;
                            }
                            permittedTypeBindings[count++] = permittedType;
                        }
                    }
                    ++i;
                }
                if (count > 0) {
                    if (count != length) {
                        ReferenceBinding[] referenceBindingArray = permittedTypeBindings;
                        permittedTypeBindings = new ReferenceBinding[count];
                        System.arraycopy(referenceBindingArray, 0, permittedTypeBindings, 0, count);
                    }
                    sourceType.setPermittedTypes(permittedTypeBindings);
                }
                sourceType.setPermittedTypes(Binding.NO_PERMITTED_TYPES);
            }
            finally {
                sourceType.tagBits &= 0xFFFFFFFFFFF7FFFFL;
            }
        } else {
            ReferenceBinding[] permittedTypes = sourceType.permittedTypes();
            if (permittedTypes == null || permittedTypes.length == 0) {
                sourceType.setPermittedTypes(Binding.NO_PERMITTED_TYPES);
                if (sourceType.isSealed() && !sourceType.isLocalType() && !sourceType.isRecord() && !sourceType.isEnum()) {
                    this.problemReporter().missingPermitsClause(sourceType, this.referenceContext);
                }
            }
        }
        if ((memberTypes = sourceType.memberTypes) != null && memberTypes != Binding.NO_MEMBER_TYPES) {
            ReferenceBinding[] referenceBindingArray = memberTypes;
            int n = memberTypes.length;
            int n3 = 0;
            while (n3 < n) {
                ReferenceBinding memberType = referenceBindingArray[n3];
                ((SourceTypeBinding)memberType).scope.connectPermittedTypes();
                ++n3;
            }
        }
    }

    private boolean connectRecordSuperclass() {
        SourceTypeBinding sourceType = this.referenceContext.binding;
        ReferenceBinding rootRecordType = this.getJavaLangRecord();
        sourceType.setSuperClass(rootRecordType);
        if ((rootRecordType.tagBits & 0x80L) != 0L) {
            sourceType.tagBits |= 0x20000L;
            return false;
        }
        return !this.detectHierarchyCycle(sourceType, rootRecordType, null);
    }

    private boolean connectSuperInterfaces() {
        SourceTypeBinding sourceType = this.referenceContext.binding;
        boolean hasSealedSupertype = sourceType.superclass == null ? false : sourceType.superclass.isSealed();
        boolean noProblems = true;
        try {
            sourceType.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
            if (this.referenceContext.superInterfaces == null) {
                if (sourceType.isAnnotationType()) {
                    ReferenceBinding annotationType = this.getJavaLangAnnotationAnnotation();
                    boolean foundCycle = this.detectHierarchyCycle(sourceType, annotationType, null);
                    sourceType.setSuperInterfaces(new ReferenceBinding[]{annotationType});
                    boolean bl = !foundCycle;
                    return bl;
                }
                return true;
            }
            if (sourceType.id == 1) {
                return true;
            }
            int length = this.referenceContext.superInterfaces.length;
            ReferenceBinding[] interfaceBindings = new ReferenceBinding[length];
            int count = 0;
            int i = 0;
            while (i < length) {
                block26: {
                    TypeReference superInterfaceRef = this.referenceContext.superInterfaces[i];
                    ReferenceBinding superInterface = this.findSupertype(superInterfaceRef);
                    if (superInterface == null) {
                        sourceType.tagBits |= 0x20000L;
                        noProblems = false;
                    } else {
                        if (superInterface.isSealed()) {
                            hasSealedSupertype = true;
                        }
                        int j = 0;
                        while (j < i) {
                            if (TypeBinding.equalsEquals(interfaceBindings[j], superInterface)) {
                                this.problemReporter().duplicateSuperinterface(sourceType, superInterfaceRef, superInterface);
                                sourceType.tagBits |= 0x20000L;
                                noProblems = false;
                                break block26;
                            }
                            ++j;
                        }
                        if (!superInterface.isInterface() && (superInterface.tagBits & 0x80L) == 0L) {
                            this.problemReporter().superinterfaceMustBeAnInterface(sourceType, superInterfaceRef, superInterface);
                            sourceType.tagBits |= 0x20000L;
                            noProblems = false;
                        } else {
                            if (superInterface.isAnnotationType()) {
                                this.problemReporter().annotationTypeUsedAsSuperinterface(sourceType, superInterfaceRef, superInterface);
                            }
                            if ((superInterface.tagBits & 0x40000000L) != 0L) {
                                this.problemReporter().superTypeCannotUseWildcard(sourceType, superInterfaceRef, superInterface);
                                sourceType.tagBits |= 0x20000L;
                                noProblems = false;
                            } else {
                                if ((superInterface.tagBits & 0x20000L) != 0L || !superInterfaceRef.resolvedType.isValidBinding()) {
                                    sourceType.tagBits |= 0x20000L;
                                    noProblems &= superInterfaceRef.resolvedType.isValidBinding();
                                }
                                if (superInterface.isSealed() && sourceType.isLocalType()) {
                                    this.problemReporter().localTypeMayNotBePermittedType(sourceType, superInterfaceRef, superInterface);
                                    noProblems = false;
                                } else if (superInterface.isSealed() && !sourceType.isFinal() && !sourceType.isSealed() && !sourceType.isNonSealed()) {
                                    this.problemReporter().permittedTypeNeedsModifier(sourceType, this.referenceContext, superInterface);
                                    noProblems = false;
                                }
                                sourceType.typeBits |= superInterface.typeBits & 0x713;
                                interfaceBindings[count++] = superInterface;
                            }
                        }
                    }
                }
                ++i;
            }
            if (count > 0) {
                if (count != length) {
                    ReferenceBinding[] referenceBindingArray = interfaceBindings;
                    interfaceBindings = new ReferenceBinding[count];
                    System.arraycopy(referenceBindingArray, 0, interfaceBindings, 0, count);
                }
                sourceType.setSuperInterfaces(interfaceBindings);
            }
        }
        finally {
            if (!(!sourceType.isNonSealed() || hasSealedSupertype || sourceType.isRecord() || sourceType.isLocalType() || sourceType.isEnum() || sourceType.isSealed())) {
                this.problemReporter().disallowedNonSealedModifier(sourceType, this.referenceContext);
            }
        }
        return noProblems;
    }

    void connectTypeHierarchy() {
        SourceTypeBinding sourceType = this.referenceContext.binding;
        if ((sourceType.tagBits & 0x100L) == 0L) {
            sourceType.tagBits |= 0x100L;
            this.environment().typesBeingConnected.add(sourceType);
            boolean noProblems = this.connectSuperclass();
            noProblems &= this.connectSuperInterfaces();
            if ((sourceType.typeBits & 3) != 0) {
                sourceType.typeBits |= sourceType.applyCloseableWhitelists(this.compilerOptions());
            }
            this.environment().typesBeingConnected.remove(sourceType);
            sourceType.tagBits |= 0x200L;
            sourceType.tagBits |= 0x40000L;
            if ((noProblems &= this.connectTypeVariables(this.referenceContext.typeParameters, false)) && sourceType.isHierarchyInconsistent()) {
                this.problemReporter().hierarchyHasProblems(sourceType);
            }
        }
        this.connectMemberTypes();
        LookupEnvironment env = this.environment();
        try {
            try {
                env.missingClassFileLocation = this.referenceContext;
                this.checkForInheritedMemberTypes(sourceType);
            }
            catch (AbortCompilation e) {
                e.updateContext(this.referenceContext, this.referenceCompilationUnit().compilationResult);
                throw e;
            }
        }
        finally {
            env.missingClassFileLocation = null;
        }
    }

    private void connectTypeHierarchyWithoutMembers() {
        if (this.parent instanceof CompilationUnitScope) {
            if (((CompilationUnitScope)this.parent).imports == null) {
                ((CompilationUnitScope)this.parent).checkAndSetImports();
            }
        } else if (this.parent instanceof ClassScope) {
            ((ClassScope)this.parent).connectTypeHierarchyWithoutMembers();
        }
        SourceTypeBinding sourceType = this.referenceContext.binding;
        if ((sourceType.tagBits & 0x100L) != 0L) {
            return;
        }
        sourceType.tagBits |= 0x100L;
        this.environment().typesBeingConnected.add(sourceType);
        boolean noProblems = this.connectSuperclass();
        noProblems &= this.connectSuperInterfaces();
        this.environment().typesBeingConnected.remove(sourceType);
        sourceType.tagBits |= 0x200L;
        sourceType.tagBits |= 0x40000L;
        if ((noProblems &= this.connectTypeVariables(this.referenceContext.typeParameters, false)) && sourceType.isHierarchyInconsistent()) {
            this.problemReporter().hierarchyHasProblems(sourceType);
        }
    }

    public boolean detectHierarchyCycle(TypeBinding superType, TypeReference reference) {
        if (!(superType instanceof ReferenceBinding)) {
            return false;
        }
        if (reference == this.superTypeReference) {
            if (superType.isTypeVariable()) {
                return false;
            }
            if (superType.isParameterizedType()) {
                superType = ((ParameterizedTypeBinding)superType).genericType();
            }
            this.compilationUnitScope().recordSuperTypeReference(superType);
            return this.detectHierarchyCycle(this.referenceContext.binding, (ReferenceBinding)superType, reference);
        }
        if ((superType.tagBits & 0x100L) == 0L && superType instanceof SourceTypeBinding) {
            ((SourceTypeBinding)superType).scope.connectTypeHierarchyWithoutMembers();
        }
        return false;
    }

    private boolean detectHierarchyCycle(SourceTypeBinding sourceType, ReferenceBinding superType, TypeReference reference) {
        if (superType.isRawType()) {
            superType = ((RawTypeBinding)superType).genericType();
        }
        if (TypeBinding.equalsEquals(sourceType, superType)) {
            this.problemReporter().hierarchyCircularity(sourceType, superType, reference);
            sourceType.tagBits |= 0x20000L;
            return true;
        }
        if (superType.isMemberType()) {
            ReferenceBinding current = superType.enclosingType();
            do {
                if (!current.isHierarchyBeingActivelyConnected()) continue;
                this.problemReporter().hierarchyCircularity(sourceType, current, reference);
                sourceType.tagBits |= 0x20000L;
                current.tagBits |= 0x20000L;
                return true;
            } while ((current = current.enclosingType()) != null);
        }
        if (superType.isBinaryBinding()) {
            ReferenceBinding[] itsInterfaces;
            if (superType.problemId() != 1 && (superType.tagBits & 0x20000L) != 0L) {
                sourceType.tagBits |= 0x20000L;
                this.problemReporter().hierarchyHasProblems(sourceType);
                return true;
            }
            boolean hasCycle = false;
            ReferenceBinding parentType = superType.superclass();
            if (parentType != null) {
                if (TypeBinding.equalsEquals(sourceType, parentType)) {
                    this.problemReporter().hierarchyCircularity(sourceType, superType, reference);
                    sourceType.tagBits |= 0x20000L;
                    superType.tagBits |= 0x20000L;
                    return true;
                }
                if (parentType.isParameterizedType()) {
                    parentType = ((ParameterizedTypeBinding)parentType).genericType();
                }
                hasCycle |= this.detectHierarchyCycle(sourceType, parentType, reference);
                if ((parentType.tagBits & 0x20000L) != 0L) {
                    sourceType.tagBits |= 0x20000L;
                    parentType.tagBits |= 0x20000L;
                }
            }
            if ((itsInterfaces = superType.superInterfaces()) != null && itsInterfaces != Binding.NO_SUPERINTERFACES) {
                ReferenceBinding[] referenceBindingArray = itsInterfaces;
                int n = itsInterfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    ReferenceBinding anInterface = referenceBindingArray[n2];
                    if (TypeBinding.equalsEquals(sourceType, anInterface)) {
                        this.problemReporter().hierarchyCircularity(sourceType, superType, reference);
                        sourceType.tagBits |= 0x20000L;
                        superType.tagBits |= 0x20000L;
                        return true;
                    }
                    if (anInterface.isParameterizedType()) {
                        anInterface = ((ParameterizedTypeBinding)anInterface).genericType();
                    }
                    hasCycle |= this.detectHierarchyCycle(sourceType, anInterface, reference);
                    if ((anInterface.tagBits & 0x20000L) != 0L) {
                        sourceType.tagBits |= 0x20000L;
                        superType.tagBits |= 0x20000L;
                    }
                    ++n2;
                }
            }
            return hasCycle;
        }
        if (superType.isHierarchyBeingActivelyConnected()) {
            TypeReference ref = ((SourceTypeBinding)superType).scope.superTypeReference;
            if (ref != null && ref.resolvedType != null) {
                ReferenceBinding s = (ReferenceBinding)ref.resolvedType;
                do {
                    if (!s.isHierarchyBeingActivelyConnected()) continue;
                    this.problemReporter().hierarchyCircularity(sourceType, superType, reference);
                    sourceType.tagBits |= 0x20000L;
                    superType.tagBits |= 0x20000L;
                    return true;
                } while ((s = s.enclosingType()) != null);
            }
            if (ref != null && ref.resolvedType == null) {
                char[] referredName = ref.getLastToken();
                for (SourceTypeBinding type : this.environment().typesBeingConnected) {
                    if (!CharOperation.equals(referredName, type.sourceName())) continue;
                    this.problemReporter().hierarchyCircularity(sourceType, superType, reference);
                    sourceType.tagBits |= 0x20000L;
                    superType.tagBits |= 0x20000L;
                    return true;
                }
            }
        }
        if ((superType.tagBits & 0x100L) == 0L && superType.isValidBinding() && !superType.isUnresolvedType()) {
            ((SourceTypeBinding)superType).scope.connectTypeHierarchyWithoutMembers();
        }
        if ((superType.tagBits & 0x20000L) != 0L) {
            sourceType.tagBits |= 0x20000L;
        }
        return false;
    }

    private ReferenceBinding findSupertype(TypeReference typeReference) {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        LookupEnvironment env = unitScope.environment;
        try {
            ReferenceBinding superType;
            env.missingClassFileLocation = typeReference;
            typeReference.aboutToResolve(this);
            unitScope.recordQualifiedReference(typeReference.getTypeName());
            this.superTypeReference = typeReference;
            ReferenceBinding referenceBinding = superType = (ReferenceBinding)typeReference.resolveSuperType(this);
            return referenceBinding;
        }
        catch (AbortCompilation e) {
            SourceTypeBinding sourceType = this.referenceContext.binding;
            if (sourceType.superInterfaces == null) {
                sourceType.setSuperInterfaces(Binding.NO_SUPERINTERFACES);
            }
            if (sourceType.permittedTypes == null) {
                sourceType.setPermittedTypes(Binding.NO_PERMITTED_TYPES);
            }
            e.updateContext(typeReference, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
        finally {
            env.missingClassFileLocation = null;
            this.superTypeReference = null;
        }
    }

    private ReferenceBinding findPermittedtype(TypeReference typeReference) {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        LookupEnvironment env = unitScope.environment;
        try {
            env.missingClassFileLocation = typeReference;
            typeReference.aboutToResolve(this);
            unitScope.recordQualifiedReference(typeReference.getTypeName());
            if (typeReference.isParameterizedTypeReference()) {
                TypeReference[][] typeReferenceArray = typeReference.getTypeArguments();
                int n = typeReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TypeReference[] typeArguments = typeReferenceArray[n2];
                    if (typeArguments != null && typeArguments.length > 0) {
                        this.problemReporter().invalidTypeArguments(typeArguments);
                    }
                    ++n2;
                }
            }
            typeReference.bits |= 0x40000000;
            ReferenceBinding permittedType = (ReferenceBinding)typeReference.resolveType(this);
            ReferenceBinding referenceBinding = permittedType != null ? permittedType.actualType() : permittedType;
            return referenceBinding;
        }
        catch (AbortCompilation e) {
            SourceTypeBinding sourceType = this.referenceContext.binding;
            if (sourceType.permittedTypes == null) {
                sourceType.setPermittedTypes(Binding.NO_PERMITTED_TYPES);
            }
            e.updateContext(typeReference, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
        finally {
            env.missingClassFileLocation = null;
        }
    }

    @Override
    public ProblemReporter problemReporter() {
        MethodScope outerMethodScope = this.outerMostMethodScope();
        if (outerMethodScope == null) {
            ProblemReporter problemReporter = this.referenceCompilationUnit().problemReporter;
            problemReporter.referenceContext = this.referenceContext;
            return problemReporter;
        }
        return outerMethodScope.problemReporter();
    }

    public TypeDeclaration referenceType() {
        return this.referenceContext;
    }

    public final MethodBinding enclosingMethod() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            if (!(scope instanceof MethodScope)) continue;
            MethodScope methodScope = (MethodScope)scope;
            if (methodScope.referenceContext instanceof TypeDeclaration) {
                return null;
            }
            if (!(methodScope.referenceContext instanceof AbstractMethodDeclaration)) continue;
            return ((MethodScope)scope).referenceMethodBinding();
        }
        return null;
    }

    @Override
    public boolean hasDefaultNullnessFor(int location, int sourceStart) {
        int nullDefault;
        int nonNullByDefaultValue = this.localNonNullByDefaultValue(sourceStart);
        if (nonNullByDefaultValue != 0) {
            return (nonNullByDefaultValue & location) != 0;
        }
        SourceTypeBinding binding = this.referenceContext.binding;
        if (binding != null && (nullDefault = binding.getNullDefault()) != 0) {
            return (nullDefault & location) != 0;
        }
        return this.parent.hasDefaultNullnessFor(location, sourceStart);
    }

    @Override
    public Binding checkRedundantDefaultNullness(int nullBits, int sourceStart) {
        int nullDefault;
        Binding target = this.localCheckRedundantDefaultNullness(nullBits, sourceStart);
        if (target != null) {
            return target;
        }
        SourceTypeBinding binding = this.referenceContext.binding;
        if (binding != null && (nullDefault = binding.getNullDefault()) != 0) {
            return nullDefault == nullBits ? binding : null;
        }
        return this.parent.checkRedundantDefaultNullness(nullBits, sourceStart);
    }

    public String toString() {
        if (this.referenceContext != null) {
            return "--- Class Scope ---\n\n" + this.referenceContext.binding.toString();
        }
        return "--- Class Scope ---\n\n Binding not initialized";
    }
}

