/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.db;

import io.opentelemetry.instrumentation.api.incubator.semconv.db.DbClientAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlStatementInfo;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.SqlStatementSanitizer;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;

public abstract class DbClientSpanNameExtractor<REQUEST>
implements SpanNameExtractor<REQUEST> {
    private static final String DEFAULT_SPAN_NAME = "DB Query";

    public static <REQUEST> SpanNameExtractor<REQUEST> create(DbClientAttributesGetter<REQUEST> getter) {
        return new GenericDbClientSpanNameExtractor(getter);
    }

    public static <REQUEST> SpanNameExtractor<REQUEST> create(SqlClientAttributesGetter<REQUEST> getter) {
        return new SqlClientSpanNameExtractor(getter);
    }

    private DbClientSpanNameExtractor() {
    }

    protected String computeSpanName(String dbName, String operation, String mainIdentifier) {
        if (operation == null) {
            return dbName == null ? DEFAULT_SPAN_NAME : dbName;
        }
        StringBuilder name = new StringBuilder(operation);
        if (dbName != null || mainIdentifier != null) {
            name.append(' ');
        }
        if (dbName != null && (mainIdentifier == null || mainIdentifier.indexOf(46) == -1)) {
            name.append(dbName);
            if (mainIdentifier != null) {
                name.append('.');
            }
        }
        if (mainIdentifier != null) {
            name.append(mainIdentifier);
        }
        return name.toString();
    }

    private static final class GenericDbClientSpanNameExtractor<REQUEST>
    extends DbClientSpanNameExtractor<REQUEST> {
        private final DbClientAttributesGetter<REQUEST> getter;

        private GenericDbClientSpanNameExtractor(DbClientAttributesGetter<REQUEST> getter) {
            this.getter = getter;
        }

        public String extract(REQUEST request) {
            String dbName = this.getter.getName(request);
            String operation = this.getter.getOperation(request);
            return this.computeSpanName(dbName, operation, null);
        }
    }

    private static final class SqlClientSpanNameExtractor<REQUEST>
    extends DbClientSpanNameExtractor<REQUEST> {
        private static final SqlStatementSanitizer sanitizer = SqlStatementSanitizer.create(true);
        private final SqlClientAttributesGetter<REQUEST> getter;

        private SqlClientSpanNameExtractor(SqlClientAttributesGetter<REQUEST> getter) {
            this.getter = getter;
        }

        public String extract(REQUEST request) {
            String dbName = this.getter.getName(request);
            SqlStatementInfo sanitizedStatement = sanitizer.sanitize(this.getter.getRawStatement(request));
            return this.computeSpanName(dbName, sanitizedStatement.getOperation(), sanitizedStatement.getMainIdentifier());
        }
    }
}

