/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveCompressionHandler;
import io.quarkus.vertx.http.Compressed;
import io.quarkus.vertx.http.Uncompressed;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpCompression;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationStore;
import org.jboss.resteasy.reactive.server.model.FixedHandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class CompressionScanner
implements MethodScanner {
    static final DotName COMPRESSED = DotName.createSimple((String)Compressed.class.getName());
    static final DotName UNCOMPRESSED = DotName.createSimple((String)Uncompressed.class.getName());
    private final HttpBuildTimeConfig httpBuildTimeConfig;

    public CompressionScanner(HttpBuildTimeConfig httpBuildTimeConfig) {
        this.httpBuildTimeConfig = httpBuildTimeConfig;
    }

    public List<HandlerChainCustomizer> scan(MethodInfo method, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
        if (!this.httpBuildTimeConfig.enableCompression) {
            return Collections.emptyList();
        }
        AnnotationStore annotationStore = (AnnotationStore)methodContext.get("ANNOTATION_STORE");
        HttpCompression compression = HttpCompression.UNDEFINED;
        if (annotationStore.hasAnnotation((AnnotationTarget)method, COMPRESSED)) {
            compression = HttpCompression.ON;
        }
        if (annotationStore.hasAnnotation((AnnotationTarget)method, UNCOMPRESSED)) {
            if (compression == HttpCompression.ON) {
                throw new IllegalStateException(String.format("@Compressed and @Uncompressed cannot be both declared on resource method %s declared on %s", method, actualEndpointClass));
            }
            compression = HttpCompression.OFF;
        }
        if (compression == HttpCompression.OFF) {
            return Collections.emptyList();
        }
        ResteasyReactiveCompressionHandler handler = new ResteasyReactiveCompressionHandler(Set.copyOf(this.httpBuildTimeConfig.compressMediaTypes.orElse(Collections.emptyList())));
        handler.setCompression(compression);
        String[] produces = (String[])methodContext.get("METHOD_PRODUCES");
        if (produces != null && produces.length > 0) {
            handler.setProduces(produces[0]);
        } else {
            handler.setProduces(null);
        }
        return List.of(new FixedHandlerChainCustomizer((ServerRestHandler)handler, HandlerChainCustomizer.Phase.AFTER_RESPONSE_CREATED));
    }
}

