/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter;

import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.util.AssertUtil;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AuthenticatorTransportConverter {
    public @NonNull AuthenticatorTransport convert(@NonNull String value) {
        try {
            AssertUtil.notNull((Object)value, (String)"value must not be null");
            return AuthenticatorTransport.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    public @NonNull Set<AuthenticatorTransport> convertSet(@NonNull Set<String> values) {
        try {
            AssertUtil.notNull(values, (String)"values must not be null");
            return values.stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    public @NonNull String convertToString(@NonNull AuthenticatorTransport value) {
        try {
            AssertUtil.notNull((Object)value, (String)"value must not be null");
            return value.getValue();
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }

    public @NonNull Set<String> convertSetToStringSet(@NonNull Set<AuthenticatorTransport> values) {
        try {
            AssertUtil.notNull(values, (String)"values must not be null");
            return values.stream().map(this::convertToString).collect(Collectors.toSet());
        }
        catch (IllegalArgumentException e) {
            throw new DataConversionException(e);
        }
    }
}

