/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.ui.rest;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.keycloak.admin.ui.rest.model.EventListener;
import org.keycloak.admin.ui.rest.model.ProviderMapper;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventListenerProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class AvailableEventListenersResource {
    private final KeycloakSession session;
    private final AdminPermissionEvaluator auth;

    public AvailableEventListenersResource(KeycloakSession session, AdminPermissionEvaluator auth) {
        this.session = session;
        this.auth = auth;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @Operation(summary="List all available event listener providers", description="This endpoint returns List all available event listener providers")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=EventListener.class, type=SchemaType.ARRAY))})
    public final List<EventListener> listAvailableEventListeners() {
        this.auth.realm().requireViewEvents();
        this.auth.adminAuth().getRealm().getEventsListenersStream();
        ArrayList<EventListener> result = new ArrayList<EventListener>();
        this.session.getKeycloakSessionFactory().getProviderFactoriesStream(EventListenerProvider.class).forEach(providerFactory -> {
            if (!((EventListenerProviderFactory)providerFactory).isGlobal()) {
                result.add(ProviderMapper.convertToModel((EventListenerProviderFactory)providerFactory));
            }
        });
        return result;
    }
}

