/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.role;

import java.util.Set;
import java.util.function.BiFunction;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.attribute.Attributes;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.representations.idm.authorization.RolePolicyRepresentation;

public class RolePolicyProvider
implements PolicyProvider {
    private final BiFunction<Policy, AuthorizationProvider, RolePolicyRepresentation> representationFunction;
    private static final Logger logger = Logger.getLogger(RolePolicyProvider.class);

    public RolePolicyProvider(BiFunction<Policy, AuthorizationProvider, RolePolicyRepresentation> representationFunction) {
        this.representationFunction = representationFunction;
    }

    public void evaluate(Evaluation evaluation) {
        Policy policy = evaluation.getPolicy();
        RolePolicyRepresentation policyRep = this.representationFunction.apply(policy, evaluation.getAuthorizationProvider());
        Set roleIds = policyRep.getRoles();
        AuthorizationProvider authorizationProvider = evaluation.getAuthorizationProvider();
        RealmModel realm = authorizationProvider.getKeycloakSession().getContext().getRealm();
        Identity identity = evaluation.getContext().getIdentity();
        for (RolePolicyRepresentation.RoleDefinition roleDefinition : roleIds) {
            RoleModel role = realm.getRoleById(roleDefinition.getId());
            if (role == null) continue;
            boolean isFetchRoles = policyRep.isFetchRoles() != null && policyRep.isFetchRoles() != false;
            boolean hasRole = this.hasRole(identity, role, realm, authorizationProvider, isFetchRoles);
            if (!hasRole && roleDefinition.isRequired() != null && roleDefinition.isRequired().booleanValue()) {
                evaluation.deny();
                return;
            }
            if (!hasRole) continue;
            evaluation.grant();
        }
        logger.debugf("policy %s evaluated with status %s on identity %s", (Object)policy.getName(), (Object)evaluation.getEffect(), (Object)identity.getId());
    }

    private boolean hasRole(Identity identity, RoleModel role, RealmModel realm, AuthorizationProvider authorizationProvider, boolean fetchRoles) {
        if (fetchRoles) {
            UserModel subject = this.getSubject(identity, realm, authorizationProvider);
            return subject != null && subject.hasRole(role);
        }
        String roleName = role.getName();
        if (role.isClientRole()) {
            ClientModel clientModel = realm.getClientById(role.getContainerId());
            return identity.hasClientRole(clientModel.getClientId(), roleName);
        }
        return identity.hasRealmRole(roleName);
    }

    private UserModel getSubject(Identity identity, RealmModel realm, AuthorizationProvider authorizationProvider) {
        KeycloakSession session = authorizationProvider.getKeycloakSession();
        UserProvider users = session.users();
        UserModel user = users.getUserById(realm, identity.getId());
        if (user == null) {
            Attributes.Entry sub = identity.getAttributes().getValue("sub");
            if (sub == null || sub.isEmpty()) {
                return null;
            }
            return users.getUserById(realm, sub.asString(0));
        }
        return user;
    }

    public void close() {
    }
}

