/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.ConfigurableAuthenticatorFactory;
import org.keycloak.authentication.requiredactions.util.CredentialDeleteHelper;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialTypeMetadata;
import org.keycloak.credential.CredentialTypeMetadataContext;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.protocol.oidc.utils.AcrUtils;
import org.keycloak.representations.account.CredentialMetadataRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.managers.Auth;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.CredentialHelper;

public class AccountCredentialResource {
    public static final String TYPE = "type";
    public static final String USER_CREDENTIALS = "user-credentials";
    private static final Logger logger = Logger.getLogger(AccountCredentialResource.class);
    private final KeycloakSession session;
    private final UserModel user;
    private final RealmModel realm;
    private Auth auth;
    private final EventBuilder event;

    public AccountCredentialResource(KeycloakSession session, UserModel user, Auth auth, EventBuilder event) {
        this.session = session;
        this.user = user;
        this.auth = auth;
        this.event = event;
        this.realm = session.getContext().getRealm();
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<CredentialContainer> credentialTypes(@QueryParam(value="type") String type, @QueryParam(value="user-credentials") Boolean userCredentials) {
        this.auth.requireOneOf("manage-account", "view-profile");
        boolean includeUserCredentials = userCredentials == null || userCredentials != false;
        Set<String> enabledCredentialTypes = this.getEnabledCredentialTypes();
        Stream modelsStream = includeUserCredentials ? this.user.credentialManager().getStoredCredentialsStream() : Stream.empty();
        List models = modelsStream.collect(Collectors.toList());
        Function<CredentialProvider, CredentialContainer> toCredentialContainer = credentialProvider -> {
            CredentialTypeMetadataContext ctx = CredentialTypeMetadataContext.builder().user(this.user).build(this.session);
            CredentialTypeMetadata metadata = credentialProvider.getCredentialTypeMetadata(ctx);
            List<Object> userCredentialMetadataModels = null;
            if (includeUserCredentials) {
                List modelsOfType = models.stream().filter(credentialModel -> credentialProvider.getType().equals(credentialModel.getType())).collect(Collectors.toList());
                List credentialMetadataList = modelsOfType.stream().map(m -> credentialProvider.getCredentialMetadata(credentialProvider.getCredentialFromModel(m), metadata)).collect(Collectors.toList());
                credentialMetadataList.stream().forEach(md -> md.getCredentialModel().setSecretData(null));
                userCredentialMetadataModels = credentialMetadataList.stream().map(ModelToRepresentation::toRepresentation).collect(Collectors.toList());
                if (userCredentialMetadataModels.isEmpty() && this.user.credentialManager().isConfiguredFor(credentialProvider.getType())) {
                    CredentialMetadataRepresentation metadataRepresentation = new CredentialMetadataRepresentation();
                    CredentialRepresentation credential = CredentialHelper.createUserStorageCredentialRepresentation((String)credentialProvider.getType());
                    metadataRepresentation.setCredential(credential);
                    userCredentialMetadataModels = Collections.singletonList(metadataRepresentation);
                }
                if (userCredentialMetadataModels.isEmpty() && metadata.getCreateAction() == null && metadata.getUpdateAction() == null) {
                    return null;
                }
            }
            return new CredentialContainer(metadata, userCredentialMetadataModels);
        };
        return AuthenticatorUtil.getCredentialProviders(this.session).filter(p -> type == null || Objects.equals(p.getType(), type)).filter(p -> enabledCredentialTypes.contains(p.getType())).map(toCredentialContainer).filter(Objects::nonNull).sorted(Comparator.comparing(CredentialContainer::getMetadata));
    }

    private Set<String> getEnabledCredentialTypes() {
        return this.realm.getAuthenticationFlowsStream().filter(((Predicate<AuthenticationFlowModel>)this::isFlowEffectivelyDisabled).negate()).flatMap(flow -> this.realm.getAuthenticationExecutionsStream(flow.getId()).filter(exe -> Objects.nonNull(exe.getAuthenticator()) && exe.getRequirement() != AuthenticationExecutionModel.Requirement.DISABLED).map(exe -> (AuthenticatorFactory)this.session.getKeycloakSessionFactory().getProviderFactory(Authenticator.class, exe.getAuthenticator())).filter(Objects::nonNull).map(ConfigurableAuthenticatorFactory::getReferenceCategory).filter(Objects::nonNull)).collect(Collectors.toSet());
    }

    private boolean isFlowEffectivelyDisabled(AuthenticationFlowModel flow) {
        while (!flow.isTopLevel()) {
            AuthenticationExecutionModel flowExecution = this.realm.getAuthenticationExecutionByFlowId(flow.getId());
            if (flowExecution == null) {
                return false;
            }
            if (AuthenticationExecutionModel.Requirement.DISABLED == flowExecution.getRequirement()) {
                return true;
            }
            if (flowExecution.getParentFlow() == null) {
                return false;
            }
            flow = this.realm.getAuthenticationFlowById(flowExecution.getParentFlow());
            if (flow != null) continue;
            return false;
        }
        return false;
    }

    private Integer getCurrentAuthenticatedLevel() {
        ClientModel client = this.realm.getClientByClientId(this.auth.getToken().getIssuedFor());
        Map<String, Integer> acrLoaMap = AcrUtils.getAcrLoaMap(client);
        String tokenAcr = this.auth.getToken().getAcr();
        if (tokenAcr == null) {
            logger.warnf("Not able to remove credential of user '%s' as no acr claim on the token", (Object)this.user.getUsername());
            throw new ForbiddenException("No LoA on the token");
        }
        Integer currentAuthenticatedLevel = acrLoaMap.get(tokenAcr);
        if (currentAuthenticatedLevel != null) {
            return currentAuthenticatedLevel;
        }
        try {
            return Integer.parseInt(tokenAcr);
        }
        catch (NumberFormatException nfe) {
            logger.warnf("Token acr '%s' not found in acrLoaMap of client '%s' or realm '%s'. Not able to remove credential of user '%s'", new Object[]{tokenAcr, client.getClientId(), this.realm.getName(), this.user.getUsername()});
            throw new ForbiddenException("Unsupported acr on the token");
        }
    }

    @Path(value="{credentialId}")
    @DELETE
    @NoCache
    @Deprecated
    public void removeCredential(@PathParam(value="credentialId") String credentialId) {
        this.auth.require("manage-account");
        logger.warnf("Using deprecated endpoint of Account REST service for removing credential of user '%s' in the realm '%s'. It is recommended to use application initiated actions (AIA) for removing credentials", (Object)this.user.getUsername(), (Object)this.realm.getName());
        CredentialModel credential = CredentialDeleteHelper.removeCredential(this.session, this.user, credentialId, this::getCurrentAuthenticatedLevel);
        if (credential != null) {
            this.event.event(EventType.REMOVE_CREDENTIAL).detail("credential_type", credential.getType()).detail("selected_credential_id", credentialId).detail("credential_user_label", credential.getUserLabel());
            if ("otp".equals(credential.getType())) {
                this.event.clone().event(EventType.REMOVE_TOTP).success();
            }
            this.event.success();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="{credentialId}/label")
    @NoCache
    public void setLabel(@PathParam(value="credentialId") String credentialId, String userLabel) {
        this.auth.require("manage-account");
        CredentialModel credential = this.user.credentialManager().getStoredCredentialById(credentialId);
        if (credential == null) {
            throw new NotFoundException("Credential not found");
        }
        try {
            String label = (String)JsonSerialization.readValue((String)userLabel, String.class);
            this.user.credentialManager().updateCredentialLabel(credentialId, label);
        }
        catch (IOException ioe) {
            throw ErrorResponse.error("invalidRequestMessage", Response.Status.BAD_REQUEST);
        }
    }

    public static class CredentialContainer {
        private String type;
        private String category;
        private String displayName;
        private String helptext;
        private String iconCssClass;
        private String createAction;
        private String updateAction;
        private boolean removeable;
        private List<CredentialMetadataRepresentation> userCredentialMetadatas;
        private CredentialTypeMetadata metadata;

        public CredentialContainer() {
        }

        public CredentialContainer(CredentialTypeMetadata metadata, List<CredentialMetadataRepresentation> userCredentialMetadatas) {
            this.metadata = metadata;
            this.type = metadata.getType();
            this.category = metadata.getCategory().toString();
            this.displayName = metadata.getDisplayName();
            this.helptext = metadata.getHelpText();
            this.iconCssClass = metadata.getIconCssClass();
            this.createAction = metadata.getCreateAction();
            this.updateAction = metadata.getUpdateAction();
            this.removeable = metadata.isRemoveable();
            this.userCredentialMetadatas = userCredentialMetadatas;
        }

        public String getCategory() {
            return this.category;
        }

        public String getType() {
            return this.type;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getHelptext() {
            return this.helptext;
        }

        public String getIconCssClass() {
            return this.iconCssClass;
        }

        public String getCreateAction() {
            return this.createAction;
        }

        public String getUpdateAction() {
            return this.updateAction;
        }

        public boolean isRemoveable() {
            return this.removeable;
        }

        public List<CredentialMetadataRepresentation> getUserCredentialMetadatas() {
            return this.userCredentialMetadatas;
        }

        @JsonIgnore
        public CredentialTypeMetadata getMetadata() {
            return this.metadata;
        }
    }
}

