/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jupnp.model.ServiceReference;
import org.jupnp.model.Validatable;
import org.jupnp.model.ValidationError;
import org.jupnp.model.ValidationException;
import org.jupnp.model.meta.Action;
import org.jupnp.model.meta.ActionArgument;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.model.meta.StateVariableTypeDetails;
import org.jupnp.model.types.Datatype;
import org.jupnp.model.types.ServiceId;
import org.jupnp.model.types.ServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Service<D extends Device, S extends Service> {
    private final Logger logger = LoggerFactory.getLogger(Service.class);
    private final ServiceType serviceType;
    private final ServiceId serviceId;
    private final Map<String, Action> actions = new HashMap<String, Action>();
    private final Map<String, StateVariable> stateVariables = new HashMap<String, StateVariable>();
    private D device;

    protected Service(ServiceType serviceType, ServiceId serviceId) throws ValidationException {
        this(serviceType, serviceId, null, null);
    }

    protected Service(ServiceType serviceType, ServiceId serviceId, Action<S>[] actions, StateVariable<S>[] stateVariables) throws ValidationException {
        this.serviceType = serviceType;
        this.serviceId = serviceId;
        if (actions != null) {
            for (Validatable validatable : actions) {
                this.actions.put(((Action)validatable).getName(), (Action)validatable);
                ((Action)validatable).setService(this);
            }
        }
        if (stateVariables != null) {
            for (Validatable validatable : stateVariables) {
                this.stateVariables.put(((StateVariable)validatable).getName(), (StateVariable)validatable);
                ((StateVariable)validatable).setService(this);
            }
        }
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public ServiceId getServiceId() {
        return this.serviceId;
    }

    public boolean hasActions() {
        return this.getActions() != null && this.getActions().length > 0;
    }

    public Action<S>[] getActions() {
        return this.actions == null ? null : this.actions.values().toArray(new Action[this.actions.values().size()]);
    }

    public boolean hasStateVariables() {
        return this.getStateVariables() != null && this.getStateVariables().length > 0;
    }

    public StateVariable<S>[] getStateVariables() {
        return this.stateVariables == null ? null : this.stateVariables.values().toArray(new StateVariable[this.stateVariables.values().size()]);
    }

    public D getDevice() {
        return this.device;
    }

    void setDevice(D device) {
        if (this.device != null) {
            throw new IllegalStateException("Final value has been set already, model is immutable");
        }
        this.device = device;
    }

    public Action<S> getAction(String name) {
        return this.actions == null ? null : this.actions.get(name);
    }

    public StateVariable<S> getStateVariable(String name) {
        if ("VirtualQueryActionInput".equals(name)) {
            return new StateVariable("VirtualQueryActionInput", new StateVariableTypeDetails(Datatype.Builtin.STRING.getDatatype()));
        }
        if ("VirtualQueryActionOutput".equals(name)) {
            return new StateVariable("VirtualQueryActionOutput", new StateVariableTypeDetails(Datatype.Builtin.STRING.getDatatype()));
        }
        return this.stateVariables == null ? null : this.stateVariables.get(name);
    }

    public StateVariable<S> getRelatedStateVariable(ActionArgument argument) {
        return this.getStateVariable(argument.getRelatedStateVariableName());
    }

    public Datatype<S> getDatatype(ActionArgument argument) {
        return this.getRelatedStateVariable(argument).getTypeDetails().getDatatype();
    }

    public ServiceReference getReference() {
        return new ServiceReference(((DeviceIdentity)((Device)this.getDevice()).getIdentity()).getUdn(), this.getServiceId());
    }

    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getServiceType() == null) {
            errors.add(new ValidationError(this.getClass(), "serviceType", "Service type/info is required"));
        }
        if (this.getServiceId() == null) {
            errors.add(new ValidationError(this.getClass(), "serviceId", "Service ID is required"));
        }
        if (this.hasStateVariables()) {
            for (Validatable validatable : this.getStateVariables()) {
                errors.addAll(((StateVariable)validatable).validate());
            }
        }
        if (this.hasActions()) {
            for (Validatable validatable : this.getActions()) {
                List<ValidationError> actionErrors = ((Action)validatable).validate();
                if (actionErrors.isEmpty()) continue;
                this.actions.remove(((Action)validatable).getName());
                this.logger.warn("Discarding invalid action of service '{}': {}", (Object)this.getServiceId(), (Object)((Action)validatable).getName());
                if (!this.logger.isDebugEnabled()) continue;
                for (ValidationError actionError : actionErrors) {
                    this.logger.debug("Invalid action '{}': {}", (Object)((Action)validatable).getName(), (Object)actionError);
                }
            }
        }
        return errors;
    }

    public abstract Action getQueryStateVariableAction();

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") ServiceId: " + String.valueOf(this.getServiceId());
    }
}

