/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import net.wimpi.modbus.ModbusException;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.ModbusSlaveException;
import net.wimpi.modbus.io.ModbusTransaction;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.msg.ExceptionResponse;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.net.UDPMasterConnection;
import net.wimpi.modbus.net.UDPTerminal;
import net.wimpi.modbus.util.AtomicCounter;
import net.wimpi.modbus.util.Mutex;

public class ModbusUDPTransaction
implements ModbusTransaction {
    private static AtomicCounter c_TransactionID = new AtomicCounter(0);
    private UDPTerminal m_Terminal;
    private ModbusTransport m_IO;
    private ModbusRequest m_Request;
    private ModbusResponse m_Response;
    private boolean m_ValidityCheck = true;
    private int m_Retries = 3;
    private int m_RetryCounter = 0;
    private Mutex m_TransactionLock = new Mutex();
    private long m_RetryDelayMillis;

    public ModbusUDPTransaction() {
    }

    public ModbusUDPTransaction(ModbusRequest request) {
        this.setRequest(request);
    }

    public ModbusUDPTransaction(UDPTerminal terminal) {
        this.setTerminal(terminal);
    }

    public ModbusUDPTransaction(UDPMasterConnection con) {
        this.setTerminal(con.getTerminal());
    }

    public void setTerminal(UDPTerminal terminal) {
        this.m_Terminal = terminal;
        if (terminal.isActive()) {
            this.m_IO = terminal.getModbusTransport();
        }
    }

    @Override
    public void setRequest(ModbusRequest req) {
        this.m_Request = req;
    }

    @Override
    public ModbusRequest getRequest() {
        return this.m_Request;
    }

    @Override
    public ModbusResponse getResponse() {
        return this.m_Response;
    }

    @Override
    public int getTransactionID() {
        return c_TransactionID.get();
    }

    @Override
    public void setCheckingValidity(boolean b) {
        this.m_ValidityCheck = b;
    }

    @Override
    public boolean isCheckingValidity() {
        return this.m_ValidityCheck;
    }

    @Override
    public int getRetries() {
        return this.m_Retries;
    }

    @Override
    public void setRetries(int num) {
        this.m_Retries = num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws ModbusIOException, ModbusSlaveException, ModbusException {
        this.assertExecutable();
        try {
            this.m_TransactionLock.acquire();
            if (!this.m_Terminal.isActive()) {
                try {
                    this.m_Terminal.activate();
                    this.m_IO = this.m_Terminal.getModbusTransport();
                }
                catch (Exception ex) {
                    throw new ModbusIOException("Activation failed.");
                }
            }
            this.m_RetryCounter = 0;
            while (this.m_RetryCounter <= this.m_Retries) {
                if (this.m_RetryCounter != 0) {
                    Thread.sleep(this.m_RetryDelayMillis);
                }
                try {
                    this.m_Request.setTransactionID(c_TransactionID.increment());
                    ModbusTransport ex = this.m_IO;
                    synchronized (ex) {
                        this.m_IO.writeMessage(this.m_Request);
                        this.m_Response = this.m_IO.readResponse();
                        break;
                    }
                }
                catch (ModbusIOException ex) {
                    ++this.m_RetryCounter;
                }
            }
            if (this.m_Response instanceof ExceptionResponse) {
                throw new ModbusSlaveException(((ExceptionResponse)this.m_Response).getExceptionCode());
            }
            if (this.isCheckingValidity()) {
                this.checkValidity();
            }
        }
        catch (InterruptedException ex) {
            throw new ModbusIOException("Thread acquiring lock was interrupted.");
        }
        finally {
            this.m_TransactionLock.release();
        }
    }

    private void assertExecutable() throws ModbusException {
        if (this.m_Request == null || this.m_Terminal == null) {
            throw new ModbusException("Assertion failed, transaction not executable");
        }
    }

    protected void checkValidity() throws ModbusException {
    }

    @Override
    public long getRetryDelayMillis() {
        return this.m_RetryDelayMillis;
    }

    @Override
    public void setRetryDelayMillis(long retryDelayMillis) {
        this.m_RetryDelayMillis = retryDelayMillis;
    }
}

