/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.util;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.MasterReport;
import com.adobe.epubcheck.messages.Message;
import com.adobe.epubcheck.messages.Severity;
import com.adobe.epubcheck.reporting.CheckMessage;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.KeyValue;
import com.adobe.epubcheck.util.PathUtil;
import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XmlReportAbstract
extends MasterReport {
    protected PrintWriter out;
    protected String epubCheckName = "epubcheck";
    protected String epubCheckVersion;
    protected String epubCheckDate = "2012-10-31";
    protected String generationDate;
    protected String creationDate;
    protected String lastModifiedDate;
    protected String identifier;
    protected Set<String> titles = new LinkedHashSet<String>();
    protected final Set<String> creators = new LinkedHashSet<String>();
    protected final Set<String> contributors = new LinkedHashSet<String>();
    protected final Set<String> subjects = new LinkedHashSet<String>();
    protected String publisher;
    protected final Set<String> rights = new LinkedHashSet<String>();
    protected String date;
    protected final Set<String> mediaTypes = new LinkedHashSet<String>();
    protected String formatName;
    protected String formatVersion;
    protected long pagesCount;
    protected long charsCount;
    protected String language;
    protected final Set<String> embeddedFonts = new LinkedHashSet<String>();
    protected final Set<String> refFonts = new LinkedHashSet<String>();
    protected final Set<String> references = new LinkedHashSet<String>();
    protected boolean hasEncryption;
    protected boolean hasSignatures;
    protected boolean hasAudio;
    protected boolean hasVideo;
    protected boolean hasFixedLayout;
    protected boolean hasScripts;
    protected final List<CheckMessage> warns = new ArrayList<CheckMessage>();
    protected final List<CheckMessage> errors = new ArrayList<CheckMessage>();
    protected final List<CheckMessage> fatalErrors = new ArrayList<CheckMessage>();
    protected final List<CheckMessage> hints = new ArrayList<CheckMessage>();
    private Document doc;
    private Element currentEl;
    private String namespaceURI;
    private Map<String, String> namespaces;

    public XmlReportAbstract(PrintWriter out, String ePubName, String versionEpubCheck) {
        this.out = out;
        this.setEpubFileName(PathUtil.removeWorkingDirectory(ePubName));
        this.epubCheckVersion = versionEpubCheck;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void close() {
    }

    @Override
    public void message(Message message, EPUBLocation location, Object ... args) {
        Severity s = message.getSeverity();
        switch (s) {
            case FATAL: {
                CheckMessage.addCheckMessage(this.fatalErrors, message, location, args);
                break;
            }
            case ERROR: {
                CheckMessage.addCheckMessage(this.errors, message, location, args);
                break;
            }
            case WARNING: {
                CheckMessage.addCheckMessage(this.warns, message, location, args);
                break;
            }
            case USAGE: {
                CheckMessage.addCheckMessage(this.hints, message, location, args);
                break;
            }
            case INFO: {
                break;
            }
            case SUPPRESSED: {
                break;
            }
        }
    }

    @Override
    public void info(String resource, FeatureEnum feature, String value) {
        if (value == null) {
            return;
        }
        switch (feature) {
            case TOOL_DATE: {
                if (value == null || value.startsWith("$")) break;
                this.epubCheckDate = value;
                break;
            }
            case TOOL_NAME: {
                this.epubCheckName = value;
                break;
            }
            case TOOL_VERSION: {
                this.epubCheckVersion = value;
                break;
            }
            case FORMAT_NAME: {
                this.formatName = value;
                break;
            }
            case FORMAT_VERSION: {
                this.formatVersion = value;
                break;
            }
            case CREATION_DATE: {
                this.creationDate = value;
                break;
            }
            case MODIFIED_DATE: {
                this.lastModifiedDate = value;
                break;
            }
            case PAGES_COUNT: {
                this.pagesCount = Long.parseLong(value);
                break;
            }
            case CHARS_COUNT: {
                this.charsCount += Long.parseLong(value);
                break;
            }
            case DECLARED_MIMETYPE: {
                this.mediaTypes.add(value);
                if (value != null && value.startsWith("audio/")) {
                    this.hasAudio = true;
                    break;
                }
                if (value == null || !value.startsWith("video/")) break;
                this.hasVideo = true;
                break;
            }
            case FONT_EMBEDDED: {
                this.embeddedFonts.add(value);
                break;
            }
            case FONT_REFERENCE: {
                this.refFonts.add(value);
                break;
            }
            case REFERENCE: {
                this.references.add(value);
                break;
            }
            case DC_LANGUAGE: {
                this.language = value;
                break;
            }
            case DC_TITLE: {
                this.titles.add(value);
                break;
            }
            case DC_CREATOR: {
                this.creators.add(value);
                break;
            }
            case DC_CONTRIBUTOR: {
                this.contributors.add(value);
                break;
            }
            case DC_PUBLISHER: {
                this.publisher = value;
                break;
            }
            case DC_SUBJECT: {
                this.subjects.add(value);
                break;
            }
            case DC_RIGHTS: {
                this.rights.add(value);
                break;
            }
            case DC_DATE: {
                this.date = value;
                break;
            }
            case UNIQUE_IDENT: {
                if (resource != null) break;
                this.identifier = value;
                break;
            }
            case HAS_SIGNATURES: {
                this.hasSignatures = true;
                break;
            }
            case HAS_ENCRYPTION: {
                this.hasEncryption = true;
                break;
            }
            case HAS_FIXED_LAYOUT: {
                this.hasFixedLayout = true;
                break;
            }
            case HAS_SCRIPTS: {
                this.hasScripts = true;
                break;
            }
            case SPINE_INDEX: {
                break;
            }
        }
    }

    protected String getNameFromPath(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash == -1) {
            if (File.separatorChar != '/') {
                int lastSlash2 = path.lastIndexOf(File.separatorChar);
                if (lastSlash2 == -1) {
                    return path;
                }
                return path.substring(lastSlash2 + 1);
            }
            return path;
        }
        return path.substring(lastSlash + 1);
    }

    public abstract int generateReport();

    public void setNamespace(String uri) {
        this.namespaceURI = uri;
    }

    public void addPrefixNamespace(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int generate() {
        this.namespaces = new HashMap<String, String>();
        int returnCode = 1;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            this.doc = docBuilder.newDocument();
            returnCode = this.generateReport();
            if (returnCode == 0) {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                DOMSource source = new DOMSource(this.doc);
                StreamResult result = new StreamResult(this.out);
                transformer.transform(source, result);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            returnCode = 1;
        }
        catch (TransformerException e) {
            System.err.println("Error while generating the XML report " + e.getMessage());
            e.printStackTrace();
            returnCode = 1;
        }
        finally {
            if (this.out != null) {
                this.out.flush();
                this.out.close();
            }
        }
        return returnCode;
    }

    protected String capitalize(String in) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (i == 0) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private Element makeElement(String name) {
        String prefix;
        String uri;
        int index = name.indexOf(58);
        Element el = index == -1 ? (this.namespaceURI == null ? this.doc.createElement(name) : this.doc.createElementNS(this.namespaceURI, name)) : ((uri = this.namespaces.get(prefix = name.substring(0, index))) == null ? this.doc.createElement(name) : this.doc.createElementNS(uri, name));
        return el;
    }

    private Attr makeAttribute(KeyValue<String, String> kv) {
        String prefix;
        String uri;
        String attName = kv.getKey();
        int iAttr = attName.indexOf(58);
        Attr attr = iAttr == -1 ? this.doc.createAttribute(attName) : ((uri = this.namespaces.get(prefix = attName.substring(0, iAttr))) == null ? this.doc.createAttribute(attName) : this.doc.createAttributeNS(uri, attName));
        attr.setValue(kv.getValue());
        return attr;
    }

    protected void startElement(String name, List<KeyValue<String, String>> attrs) {
        if (name == null || name.trim().length() == 0) {
            return;
        }
        Element el = this.makeElement(name.trim());
        if (attrs != null && attrs.size() != 0) {
            for (KeyValue<String, String> attr : attrs) {
                el.setAttributeNode(this.makeAttribute(attr));
            }
        }
        if (this.currentEl == null) {
            this.doc.appendChild(el);
        } else {
            this.currentEl.appendChild(el);
        }
        this.currentEl = el;
    }

    protected void startElement(String name, KeyValue<String, String> ... attrs) {
        this.startElement(name, Arrays.asList(attrs));
    }

    protected void startElement(String name) {
        this.startElement(name, (List<KeyValue<String, String>>)null);
    }

    protected void endElement(String name) {
        if (this.currentEl == null) {
            return;
        }
        Node parent = this.currentEl.getParentNode();
        if (parent == null || parent == this.doc) {
            this.currentEl = null;
        } else if (parent instanceof Element) {
            this.currentEl = (Element)this.currentEl.getParentNode();
        } else {
            System.out.println("Pb at Element [" + this.currentEl.getLocalName() + "] with parent " + parent);
        }
    }

    protected void generateElement(String name, String value) {
        if (name == null || name.trim().length() == 0 || value == null || value.trim().length() == 0) {
            return;
        }
        Element el = this.makeElement(name.trim());
        el.appendChild(this.doc.createTextNode(XmlReportAbstract.correctToUtf8(value.trim())));
        this.currentEl.appendChild(el);
    }

    protected void generateElement(String name, String value, KeyValue<String, String> ... attrs) {
        this.generateElement(name, value, Arrays.asList(attrs));
    }

    protected void generateElement(String name, String value, List<KeyValue<String, String>> attrs) {
        if (name == null || name.trim().length() == 0) {
            return;
        }
        Element el = this.makeElement(name);
        if (attrs != null && attrs.size() != 0) {
            for (KeyValue<String, String> attr : attrs) {
                el.setAttributeNode(this.makeAttribute(attr));
            }
        }
        if (value != null && value.trim().length() != 0) {
            el.appendChild(this.doc.createTextNode(XmlReportAbstract.correctToUtf8(value.trim())));
        }
        this.currentEl.appendChild(el);
    }

    protected static String correctToUtf8(String inputString) {
        StringBuilder result = new StringBuilder(inputString.length());
        StringCharacterIterator it = new StringCharacterIterator(inputString);
        char ch = it.current();
        boolean modified = false;
        while (ch != '\uffff') {
            if (Character.isISOControl(ch)) {
                if (ch == '\r' || ch == '\n') {
                    result.append(ch);
                } else {
                    modified = true;
                    result.append(String.format("0x%x", ch));
                }
            } else {
                result.append(ch);
            }
            ch = it.next();
        }
        if (!modified) {
            return inputString;
        }
        return result.toString();
    }

    protected static String fromTime(long time) {
        Date date = new Date(time);
        String formatted = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(date);
        return formatted.substring(0, 22) + ":" + formatted.substring(22);
    }
}

