/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.IOException;
import java.io.OutputStream;

final class CountingOutputStream
extends OutputStream {
    private final OutputStream delegate;
    long currentSize;

    CountingOutputStream(OutputStream delegate) {
        this.delegate = delegate;
        this.currentSize = 0L;
    }

    @Override
    public void write(int b) throws IOException {
        this.delegate.write(b);
        ++this.currentSize;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.delegate.write(b);
        this.currentSize += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
        this.currentSize += (long)len;
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

