/*
 * Decompiled with CFR 0.152.
 */
package gnu.io.rfc2217;

import gnu.io.rfc2217.ComPortCommand;
import gnu.io.rfc2217.ComPortCommandSwitch;
import gnu.io.rfc2217.Util;

public class LineStateMaskCommand
extends ComPortCommand {
    private int lineStateMask;

    public LineStateMaskCommand(int[] bytes) {
        super("SET-LINESTATE-MASK", 10, bytes);
        this.lineStateMask = bytes[2];
    }

    public LineStateMaskCommand(boolean client, int lineStateMask) {
        this(new int[]{44, client ? 10 : 110, lineStateMask});
    }

    @Override
    public String toString() {
        return this.getName() + " " + Util.decodeBits(this.lineStateMask, Util.LINE_STATE_BITS);
    }

    @Override
    public void visit(ComPortCommandSwitch sw) {
        sw.caseLineStateMask(this);
    }

    public int getLineStateMask() {
        return this.lineStateMask;
    }

    @Override
    int getMinPayloadLength() {
        return 1;
    }

    @Override
    int getMaxPayloadLength() {
        return 1;
    }
}

