/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;

public class HandshakeParameter {
    private final CipherSuite.KeyExchangeAlgorithm keyExchange;
    private final CertificateType certificateType;

    public HandshakeParameter(CipherSuite.KeyExchangeAlgorithm keyExchange, CertificateType certificateType) {
        if (keyExchange == null) {
            throw new NullPointerException("key exchange must not be null!");
        }
        if (certificateType == null) {
            throw new NullPointerException("certificate type must not be null!");
        }
        this.keyExchange = keyExchange;
        this.certificateType = certificateType;
    }

    public CipherSuite.KeyExchangeAlgorithm getKeyExchangeAlgorithm() {
        return this.keyExchange;
    }

    public CertificateType getCertificateType() {
        return this.certificateType;
    }

    public String toString() {
        return "KeyExgAl=" + (Object)((Object)this.keyExchange) + ", cert.type=" + (Object)((Object)this.certificateType);
    }
}

