/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java;

enum keyword {
    none_k,
    cat_k,
    shuffle_k,
    burst_k,
    barcode_burst_k,
    filter_k,
    dump_data_k,
    dump_data_utf8_k,
    dump_data_fields_k,
    dump_data_fields_utf8_k,
    dump_data_annots_k,
    generate_fdf_k,
    unpack_files_k,
    fill_form_k,
    attach_file_k,
    update_info_k,
    update_info_utf8_k,
    background_k,
    multibackground_k,
    stamp_k,
    multistamp_k,
    rotate_k,
    attach_file_to_page_k,
    attach_file_relation_k,
    even_k,
    odd_k,
    range_minus_k,
    output_k,
    input_pw_k,
    owner_pw_k,
    user_pw_k,
    user_perms_k,
    encrypt_40bit_k,
    encrypt_128bit_k,
    encrypt_aes128_k,
    perm_printing_k,
    perm_modify_contents_k,
    perm_copy_contents_k,
    perm_modify_annotations_k,
    perm_fillin_k,
    perm_screen_readers_k,
    perm_assembly_k,
    perm_degraded_printing_k,
    perm_all_k,
    filt_uncompress_k,
    filt_compress_k,
    flatten_k,
    need_appearances_k,
    drop_xfa_k,
    drop_xmp_k,
    keep_first_id_k,
    keep_final_id_k,
    replacement_font_k,
    verbose_k,
    dont_ask_k,
    do_ask_k,
    rot_north_k,
    rot_east_k,
    rot_south_k,
    rot_west_k,
    rot_left_k,
    rot_right_k,
    rot_upside_down_k;


    static keyword is_keyword(String ss) {
        ss = ss.toLowerCase();
        try {
            keyword k = keyword.valueOf(ss + "_k");
            return k;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (ss.equals("dumpdata") || ss.equals("data_dump") || ss.equals("datadump")) {
                return dump_data_k;
            }
            if (ss.equals("fdfgen") || ss.equals("fdfdump") || ss.equals("dump_data_fields_fdf")) {
                return generate_fdf_k;
            }
            if (ss.equals("fillform")) {
                return fill_form_k;
            }
            if (ss.equals("attach_files") || ss.equals("attachfile")) {
                return attach_file_k;
            }
            if (ss.equals("unpack_file") || ss.equals("unpackfiles")) {
                return unpack_files_k;
            }
            if (ss.equals("updateinfo")) {
                return update_info_k;
            }
            if (ss.equals("updateinfoutf8")) {
                return update_info_utf8_k;
            }
            if (ss.startsWith("even")) {
                return even_k;
            }
            if (ss.startsWith("odd")) {
                return odd_k;
            }
            if (ss.equals("to_page") || ss.equals("topage")) {
                return attach_file_to_page_k;
            }
            if (ss.equals("relation")) {
                return attach_file_relation_k;
            }
            if (ss.equals("ownerpw")) {
                return owner_pw_k;
            }
            if (ss.equals("userpw")) {
                return user_pw_k;
            }
            if (ss.equals("inputpw")) {
                return input_pw_k;
            }
            if (ss.equals("allow")) {
                return user_perms_k;
            }
            if (ss.equals("encrypt_40bits") || ss.equals("encrypt40bit") || ss.equals("encrypt40bits") || ss.equals("encrypt40_bit") || ss.equals("encrypt40_bits") || ss.equals("encrypt_40_bit") || ss.equals("encrypt_40_bits")) {
                return encrypt_40bit_k;
            }
            if (ss.equals("encrypt_128bits") || ss.equals("encrypt128bit") || ss.equals("encrypt128bits") || ss.equals("encrypt128_bit") || ss.equals("encrypt128_bits") || ss.equals("encrypt_128_bit") || ss.equals("encrypt_128_bits")) {
                return encrypt_128bit_k;
            }
            if (ss.equals("printing")) {
                return perm_printing_k;
            }
            if (ss.equals("modifycontents")) {
                return perm_modify_contents_k;
            }
            if (ss.equals("copycontents")) {
                return perm_copy_contents_k;
            }
            if (ss.equals("modifyannotations")) {
                return perm_modify_annotations_k;
            }
            if (ss.equals("fillin")) {
                return perm_fillin_k;
            }
            if (ss.equals("screenreaders")) {
                return perm_screen_readers_k;
            }
            if (ss.equals("assembly")) {
                return perm_assembly_k;
            }
            if (ss.equals("degradedprinting")) {
                return perm_degraded_printing_k;
            }
            if (ss.equals("allfeatures")) {
                return perm_all_k;
            }
            if (ss.equals("uncompress")) {
                return filt_uncompress_k;
            }
            if (ss.equals("compress")) {
                return filt_compress_k;
            }
            if (ss.equals("dontask")) {
                return dont_ask_k;
            }
            if (ss.equals("north")) {
                return rot_north_k;
            }
            if (ss.equals("south")) {
                return rot_south_k;
            }
            if (ss.equals("east")) {
                return rot_east_k;
            }
            if (ss.equals("west")) {
                return rot_west_k;
            }
            if (ss.equals("left")) {
                return rot_left_k;
            }
            if (ss.equals("right")) {
                return rot_right_k;
            }
            if (ss.equals("down")) {
                return rot_upside_down_k;
            }
            if (ss.equals("~")) {
                return range_minus_k;
            }
            return none_k;
        }
    }

    static keyword consume_keyword(StringBuilder ssb) {
        String ss = ssb.toString().toLowerCase();
        if (ss.startsWith("even")) {
            ssb.delete(0, 4);
            return even_k;
        }
        if (ss.startsWith("odd")) {
            ssb.delete(0, 3);
            return odd_k;
        }
        if (ss.startsWith("~")) {
            ssb.delete(0, 1);
            return range_minus_k;
        }
        ssb.setLength(0);
        return keyword.is_keyword(ss);
    }
}

