/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldapinput;

import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ldapinput.LDAPInputData;
import org.pentaho.di.trans.steps.ldapinput.LDAPInputMeta;
import org.pentaho.di.trans.steps.ldapinput.Messages;

public class LDAPInput
extends BaseStep
implements StepInterface {
    private LDAPInputMeta meta;
    private LDAPInputData data;

    public LDAPInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.first) {
            int i;
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            this.data.convertRowMeta = this.data.outputRowMeta.clone();
            for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                this.data.convertRowMeta.getValueMeta(i).setType(2);
            }
            this.data.convertRowMeta = this.data.outputRowMeta.clone();
            for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                this.data.convertRowMeta.getValueMeta(i).setType(2);
            }
            this.connectServerLdap();
            this.data.multi_valuedFieldSeparator = this.environmentSubstitute(this.meta.getMultiValuedSeparator());
            this.data.nrfields = this.meta.getInputFields().length;
        }
        Object[] outputRowData = null;
        boolean sendToErrorRow = false;
        String errorMessage = null;
        try {
            outputRowData = this.getOneRow();
            if (outputRowData == null) {
                this.setOutputDone();
                return false;
            }
            this.putRow(this.data.outputRowMeta, outputRowData);
            if (this.log.isDebug()) {
                this.log.logDebug(Messages.getString("LDAPInput.log.ReadRow"), outputRowData.toString(), new Object[0]);
            }
            if (this.checkFeedback(this.getLinesInput()) && this.log.isDetailed()) {
                this.logDetailed(Messages.getString("LDAPInput.log.LineRow") + this.getLinesInput());
            }
            return true;
        }
        catch (Exception e) {
            if (!this.getStepMeta().isDoingErrorHandling()) {
                this.logError(Messages.getString("LDAPInput.log.Exception", e.getMessage()));
                this.setErrors(1L);
                this.stopAll();
                this.setOutputDone();
                return false;
            }
            sendToErrorRow = true;
            errorMessage = e.toString();
            if (sendToErrorRow) {
                this.putError(this.getInputRowMeta(), outputRowData, 1L, errorMessage, null, "LDAPINPUT001");
            }
            return true;
        }
    }

    private Object[] getOneRow() throws KettleException {
        if (!this.data.results.hasMoreElements()) {
            return null;
        }
        Object[] outputRowData = this.buildEmptyRow();
        try {
            SearchResult searchResult = this.data.results.next();
            Attributes attributes = searchResult.getAttributes();
            if (attributes != null) {
                RowMetaInterface irow;
                for (int i = 0; i < this.meta.getInputFields().length; ++i) {
                    String attrvalue = null;
                    Attribute attr = attributes.get(this.environmentSubstitute(this.meta.getInputFields()[i].getAttribute()));
                    if (attr != null) {
                        StringBuilder attrStr = new StringBuilder();
                        NamingEnumeration<?> eattr = attr.getAll();
                        while (eattr.hasMore()) {
                            if (attrStr.length() > 0) {
                                attrStr.append(this.data.multi_valuedFieldSeparator);
                            }
                            attrStr.append(eattr.next().toString());
                        }
                        attrvalue = attrStr.toString();
                        switch (this.meta.getInputFields()[i].getTrimType()) {
                            case 1: {
                                attrvalue = Const.ltrim((String)attrvalue);
                                break;
                            }
                            case 2: {
                                attrvalue = Const.rtrim((String)attrvalue);
                                break;
                            }
                            case 3: {
                                attrvalue = Const.trim((String)attrvalue);
                                break;
                            }
                        }
                    }
                    ValueMetaInterface targetValueMeta = this.data.outputRowMeta.getValueMeta(i);
                    ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(i);
                    outputRowData[i] = targetValueMeta.convertData(sourceValueMeta, (Object)attrvalue);
                    if (!this.meta.getInputFields()[i].isRepeated() || this.data.previousRow == null || !Const.isEmpty((String)attrvalue)) continue;
                    outputRowData[i] = this.data.previousRow[i];
                }
                if (this.meta.includeRowNumber() && !Const.isEmpty((String)this.meta.getRowNumberField())) {
                    outputRowData[this.data.nrfields] = new Long(this.data.rownr);
                }
                this.data.previousRow = (irow = this.getInputRowMeta()) == null ? outputRowData : irow.cloneRow(outputRowData);
                ++this.data.rownr;
                this.incrementLinesInput();
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("LDAPInput.Exception.CanNotReadLDAP"), (Throwable)e);
        }
        return outputRowData;
    }

    public void connectServerLdap() throws KettleException {
        try {
            String port = this.environmentSubstitute(this.meta.getPort());
            int portint = Const.toInt((String)port, (int)389);
            String hostname = this.environmentSubstitute(this.meta.getHost());
            String username = this.environmentSubstitute(this.meta.getUserName());
            String password = this.environmentSubstitute(this.meta.getPassword());
            String filter = this.environmentSubstitute(this.meta.getFilterString());
            String searchbase = this.environmentSubstitute(this.meta.getSearchBase());
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            if (hostname.indexOf("ldap://") >= 0) {
                env.put("java.naming.provider.url", hostname + ":" + portint);
            } else {
                env.put("java.naming.provider.url", "ldap://" + hostname + ":" + portint);
            }
            env.put("java.naming.security.authentication", "simple");
            if (this.meta.UseAuthentication()) {
                env.put("java.naming.security.principal", username);
                env.put("java.naming.security.credentials", password);
            }
            this.data.ctx = new InitialDirContext(env);
            if (this.data.ctx == null) {
                this.logError(Messages.getString("LDAPInput.Error.UnableToConnectToServer"));
                throw new KettleException(Messages.getString("LDAPInput.Error.UnableToConnectToServer"));
            }
            if (this.log.isBasic()) {
                this.logBasic(Messages.getString("LDAPInput.Log.ConnectedToServer", hostname, username));
            }
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("LDAPInput.ClassUsed.Message", this.data.ctx.getClass().getName()));
            }
            SearchControls controls = new SearchControls();
            controls.setCountLimit(this.meta.getRowLimit());
            if (this.meta.getTimeLimit() > 0) {
                controls.setTimeLimit(this.meta.getTimeLimit() * 1000);
            }
            String[] attrReturned = new String[this.meta.getInputFields().length];
            for (int i = 0; i < this.meta.getInputFields().length; ++i) {
                attrReturned[i] = this.environmentSubstitute(this.meta.getInputFields()[i].getAttribute());
            }
            controls.setReturningAttributes(attrReturned);
            if (Const.isEmpty((String)searchbase)) {
                Attributes attrs = this.data.ctx.getAttributes("", new String[]{"namingContexts"});
                Attribute attr = attrs.get("namingContexts");
                searchbase = attr.get().toString();
                if (this.log.isBasic()) {
                    this.logBasic(Messages.getString("LDAPInput.SearchBaseFound", searchbase));
                }
            }
            controls.setSearchScope(2);
            this.data.results = this.data.ctx.search(searchbase, filter.replace("\n\r", "").replace("\n", ""), controls);
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("LDAPinput.Exception.ErrorConnecting", e.getMessage()));
        }
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (LDAPInputMeta)smi;
        this.data = (LDAPInputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.rownr = 1L;
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (LDAPInputMeta)smi;
        this.data = (LDAPInputData)sdi;
        if (this.data.ctx != null) {
            try {
                this.data.ctx.close();
                if (this.data.results != null) {
                    this.data.results = null;
                }
                if (this.log.isBasic()) {
                    this.log.logBasic(this.toString(), Messages.getString("LDAPInput.log.Disconnection.Done"), new Object[0]);
                }
            }
            catch (Exception e) {
                this.logError(Messages.getString("LDAPInput.Exception.ErrorDisconecting", e.toString()));
                this.logError(Const.getStackTracker((Throwable)e));
            }
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

