/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.SimplePayload;

public class ItemProvider
extends ExtensionElementProvider<Item> {
    @Override
    public Item parse(XmlPullParser parser2, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        String id = parser2.getAttributeValue(null, "id");
        String node2 = parser2.getAttributeValue(null, "node");
        String xmlns = parser2.getNamespace();
        Item.ItemNamespace itemNamespace = Item.ItemNamespace.fromXmlns(xmlns);
        XmlPullParser.TagEvent event = parser2.nextTag();
        switch (event) {
            case START_ELEMENT: {
                String payloadElemName = parser2.getName();
                String payloadNS = parser2.getNamespace();
                ExtensionElementProvider<ExtensionElement> extensionProvider = ProviderManager.getExtensionProvider(payloadElemName, payloadNS);
                if (extensionProvider == null) {
                    CharSequence payloadText = PacketParserUtils.parseElement(parser2, true);
                    return new PayloadItem<SimplePayload>(itemNamespace, id, node2, new SimplePayload(payloadText.toString()));
                }
                return new PayloadItem<ExtensionElement>(itemNamespace, id, node2, (ExtensionElement)extensionProvider.parse(parser2));
            }
            case END_ELEMENT: {
                return new Item(itemNamespace, id, node2);
            }
        }
        throw new AssertionError((Object)("unknown: " + (Object)((Object)event)));
    }
}

