/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.dialogs.changeset.AbstractCellRenderer;
import org.openstreetmap.josm.tools.I18n;

public class ChangesetCacheTableCellRenderer
extends AbstractCellRenderer {
    protected void renderUploadComment(Changeset cs) {
        String comment = cs.getComment();
        if (comment.trim().isEmpty()) {
            this.setText(I18n.trc("changeset.upload-comment", "empty"));
            this.setFont(UIManager.getFont("Table.font").deriveFont(2));
        } else {
            this.setText(comment);
            this.setToolTipText(comment);
            this.setFont(UIManager.getFont("Table.font"));
        }
    }

    protected void renderOpen(Changeset cs) {
        if (cs.isOpen()) {
            this.setText(I18n.trc("changeset.state", "Open"));
        } else {
            this.setText(I18n.trc("changeset.state", "Closed"));
        }
        this.setToolTipText(null);
    }

    protected void renderChanges(Changeset cs) {
        this.setText(Integer.toString(cs.getChangesCount()));
        this.setToolTipText(null);
    }

    protected void renderDiscussions(Changeset cs) {
        this.setText(Integer.toString(cs.getCommentsCount()));
        this.setToolTipText(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return this;
        }
        this.reset();
        this.renderColors(isSelected);
        Changeset cs = (Changeset)value;
        switch (column) {
            case 0: {
                this.renderId(cs.getId());
                break;
            }
            case 1: {
                this.renderUploadComment(cs);
                break;
            }
            case 2: {
                this.renderOpen(cs);
                break;
            }
            case 3: {
                this.renderUser(cs.getUser());
                break;
            }
            case 4: {
                this.renderDate(cs.getCreatedAt());
                break;
            }
            case 5: {
                this.renderDate(cs.getClosedAt());
                break;
            }
            case 6: {
                this.renderChanges(cs);
                break;
            }
            case 7: {
                this.renderDiscussions(cs);
                break;
            }
        }
        return this;
    }
}

