/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlSocketFactory;
import org.hsqldb.HsqlSocketRequestHandler;
import org.hsqldb.Result;
import org.hsqldb.ServerConfiguration;
import org.hsqldb.ServerConnection;
import org.hsqldb.Trace;
import org.hsqldb.WebServer;
import org.hsqldb.WebServerConnection;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.resources.BundleHandler;

public class Server
implements HsqlSocketRequestHandler {
    protected static final int serverBundleHandle = BundleHandler.getBundleHandle("org_hsqldb_Server_messages", null);
    HsqlProperties serverProperties;
    HashSet serverConnSet;
    private String[] dbAlias;
    private String[] dbType;
    private String[] dbPath;
    private HsqlProperties[] dbProps;
    private int[] dbID;
    private int maxConnections;
    protected String serverId;
    protected int serverProtocol;
    protected ThreadGroup serverConnectionThreadGroup;
    protected HsqlSocketFactory socketFactory;
    protected ServerSocket socket;
    private Thread serverThread;
    private Throwable serverError;
    private volatile int serverState;
    private volatile boolean isSilent;
    private volatile boolean isRemoteOpen;
    private PrintWriter logWriter;
    private PrintWriter errWriter;

    public Server() {
        this(1);
    }

    protected Server(int n) {
        this.init(n);
    }

    public static void main(String[] stringArray) {
        String string = FileUtil.getDefaultInstance().canonicalOrAbsolutePath("server");
        HsqlProperties hsqlProperties = ServerConfiguration.getPropertiesFromFile(string);
        HsqlProperties hsqlProperties2 = hsqlProperties == null ? new HsqlProperties() : hsqlProperties;
        HsqlProperties hsqlProperties3 = null;
        try {
            hsqlProperties3 = HsqlProperties.argArrayToProps(stringArray, "server");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Server.printHelp("server.help");
            return;
        }
        if (hsqlProperties3 != null) {
            if (hsqlProperties3.getErrorKeys().length != 0) {
                Server.printHelp("server.help");
                return;
            }
            hsqlProperties2.addProperties(hsqlProperties3);
        }
        ServerConfiguration.translateDefaultDatabaseProperty(hsqlProperties2);
        ServerConfiguration.translateDefaultNoSystemExitProperty(hsqlProperties2);
        Server server = new Server();
        try {
            server.setProperties(hsqlProperties2);
        }
        catch (Exception exception) {
            server.printError("Failed to set properties");
            server.printStackTrace(exception);
            return;
        }
        server.print("Startup sequence initiated from main() method");
        if (hsqlProperties != null) {
            server.print("Loaded properties from [" + string + ".properties]");
        } else {
            server.print("Could not load properties from file");
            server.print("Using cli/default properties only");
        }
        server.start();
    }

    public void checkRunning(boolean bl) throws RuntimeException {
        boolean bl2;
        this.printWithThread("checkRunning(" + bl + ") entered");
        int n = this.getState();
        boolean bl3 = bl2 = bl && n != 1 || !bl && n != 16;
        if (bl2) {
            String string = "server is " + (bl ? "not " : "") + "running";
            throw new RuntimeException(string);
        }
        this.printWithThread("checkRunning(" + bl + ") exited");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void signalCloseAllServerConnections() {
        WrapperIterator wrapperIterator;
        this.printWithThread("signalCloseAllServerConnections() entered");
        Object object = this.serverConnSet;
        synchronized (object) {
            wrapperIterator = new WrapperIterator(this.serverConnSet.toArray(null));
        }
        while (wrapperIterator.hasNext()) {
            object = (ServerConnection)wrapperIterator.next();
            this.printWithThread("Closing " + object);
            ((ServerConnection)object).signalClose();
        }
        this.printWithThread("signalCloseAllServerConnections() exited");
    }

    protected void finalize() throws Throwable {
        if (this.serverThread != null) {
            this.releaseServerSocket();
        }
    }

    public String getAddress() {
        return this.socket == null ? this.serverProperties.getProperty("server.address") : this.socket.getInetAddress().getHostAddress();
    }

    public String getDatabaseName(int n, boolean bl) {
        if (bl) {
            return this.serverProperties.getProperty("server.dbname." + n);
        }
        if (this.getState() == 1) {
            return this.dbAlias == null || n < 0 || n >= this.dbAlias.length ? null : this.dbAlias[n];
        }
        return null;
    }

    public String getDatabasePath(int n, boolean bl) {
        if (bl) {
            return this.serverProperties.getProperty("server.database." + n);
        }
        if (this.getState() == 1) {
            return this.dbPath == null || n < 0 || n >= this.dbPath.length ? null : this.dbPath[n];
        }
        return null;
    }

    public String getDatabaseType(int n) {
        return this.dbType == null || n < 0 || n >= this.dbType.length ? null : this.dbType[n];
    }

    public String getDefaultWebPage() {
        return "[IGNORED]";
    }

    public String getHelpString() {
        return BundleHandler.getString(serverBundleHandle, "server.help");
    }

    public PrintWriter getErrWriter() {
        return this.errWriter;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public int getPort() {
        return this.serverProperties.getIntegerProperty("server.port", ServerConfiguration.getDefaultPort(this.serverProtocol, this.isTls()));
    }

    public String getProductName() {
        return "HSQLDB server";
    }

    public String getProductVersion() {
        return "1.8.0";
    }

    public String getProtocol() {
        return this.isTls() ? "HSQLS" : "HSQL";
    }

    public Throwable getServerError() {
        return this.serverError;
    }

    public String getServerId() {
        return this.serverId;
    }

    public synchronized int getState() {
        return this.serverState;
    }

    public String getStateDescriptor() {
        String string;
        Throwable throwable = this.getServerError();
        switch (this.serverState) {
            case 16: {
                string = "SHUTDOWN";
                break;
            }
            case 4: {
                string = "OPENING";
                break;
            }
            case 8: {
                string = "CLOSING";
                break;
            }
            case 1: {
                string = "ONLINE";
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }

    public String getWebRoot() {
        return "[IGNORED]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnection(Socket socket) {
        String string;
        Runnable runnable;
        this.printWithThread("handleConnection(" + socket + ") entered");
        if (!this.allowConnection(socket)) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.printWithThread("allowConnection(): connection refused");
            this.printWithThread("handleConnection() exited");
            return;
        }
        if (this.socketFactory != null) {
            this.socketFactory.configureSocket(socket);
        }
        if (this.serverProtocol == 1) {
            runnable = new ServerConnection(socket, this);
            string = runnable.getConnectionThreadName();
            HashSet hashSet = this.serverConnSet;
            synchronized (hashSet) {
                this.serverConnSet.add(runnable);
            }
        } else {
            runnable = new WebServerConnection(socket, (WebServer)this);
            string = ((WebServerConnection)runnable).getConnectionThreadName();
        }
        Thread thread = new Thread(this.serverConnectionThreadGroup, runnable, string);
        thread.start();
        this.printWithThread("handleConnection() exited");
    }

    public boolean isNoSystemExit() {
        return this.serverProperties.isPropertyTrue("server.no_system_exit");
    }

    public boolean isRestartOnShutdown() {
        return this.serverProperties.isPropertyTrue("server.restart_on_shutdown");
    }

    public boolean isSilent() {
        return this.isSilent;
    }

    public boolean isTls() {
        return this.serverProperties.isPropertyTrue("server.tls");
    }

    public boolean isTrace() {
        return this.serverProperties.isPropertyTrue("server.trace");
    }

    public boolean putPropertiesFromFile(String string) {
        if (this.getState() != 16) {
            throw new RuntimeException();
        }
        string = FileUtil.getDefaultInstance().canonicalOrAbsolutePath(string);
        HsqlProperties hsqlProperties = ServerConfiguration.getPropertiesFromFile(string);
        if (hsqlProperties == null || hsqlProperties.isEmpty()) {
            return false;
        }
        this.printWithThread("putPropertiesFromFile(): [" + string + ".properties]");
        try {
            this.setProperties(hsqlProperties);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to set properties: " + exception);
        }
        return true;
    }

    public void putPropertiesFromString(String string) {
        if (this.getState() != 16) {
            throw new RuntimeException();
        }
        if (StringUtil.isEmpty(string)) {
            return;
        }
        this.printWithThread("putPropertiesFromString(): [" + string + "]");
        HsqlProperties hsqlProperties = HsqlProperties.delimitedArgPairsToProps(string, "=", ";", "server");
        try {
            this.setProperties(hsqlProperties);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to set properties: " + exception);
        }
    }

    public void setAddress(String string) throws RuntimeException {
        this.checkRunning(false);
        if (StringUtil.isEmpty(string)) {
            string = "0.0.0.0";
        }
        this.printWithThread("setAddress(" + string + ")");
        this.serverProperties.setProperty("server.address", string);
    }

    public void setDatabaseName(int n, String string) throws RuntimeException {
        this.checkRunning(false);
        this.printWithThread("setDatabaseName(" + n + "," + string + ")");
        this.serverProperties.setProperty("server.dbname." + n, string);
    }

    public void setDatabasePath(int n, String string) throws RuntimeException {
        this.checkRunning(false);
        this.printWithThread("setDatabasePath(" + n + "," + string + ")");
        this.serverProperties.setProperty("server.database." + n, string);
    }

    public void setDefaultWebPage(String string) {
        this.checkRunning(false);
        this.printWithThread("setDefaultWebPage(" + string + ")");
        if (this.serverProtocol != 0) {
            return;
        }
        this.serverProperties.setProperty("server.default_page", string);
    }

    public void setPort(int n) throws RuntimeException {
        this.checkRunning(false);
        this.printWithThread("setPort(" + n + ")");
        this.serverProperties.setProperty("server.port", n);
    }

    public void setErrWriter(PrintWriter printWriter) {
        this.errWriter = printWriter;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public void setNoSystemExit(boolean bl) {
        this.printWithThread("setNoSystemExit(" + bl + ")");
        this.serverProperties.setProperty("server.no_system_exit", bl);
    }

    public void setRestartOnShutdown(boolean bl) {
        this.printWithThread("setRestartOnShutdown(" + bl + ")");
        this.serverProperties.setProperty("server.restart_on_shutdown", bl);
    }

    public void setSilent(boolean bl) {
        this.printWithThread("setSilent(" + bl + ")");
        this.serverProperties.setProperty("server.silent", bl);
        this.isSilent = bl;
    }

    public void setTls(boolean bl) {
        this.checkRunning(false);
        this.printWithThread("setTls(" + bl + ")");
        this.serverProperties.setProperty("server.tls", bl);
    }

    public void setTrace(boolean bl) {
        this.printWithThread("setTrace(" + bl + ")");
        this.serverProperties.setProperty("server.trace", bl);
        JavaSystem.setLogToSystem(bl);
    }

    public void setWebRoot(String string) {
        this.checkRunning(false);
        string = new File(string).getAbsolutePath();
        this.printWithThread("setWebRoot(" + string + ")");
        if (this.serverProtocol != 0) {
            return;
        }
        this.serverProperties.setProperty("server.root", string);
    }

    public void setProperties(HsqlProperties hsqlProperties) {
        this.checkRunning(false);
        if (hsqlProperties != null) {
            this.serverProperties.addProperties(hsqlProperties);
            ServerConfiguration.translateAddressProperty(this.serverProperties);
        }
        this.maxConnections = this.serverProperties.getIntegerProperty("server.maxconnections", 16);
        JavaSystem.setLogToSystem(this.isTrace());
        this.isSilent = this.serverProperties.isPropertyTrue("server.silent");
        this.isRemoteOpen = this.serverProperties.isPropertyTrue("server.remote_open");
    }

    public int start() {
        this.printWithThread("start() entered");
        int n = this.getState();
        if (this.serverThread != null) {
            this.printWithThread("start(): serverThread != null; no action taken");
            return n;
        }
        this.setState(4);
        this.serverThread = new ServerThread("HSQLDB Server ");
        this.serverThread.start();
        while (this.getState() == 4) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.printWithThread("start() exiting");
        return n;
    }

    public int stop() {
        this.printWithThread("stop() entered");
        int n = this.getState();
        if (this.serverThread == null) {
            this.printWithThread("stop() serverThread is null; no action taken");
            return n;
        }
        this.releaseServerSocket();
        this.printWithThread("stop() exiting");
        return n;
    }

    protected boolean allowConnection(Socket socket) {
        return true;
    }

    protected void init(int n) {
        this.serverState = 16;
        this.serverConnSet = new HashSet();
        this.serverId = this.toString();
        this.serverId = this.serverId.substring(this.serverId.lastIndexOf(46) + 1);
        this.serverProtocol = n;
        this.serverProperties = ServerConfiguration.newDefaultProperties(n);
        this.logWriter = new PrintWriter(System.out);
        this.errWriter = new PrintWriter(System.err);
        JavaSystem.setLogToSystem(this.isTrace());
    }

    protected synchronized void setState(int n) {
        this.serverState = n;
    }

    final void notify(int n, int n2) {
        this.printWithThread("notifiy(" + n + "," + n2 + ") entered");
        if (n != 0) {
            return;
        }
        this.releaseDatabase(n2);
        boolean bl = true;
        for (int i = 0; i < this.dbID.length; ++i) {
            if (this.dbAlias[i] == null) continue;
            bl = false;
        }
        if (!this.isRemoteOpen && bl) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void releaseDatabase(int n) {
        WrapperIterator wrapperIterator;
        boolean bl = false;
        this.printWithThread("releaseDatabase(" + n + ") entered");
        for (int i = 0; i < this.dbID.length; ++i) {
            if (this.dbID[i] != n || this.dbAlias[i] == null) continue;
            this.dbID[i] = 0;
            this.dbAlias[i] = null;
            this.dbPath[i] = null;
            this.dbType[i] = null;
            this.dbProps[i] = null;
        }
        Object object = this.serverConnSet;
        synchronized (object) {
            wrapperIterator = new WrapperIterator(this.serverConnSet.toArray(null));
        }
        while (wrapperIterator.hasNext()) {
            object = (ServerConnection)wrapperIterator.next();
            if (((ServerConnection)object).dbID != n) continue;
            ((ServerConnection)object).signalClose();
            this.serverConnSet.remove(object);
        }
        this.printWithThread("releaseDatabase(" + n + ") exiting");
    }

    protected synchronized void print(String string) {
        PrintWriter printWriter = this.logWriter;
        if (printWriter != null) {
            printWriter.println("[" + this.serverId + "]: " + string);
            printWriter.flush();
        }
    }

    final void printResource(String string) {
        if (serverBundleHandle < 0) {
            return;
        }
        String string2 = BundleHandler.getString(serverBundleHandle, string);
        if (string2 == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            this.print(stringTokenizer.nextToken());
        }
    }

    protected synchronized void printStackTrace(Throwable throwable) {
        if (this.errWriter != null) {
            throwable.printStackTrace(this.errWriter);
            this.errWriter.flush();
        }
    }

    final void printWithTimestamp(String string) {
        this.print(HsqlDateTime.getSytemTimeString() + " " + string);
    }

    protected void printWithThread(String string) {
        if (!this.isSilent()) {
            this.print("[" + Thread.currentThread() + "]: " + string);
        }
    }

    protected synchronized void printError(String string) {
        PrintWriter printWriter = this.errWriter;
        if (printWriter != null) {
            printWriter.print("[" + this.serverId + "]: ");
            printWriter.print("[" + Thread.currentThread() + "]: ");
            printWriter.println(string);
            printWriter.flush();
        }
    }

    final void printRequest(int n, Result result) {
        if (this.isSilent()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append(':');
        block0 : switch (result.mode) {
            case 65555: {
                stringBuffer.append("SQLCLI:SQLPREPARE ");
                stringBuffer.append(result.getMainString());
                break;
            }
            case 65547: {
                if (result.getSize() < 2) {
                    stringBuffer.append(result.getMainString());
                    break;
                }
                stringBuffer.append("SQLCLI:SQLEXECDIRECT:BATCHMODE\n");
                Iterator iterator = result.iterator();
                while (iterator.hasNext()) {
                    Object[] objectArray = (Object[])iterator.next();
                    stringBuffer.append(objectArray[0]).append('\n');
                }
                break;
            }
            case 65548: {
                stringBuffer.append("SQLCLI:SQLEXECUTE:");
                if (result.getSize() > 1) {
                    stringBuffer.append("BATCHMODE:");
                }
                stringBuffer.append(result.getStatementID());
                break;
            }
            case 65552: {
                stringBuffer.append("SQLCLI:SQLFREESTMT:");
                stringBuffer.append(result.getStatementID());
                break;
            }
            case 7: {
                stringBuffer.append("HSQLCLI:GETSESSIONATTR");
                break;
            }
            case 6: {
                stringBuffer.append("HSQLCLI:SETSESSIONATTR:");
                stringBuffer.append("AUTOCOMMIT ");
                stringBuffer.append(result.rRoot.data[4]);
                stringBuffer.append(" CONNECTION_READONLY ");
                stringBuffer.append(result.rRoot.data[6]);
                break;
            }
            case 66541: {
                stringBuffer.append("SQLCLI:SQLENDTRAN:");
                switch (result.getEndTranType()) {
                    case 0: {
                        stringBuffer.append("COMMIT");
                        break block0;
                    }
                    case 1: {
                        stringBuffer.append("ROLLBACK");
                        break block0;
                    }
                    case 4: {
                        stringBuffer.append("SAVEPOINT_NAME_RELEASE ");
                        stringBuffer.append(result.getMainString());
                        break block0;
                    }
                    case 2: {
                        stringBuffer.append("SAVEPOINT_NAME_ROLLBACK ");
                        stringBuffer.append(result.getMainString());
                        break block0;
                    }
                }
                stringBuffer.append(result.getEndTranType());
                break;
            }
            case 65610: {
                stringBuffer.append("SQLCLI:SQLSTARTTRAN");
                break;
            }
            case 65545: {
                stringBuffer.append("SQLCLI:SQLDISCONNECT");
                break;
            }
            case 66552: {
                stringBuffer.append("SQLCLI:SQLSETCONNECTATTR:");
                switch (result.getConnectionAttrType()) {
                    case 10027: {
                        stringBuffer.append("SQL_ATTR_SAVEPOINT_NAME ");
                        stringBuffer.append(result.getMainString());
                        break block0;
                    }
                }
                stringBuffer.append(result.getConnectionAttrType());
                break;
            }
            default: {
                stringBuffer.append("SQLCLI:MODE:");
                stringBuffer.append(result.mode);
            }
        }
        this.print(stringBuffer.toString());
    }

    final synchronized int getDBID(String string) throws HsqlException {
        int n;
        int n2 = string.indexOf(59);
        String string2 = string;
        String string3 = null;
        if (n2 != -1) {
            string2 = string.substring(0, n2);
            string3 = string.substring(n2 + 1);
        }
        if ((n = ArrayUtil.find(this.dbAlias, string2)) == -1) {
            if (string3 == null) {
                RuntimeException runtimeException = new RuntimeException("database alias does not exist");
                this.printError("database alias=" + string2 + " does not exist");
                this.setServerError(runtimeException);
                throw runtimeException;
            }
            return this.openDatabase(string2, string3);
        }
        return this.dbID[n];
    }

    final int openDatabase(String string, String string2) throws HsqlException {
        if (!this.isRemoteOpen) {
            RuntimeException runtimeException = new RuntimeException("remote open not allowed");
            this.printError("Remote database open not allowed");
            this.setServerError(runtimeException);
            throw runtimeException;
        }
        int n = this.getFirstEmptyDatabaseIndex();
        if (n < -1) {
            RuntimeException runtimeException = new RuntimeException("limit of open databases reached");
            this.printError("limit of open databases reached");
            this.setServerError(runtimeException);
            throw runtimeException;
        }
        HsqlProperties hsqlProperties = DatabaseURL.parseURL(string2, false);
        if (hsqlProperties == null) {
            RuntimeException runtimeException = new RuntimeException("invalid database path");
            this.printError("invalid database path");
            this.setServerError(runtimeException);
            throw runtimeException;
        }
        String string3 = hsqlProperties.getProperty("database");
        String string4 = hsqlProperties.getProperty("connection_type");
        try {
            int n2;
            this.dbID[n] = n2 = DatabaseManager.getDatabase(string4, string3, this, hsqlProperties);
            this.dbAlias[n] = string;
            this.dbPath[n] = string3;
            this.dbType[n] = string4;
            this.dbProps[n] = hsqlProperties;
            return n2;
        }
        catch (HsqlException hsqlException) {
            this.printError("Database [index=" + n + "db=" + this.dbType[n] + this.dbPath[n] + ", alias=" + this.dbAlias[n] + "] did not open: " + hsqlException.toString());
            this.setServerError(hsqlException);
            throw hsqlException;
        }
    }

    final int getFirstEmptyDatabaseIndex() {
        for (int i = 0; i < this.dbAlias.length; ++i) {
            if (this.dbAlias[i] != null) continue;
            return i;
        }
        return -1;
    }

    final boolean openDatabases() {
        this.printWithThread("openDatabases() entered");
        boolean bl = false;
        this.setDBInfoArrays();
        for (int i = 0; i < this.dbAlias.length; ++i) {
            int n;
            if (this.dbAlias[i] == null) continue;
            this.printWithThread("Opening database: [" + this.dbType[i] + this.dbPath[i] + "]");
            StopWatch stopWatch = new StopWatch();
            try {
                this.dbID[i] = n = DatabaseManager.getDatabase(this.dbType[i], this.dbPath[i], this, this.dbProps[i]);
                bl = true;
            }
            catch (HsqlException hsqlException) {
                this.printError("Database [index=" + i + "db=" + this.dbType[i] + this.dbPath[i] + ", alias=" + this.dbAlias[i] + "] did not open: " + hsqlException.toString());
                this.setServerError(hsqlException);
                this.dbAlias[i] = null;
                this.dbPath[i] = null;
                this.dbType[i] = null;
                this.dbProps[i] = null;
                continue;
            }
            stopWatch.stop();
            String string = "Database [index=" + i + ", id=" + n + ", " + "db=" + this.dbType[i] + this.dbPath[i] + ", alias=" + this.dbAlias[i] + "] opened sucessfully";
            this.print(stopWatch.elapsedTimeToMessage(string));
        }
        this.printWithThread("openDatabases() exiting");
        if (this.isRemoteOpen) {
            bl = true;
        }
        if (!bl && this.getServerError() == null) {
            this.setServerError(Trace.error(147));
        }
        return bl;
    }

    private void setDBInfoArrays() {
        this.dbAlias = this.getDBNameArray();
        this.dbPath = new String[this.dbAlias.length];
        this.dbType = new String[this.dbAlias.length];
        this.dbID = new int[this.dbAlias.length];
        this.dbProps = new HsqlProperties[this.dbAlias.length];
        for (int i = 0; i < this.dbAlias.length; ++i) {
            if (this.dbAlias[i] == null) continue;
            String string = this.getDatabasePath(i, true);
            if (string == null) {
                this.dbAlias[i] = null;
                continue;
            }
            HsqlProperties hsqlProperties = DatabaseURL.parseURL(string, false);
            if (hsqlProperties == null) {
                this.dbAlias[i] = null;
                continue;
            }
            this.dbPath[i] = hsqlProperties.getProperty("database");
            this.dbType[i] = hsqlProperties.getProperty("connection_type");
            this.dbProps[i] = hsqlProperties;
        }
    }

    private String[] getDBNameArray() {
        int n = "server.dbname.".length();
        String[] stringArray = new String[10];
        int n2 = 0;
        try {
            Enumeration enumeration = this.serverProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.startsWith("server.dbname.")) continue;
                try {
                    int n3 = Integer.parseInt(string.substring(n));
                    n2 = n3 < n2 ? n2 : n3;
                    stringArray[n3] = this.serverProperties.getProperty(string).toLowerCase();
                }
                catch (NumberFormatException numberFormatException) {
                    this.printWithThread("dblist: " + numberFormatException.toString());
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.printWithThread("dblist: " + arrayIndexOutOfBoundsException.toString());
        }
        return stringArray;
    }

    private void openServerSocket() throws Exception {
        this.printWithThread("openServerSocket() entered");
        if (this.isTls()) {
            this.printWithThread("Requesting TLS/SSL-encrypted JDBC");
        }
        StopWatch stopWatch = new StopWatch();
        this.socketFactory = HsqlSocketFactory.getInstance(this.isTls());
        String string = this.getAddress();
        int n = this.getPort();
        if (StringUtil.isEmpty(string) || "0.0.0.0".equalsIgnoreCase(string.trim())) {
            this.socket = this.socketFactory.createServerSocket(n);
        } else {
            try {
                this.socket = this.socketFactory.createServerSocket(n, string);
            }
            catch (UnknownHostException unknownHostException) {
                Object[] objectArray;
                int n2;
                String[] stringArray = ServerConfiguration.listLocalInetAddressNames();
                if (stringArray.length > 0) {
                    n2 = 148;
                    objectArray = new Object[]{string, stringArray};
                } else {
                    n2 = 149;
                    objectArray = new Object[]{string};
                }
                throw new UnknownHostException(Trace.getMessage(n2, true, objectArray));
            }
        }
        this.socket.setSoTimeout(1000);
        this.printWithThread("Got server socket: " + this.socket);
        this.print(stopWatch.elapsedTimeToMessage("Server socket opened successfully"));
        if (this.socketFactory.isSecure()) {
            this.print("Using TLS/SSL-encrypted JDBC");
        }
        this.printWithThread("openServerSocket() exiting");
    }

    private void printServerOnlineMessage() {
        String string = this.getProductName() + " " + this.getProductVersion() + " is online";
        this.printWithTimestamp(string);
        this.printResource("online.help");
    }

    protected void printProperties() {
        if (this.isSilent()) {
            return;
        }
        Enumeration enumeration = this.serverProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.serverProperties.getProperty(string);
            this.printWithThread(string + "=" + string2);
        }
    }

    private void releaseServerSocket() {
        this.printWithThread("releaseServerSocket() entered");
        if (this.socket != null) {
            this.printWithThread("Releasing server socket: [" + this.socket + "]");
            this.setState(8);
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                this.printError("Exception closing server socket");
                this.printError("releaseServerSocket(): " + iOException);
            }
            this.socket = null;
        }
        this.printWithThread("releaseServerSocket() exited");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        this.printWithThread("run() entered");
        this.print("Initiating startup sequence...");
        this.printProperties();
        StopWatch stopWatch = new StopWatch();
        this.setServerError(null);
        try {
            this.openServerSocket();
        }
        catch (Exception exception) {
            this.setServerError(exception);
            this.printError("run()/openServerSocket(): ");
            this.printStackTrace(exception);
            this.shutdown(true);
            return;
        }
        String string = "HSQLDB Connections @" + Integer.toString(this.hashCode(), 16);
        ThreadGroup threadGroup = new ThreadGroup(string);
        threadGroup.setDaemon(false);
        this.serverConnectionThreadGroup = threadGroup;
        if (!this.openDatabases()) {
            this.setServerError(null);
            this.printError("Shutting down because there are no open databases");
            this.shutdown(true);
            return;
        }
        this.setState(1);
        this.print(stopWatch.elapsedTimeToMessage("Startup sequence completed"));
        this.printServerOnlineMessage();
        try {
            while (true) {
                try {
                    while (true) {
                        this.handleConnection(this.socket.accept());
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            if (this.getState() == 1) {
                this.setServerError(iOException);
                this.printError(this + ".run()/handleConnection(): ");
                this.printStackTrace(iOException);
            }
            this.shutdown(false);
        }
        catch (Throwable throwable) {
            try {
                this.printWithThread(throwable.toString());
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                this.shutdown(false);
            }
        }
    }

    protected void setServerError(Throwable throwable) {
        this.serverError = throwable;
    }

    public void shutdown() {
        this.shutdown(false);
    }

    protected synchronized void shutdown(boolean bl) {
        int n;
        if (this.serverState == 16) {
            return;
        }
        this.printWithThread("shutdown() entered");
        StopWatch stopWatch = new StopWatch();
        this.print("Initiating shutdown sequence...");
        this.releaseServerSocket();
        DatabaseManager.deRegisterServer(this);
        if (this.dbPath != null) {
            for (n = 0; n < this.dbPath.length; ++n) {
                this.releaseDatabase(this.dbID[n]);
            }
        }
        if (this.serverConnectionThreadGroup != null) {
            if (!this.serverConnectionThreadGroup.isDestroyed()) {
                n = 0;
                while (this.serverConnectionThreadGroup.activeCount() > 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n;
                }
                try {
                    this.serverConnectionThreadGroup.destroy();
                    this.printWithThread(this.serverConnectionThreadGroup.getName() + " destroyed");
                }
                catch (Throwable throwable) {
                    this.printWithThread(this.serverConnectionThreadGroup.getName() + " not destroyed");
                    this.printWithThread(throwable.toString());
                }
            }
            this.serverConnectionThreadGroup = null;
        }
        this.serverThread = null;
        this.setState(16);
        this.print(stopWatch.elapsedTimeToMessage("Shutdown sequence completed"));
        if (this.isNoSystemExit()) {
            this.printWithTimestamp("SHUTDOWN : System.exit() was not called");
            this.printWithThread("shutdown() exited");
        } else {
            this.printWithTimestamp("SHUTDOWN : System.exit() is called next");
            this.printWithThread("shutdown() exiting...");
            try {
                System.exit(0);
            }
            catch (Throwable throwable) {
                this.printWithThread(throwable.toString());
            }
        }
    }

    protected static void printHelp(String string) {
        System.out.print(BundleHandler.getString(serverBundleHandle, string));
    }

    private class ServerThread
    extends Thread {
        ServerThread(String string) {
            super(string);
            this.setName(string + '@' + Integer.toString(Server.this.hashCode(), 16));
        }

        public void run() {
            Server.this.run();
            Server.this.printWithThread("ServerThread.run() exited");
        }
    }
}

