/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex.writer;

import com.googlecode.d2j.dex.writer.ClassWriter;
import com.googlecode.d2j.dex.writer.ev.EncodedArray;
import com.googlecode.d2j.dex.writer.io.ByteBufferOut;
import com.googlecode.d2j.dex.writer.io.DataOut;
import com.googlecode.d2j.dex.writer.item.AnnotationItem;
import com.googlecode.d2j.dex.writer.item.AnnotationSetItem;
import com.googlecode.d2j.dex.writer.item.AnnotationSetRefListItem;
import com.googlecode.d2j.dex.writer.item.AnnotationsDirectoryItem;
import com.googlecode.d2j.dex.writer.item.BaseItem;
import com.googlecode.d2j.dex.writer.item.CallSiteIdItem;
import com.googlecode.d2j.dex.writer.item.ClassDataItem;
import com.googlecode.d2j.dex.writer.item.ClassDefItem;
import com.googlecode.d2j.dex.writer.item.CodeItem;
import com.googlecode.d2j.dex.writer.item.ConstPool;
import com.googlecode.d2j.dex.writer.item.DebugInfoItem;
import com.googlecode.d2j.dex.writer.item.FieldIdItem;
import com.googlecode.d2j.dex.writer.item.HeadItem;
import com.googlecode.d2j.dex.writer.item.MapListItem;
import com.googlecode.d2j.dex.writer.item.MethodHandleItem;
import com.googlecode.d2j.dex.writer.item.MethodIdItem;
import com.googlecode.d2j.dex.writer.item.ProtoIdItem;
import com.googlecode.d2j.dex.writer.item.SectionItem;
import com.googlecode.d2j.dex.writer.item.StringDataItem;
import com.googlecode.d2j.dex.writer.item.StringIdItem;
import com.googlecode.d2j.dex.writer.item.TypeIdItem;
import com.googlecode.d2j.dex.writer.item.TypeListItem;
import com.googlecode.d2j.visitors.DexClassVisitor;
import com.googlecode.d2j.visitors.DexFileVisitor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.Adler32;

public class DexFileWriter
extends DexFileVisitor {
    private static final boolean DEBUG = false;
    MapListItem mapItem;
    HeadItem headItem;
    public ConstPool cp = new ConstPool();

    private static DataOut wrapDumpOut(final DataOut out0) {
        return (DataOut)Proxy.newProxyInstance(DexFileWriter.class.getClassLoader(), new Class[]{DataOut.class}, new InvocationHandler(){
            int indent = 0;

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getParameterTypes().length > 0 && method.getParameterTypes()[0].equals(String.class)) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < this.indent; ++i) {
                        sb.append("  ");
                    }
                    sb.append(String.format("%05d ", out0.offset()));
                    sb.append(method.getName() + " [");
                    for (Object arg : args) {
                        if (arg instanceof byte[]) {
                            byte[] data = (byte[])arg;
                            sb.append("0x[");
                            int start = 0;
                            int size = data.length;
                            if (args.length > 2) {
                                start = (Integer)args[2];
                                size = (Integer)args[3];
                            }
                            for (int i = 0; i < size; ++i) {
                                sb.append(String.format("%02x", data[start + i] & 0xFF));
                                if (i == size - 1) continue;
                                sb.append(", ");
                            }
                            sb.append("], ");
                            continue;
                        }
                        sb.append(arg).append(", ");
                    }
                    sb.append("]");
                    System.out.println(sb);
                }
                if (method.getName().equals("begin")) {
                    ++this.indent;
                }
                if (method.getName().equals("end")) {
                    --this.indent;
                }
                return method.invoke((Object)out0, args);
            }
        });
    }

    void buildMapListItem() {
        if (this.cp.classDefs.isEmpty()) {
            System.err.println("WARN: no classdef on the dex");
        }
        if (this.cp.methods.isEmpty()) {
            this.cp.uniqMethod("Ljava/lang/Object;", "<init>", new String[0], "V");
        }
        if (this.cp.fields.isEmpty()) {
            this.cp.uniqField("Ljava/lang/System;", "out", "Ljava/io/PrintStream;");
        }
        if (this.cp.protos.isEmpty()) {
            this.cp.uniqProto(new String[0], "V");
        }
        if (this.cp.types.isEmpty()) {
            this.cp.uniqType("V");
        }
        if (this.cp.strings.isEmpty()) {
            this.cp.uniqString("V");
        }
        this.mapItem = new MapListItem();
        this.headItem = new HeadItem();
        this.headItem.version = this.cp.dexVersion;
        SectionItem headSection = new SectionItem(SectionItem.SectionType.TYPE_HEADER_ITEM);
        headSection.items.add(this.headItem);
        SectionItem mapSection = new SectionItem(SectionItem.SectionType.TYPE_MAP_LIST);
        mapSection.items.add(this.mapItem);
        SectionItem<StringIdItem> stringIdSection = new SectionItem<StringIdItem>(SectionItem.SectionType.TYPE_STRING_ID_ITEM, this.cp.strings.values());
        SectionItem<TypeIdItem> typeIdSection = new SectionItem<TypeIdItem>(SectionItem.SectionType.TYPE_TYPE_ID_ITEM, this.cp.types.values());
        SectionItem<ProtoIdItem> protoIdSection = new SectionItem<ProtoIdItem>(SectionItem.SectionType.TYPE_PROTO_ID_ITEM, this.cp.protos.values());
        SectionItem<FieldIdItem> fieldIdSection = new SectionItem<FieldIdItem>(SectionItem.SectionType.TYPE_FIELD_ID_ITEM, this.cp.fields.values());
        SectionItem<MethodIdItem> methodIdSection = new SectionItem<MethodIdItem>(SectionItem.SectionType.TYPE_METHOD_ID_ITEM, this.cp.methods.values());
        SectionItem<MethodHandleItem> methodHandlerSection = new SectionItem<MethodHandleItem>(SectionItem.SectionType.TYPE_METHOD_HANDLE_ITEM, this.cp.methodHandlers.values());
        SectionItem<ClassDefItem> classDefSection = new SectionItem<ClassDefItem>(SectionItem.SectionType.TYPE_CLASS_DEF_ITEM, this.cp.buildSortedClassDefItems());
        SectionItem<TypeListItem> typeListSection = new SectionItem<TypeListItem>(SectionItem.SectionType.TYPE_TYPE_LIST, this.cp.typeLists.values());
        SectionItem<AnnotationSetRefListItem> annotationSetRefListItemSection = new SectionItem<AnnotationSetRefListItem>(SectionItem.SectionType.TYPE_ANNOTATION_SET_REF_LIST, this.cp.annotationSetRefListItems.values());
        SectionItem<AnnotationSetItem> annotationSetSection = new SectionItem<AnnotationSetItem>(SectionItem.SectionType.TYPE_ANNOTATION_SET_ITEM, this.cp.annotationSetItems.values());
        SectionItem<ClassDataItem> classDataItemSection = new SectionItem<ClassDataItem>(SectionItem.SectionType.TYPE_CLASS_DATA_ITEM, this.cp.classDataItems);
        SectionItem<CodeItem> codeItemSection = new SectionItem<CodeItem>(SectionItem.SectionType.TYPE_CODE_ITEM, this.cp.codeItems);
        SectionItem<StringDataItem> stringDataItemSection = new SectionItem<StringDataItem>(SectionItem.SectionType.TYPE_STRING_DATA_ITEM, this.cp.stringDatas);
        SectionItem<DebugInfoItem> debugInfoSection = new SectionItem<DebugInfoItem>(SectionItem.SectionType.TYPE_DEBUG_INFO_ITEM, this.cp.debugInfoItems);
        SectionItem<AnnotationItem> annotationItemSection = new SectionItem<AnnotationItem>(SectionItem.SectionType.TYPE_ANNOTATION_ITEM, this.cp.annotationItems.values());
        SectionItem<EncodedArray> encodedArrayItemSection = new SectionItem<EncodedArray>(SectionItem.SectionType.TYPE_ENCODED_ARRAY_ITEM, this.cp.encodedArrayItems.values());
        SectionItem<CallSiteIdItem> callSiteIdItemSectionItem = new SectionItem<CallSiteIdItem>(SectionItem.SectionType.TYPE_CALL_SITE_ID_ITEM, this.cp.callSiteIdItems.values());
        SectionItem<AnnotationsDirectoryItem> annotationsDirectoryItemSection = new SectionItem<AnnotationsDirectoryItem>(SectionItem.SectionType.TYPE_ANNOTATIONS_DIRECTORY_ITEM, this.cp.annotationsDirectoryItems);
        this.headItem.mapSection = mapSection;
        this.headItem.stringIdSection = stringIdSection;
        this.headItem.typeIdSection = typeIdSection;
        this.headItem.protoIdSection = protoIdSection;
        this.headItem.fieldIdSection = fieldIdSection;
        this.headItem.methodIdSection = methodIdSection;
        this.headItem.classDefSection = classDefSection;
        ArrayList dataSectionItems = new ArrayList();
        dataSectionItems.add(mapSection);
        dataSectionItems.add(typeListSection);
        dataSectionItems.add(annotationSetRefListItemSection);
        dataSectionItems.add(annotationSetSection);
        dataSectionItems.add(codeItemSection);
        dataSectionItems.add(classDataItemSection);
        dataSectionItems.add(stringDataItemSection);
        dataSectionItems.add(debugInfoSection);
        dataSectionItems.add(annotationItemSection);
        dataSectionItems.add(encodedArrayItemSection);
        dataSectionItems.add(annotationsDirectoryItemSection);
        List<SectionItem<?>> items = this.mapItem.items;
        items.add(headSection);
        items.add(stringIdSection);
        items.add(typeIdSection);
        items.add(protoIdSection);
        items.add(fieldIdSection);
        items.add(methodIdSection);
        items.add(classDefSection);
        if (callSiteIdItemSectionItem.items.size() > 0) {
            items.add(callSiteIdItemSectionItem);
        }
        if (methodHandlerSection.items.size() > 0) {
            items.add(methodHandlerSection);
        }
        items.addAll(dataSectionItems);
        this.cp.clean();
        this.cp = null;
    }

    public byte[] toByteArray() {
        this.buildMapListItem();
        int size = this.place();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        ByteBufferOut out = new ByteBufferOut(buffer);
        this.write(out);
        if (size != buffer.position()) {
            throw new RuntimeException("generated different file size, planned " + size + ", but is " + buffer.position());
        }
        DexFileWriter.updateChecksum(buffer, size);
        return buffer.array();
    }

    public static void updateChecksum(ByteBuffer buffer, int size) {
        MessageDigest digest;
        byte[] data = buffer.array();
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
        digest.update(data, 32, size - 32);
        byte[] sha1 = digest.digest();
        System.arraycopy(sha1, 0, data, 12, sha1.length);
        Adler32 adler32 = new Adler32();
        adler32.update(data, 12, size - 12);
        int v = (int)adler32.getValue();
        buffer.position(8);
        buffer.putInt(v);
    }

    private void write(DataOut out) {
        ArrayList list = new ArrayList(this.mapItem.items);
        this.mapItem = null;
        for (int i = 0; i < list.size(); ++i) {
            SectionItem section = (SectionItem)list.get(i);
            list.set(i, null);
            BaseItem.addPadding(out, out.offset(), section.sectionType.alignment);
            if (out.offset() != section.offset) {
                throw new RuntimeException((Object)((Object)section.sectionType) + " start with different position, planned:" + section.offset + ", but is:" + out.offset());
            }
            section.write(out);
        }
    }

    private int place() {
        int size;
        this.mapItem.cleanZeroSizeEntry();
        int offset = 0;
        for (SectionItem<?> section : this.mapItem.items) {
            section.offset = offset = BaseItem.padding(offset, section.sectionType.alignment);
            offset = section.place(offset);
        }
        this.headItem.fileSize = size = offset;
        this.headItem = null;
        return size;
    }

    public DexClassVisitor visit(int accessFlag, String name, String superClass, String[] itfClass) {
        ClassDefItem defItem = this.cp.putClassDefItem(accessFlag, name, superClass, itfClass);
        return new ClassWriter(defItem, this.cp);
    }
}

