/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.logging;

import javax.annotation.Nonnull;

public class JavaClassNameFormatter {
    private static final char PACKAGE_SEPARATOR = '.';

    public static String abbreviateJavaPackage(@Nonnull String qualifiedClassName, int maxLength) {
        if (qualifiedClassName.length() <= maxLength || qualifiedClassName.indexOf(46) == -1) {
            return qualifiedClassName;
        }
        int maxLengthWithoutEllipsis = maxLength - 3;
        int beginIdx = 0;
        int endIdx = qualifiedClassName.lastIndexOf(46);
        int iterations = 0;
        while (beginIdx + (qualifiedClassName.length() - endIdx) <= maxLengthWithoutEllipsis) {
            int tmp;
            if (iterations % 2 == 0) {
                tmp = qualifiedClassName.indexOf(46, beginIdx + 1);
                if (tmp == -1 || tmp + (qualifiedClassName.length() - endIdx) > maxLengthWithoutEllipsis) break;
                beginIdx = tmp;
            } else {
                tmp = qualifiedClassName.lastIndexOf(46, endIdx - 1);
                if (tmp == -1 || beginIdx + (qualifiedClassName.length() - tmp) > maxLengthWithoutEllipsis) break;
                endIdx = tmp;
            }
            ++iterations;
        }
        return qualifiedClassName.substring(0, beginIdx) + "..." + qualifiedClassName.substring(endIdx + 1);
    }
}

