/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.router.web.RouterConsoleRunner;
import net.i2p.util.FileSuffixFilter;
import org.apache.tomcat.SimpleInstanceManager;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebAppConfiguration
implements Configuration {
    private static final String CLASSPATH = ".classpath";

    private void configureClassPath(WebAppContext wac) throws Exception {
        String cp;
        String ctxPath = wac.getContextPath();
        if (ctxPath.equals("/")) {
            return;
        }
        String appName = ctxPath.substring(1);
        I2PAppContext i2pContext = I2PAppContext.getGlobalContext();
        File libDir = i2pContext.getLibDir();
        String pluginName = wac.getInitParameter("net.i2p.router.web.WebAppStarter.PLUGIN_NAME");
        if (pluginName == null) {
            pluginName = ctxPath;
        }
        File pluginDir = new File(i2pContext.getConfigDir(), "plugins");
        pluginDir = new File(pluginDir, pluginName);
        File dir = libDir;
        if (ctxPath.equals("/susidns")) {
            cp = "addressbook.jar";
            wac.setParentLoaderPriority(true);
        } else if (pluginDir.exists()) {
            File consoleDir = new File(pluginDir, "console");
            Properties props = RouterConsoleRunner.webAppProperties(consoleDir.getAbsolutePath());
            cp = props.getProperty("webapps." + appName + CLASSPATH);
            dir = pluginDir;
        } else {
            Properties props = RouterConsoleRunner.webAppProperties(i2pContext);
            cp = props.getProperty("webapps." + appName + CLASSPATH);
        }
        if (cp == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(cp, " ,");
        StringBuilder buf = new StringBuilder();
        Set<URI> systemCP = WebAppConfiguration.getSystemClassPath(i2pContext);
        while (tok.hasMoreTokens()) {
            String elem;
            if (buf.length() > 0) {
                buf.append(',');
            }
            String path = (elem = tok.nextToken().trim()).startsWith("$I2P") ? i2pContext.getBaseDir().getAbsolutePath() + elem.substring(4) : (elem.startsWith("$PLUGIN") ? dir.getAbsolutePath() + elem.substring(7) : dir.getAbsolutePath() + '/' + elem);
            File jfile = new File(path);
            File jdir = jfile.getParentFile();
            if ((systemCP.contains(jfile.toURI()) || jdir != null && systemCP.contains(jdir.toURI())) && !ctxPath.equals("/susimail")) continue;
            buf.append(path);
        }
        if (buf.length() <= 0) {
            return;
        }
        ClassLoader cl = wac.getClassLoader();
        if (cl != null && cl instanceof WebAppClassLoader) {
            WebAppClassLoader wacl = (WebAppClassLoader)cl;
            wacl.addClassPath(buf.toString());
        } else {
            wac.setExtraClasspath(buf.toString());
        }
    }

    private static Set<URI> getSystemClassPath(I2PAppContext ctx) {
        HashSet<URI> rv;
        block5: {
            block4: {
                rv = new HashSet<URI>(32);
                ClassLoader loader = ClassLoader.getSystemClassLoader();
                if (!(loader instanceof URLClassLoader)) break block4;
                URLClassLoader urlClassLoader = (URLClassLoader)loader;
                URL[] urls = urlClassLoader.getURLs();
                for (int i = 0; i < urls.length; ++i) {
                    try {
                        rv.add(urls[i].toURI());
                        continue;
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
                break block5;
            }
            File libDir = ctx.getLibDir();
            File[] files = libDir.listFiles(new FileSuffixFilter(".jar"));
            if (files == null) break block5;
            for (int i = 0; i < files.length; ++i) {
                String name = files[i].getName();
                if (name.equals("addressbook.jar")) continue;
                rv.add(files[i].toURI());
            }
        }
        return rv;
    }

    public void deconfigure(WebAppContext context) {
    }

    public void configure(WebAppContext context) throws Exception {
        this.configureClassPath(context);
        context.getServletContext().setAttribute("org.apache.tomcat.InstanceManager", (Object)new SimpleInstanceManager());
    }

    public void cloneConfigure(WebAppContext template, WebAppContext context) {
    }

    public void destroy(WebAppContext context) {
    }

    public void preConfigure(WebAppContext context) {
    }

    public void postConfigure(WebAppContext context) {
    }
}

