/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.jetty;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.Locale;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.eclipse.jetty.xml.XmlParser;
import org.xml.sax.SAXException;

public class JettyXmlConfigurationParser {
    private static XmlParser initParser() {
        XmlParser parser = new XmlParser();
        URL config60 = Loader.getResource(XmlConfiguration.class, (String)"org/eclipse/jetty/xml/configure_6_0.dtd");
        URL config76 = Loader.getResource(XmlConfiguration.class, (String)"org/eclipse/jetty/xml/configure_7_6.dtd");
        URL config90 = Loader.getResource(XmlConfiguration.class, (String)"org/eclipse/jetty/xml/configure_9_0.dtd");
        parser.redirectEntity("configure.dtd", config90);
        parser.redirectEntity("configure_1_0.dtd", config60);
        parser.redirectEntity("configure_1_1.dtd", config60);
        parser.redirectEntity("configure_1_2.dtd", config60);
        parser.redirectEntity("configure_1_3.dtd", config60);
        parser.redirectEntity("configure_6_0.dtd", config60);
        parser.redirectEntity("configure_7_6.dtd", config76);
        parser.redirectEntity("configure_9_0.dtd", config90);
        parser.redirectEntity("http://jetty.mortbay.org/configure.dtd", config90);
        parser.redirectEntity("http://jetty.eclipse.org/configure.dtd", config90);
        parser.redirectEntity("http://www.eclipse.org/jetty/configure.dtd", config90);
        parser.redirectEntity("-//Mort Bay Consulting//DTD Configure//EN", config90);
        parser.redirectEntity("-//Jetty//Configure//EN", config90);
        return parser;
    }

    public static XmlParser.Node parse(File f) throws SAXException, IOException {
        return JettyXmlConfigurationParser.initParser().parse(f);
    }

    public static String getValue(XmlParser.Node node, String name) {
        String nameLC = name.toLowerCase(Locale.US);
        for (Object o : node) {
            if (!(o instanceof XmlParser.Node)) continue;
            XmlParser.Node n = (XmlParser.Node)o;
            String tag = n.getTag();
            if (tag != null && "set".equals(tag.toLowerCase(Locale.US))) {
                String aname = n.getAttribute("name");
                if (aname == null || !aname.toLowerCase(Locale.US).equals(nameLC)) continue;
                return n.toString(false);
            }
            String rv = JettyXmlConfigurationParser.getValue(n, name);
            if (rv == null) continue;
            return rv;
        }
        return null;
    }

    public static boolean setValue(XmlParser.Node node, String name, String value) {
        String nameLC = name.toLowerCase(Locale.US);
        for (Object o : node) {
            if (!(o instanceof XmlParser.Node)) continue;
            XmlParser.Node n = (XmlParser.Node)o;
            String tag = n.getTag();
            if (tag != null && "set".equals(tag.toLowerCase(Locale.US))) {
                String aname = n.getAttribute("name");
                if (aname == null || !aname.toLowerCase(Locale.US).equals(nameLC)) continue;
                n.clear();
                n.add(0);
                n.clear();
                n.add(value);
                return true;
            }
            boolean rv = JettyXmlConfigurationParser.setValue(n, name, value);
            if (!rv) continue;
            return rv;
        }
        return false;
    }

    public static void write(XmlParser.Node node, Writer out) throws IOException {
        int size;
        out.write(60);
        String tag = node.getTag();
        out.write(tag);
        XmlParser.Attribute[] attrs = node.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                out.write(32);
                out.write(attrs[i].getName());
                out.write("=\"");
                out.write(attrs[i].getValue());
                out.write(34);
            }
        }
        if ((size = node.size()) > 0) {
            out.write(">");
            for (int i = 0; i < size; ++i) {
                Object o = node.get(i);
                if (o == null) continue;
                if (o instanceof XmlParser.Node) {
                    JettyXmlConfigurationParser.write((XmlParser.Node)o, out);
                    continue;
                }
                out.write(o.toString());
            }
            out.write("</");
            out.write(tag);
            out.write(">\n");
        } else {
            out.write("/>\n");
        }
    }

    public static String obfuscate(String s) {
        if (s.startsWith("OBF:")) {
            return s;
        }
        return Password.obfuscate((String)s);
    }

    public static String deobfuscate(String s) {
        if (!s.startsWith("OBF:")) {
            return s;
        }
        return Password.deobfuscate((String)s);
    }
}

