/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx;

import java.util.List;
import java.util.Stack;
import org.olap4j.OlapException;
import org.olap4j.mdx.AxisNode;
import org.olap4j.mdx.CallNode;
import org.olap4j.mdx.CubeNode;
import org.olap4j.mdx.DimensionNode;
import org.olap4j.mdx.HierarchyNode;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.LevelNode;
import org.olap4j.mdx.LiteralNode;
import org.olap4j.mdx.MdxUtil;
import org.olap4j.mdx.MemberNode;
import org.olap4j.mdx.ParameterNode;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeVisitor;
import org.olap4j.mdx.PropertyValueNode;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.WithMemberNode;
import org.olap4j.mdx.WithSetNode;
import org.olap4j.mdx.parser.MdxValidator;
import org.olap4j.type.Type;
import org.olap4j.type.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultMdxValidatorImpl
implements ParseTreeVisitor<ParseTreeNode>,
MdxValidator {
    private Stack<Boolean> scalarStack = new Stack();
    private final SelectNode selectNode;

    protected DefaultMdxValidatorImpl(SelectNode selectNode) {
        this.selectNode = selectNode;
    }

    @Override
    public SelectNode validateSelect(SelectNode selectNode) throws OlapException {
        return null;
    }

    @Override
    public ParseTreeNode visit(SelectNode selectNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParseTreeNode visit(AxisNode axis) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParseTreeNode visit(WithMemberNode withMemberNode) {
        ParseTreeNode expression = this.acceptScalar(withMemberNode.getExpression());
        withMemberNode.setExpression(expression);
        Type type = expression.getType();
        if (!TypeUtil.canEvaluate(type)) {
            throw new RuntimeException("'Member expression '" + MdxUtil.toString(expression) + "' must not be a set'");
        }
        for (PropertyValueNode prop : withMemberNode.getMemberPropertyList()) {
            prop.accept(this);
        }
        return withMemberNode;
    }

    @Override
    public ParseTreeNode visit(WithSetNode withSetNode) {
        ParseTreeNode expression = this.acceptScalar(withSetNode.getExpression());
        withSetNode.setExpression(expression);
        Type type = expression.getType();
        if (!TypeUtil.isSet(type)) {
            IdentifierNode id = withSetNode.getIdentifier();
            String idString = MdxUtil.toString(id);
            throw new RuntimeException("Set expression '" + idString + "' must be a set");
        }
        return withSetNode;
    }

    @Override
    public ParseTreeNode visit(CallNode call) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParseTreeNode visit(IdentifierNode id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParseTreeNode visit(ParameterNode parameterNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParseTreeNode visit(CubeNode cubeNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParseTreeNode visit(DimensionNode dimensionNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParseTreeNode visit(HierarchyNode hierarchyNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParseTreeNode visit(LevelNode levelExpr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParseTreeNode visit(MemberNode memberNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParseTreeNode visit(LiteralNode literalNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParseTreeNode visit(PropertyValueNode propertyValueNode) {
        throw new UnsupportedOperationException();
    }

    public void accept(AxisNode axis) {
        ParseTreeNode exp = axis.getExpression().accept(this);
        Type type = exp.getType();
        if (!TypeUtil.isSet(type)) {
            throw new RuntimeException("Axis '" + axis.getAxis().name() + "' expression is not a set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParseTreeNode acceptScalar(ParseTreeNode node) {
        this.scalarStack.push(Boolean.TRUE);
        try {
            ParseTreeNode parseTreeNode = node.accept(this);
            return parseTreeNode;
        }
        finally {
            this.scalarStack.pop();
        }
    }

    public ParseTreeNode accept(IdentifierNode identifier) {
        IdentifierNode.Segment s;
        if (identifier.getSegmentList().size() == 1 && (s = identifier.getSegmentList().get(0)).getQuoting() == IdentifierNode.Quoting.UNQUOTED && this.isReserved(s.getName())) {
            return LiteralNode.createSymbol(s.getRegion(), s.getName().toUpperCase());
        }
        ParseTreeNode element = this.lookup(this.selectNode, identifier.getSegmentList(), true);
        if (element == null) {
            return null;
        }
        return element.accept(this);
    }

    public ParseTreeNode accept(LiteralNode literalNode) {
        return literalNode;
    }

    public boolean isReserved(String name) {
        throw new UnsupportedOperationException();
    }

    private ParseTreeNode lookup(SelectNode select, List<IdentifierNode.Segment> segments, boolean allowProp) {
        throw new UnsupportedOperationException();
    }
}

