/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.jruby;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProcess;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.Exception;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.jruby.CoreExt;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.javasupport.Java;
import org.jruby.management.Caches;
import org.jruby.platform.Platform;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.BasicLibraryService;
import org.jruby.runtime.load.Library;
import org.jruby.util.ClasspathLauncher;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.URLUtil;

public class JRubyUtilLibrary
implements Library {
    @Override
    public void load(Ruby runtime2, boolean wrap2) {
        ThreadContext context = runtime2.getCurrentContext();
        RubyModule JRuby = Define.defineModule(context, "JRuby");
        ((RubyModule)((RubyModule)((RubyModule)JRuby.defineModuleUnder(context, "Util").defineMethods(context, JRubyUtilLibrary.class)).defineConstant(context, "SEPARATOR", Create.newString(context, "(?<!jar:file|jar|file|classpath|uri:classloader|uri|http|https):"))).defineConstant(context, "ON_WINDOWS", Convert.asBoolean(context, Platform.IS_WINDOWS))).defineConstant(context, "ON_SOLARIS", Convert.asBoolean(context, Platform.IS_SOLARIS));
    }

    @JRubyMethod(module=true)
    public static IRubyObject gc(ThreadContext context, IRubyObject recv2) {
        System.gc();
        return context.nil;
    }

    @JRubyMethod(name={"objectspace", "object_space?"}, alias={"objectspace?"}, module=true)
    public static IRubyObject getObjectSpaceEnabled(ThreadContext context, IRubyObject recv2) {
        return Convert.asBoolean(context, context.runtime.isObjectSpaceEnabled());
    }

    @Deprecated(since="9.4-")
    public static IRubyObject getObjectSpaceEnabled(IRubyObject recv2) {
        return JRubyUtilLibrary.getObjectSpaceEnabled(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject setObjectSpaceEnabled(IRubyObject recv2, IRubyObject arg2) {
        return JRubyUtilLibrary.setObjectSpaceEnabled(((RubyBasicObject)recv2).getCurrentContext(), recv2, arg2);
    }

    @JRubyMethod(name={"objectspace=", "object_space="}, module=true)
    public static IRubyObject setObjectSpaceEnabled(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        boolean enabled = arg2.isTrue();
        if (enabled) {
            Warn.warn(context, "ObjectSpace impacts performance. See https://github.com/jruby/jruby/wiki/PerformanceTuning#dont-enable-objectspace");
        }
        context.runtime.setObjectSpaceEnabled(enabled);
        return enabled ? context.tru : context.fals;
    }

    @JRubyMethod(meta=true, name={"native_posix?"})
    public static IRubyObject native_posix_p(ThreadContext context, IRubyObject self2) {
        return Convert.asBoolean(context, context.runtime.getPosix().isNative());
    }

    @Deprecated(since="9.2.1.0")
    public static IRubyObject getClassLoaderResources(IRubyObject recv2, IRubyObject name2) {
        return JRubyUtilLibrary.class_loader_resources(((RubyBasicObject)recv2).getCurrentContext(), recv2, name2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject load_java_class(ThreadContext context, IRubyObject recv2, IRubyObject name2) {
        Class klass = Java.getJavaClass(context, name2.convertToString().asJavaString());
        return Java.getInstance(context.runtime, klass);
    }

    @JRubyMethod(module=true, name={"class_loader_resources"}, alias={"classloader_resources"}, required=1, optional=1, checkArity=false)
    public static IRubyObject class_loader_resources(ThreadContext context, IRubyObject recv2, IRubyObject ... args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, 2);
        JRubyClassLoader loader = context.runtime.getJRubyClassLoader();
        String name2 = args2[0].convertToString().asJavaString();
        RubyArray<?> resources = Create.newArray(context);
        boolean raw = false;
        boolean path2 = false;
        if (argc > 1 && args2[1] instanceof RubyHash) {
            IRubyObject[] values2 = ArgsUtil.extractKeywordArgs(context, (RubyHash)args2[1], "raw", "path");
            raw = values2[0] != null && values2[0].isTrue();
            path2 = values2[1] != null && values2[1].isTrue();
        }
        try {
            Enumeration<URL> e = loader.getResources(name2);
            while (e.hasMoreElements()) {
                URL entry = e.nextElement();
                if (path2) {
                    resources.append(context, Create.newString(context, URLUtil.getPath(entry)));
                    continue;
                }
                if (raw) {
                    resources.append(context, Java.getInstance(context.runtime, entry));
                    continue;
                }
                resources.append(context, Create.newString(context, entry.toString()));
            }
        }
        catch (IOException ex) {
            throw context.runtime.newIOErrorFromException(ex);
        }
        return resources;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject classpath_launcher(ThreadContext context, IRubyObject recv2) {
        String launcher = Access.instanceConfig(context).getEnvironment().get("RUBY");
        if (launcher == null) {
            launcher = ClasspathLauncher.jrubyCommand(context.runtime);
        }
        return Create.newString(context, launcher);
    }

    @JRubyMethod(name={"extra_gem_paths"}, meta=true)
    public static IRubyObject extra_gem_paths(ThreadContext context, IRubyObject recv2) {
        List<String> extraGemPaths = Access.instanceConfig(context).getExtraGemPaths();
        IRubyObject[] extra_gem_paths2 = new IRubyObject[extraGemPaths.size()];
        int i2 = 0;
        for (String gemPath : extraGemPaths) {
            extra_gem_paths2[i2++] = Create.newString(context, gemPath);
        }
        return RubyArray.newArrayNoCopy(context.runtime, extra_gem_paths2);
    }

    @JRubyMethod(name={"current_directory"}, meta=true)
    public static IRubyObject current_directory(ThreadContext context, IRubyObject recv2) {
        return Create.newString(context, context.runtime.getCurrentDirectory());
    }

    @JRubyMethod(name={"set_last_exit_status"}, meta=true)
    public static IRubyObject set_last_exit_status(ThreadContext context, IRubyObject recv2, IRubyObject status2, IRubyObject pid2) {
        RubyProcess.RubyStatus processStatus = RubyProcess.RubyStatus.newProcessStatus(context.runtime, Convert.toLong(context, status2), Convert.toLong(context, pid2));
        context.setLastExitStatus(processStatus);
        return processStatus;
    }

    @JRubyMethod(meta=true, name={"set_meta_class"})
    public static IRubyObject set_meta_class(ThreadContext context, IRubyObject recv2, IRubyObject obj, IRubyObject klass) {
        if (!(klass instanceof RubyClass)) {
            klass = klass.getMetaClass();
        }
        ((RubyObject)obj).setMetaClass((RubyClass)klass);
        return context.nil;
    }

    @JRubyMethod(module=true, name={"load_ext"})
    public static IRubyObject load_ext(ThreadContext context, IRubyObject recv2, IRubyObject klass) {
        if (klass instanceof RubySymbol) {
            switch (klass.asJavaString()) {
                case "string": {
                    CoreExt.loadStringExtensions(context);
                    break;
                }
                default: {
                    throw Error.argumentError(context, ":" + klass.asJavaString());
                }
            }
            return context.tru;
        }
        return JRubyUtilLibrary.loadExtension(context, klass.convertToString().toString()) ? context.tru : context.fals;
    }

    private static boolean loadExtension(ThreadContext context, String className) {
        Ruby runtime2 = context.runtime;
        Class clazz = Java.getJavaClass(context, className);
        if (BasicLibraryService.class.isAssignableFrom(clazz)) {
            try {
                return ((BasicLibraryService)clazz.getConstructor(new Class[0]).newInstance(new Object[0])).basicLoad(runtime2);
            }
            catch (Exception e) {
                throw e;
            }
            catch (ReflectiveOperationException e) {
                RaiseException ex = runtime2.newNameError("cannot instantiate (ext) Java class " + className, className, (Throwable)e, true);
                ex.initCause(e);
                throw ex;
            }
            catch (java.lang.Exception e) {
                RaiseException ex = runtime2.newNameError("cannot load (ext) (" + className + ")", (String)null, (Throwable)e, true);
                ex.initCause(e);
                throw ex;
            }
        }
        if (Library.class.isAssignableFrom(clazz)) {
            try {
                ((Library)clazz.getConstructor(new Class[0]).newInstance(new Object[0])).load(runtime2, false);
                return true;
            }
            catch (Exception e) {
                throw e;
            }
            catch (ReflectiveOperationException e) {
                RaiseException ex = runtime2.newNameError("cannot instantiate (ext) Java class " + className, className, (Throwable)e, true);
                ex.initCause(e);
                throw ex;
            }
            catch (java.lang.Exception e) {
                RaiseException ex = runtime2.newNameError("cannot load (ext) (" + className + ")", (String)null, (Throwable)e, true);
                ex.initCause(e);
                throw ex;
            }
        }
        try {
            Object result2 = clazz.getMethod("load", Ruby.class).invoke(null, runtime2);
            return !(result2 instanceof Boolean) || (Boolean)result2 != false;
        }
        catch (Exception e) {
            throw e;
        }
        catch (java.lang.Exception e) {
            RaiseException ex = runtime2.newNameError("cannot load (ext) (" + className + ")", (String)null, (Throwable)e, true);
            ex.initCause(e);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"synchronized"}, module=true)
    public static IRubyObject rbSynchronized(ThreadContext context, IRubyObject recv2, IRubyObject arg2, Block block) {
        Object object = JRubyUtilLibrary.getSyncObject(arg2);
        synchronized (object) {
            return block.call(context);
        }
    }

    @JRubyMethod(module=true)
    public static IRubyObject wait(ThreadContext context, IRubyObject recv2, IRubyObject arg2) throws InterruptedException {
        Object obj = JRubyUtilLibrary.getSyncObject(arg2);
        obj.wait();
        return arg2;
    }

    @JRubyMethod(module=true)
    public static IRubyObject wait(ThreadContext context, IRubyObject recv2, IRubyObject arg2, IRubyObject timeoutMillis) throws InterruptedException {
        Object obj = JRubyUtilLibrary.getSyncObject(arg2);
        obj.wait(Convert.toLong(context, timeoutMillis));
        return arg2;
    }

    @JRubyMethod(module=true)
    public static IRubyObject wait(ThreadContext context, IRubyObject recv2, IRubyObject arg2, IRubyObject timeoutMillis, IRubyObject timeoutNanos) throws InterruptedException {
        JRubyUtilLibrary.getSyncObject(arg2).wait(Convert.toLong(context, timeoutMillis), Convert.toInt(context, timeoutNanos));
        return arg2;
    }

    @JRubyMethod(module=true)
    public static IRubyObject notify(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Object obj = JRubyUtilLibrary.getSyncObject(arg2);
        obj.notify();
        return arg2;
    }

    @JRubyMethod(name={"notify_all"}, module=true)
    public static IRubyObject notifyAll(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Object obj = JRubyUtilLibrary.getSyncObject(arg2);
        obj.notifyAll();
        return arg2;
    }

    private static Object getSyncObject(IRubyObject arg2) {
        Object obj = arg2;
        if (arg2 instanceof ConcreteJavaProxy) {
            obj = ((ConcreteJavaProxy)arg2).getObject();
        }
        return obj;
    }

    @JRubyMethod(name={"cache_stats"}, module=true)
    public static IRubyObject cache_stats(ThreadContext context, IRubyObject self2) {
        Caches caches = context.runtime.getCaches();
        RubyHash stat2 = Create.newHash(context);
        stat2.op_aset(context, Convert.asSymbol(context, "method_invalidation_count"), Convert.asFixnum(context, caches.getMethodInvalidationCount()));
        stat2.op_aset(context, Convert.asSymbol(context, "constant_invalidation_count"), Convert.asFixnum(context, caches.getConstantInvalidationCount()));
        return stat2;
    }

    @JRubyMethod(module=true)
    @Deprecated(since="9.4-")
    public static RubyArray internal_libraries(ThreadContext context, IRubyObject self2) {
        Warn.warnDeprecated(context, "JRuby::Util.internal_libraries is deprecated");
        return Create.newEmptyArray(context);
    }

    @JRubyMethod(module=true)
    public static IRubyObject safe_recurse(ThreadContext context, IRubyObject utilModule, IRubyObject state2, IRubyObject obj, IRubyObject name2, Block block) {
        return context.safeRecurse(block, state2, obj, name2.convertToString().toString(), false);
    }

    @Deprecated(since="9.2.0.0")
    public static class StringUtils {
        public static IRubyObject unseeded_hash(ThreadContext context, IRubyObject recv2) {
            return CoreExt.String.unseeded_hash(context, recv2);
        }
    }
}

