/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.ir.IRClosure;
import org.jruby.ir.dataflow.analyses.LiveVariablesProblem;
import org.jruby.ir.instructions.ClosureAcceptingInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.interpreter.FullInterpreterContext;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.passes.CompilerPass;
import org.jruby.ir.passes.OptimizeDynScopesPass;
import org.jruby.ir.representations.BasicBlock;

public class LiveVariableAnalysis
extends CompilerPass {
    private static final List<Class<? extends CompilerPass>> DEPENDENCIES = Collections.singletonList(OptimizeDynScopesPass.class);

    @Override
    public List<Class<? extends CompilerPass>> getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public String getLabel() {
        return "Live Variable Analysis";
    }

    @Override
    public Object previouslyRun(FullInterpreterContext fic) {
        return fic.getDataFlowProblems().get("Live Variables Analysis");
    }

    private void collectNonLocalDirtyVars(FullInterpreterContext fic, Set<LocalVariable> vars, int minDepth) {
        for (BasicBlock bb : fic.getCFG().getBasicBlocks()) {
            for (Instr i2 : bb.getInstrs()) {
                Operand clArg;
                Variable res;
                if (i2 instanceof ResultInstr && (res = ((ResultInstr)((Object)i2)).getResult()) instanceof LocalVariable && ((LocalVariable)res).getScopeDepth() > minDepth) {
                    vars.add((LocalVariable)res);
                }
                if (!(i2 instanceof ClosureAcceptingInstr) || !((clArg = ((ClosureAcceptingInstr)((Object)i2)).getClosureArg()) instanceof WrappedIRClosure)) continue;
                this.collectNonLocalDirtyVars(((WrappedIRClosure)clArg).getClosure().getFullInterpreterContext(), vars, minDepth + 1);
            }
        }
    }

    @Override
    public Object execute(FullInterpreterContext fic, Object ... data2) {
        LiveVariablesProblem lvp = new LiveVariablesProblem(fic);
        if (fic.getScope() instanceof IRClosure) {
            HashSet<LocalVariable> nlVars = new HashSet<LocalVariable>();
            this.collectNonLocalDirtyVars(fic, nlVars, fic.isDynamicScopeEliminated() ? -1 : 0);
            for (Variable variable : nlVars) {
                lvp.addDFVar(variable);
            }
            lvp.setVarsLiveOnScopeExit(nlVars);
        }
        lvp.compute_MOP_Solution();
        fic.getDataFlowProblems().put("Live Variables Analysis", lvp);
        return lvp;
    }

    @Override
    public boolean invalidate(FullInterpreterContext fic) {
        super.invalidate(fic);
        fic.getDataFlowProblems().put("Live Variables Analysis", null);
        return true;
    }
}

