/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.handler.BaseConditionModuleHandler;
import org.openhab.core.automation.handler.TimeBasedConditionHandler;
import org.openhab.core.config.core.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class TimeOfDayConditionHandler
extends BaseConditionModuleHandler
implements TimeBasedConditionHandler {
    public static final String MODULE_TYPE_ID = "core.TimeOfDayCondition";
    public static final String CFG_START_TIME = "startTime";
    public static final String CFG_END_TIME = "endTime";
    private final Logger logger = LoggerFactory.getLogger(TimeOfDayConditionHandler.class);
    private final @Nullable LocalTime startTime;
    private final @Nullable LocalTime endTime;

    public TimeOfDayConditionHandler(Condition condition) {
        super(condition);
        Configuration configuration = ((Condition)this.module).getConfiguration();
        String startTimeConfig = (String)configuration.get(CFG_START_TIME);
        String endTimeConfig = (String)configuration.get(CFG_END_TIME);
        this.startTime = startTimeConfig == null ? null : LocalTime.parse(startTimeConfig).truncatedTo(ChronoUnit.MINUTES);
        this.endTime = endTimeConfig == null ? null : LocalTime.parse(endTimeConfig).truncatedTo(ChronoUnit.MINUTES);
    }

    @Override
    public boolean isSatisfied(Map<String, Object> inputs) {
        return this.isSatisfiedAt(ZonedDateTime.now());
    }

    @Override
    public boolean isSatisfiedAt(ZonedDateTime time) {
        LocalTime startTime = this.startTime;
        LocalTime endTime = this.endTime;
        if (startTime == null || endTime == null) {
            this.logger.warn("Time condition with id {} is not well configured: startTime={}  endTime = {}", new Object[]{((Condition)this.module).getId(), startTime, endTime});
            return false;
        }
        LocalTime currentTime = time.toLocalTime().truncatedTo(ChronoUnit.MINUTES);
        if (currentTime.equals(startTime)) {
            this.logger.debug("Time condition with id {} evaluated, that the current time {} equals the start time: {}", new Object[]{((Condition)this.module).getId(), currentTime, startTime});
            return true;
        }
        if (startTime.isBefore(endTime)) {
            if (currentTime.isAfter(startTime) && currentTime.isBefore(endTime)) {
                this.logger.debug("Time condition with id {} evaluated, that {} is between {} and {}.", new Object[]{((Condition)this.module).getId(), currentTime, startTime, endTime});
                return true;
            }
        } else if (currentTime.isAfter(LocalTime.MIDNIGHT) && currentTime.isBefore(endTime) || currentTime.isAfter(startTime) && currentTime.isBefore(LocalTime.MAX)) {
            this.logger.debug("Time condition with id {} evaluated, that {} is between {} and {}, or between {} and {}.", new Object[]{((Condition)this.module).getId(), currentTime, LocalTime.MIDNIGHT, endTime, startTime, LocalTime.MAX.truncatedTo(ChronoUnit.MINUTES)});
            return true;
        }
        return false;
    }
}

