/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * refract(vec3(-0.02366537, -0.6705188, -0.741515), vec3(-0.02366537, -0.6705188, -0.741515), 0.5) => vec3(0.02366537, 0.6705188, 0.741515)
 * refract(vec3(-0.02366537, -0.6705188, -0.741515), vec3(-0.02366537, -0.6705188, -0.741515), 2.0) => vec3(0.02366537, 0.6705188, 0.741515)
 * refract(vec3(-0.02366537, -0.6705188, -0.741515), vec3(0.64414936, 0.254574, 0.72129303), 0.5) => vec3(-0.38391045, -0.48230812, -0.7873955)
 * refract(vec3(-0.02366537, -0.6705188, -0.741515), vec3(0.64414936, 0.254574, 0.72129303), 2.0) => vec3(-0.0, -0.0, -0.0)
 * refract(vec3(0.64414936, 0.254574, 0.72129303), vec3(-0.02366537, -0.6705188, -0.741515), 0.5) => vec3(0.33574444, 0.51459646, 0.7889652)
 * refract(vec3(0.64414936, 0.254574, 0.72129303), vec3(-0.02366537, -0.6705188, -0.741515), 2.0) => vec3(0.0, 0.0, 0.0)
 * refract(vec3(0.64414936, 0.254574, 0.72129303), vec3(0.64414936, 0.254574, 0.72129303), 0.5) => vec3(-0.64414936, -0.254574, -0.72129303)
 * refract(vec3(0.64414936, 0.254574, 0.72129303), vec3(0.64414936, 0.254574, 0.72129303), 2.0) => vec3(-0.64414924, -0.25457394, -0.72129285)
 */
#version 150

void main()
{
  float[distance(refract(vec3(-0.02366537, -0.6705188, -0.741515), vec3(-0.02366537, -0.6705188, -0.741515), 0.5), vec3(0.02366537, 0.6705188, 0.741515)) <= 1e-05 ? 1 : -1] array0;
  float[distance(refract(vec3(-0.02366537, -0.6705188, -0.741515), vec3(-0.02366537, -0.6705188, -0.741515), 2.0), vec3(0.02366537, 0.6705188, 0.741515)) <= 1e-05 ? 1 : -1] array1;
  float[distance(refract(vec3(-0.02366537, -0.6705188, -0.741515), vec3(0.64414936, 0.254574, 0.72129303), 0.5), vec3(-0.38391045, -0.48230812, -0.7873955)) <= 1e-05 ? 1 : -1] array2;
  float[distance(refract(vec3(-0.02366537, -0.6705188, -0.741515), vec3(0.64414936, 0.254574, 0.72129303), 2.0), vec3(-0.0, -0.0, -0.0)) <= 0.0 ? 1 : -1] array3;
  float[distance(refract(vec3(0.64414936, 0.254574, 0.72129303), vec3(-0.02366537, -0.6705188, -0.741515), 0.5), vec3(0.33574444, 0.51459646, 0.7889652)) <= 1e-05 ? 1 : -1] array4;
  float[distance(refract(vec3(0.64414936, 0.254574, 0.72129303), vec3(-0.02366537, -0.6705188, -0.741515), 2.0), vec3(0.0, 0.0, 0.0)) <= 0.0 ? 1 : -1] array5;
  float[distance(refract(vec3(0.64414936, 0.254574, 0.72129303), vec3(0.64414936, 0.254574, 0.72129303), 0.5), vec3(-0.64414936, -0.254574, -0.72129303)) <= 1e-05 ? 1 : -1] array6;
  float[distance(refract(vec3(0.64414936, 0.254574, 0.72129303), vec3(0.64414936, 0.254574, 0.72129303), 2.0), vec3(-0.64414924, -0.25457394, -0.72129285)) <= 9.999998e-06 ? 1 : -1] array7;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
