/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.frames;

import com.projectlibre1.company.DefaultUser;
import com.projectlibre1.configuration.Configuration;
import com.projectlibre1.configuration.ConfigurationReader;
import com.projectlibre1.configuration.Dictionary;
import com.projectlibre1.contrib.ClassLoaderUtils;
import com.projectlibre1.dialog.LicenseDialog;
import com.projectlibre1.dialog.LoginDialog;
import com.projectlibre1.dialog.LoginForm;
import com.projectlibre1.dialog.TipOfTheDay;
import com.projectlibre1.dialog.UserInfoDialog;
import com.projectlibre1.init.Init;
import com.projectlibre1.pm.graphic.frames.DocumentFrame;
import com.projectlibre1.pm.graphic.frames.GraphicManager;
import com.projectlibre1.pm.graphic.laf.LafManagerImpl;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.pm.task.ProjectFactory;
import com.projectlibre1.server.access.PartnerInfo;
import com.projectlibre1.server.data.ProjectData;
import com.projectlibre1.session.SessionFactory;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.util.Alert;
import com.projectlibre1.util.DebugUtils;
import com.projectlibre1.util.Environment;
import com.projectlibre1.util.VersionUtils;
import java.awt.Container;
import java.awt.HeadlessException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.apache.commons.collections.Closure;
import org.projectlibre1.util.UpdateChecker;

public abstract class StartupFactory {
    public static final String defaultServerUrl = "http://www.projectlibre.com";
    private static final int NUM_INVALID_LOGINS = 3;
    protected String serverUrl = null;
    protected String[] projectUrls = null;
    protected String login = null;
    protected String password = null;
    protected Map credentials = new HashMap();
    protected long projectId;
    protected HashMap opts = null;

    protected StartupFactory() {
    }

    public GraphicManager restart(GraphicManager graphicManager) {
        RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)graphicManager.getContainer());
        graphicManager.encodeWorkspace();
        graphicManager.cleanUp();
        rootPaneContainer.getContentPane().removeAll();
        GraphicManager graphicManager2 = this.instanceFromExistingSession((Container)((Object)rootPaneContainer));
        return graphicManager2;
    }

    public GraphicManager instanceFromExistingSession(Container container) {
        System.gc();
        DebugUtils.isMemoryOk(true);
        long l = System.currentTimeMillis();
        final GraphicManager graphicManager = new GraphicManager(container);
        graphicManager.setStartupFactory(this);
        SessionFactory.getInstance().setJobQueue(graphicManager.getJobQueue());
        graphicManager.initLookAndFeel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                long l = System.currentTimeMillis();
                graphicManager.initView();
            }
        });
        return graphicManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphicManager instanceFromNewSession(Container container, boolean bl) {
        Object object;
        VersionUtils.versionCheck(true);
        if (!VersionUtils.isJnlpUpToDate()) {
            System.out.println("Jnlp isn't up to date, current version is: " + VersionUtils.getJnlpVersion());
        }
        long l = System.currentTimeMillis();
        Environment.setClientSide(true);
        System.setSecurityManager(null);
        Thread thread = new Thread("loadConfig"){

            @Override
            public void run() {
                long l = System.currentTimeMillis();
                StartupFactory.this.doLoadConfig();
            }
        };
        thread.start();
        GraphicManager graphicManager = null;
        try {
            graphicManager = new GraphicManager(this.serverUrl, container);
            graphicManager.setStartupFactory(this);
        }
        catch (HeadlessException headlessException) {
            headlessException.printStackTrace();
        }
        graphicManager.setConnected(false);
        if (!this.doLogin(graphicManager)) {
            return null;
        }
        graphicManager.initLookAndFeel();
        SessionFactory.getInstance().setJobQueue(graphicManager.getJobQueue());
        PartnerInfo partnerInfo = null;
        if (!Environment.getStandAlone()) {
            object = SessionFactory.getInstance().getSession(false);
            try {
                partnerInfo = (PartnerInfo)SessionFactory.call(object, "retrievePartnerInfo", null, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        l = System.currentTimeMillis();
        if (partnerInfo != null) {
            if (partnerInfo.getConfigurationXML() != null) {
                ConfigurationReader.readString(partnerInfo.getConfigurationXML(), Configuration.getInstance());
                Configuration.getInstance().setDonePopulating();
            }
            if (partnerInfo.getViewXML() != null) {
                ConfigurationReader.readString(partnerInfo.getViewXML(), Dictionary.getInstance());
            }
        }
        object = graphicManager;
        graphicManager.beginInitialization();
        try {
            String[] stringArray;
            graphicManager.initView();
            if (this.projectUrls == null && ((GraphicManager)object).getLastFileName() != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = ((GraphicManager)object).getLastFileName();
            } else {
                stringArray = this.projectUrls;
            }
            this.doStartupAction((GraphicManager)object, this.projectId, stringArray, bl, false);
            this.doPostInitView(((GraphicManager)object).getContainer());
        }
        finally {
            graphicManager.finishInitialization();
        }
        return graphicManager;
    }

    public void doLoadConfig() {
        Init.initialize();
    }

    public void doPostInitView(Container container) {
    }

    public boolean doLogin(GraphicManager graphicManager) {
        if (Environment.getStandAlone()) {
            Environment.setUser(new DefaultUser());
            return true;
        }
        this.credentials.put("serverUrl", this.serverUrl);
        this.getCredentials();
        Environment.setNewLook(true);
        int n = 0;
        while (true) {
            Object object;
            Object object2;
            if (this.login == null || this.password == null || n > 0) {
                object2 = null;
                if (this.login == null || this.password == null) {
                    try {
                        object2 = new URL(this.serverUrl + "/login");
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (((LoginForm)(object = LoginDialog.doLogin(graphicManager.getFrame(), object2))).isCancelled()) {
                    System.exit(-1);
                }
                if (((LoginForm)object).isUseMenus()) {
                    Environment.setNewLook(false);
                }
                this.login = ((LoginForm)object).getLogin();
                this.password = ((LoginForm)object).getPassword();
            }
            if ("_SA".equals(this.login) || Environment.getStandAlone()) {
                Environment.setStandAlone(true);
                Environment.setUser(new DefaultUser());
                break;
            }
            this.credentials.put("login", this.login);
            this.credentials.put("password", this.password);
            SessionFactory.getInstance().setCredentials(this.credentials);
            try {
                object2 = SessionFactory.getInstance().getSession(false);
                System.out.println("logging in");
                object = graphicManager;
                SessionFactory.callNoEx(object2, "login", new Class[]{Closure.class}, new Object[]{new Closure(){
                    final /* synthetic */ GraphicManager val$gm;
                    final /* synthetic */ StartupFactory this$0;
                    {
                        this.val$gm = graphicManager;
                        this.this$0 = startupFactory;
                    }

                    @Override
                    public void execute(Object object) {
                        Map map = (Map)object;
                        if (map != null) {
                            String string = (String)map.get("serverVersion");
                            this.this$0.checkServerVersion(string);
                        }
                        this.val$gm.setConnected(true);
                    }
                }});
                if (!((Boolean)SessionFactory.callNoEx(object2, "isLicensedToRunClient", null, null)).booleanValue()) {
                    Alert.error(Messages.getString("Error.roleCantRunClient"));
                    this.abort();
                    return false;
                }
            }
            catch (Exception exception) {
                if ("EXPIRED".equals(exception.getMessage())) {
                    Alert.error(Messages.getString("Error.accountExpired"));
                    this.abort();
                    return false;
                }
                System.out.println("failure " + String.valueOf(exception));
                SessionFactory.getInstance().clearSessions();
                if (++n == 3) {
                    Alert.error(Messages.getString("Login.tooManyBad"));
                    this.abort();
                    return false;
                }
                Alert.error(Messages.getString("Login.error"));
                continue;
            }
            break;
        }
        return true;
    }

    protected void checkServerVersion(String string) {
        String string2 = null;
        if (string != null) {
            string2 = VersionUtils.getVersion();
            if (string2 != null) {
                string2 = VersionUtils.toAppletVersion(string2);
            }
            if (string2 == null || string.equals(string2)) {
                return;
            }
        }
        String string3 = "";
        if (Alert.okCancel(Messages.getString("Text.newPODVersion"))) {
            try {
                Object object = ClassLoaderUtils.forName("javax.jnlp.ServiceManager").getMethod("lookup", String.class).invoke(null, "javax.jnlp.BasicService");
                ClassLoaderUtils.forName("javax.jnlp.BasicService").getMethod("showDocument", URL.class).invoke(object, new URL(string3));
            }
            catch (Exception exception) {
                return;
            }
            System.exit(0);
        }
    }

    public static Boolean verifyOpenWritable(Long l) {
        if (l == null || l == 0L) {
            return null;
        }
        if (ProjectFactory.getInstance().isResourcePoolOpenAndWritable()) {
            Alert.warn(Messages.getString("Warn.resourcePoolOpen"));
            return null;
        }
        String string = StartupFactory.getLockerName(l);
        boolean bl = false;
        if (string != null) {
            boolean bl2 = bl = 0 == Alert.confirmYesNo(Messages.getStringWithParam("Warn.lockMessage", string));
            if (!bl) {
                return null;
            }
        }
        return !bl;
    }

    public static String getLockerName(long l) {
        ProjectData projectData = (ProjectData)ProjectFactory.getProjectData(l);
        System.out.println("Locked is " + projectData.isLocked() + "  Lock info: User is " + Environment.getUser().getUniqueId() + "  locker id is " + projectData.getLockedById() + " locker is " + projectData.getLockedByName());
        if (projectData != null && projectData.isLocked() && Environment.getUser().getUniqueId() != projectData.getLockedById()) {
            return projectData.getLockedByName();
        }
        return null;
    }

    protected abstract void abort();

    protected void getCredentials() {
    }

    public void doStartupAction(final GraphicManager graphicManager, final long l, String[] stringArray, final boolean bl, boolean bl2) {
        if (Environment.isClientSide()) {
            if (l > 0L) {
                Boolean bl3 = null;
                bl3 = bl2 ? Boolean.FALSE : StartupFactory.verifyOpenWritable(l);
                if (bl3 == null) {
                    return;
                }
                graphicManager.loadDocument(l, true, bl3 == false, new Closure(){

                    @Override
                    public void execute(Object object) {
                        Project project = (Project)object;
                        DocumentFrame documentFrame = graphicManager.getCurrentFrame();
                        if (documentFrame != null && documentFrame.getProject().getUniqueId() != l) {
                            graphicManager.switchToProject(l);
                        }
                    }
                });
            } else if (stringArray != null && stringArray.length > 0) {
                graphicManager.loadLocalDocument(stringArray[0], !Environment.getStandAlone());
            } else {
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ StartupFactory this$0;
                    {
                        this.this$0 = startupFactory;
                    }

                    @Override
                    public void run() {
                        if (Environment.isProjectLibre() && !Environment.isPlugin()) {
                            LicenseDialog.showDialog(graphicManager.getFrame(), false);
                            UserInfoDialog.showDialog(graphicManager.getFrame(), false);
                            UpdateChecker.checkForUpdateInBackground();
                        }
                        if (bl && !Environment.isPlugin()) {
                            if (Environment.isProjectLibre()) {
                                TipOfTheDay.showDialog(graphicManager.getFrame(), false);
                            } else {
                                if (Environment.isNeedToRestart()) {
                                    return;
                                }
                                if (!LafManagerImpl.isLafOk()) {
                                    return;
                                }
                            }
                            graphicManager.doWelcomeDialog();
                        }
                        if (Environment.isPlugin()) {
                            graphicManager.doNewProjectNoDialog(this.this$0.opts);
                        }
                    }
                });
            }
        }
    }
}

