/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.scaladoc;

import dotty.tools.scaladoc.ArgParser;
import dotty.tools.scaladoc.DefinedRepoSummary$;
import dotty.tools.scaladoc.SourceLink;
import dotty.tools.scaladoc.TemplateSourceLink$;
import dotty.tools.scaladoc.WebBasedSourceLink$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.matching.Regex;

public class SourceLinkParser
implements ArgParser<SourceLink> {
    private final Option<String> revision;
    private final Regex KnownProvider;
    private final Regex BrokenKnownProvider;
    private final Regex ScalaDocPatten;
    private final Map<String, String> SupportedScalaDocPatternReplacements;

    public SourceLinkParser(Option<String> revision) {
        this.revision = revision;
        this.KnownProvider = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\w+):\\/\\/([^\\/#]+)\\/([^\\/#]+)(\\/[^#]+)?(#.+)?"));
        this.BrokenKnownProvider = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\w+):\\/\\/.+"));
        this.ScalaDocPatten = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\u20ac\\{(TPL_NAME|TPL_OWNER|FILE_PATH|FILE_EXT|FILE_LINE|FILE_PATH_EXT)\\}"));
        Object[] objectArray = new Tuple2[5];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"\u20ac{FILE_PATH_EXT}");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"{{ path }}");
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"\u20ac{FILE_LINE}");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)"{{ line }}");
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"\u20ac{TPL_NAME}");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)"{{ name }}");
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"\u20ac{FILE_EXT}");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)"{{ ext }}");
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"\u20ac{FILE_PATH}");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)"{{ path_no_ext }}");
        this.SupportedScalaDocPatternReplacements = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public Regex KnownProvider() {
        return this.KnownProvider;
    }

    public Regex BrokenKnownProvider() {
        return this.BrokenKnownProvider;
    }

    public Regex ScalaDocPatten() {
        return this.ScalaDocPatten;
    }

    public Map<String, String> SupportedScalaDocPatternReplacements() {
        return this.SupportedScalaDocPatternReplacements;
    }

    public String githubPrefix(String org, String repo) {
        return "https://github.com/" + org + "/" + repo;
    }

    public String gitlabPrefix(String org, String repo) {
        return "https://gitlab.com/" + org + "/" + repo + "/-";
    }

    private Option<SourceLink> parseLinkDefinition(String s) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Either<String, SourceLink> parse(String string) {
        Left res;
        Object object;
        block6: {
            String string2;
            List list;
            Option option;
            String string3;
            block8: {
                String string4;
                String string5;
                String string6;
                List list2;
                block7: {
                    Tuple2 tuple2;
                    Tuple2 $1$;
                    String scaladocSetting = string3 = string;
                    if (!this.ScalaDocPatten().findFirstIn((CharSequence)scaladocSetting).nonEmpty()) break block7;
                    Regex.MatchIterator all = this.ScalaDocPatten().findAllIn((CharSequence)scaladocSetting);
                    Tuple2 tuple22 = $1$ = (tuple2 = all.partition((Function1 & Serializable)key -> this.SupportedScalaDocPatternReplacements().contains(key)));
                    Iterator supported = (Iterator)tuple22._1();
                    Iterator unsupported = (Iterator)tuple22._2();
                    object = unsupported.nonEmpty() ? package$.MODULE$.Left().apply((Object)("Unsupported patterns from scaladoc format are used: " + unsupported.mkString(" "))) : package$.MODULE$.Right().apply((Object)TemplateSourceLink$.MODULE$.apply((String)supported.foldLeft((Object)string, (Function2 & Serializable)(template, pattern) -> template.replace((CharSequence)pattern, (CharSequence)this.SupportedScalaDocPatternReplacements().apply(pattern)))));
                    break block6;
                }
                Option option2 = this.KnownProvider().unapplySeq((CharSequence)string3);
                if (option2.isEmpty() || (list2 = (List)option2.get()).lengthCompare(5) != 0) break block8;
                String string7 = (String)list2.apply(0);
                String string8 = (String)list2.apply(1);
                String string9 = (String)list2.apply(2);
                String string10 = (String)list2.apply(3);
                String string11 = (String)list2.apply(4);
                if (string7 == null) break block8;
                String name = string6 = string7;
                if (string8 == null) break block8;
                String organization = string5 = string8;
                if (string9 == null) break block8;
                String repo = string4 = string9;
                String rawRevision = string10;
                String rawSubPath = string11;
                String subPath = (String)Option$.MODULE$.apply((Object)rawSubPath).fold(SourceLinkParser::$anonfun$14, (Function1 & Serializable)_$4 -> "/" + StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(_$4), 1));
                Option pathRev = Option$.MODULE$.apply((Object)rawRevision).map((Function1 & Serializable)_$5 -> StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(_$5), 1)).orElse(this::$anonfun$17);
                String string12 = name;
                if ("github".equals(string12)) {
                    object = SourceLinkParser.withRevision$1(pathRev, (Function1 & Serializable)rev -> WebBasedSourceLink$.MODULE$.apply(DefinedRepoSummary$.MODULE$.apply("github", organization, repo), this.githubPrefix(organization, repo), (String)rev, subPath));
                    break block6;
                } else if ("gitlab".equals(string12)) {
                    object = SourceLinkParser.withRevision$1(pathRev, (Function1 & Serializable)rev -> WebBasedSourceLink$.MODULE$.apply(DefinedRepoSummary$.MODULE$.apply("gitlab", organization, repo), this.gitlabPrefix(organization, repo), (String)rev, subPath));
                    break block6;
                } else {
                    String other = string12;
                    object = package$.MODULE$.Left().apply((Object)("'" + other + "' is not a known provider, please provide full source path template."));
                }
                break block6;
            }
            if (!(option = this.BrokenKnownProvider().unapplySeq((CharSequence)string3)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0 && ("gitlab".equals(string2 = (String)list.apply(0)) || "github".equals(string2))) {
                object = package$.MODULE$.Left().apply((Object)"Does not match known provider syntax: `<name>://organization/repository`");
            } else {
                String other = string3;
                object = package$.MODULE$.Left().apply((Object)"Does not match any implemented source link syntax");
            }
        }
        Left left = res = object;
        if (!(left instanceof Left)) return left;
        Left left2 = left;
        String error = (String)left2.value();
        return package$.MODULE$.Left().apply((Object)("'" + string + "': " + error));
    }

    private static final String $anonfun$14() {
        return "";
    }

    private final Option $anonfun$17() {
        return this.revision;
    }

    private static final Either withRevision$1$$anonfun$1() {
        return package$.MODULE$.Left().apply((Object)"No revision provided");
    }

    private static final Either withRevision$1(Option pathRev$1, Function1 template) {
        return (Either)pathRev$1.fold(SourceLinkParser::withRevision$1$$anonfun$1, (Function1 & Serializable)r -> package$.MODULE$.Right().apply(template.apply(r)));
    }
}

