/*
 * Decompiled with CFR 0.152.
 */
package ua.co.k.strftime.formatters;

import java.time.temporal.TemporalField;
import java.util.Locale;
import ua.co.k.strftime.formatters.FromTemporalFieldFormat;
import ua.co.k.strftime.formatters.HybridFormat;

class FromTemporalFieldWithPaddingFormat
extends FromTemporalFieldFormat {
    private final Padding padding;

    public FromTemporalFieldWithPaddingFormat(TemporalField field, Padding padding) {
        super(field);
        this.padding = padding;
    }

    @Override
    protected String doFormat(Object obj, int width, boolean strict, Locale locale) {
        String res = super.doFormat(obj, width, strict, locale);
        if (res.isEmpty()) {
            return res;
        }
        return HybridFormat.padLeft(res, this.padding.count, this.padding.symbol);
    }

    public static class Padding {
        final char symbol;
        final int count;

        public Padding(char symbol, int count) {
            this.symbol = symbol;
            this.count = count;
        }
    }
}

