/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.convert.impl;

import java.util.Arrays;
import scala.Function1;
import scala.Int$;
import scala.collection.Stepper;
import scala.collection.convert.impl.BinaryTreeStepper$;

public abstract class BinaryTreeStepperBase<A, T, Sub, Semi extends BinaryTreeStepperBase<A, T, ?, ?>>
implements Stepper.EfficientSplit {
    private int maxLength;
    private T myCurrent;
    private Object[] stack;
    private int index;
    private final Function1<T, T> left;
    private final Function1<T, T> right;

    public BinaryTreeStepperBase(int maxLength, T myCurrent, Object[] stack, int index, Function1<T, T> left, Function1<T, T> right) {
        this.maxLength = maxLength;
        this.myCurrent = myCurrent;
        this.stack = stack;
        this.index = index;
        this.left = left;
        this.right = right;
    }

    public int maxLength() {
        return this.maxLength;
    }

    public void maxLength_$eq(int x$1) {
        this.maxLength = x$1;
    }

    public T myCurrent() {
        return this.myCurrent;
    }

    public void myCurrent_$eq(T x$1) {
        this.myCurrent = x$1;
    }

    public Object[] stack() {
        return this.stack;
    }

    public void stack_$eq(Object[] x$1) {
        this.stack = x$1;
    }

    public int index() {
        return this.index;
    }

    public void index_$eq(int x$1) {
        this.index = x$1;
    }

    public Function1<T, T> left() {
        return this.left;
    }

    public Function1<T, T> right() {
        return this.right;
    }

    public final T unroll(T from) {
        T l;
        while (!((l = this.left().apply(from)) == null)) {
            if (this.index() + 1 >= this.stack().length) {
                this.stack_$eq(Arrays.copyOf(this.stack(), 4 + this.stack().length * 2));
            }
            this.index_$eq(this.index() + 1);
            this.stack()[this.index()] = from;
            from = l;
        }
        return from;
    }

    public final T detach(T node) {
        T r = this.right().apply(node);
        if (!(r == null)) {
            T last = this.unroll(r);
            if (this.index() + 1 >= this.stack().length) {
                this.stack_$eq(Arrays.copyOf(this.stack(), 4 + this.stack().length * 2));
            }
            this.index_$eq(this.index() + 1);
            this.stack()[this.index()] = last;
        }
        return node;
    }

    public final void initialize(T root, int size) {
        if (root == null) {
            this.maxLength_$eq(0);
            this.myCurrent_$eq(null);
            this.stack_$eq(BinaryTreeStepper$.MODULE$.emptyStack());
            this.index_$eq(-1);
            return;
        }
        this.maxLength_$eq(size);
        this.index_$eq(-1);
        this.myCurrent_$eq(this.detach(this.unroll(root)));
    }

    public abstract Semi semiclone(int var1, T var2, Object[] var3, int var4);

    public int characteristics() {
        return 16;
    }

    public long estimateSize() {
        if (this.hasStep()) {
            return Int$.MODULE$.int2long(this.maxLength());
        }
        return 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasStep() {
        if (this.myCurrent() != null) return true;
        boolean bl = true;
        if (!bl) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        if (this.maxLength() <= 0) return false;
        if (this.index() >= 0) {
            Object ans = this.stack()[this.index()];
            this.index_$eq(this.index() - 1);
            this.myCurrent_$eq(this.detach(ans));
            if (!true) return false;
            return true;
        }
        this.maxLength_$eq(0);
        this.stack_$eq(BinaryTreeStepper$.MODULE$.emptyStack());
        if (false) return true;
        return false;
    }

    public Sub trySplit() {
        if (!this.hasStep() || this.index() < 0) {
            return null;
        }
        Object root = this.stack()[0];
        Object[] leftStack = this.index() > 0 ? Arrays.copyOfRange(this.stack(), 1, this.index() + 1) : BinaryTreeStepper$.MODULE$.emptyStack();
        int leftIndex = this.index() - 1;
        T leftCurrent = this.myCurrent();
        int leftMax = this.maxLength();
        this.index_$eq(-1);
        this.detach(root);
        this.myCurrent_$eq(root);
        this.maxLength_$eq(this.maxLength() - (2 + leftIndex));
        return (Sub)this.semiclone(leftMax -= 2 + this.index(), leftCurrent, leftStack, leftIndex);
    }
}

