/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerCoordinator;
import org.klomp.snark.PeerCoordinatorSet;

class PeerAcceptor {
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(PeerAcceptor.class);
    private final PeerCoordinator coordinator;
    final PeerCoordinatorSet coordinators;
    private static final long HASH_READ_TIMEOUT = 45000L;
    private static final String PROTO_STR = "BitTorrent protocol";
    private static final int PROTO_STR_LEN = "BitTorrent protocol".length();
    private static final int PROTO_LEN = PROTO_STR_LEN + 1;
    private static final int[] PROTO = new int[PROTO_LEN];
    private static final int LOOKAHEAD_SIZE;

    public PeerAcceptor(PeerCoordinator coordinator) {
        this.coordinator = coordinator;
        this.coordinators = null;
    }

    public PeerAcceptor(PeerCoordinatorSet coordinators) {
        this.coordinators = coordinators;
        this.coordinator = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void connection(I2PSocket socket, InputStream in, OutputStream out) throws IOException {
        byte[] peerInfoHash = null;
        if (in instanceof BufferedInputStream) {
            in.mark(LOOKAHEAD_SIZE);
            long timeout = socket.getReadTimeout();
            socket.setReadTimeout(45000L);
            try {
                peerInfoHash = PeerAcceptor.readHash(in);
            }
            catch (IOException ioe) {
                throw new ProtocolException(ioe.toString());
            }
            socket.setReadTimeout(timeout);
            in.reset();
        } else {
            try {
                peerInfoHash = PeerAcceptor.readHash(in);
                if (this._log.shouldLog(20)) {
                    this._log.info("infohash read from " + socket.getPeerDestination().calculateHash().toBase64() + ": " + Base64.encode(peerInfoHash));
                }
            }
            catch (IOException ioe) {
                if (!this._log.shouldLog(20)) throw ioe;
                this._log.info("Unable to read the infohash from " + socket.getPeerDestination().calculateHash().toBase64());
                throw ioe;
            }
            in = new SequenceInputStream(new ByteArrayInputStream(peerInfoHash), in);
        }
        if (this.coordinator != null) {
            if (!DataHelper.eq(this.coordinator.getInfoHash(), peerInfoHash)) throw new IOException("Peer wants another torrent (" + Base64.encode(peerInfoHash) + ") while we only support (" + Base64.encode(this.coordinator.getInfoHash()) + ")");
            if (this.coordinator.needPeers()) {
                Peer peer = new Peer(socket, in, out, this.coordinator.getID(), this.coordinator.getInfoHash(), this.coordinator.getMetaInfo());
                this.coordinator.addPeer(peer);
                return;
            } else {
                socket.close();
            }
            return;
        } else {
            PeerCoordinator cur = this.coordinators.get(peerInfoHash);
            if (cur == null || !DataHelper.eq(cur.getInfoHash(), peerInfoHash)) throw new IOException("Peer wants another torrent (" + Base64.encode(peerInfoHash) + ") while we don't support that hash");
            if (cur.needPeers()) {
                Peer peer = new Peer(socket, in, out, cur.getID(), cur.getInfoHash(), cur.getMetaInfo());
                cur.addPeer(peer);
                return;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Rejecting new peer for " + cur.getName());
            }
            socket.close();
            return;
        }
    }

    private static byte[] readHash(InputStream in) throws IOException {
        for (int i = 0; i < PROTO_LEN; ++i) {
            int b = in.read();
            if (b == PROTO[i]) continue;
            throw new IOException("Bad protocol 0x" + Integer.toHexString(b) + " at byte " + i);
        }
        DataHelper.skip(in, 8L);
        byte[] buf = new byte[20];
        int read = DataHelper.read(in, buf);
        if (read != buf.length) {
            throw new IOException("Unable to read the hash (read " + read + ")");
        }
        return buf;
    }

    static {
        PeerAcceptor.PROTO[0] = PROTO_STR_LEN;
        for (int i = 0; i < PROTO_STR_LEN; ++i) {
            PeerAcceptor.PROTO[i + 1] = PROTO_STR.charAt(i);
        }
        LOOKAHEAD_SIZE = PROTO_LEN + 8 + 20;
    }

    public static class ProtocolException
    extends IOException {
        public ProtocolException(String s) {
            super(s);
        }
    }
}

