/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.math.BigDecimal;
import java.util.Objects;
import javax.measure.UnitConverter;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.internal.function.Calculator;
import tech.uom.lib.common.function.IntExponentSupplier;

final class PowerOfPiConverter
extends AbstractConverter
implements MultiplyConverter,
IntExponentSupplier {
    private static final long serialVersionUID = 5000593326722785126L;
    private final Object $lock1 = new Object[0];
    private final int exponent;
    private final int hashCode;
    private transient Number scaleFactor;
    public static final PowerOfPiConverter ONE = PowerOfPiConverter.of(1);

    static PowerOfPiConverter of(int exponent) {
        return new PowerOfPiConverter(exponent);
    }

    protected PowerOfPiConverter(int exponent) {
        this.exponent = exponent;
        this.hashCode = Objects.hash(exponent);
    }

    public int getExponent() {
        return this.exponent;
    }

    public boolean isIdentity() {
        return this.exponent == 0;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public AbstractConverter inverseWhenNotIdentity() {
        return new PowerOfPiConverter(-this.exponent);
    }

    @Override
    protected Number convertWhenNotIdentity(Number value) {
        return Calculator.of(this.getFactor()).multiply(value).peek();
    }

    @Override
    protected boolean canReduceWith(AbstractConverter that) {
        return that instanceof PowerOfPiConverter;
    }

    @Override
    protected AbstractConverter reduce(AbstractConverter that) {
        return new PowerOfPiConverter(this.exponent + ((PowerOfPiConverter)that).exponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number getValue() {
        Object object = this.$lock1;
        synchronized (object) {
            if (this.scaleFactor == null) {
                int nbrDigits = Calculus.MATH_CONTEXT.getPrecision();
                if (nbrDigits == 0) {
                    throw new ArithmeticException("Pi multiplication with unlimited precision");
                }
                BigDecimal pi = Calculus.Pi.ofNumDigits(nbrDigits);
                this.scaleFactor = Calculator.of(pi).power(this.exponent).peek();
            }
        }
        return this.scaleFactor;
    }

    @Override
    public boolean equals(Object obj) {
        UnitConverter other;
        if (this == obj) {
            return true;
        }
        if (obj instanceof UnitConverter) {
            other = (UnitConverter)obj;
            if (this.isIdentity() && other.isIdentity()) {
                return true;
            }
        }
        if (obj instanceof PowerOfPiConverter) {
            other = (PowerOfPiConverter)obj;
            return this.exponent == other.exponent;
        }
        return false;
    }

    @Override
    public final String transformationLiteral() {
        return String.format("x -> x * \u03c0^%s", this.exponent);
    }

    @Override
    public int compareTo(UnitConverter o) {
        if (this == o) {
            return 0;
        }
        if (this.isIdentity() && o.isIdentity()) {
            return 0;
        }
        if (o instanceof PowerOfPiConverter) {
            PowerOfPiConverter other = (PowerOfPiConverter)o;
            return Integer.compare(this.exponent, other.exponent);
        }
        return this.getClass().getName().compareTo(o.getClass().getName());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public double getAsDouble() {
        return this.getValue().doubleValue();
    }
}

