/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.net.http.internal;

import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.http.HttpChannelOverHTTP;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.client.http.HttpReceiverOverHTTP;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.openhab.core.io.net.http.ExtensibleTrustManager;
import org.openhab.core.io.net.http.HttpClientFactory;
import org.openhab.core.io.net.http.HttpClientInitializationException;
import org.openhab.core.io.net.http.WebSocketFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPid={"org.openhab.webclient"})
@NonNullByDefault
public class WebClientFactoryImpl
implements HttpClientFactory,
WebSocketFactory {
    private final Logger logger = LoggerFactory.getLogger(WebClientFactoryImpl.class);
    private static final String CONFIG_MIN_THREADS_SHARED = "minThreadsShared";
    private static final String CONFIG_MAX_THREADS_SHARED = "maxThreadsShared";
    private static final String CONFIG_KEEP_ALIVE_SHARED = "keepAliveTimeoutShared";
    private static final String CONFIG_MIN_THREADS_CUSTOM = "minThreadsCustom";
    private static final String CONFIG_MAX_THREADS_CUSTOM = "maxThreadsCustom";
    private static final String CONFIG_KEEP_ALIVE_CUSTOM = "keepAliveTimeoutCustom";
    private static final int MIN_CONSUMER_NAME_LENGTH = 4;
    private static final int MAX_CONSUMER_NAME_LENGTH = 20;
    private static final Pattern CONSUMER_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_\\-]*");
    private final ExtensibleTrustManager extensibleTrustManager;
    @NonNullByDefault(value={})
    private QueuedThreadPool threadPool;
    @NonNullByDefault(value={})
    private HttpClient commonHttpClient;
    @NonNullByDefault(value={})
    private WebSocketClient commonWebSocketClient;
    private int minThreadsShared;
    private int maxThreadsShared;
    private int keepAliveTimeoutShared;
    private int minThreadsCustom;
    private int maxThreadsCustom;
    private int keepAliveTimeoutCustom;
    private boolean hpackLoadTestDone = false;
    private @Nullable HttpClientInitializationException hpackException = null;

    @Activate
    public WebClientFactoryImpl(@Reference ExtensibleTrustManager extensibleTrustManager) {
        this.extensibleTrustManager = extensibleTrustManager;
    }

    @Activate
    protected void activate(Map<String, Object> parameters) {
        this.getConfigParameters(parameters);
    }

    @Modified
    protected void modified(Map<String, Object> parameters) {
        this.getConfigParameters(parameters);
        if (this.threadPool != null) {
            this.threadPool.setMinThreads(this.minThreadsShared);
            this.threadPool.setMaxThreads(this.maxThreadsShared);
            this.threadPool.setIdleTimeout(this.keepAliveTimeoutShared * 1000);
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this.commonHttpClient != null) {
            try {
                this.commonHttpClient.stop();
            }
            catch (Exception e) {
                this.logger.error("error while stopping shared Jetty http client", (Throwable)e);
            }
            this.commonHttpClient = null;
            this.logger.debug("Jetty shared http client stopped");
        }
        if (this.commonWebSocketClient != null) {
            try {
                this.commonWebSocketClient.stop();
            }
            catch (Exception e) {
                this.logger.error("error while stopping shared Jetty web socket client", (Throwable)e);
            }
            this.commonWebSocketClient = null;
            this.logger.debug("Jetty shared web socket client stopped");
        }
        this.threadPool = null;
    }

    @Override
    public HttpClient createHttpClient(String consumerName) {
        return this.createHttpClient(consumerName, null);
    }

    @Override
    public HttpClient createHttpClient(String consumerName, @Nullable SslContextFactory sslContextFactory) {
        this.logger.debug("http client for consumer {} requested", (Object)consumerName);
        this.checkConsumerName(consumerName);
        return this.createHttpClientInternal(consumerName, sslContextFactory, false, null);
    }

    @Override
    public WebSocketClient createWebSocketClient(String consumerName) {
        return this.createWebSocketClient(consumerName, null);
    }

    @Override
    public WebSocketClient createWebSocketClient(String consumerName, @Nullable SslContextFactory sslContextFactory) {
        this.logger.debug("web socket client for consumer {} requested", (Object)consumerName);
        this.checkConsumerName(consumerName);
        return this.createWebSocketClientInternal(consumerName, sslContextFactory, false, null);
    }

    @Override
    public HttpClient getCommonHttpClient() {
        this.initialize();
        this.logger.debug("shared http client requested");
        return this.commonHttpClient;
    }

    @Override
    public WebSocketClient getCommonWebSocketClient() {
        this.initialize();
        this.logger.debug("shared web socket client requested");
        return this.commonWebSocketClient;
    }

    private void getConfigParameters(Map<String, Object> parameters) {
        this.minThreadsShared = this.getConfigParameter(parameters, CONFIG_MIN_THREADS_SHARED, 10);
        this.maxThreadsShared = this.getConfigParameter(parameters, CONFIG_MAX_THREADS_SHARED, 40);
        this.keepAliveTimeoutShared = this.getConfigParameter(parameters, CONFIG_KEEP_ALIVE_SHARED, 300);
        this.minThreadsCustom = this.getConfigParameter(parameters, CONFIG_MIN_THREADS_CUSTOM, 5);
        this.maxThreadsCustom = this.getConfigParameter(parameters, CONFIG_MAX_THREADS_CUSTOM, 10);
        this.keepAliveTimeoutCustom = this.getConfigParameter(parameters, CONFIG_KEEP_ALIVE_CUSTOM, 300);
    }

    private int getConfigParameter(Map<String, Object> parameters, String parameter, int defaultValue) {
        if (parameters == null) {
            return defaultValue;
        }
        Object value = parameters.get(parameter);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            Integer integerValue = (Integer)value;
            return integerValue;
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                this.logger.warn("ignoring invalid value {} for parameter {}", value, (Object)parameter);
                return defaultValue;
            }
        }
        this.logger.warn("ignoring invalid type {} for parameter {}", (Object)value.getClass().getName(), (Object)parameter);
        return defaultValue;
    }

    private synchronized void initialize() {
        try {
            if (this.threadPool == null) {
                this.threadPool = this.createThreadPool("common", this.minThreadsShared, this.maxThreadsShared, this.keepAliveTimeoutShared);
            }
            if (this.commonHttpClient == null) {
                this.commonHttpClient = this.createHttpClientInternal("common", null, true, this.threadPool);
                this.threadPool.setStopTimeout(0L);
                this.logger.debug("Jetty shared http client created");
            }
            if (this.commonWebSocketClient == null) {
                this.commonWebSocketClient = this.createWebSocketClientInternal("common", null, true, this.threadPool);
                this.logger.debug("Jetty shared web socket client created");
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpClientInitializationException("unexpected checked exception during initialization of the jetty client", e);
        }
    }

    private HttpClient createHttpClientInternal(String consumerName, @Nullable SslContextFactory sslContextFactory, boolean startClient, @Nullable QueuedThreadPool threadPool) {
        try {
            String sProxyPort;
            this.logger.debug("creating http client for consumer {}", (Object)consumerName);
            HttpClient httpClient = new HttpClient((HttpClientTransport)new CustomHttpClientTransportOverHTTP(), sslContextFactory != null ? sslContextFactory : this.createSslContextFactory());
            String httpProxyHost = System.getProperty("http.proxyHost");
            String httpsProxyHost = System.getProperty("https.proxyHost");
            if (httpProxyHost != null) {
                sProxyPort = System.getProperty("http.proxyPort");
                if (sProxyPort != null) {
                    try {
                        int port = Integer.parseInt(sProxyPort);
                        httpClient.getProxyConfiguration().getProxies().add(new HttpProxy(httpProxyHost, port));
                    }
                    catch (NumberFormatException ex) {
                        this.logger.debug("HTTP Proxy detected (http.proxyHost), but invalid proxyport. Ignoring proxy.");
                    }
                }
            } else if (httpsProxyHost != null && (sProxyPort = System.getProperty("https.proxyPort")) != null) {
                try {
                    int port = Integer.parseInt(sProxyPort);
                    httpClient.getProxyConfiguration().getProxies().add(new HttpProxy(httpsProxyHost, port));
                }
                catch (NumberFormatException ex) {
                    this.logger.debug("HTTP Proxy detected (https.proxyHost), but invalid proxyport. Ignoring proxy.");
                }
            }
            httpClient.setMaxConnectionsPerDestination(2);
            if (threadPool != null) {
                httpClient.setExecutor((Executor)threadPool);
            } else {
                QueuedThreadPool queuedThreadPool = this.createThreadPool(consumerName, this.minThreadsCustom, this.maxThreadsCustom, this.keepAliveTimeoutCustom);
                httpClient.setExecutor((Executor)queuedThreadPool);
            }
            if (startClient) {
                try {
                    httpClient.start();
                }
                catch (Exception e) {
                    this.logger.error("Could not start Jetty http client", (Throwable)e);
                    throw new HttpClientInitializationException("Could not start Jetty http client", e);
                }
            }
            return httpClient;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpClientInitializationException("unexpected checked exception during initialization of the Jetty http client", e);
        }
    }

    private WebSocketClient createWebSocketClientInternal(String consumerName, @Nullable SslContextFactory sslContextFactory, boolean startClient, @Nullable QueuedThreadPool threadPool) {
        try {
            this.logger.debug("creating web socket client for consumer {}", (Object)consumerName);
            HttpClient httpClient = new HttpClient(sslContextFactory != null ? sslContextFactory : this.createSslContextFactory());
            if (threadPool != null) {
                httpClient.setExecutor((Executor)threadPool);
            } else {
                QueuedThreadPool queuedThreadPool = this.createThreadPool(consumerName, this.minThreadsCustom, this.maxThreadsCustom, this.keepAliveTimeoutCustom);
                httpClient.setExecutor((Executor)queuedThreadPool);
            }
            WebSocketClient webSocketClient = new WebSocketClient(httpClient);
            if (startClient) {
                try {
                    webSocketClient.start();
                }
                catch (Exception e) {
                    this.logger.error("Could not start Jetty web socket client", (Throwable)e);
                    throw new HttpClientInitializationException("Could not start Jetty web socket client", e);
                }
            }
            return webSocketClient;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpClientInitializationException("unexpected checked exception during initialization of the Jetty web socket client", e);
        }
    }

    private QueuedThreadPool createThreadPool(String consumerName, int minThreads, int maxThreads, int keepAliveTimeout) {
        QueuedThreadPool queuedThreadPool = new QueuedThreadPool(maxThreads, minThreads, keepAliveTimeout * 1000);
        queuedThreadPool.setName("OH-httpClient-" + consumerName);
        queuedThreadPool.setDaemon(true);
        return queuedThreadPool;
    }

    private void checkConsumerName(String consumerName) {
        if (consumerName.length() < 4) {
            throw new IllegalArgumentException("consumerName " + consumerName + " too short, minimum 4");
        }
        if (consumerName.length() > 20) {
            throw new IllegalArgumentException("consumerName " + consumerName + " too long, maximum 20");
        }
        if (!CONSUMER_NAME_PATTERN.matcher(consumerName).matches()) {
            throw new IllegalArgumentException("consumerName " + consumerName + " contains illegal character, allowed only [a-zA-Z0-9_-]");
        }
    }

    private SslContextFactory createSslContextFactory() {
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
        try {
            this.logger.debug("Setting up SSLContext for {}", (Object)this.extensibleTrustManager);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{this.extensibleTrustManager}, null);
            sslContextFactory.setSslContext(sslContext);
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            throw new HttpClientInitializationException("Cannot create an TLS context!", ex);
        }
        return sslContextFactory;
    }

    @Override
    public HTTP2Client createHttp2Client(String consumerName) {
        return this.createHttp2Client(consumerName, null);
    }

    @Override
    public HTTP2Client createHttp2Client(String consumerName, @Nullable SslContextFactory sslContextFactory) {
        this.logger.debug("http client for consumer {} requested", (Object)consumerName);
        this.checkConsumerName(consumerName);
        return this.createHttp2ClientInternal(consumerName, sslContextFactory);
    }

    private HTTP2Client createHttp2ClientInternal(String consumerName, @Nullable SslContextFactory sslContextFactory) {
        try {
            this.logger.debug("creating HTTP/2 client for consumer {}", (Object)consumerName);
            if (!this.hpackLoadTestDone) {
                try {
                    PreEncodedHttpField field = new PreEncodedHttpField(HttpHeader.C_METHOD, "PUT");
                    ByteBuffer bytes = ByteBuffer.allocate(32);
                    field.putTo(bytes, HttpVersion.HTTP_2);
                    this.hpackException = null;
                }
                catch (Exception e) {
                    this.hpackException = new HttpClientInitializationException("Jetty HTTP/2 hpack module not loaded", e);
                }
                this.hpackLoadTestDone = true;
            }
            if (this.hpackException != null) {
                throw this.hpackException;
            }
            HTTP2Client http2Client = new HTTP2Client();
            http2Client.addBean((Object)(sslContextFactory != null ? sslContextFactory : this.createSslContextFactory()));
            http2Client.setExecutor((Executor)this.createThreadPool(consumerName, this.minThreadsCustom, this.maxThreadsCustom, this.keepAliveTimeoutCustom));
            return http2Client;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpClientInitializationException("unexpected checked exception during initialization of the Jetty HTTP/2 client", e);
        }
    }

    private static class CustomHttpClientTransportOverHTTP
    extends HttpClientTransportOverHTTP {
        private CustomHttpClientTransportOverHTTP() {
        }

        @NonNullByDefault(value={})
        protected HttpConnectionOverHTTP newHttpConnection(EndPoint endPoint, HttpDestination destination, Promise<Connection> promise) {
            return new HttpConnectionOverHTTP(endPoint, destination, promise){

                protected HttpChannelOverHTTP newHttpChannel() {
                    return new HttpChannelOverHTTP(this){

                        protected HttpReceiverOverHTTP newHttpReceiver() {
                            return new CustomHttpReceiverOverHTTP(this);
                        }
                    };
                }
            };
        }

        private static class CustomHttpReceiverOverHTTP
        extends HttpReceiverOverHTTP {
            private final HttpChannelOverHTTP channel;

            public CustomHttpReceiverOverHTTP(HttpChannelOverHTTP channel) {
                super(channel);
                this.channel = channel;
            }

            public boolean headerComplete() {
                HttpExchange exchange = this.getHttpExchange();
                if (exchange != null) {
                    exchange.getRequest().getConversation().setAttribute(EndPoint.class.getName(), (Object)this.channel.getHttpConnection().getEndPoint());
                }
                return super.headerComplete();
            }
        }
    }
}

