/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.SortedIterableFactory;
import scala.collection.SortedOps;
import scala.collection.SortedSet;
import scala.collection.SortedSetOps$;
import scala.collection.View;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public interface SortedSetOps<A, CC extends SortedSet<Object>, C extends SortedSetOps<A, CC, C>>
extends SetOps<A, Set, C>,
SortedOps<A, C> {
    public static String ordMsg() {
        return SortedSetOps$.MODULE$.ordMsg();
    }

    public static String zipOrdMsg() {
        return SortedSetOps$.MODULE$.zipOrdMsg();
    }

    public static void $init$(SortedSetOps $this) {
    }

    public /* synthetic */ Object scala$collection$SortedSetOps$$super$min(Ordering var1);

    public /* synthetic */ Object scala$collection$SortedSetOps$$super$max(Ordering var1);

    public SortedIterableFactory<CC> sortedIterableFactory();

    public Set<A> unsorted();

    public Iterator<A> iteratorFrom(A var1);

    public static Iterator keysIteratorFrom$(SortedSetOps $this, Object start) {
        return $this.keysIteratorFrom(start);
    }

    default public Iterator<A> keysIteratorFrom(A start) {
        return this.iteratorFrom(start);
    }

    public static Object firstKey$(SortedSetOps $this) {
        return $this.firstKey();
    }

    @Override
    default public A firstKey() {
        return this.head();
    }

    public static Object lastKey$(SortedSetOps $this) {
        return $this.lastKey();
    }

    @Override
    default public A lastKey() {
        return this.last();
    }

    public static Option minAfter$(SortedSetOps $this, Object key) {
        return $this.minAfter(key);
    }

    default public Option<A> minAfter(A key) {
        return ((IterableOps)this.rangeFrom(key)).headOption();
    }

    public static Option maxBefore$(SortedSetOps $this, Object key) {
        return $this.maxBefore(key);
    }

    default public Option<A> maxBefore(A key) {
        return ((IterableOps)this.rangeUntil(key)).lastOption();
    }

    public static Object min$(SortedSetOps $this, Ordering ord) {
        return $this.min(ord);
    }

    @Override
    default public <B> A min(Ordering<B> ord) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.min");
        }
        Ordering<B> ordering = ord;
        Ordering ordering2 = this.ordering();
        if (!(ordering != null ? !ordering.equals(ordering2) : ordering2 != null)) {
            return this.head();
        }
        if (ord.isReverseOf(this.ordering())) {
            return this.last();
        }
        return (A)this.scala$collection$SortedSetOps$$super$min(ord);
    }

    public static Object max$(SortedSetOps $this, Ordering ord) {
        return $this.max(ord);
    }

    @Override
    default public <B> A max(Ordering<B> ord) {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("empty.max");
        }
        Ordering<B> ordering = ord;
        Ordering ordering2 = this.ordering();
        if (!(ordering != null ? !ordering.equals(ordering2) : ordering2 != null)) {
            return this.last();
        }
        if (ord.isReverseOf(this.ordering())) {
            return this.head();
        }
        return (A)this.scala$collection$SortedSetOps$$super$max(ord);
    }

    public static SortedSetOps rangeTo$(SortedSetOps $this, Object to) {
        return $this.rangeTo(to);
    }

    @Override
    default public C rangeTo(A to) {
        Iterator i = ((IterableOnce)this.rangeFrom(to)).iterator();
        if (i.isEmpty()) {
            return (C)((SortedSetOps)this.coll());
        }
        Object next = i.next();
        if (this.ordering().compare(next, to) == 0) {
            if (i.isEmpty()) {
                return (C)((SortedSetOps)this.coll());
            }
            return (C)((SortedSetOps)this.rangeUntil(i.next()));
        }
        return (C)((SortedSetOps)this.rangeUntil(next));
    }

    public static SortedSet map$(SortedSetOps $this, Function1 f, Ordering ev) {
        return $this.map(f, ev);
    }

    default public <B> CC map(Function1<A, B> f, Ordering<B> ev) {
        return (CC)((SortedSet)this.sortedIterableFactory().from(new View.Map<A, B>(this, f), ev));
    }

    public static SortedSet flatMap$(SortedSetOps $this, Function1 f, Ordering ev) {
        return $this.flatMap(f, ev);
    }

    default public <B> CC flatMap(Function1<A, IterableOnce<B>> f, Ordering<B> ev) {
        return (CC)((SortedSet)this.sortedIterableFactory().from(new View.FlatMap<A, B>(this, f), ev));
    }

    public static SortedSet zip$(SortedSetOps $this, IterableOnce that, Ordering ev) {
        return $this.zip(that, ev);
    }

    default public <B> CC zip(IterableOnce<B> that, Ordering<Tuple2<A, B>> ev) {
        IterableOnce<Tuple2<Object, Object>> iterableOnce;
        SortedIterableFactory<CC> sortedIterableFactory = this.sortedIterableFactory();
        IterableOnce<B> iterableOnce2 = that;
        if (iterableOnce2 instanceof Iterable) {
            Iterable iterable;
            Iterable that2 = iterable = (Iterable)iterableOnce2;
            iterableOnce = new View.Zip(this, that2);
        } else {
            iterableOnce = this.iterator().zip(that);
        }
        return (CC)((SortedSet)sortedIterableFactory.from((IterableOnce)iterableOnce, ev));
    }

    public static SortedSet collect$(SortedSetOps $this, PartialFunction pf, Ordering ev) {
        return $this.collect(pf, ev);
    }

    default public <B> CC collect(PartialFunction<A, B> pf, Ordering<B> ev) {
        return (CC)((SortedSet)this.sortedIterableFactory().from(new View.Collect<A, B>(this, pf), ev));
    }

    public static class WithFilter<A, IterableCC, CC extends SortedSet<Object>>
    extends IterableOps.WithFilter<A, IterableCC> {
        private final SortedSetOps<A, CC, ?> self;
        private final Function1<A, Object> p;

        public WithFilter(SortedSetOps<A, CC, ?> self, Function1<A, Object> p) {
            this.self = self;
            this.p = p;
            super(self, p);
        }

        public <B> CC map(Function1<A, B> f, Ordering<B> evidence$1) {
            return (CC)((SortedSet)this.self.sortedIterableFactory().from(new View.Map<A, B>(this.filtered(), f), evidence$1));
        }

        public <B> CC flatMap(Function1<A, IterableOnce<B>> f, Ordering<B> evidence$1) {
            return (CC)((SortedSet)this.self.sortedIterableFactory().from(new View.FlatMap<A, B>(this.filtered(), f), evidence$1));
        }

        public WithFilter<A, IterableCC, CC> withFilter(Function1<A, Object> q) {
            return new WithFilter<A, IterableCC, CC>(this.self, (Function1<Object, Boolean> & Serializable)a -> BoxesRunTime.unboxToBoolean(this.p.apply(a)) && BoxesRunTime.unboxToBoolean(q.apply(a)));
        }
    }
}

