/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ConnectivityState;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerRegistry;
import io.grpc.Status;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.WeightedTargetLoadBalancerProvider;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.client.XdsLogger;
import java.util.HashMap;
import java.util.Objects;

final class WrrLocalityLoadBalancer
extends LoadBalancer {
    private final XdsLogger logger;
    private final LoadBalancer.Helper helper;
    private final GracefulSwitchLoadBalancer switchLb;
    private final LoadBalancerRegistry lbRegistry;

    WrrLocalityLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, LoadBalancerRegistry.getDefaultRegistry());
    }

    WrrLocalityLoadBalancer(LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.lbRegistry = lbRegistry;
        this.switchLb = new GracefulSwitchLoadBalancer(helper);
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"xds-wrr-locality-lb", (String)helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created", new Object[0]);
    }

    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        WrrLocalityConfig wrrLocalityConfig = (WrrLocalityConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        HashMap<String, Integer> localityWeights = new HashMap<String, Integer>();
        for (Object eag : resolvedAddresses.getAddresses()) {
            Attributes eagAttrs = eag.getAttributes();
            String locality = (String)eagAttrs.get(XdsAttributes.ATTR_LOCALITY_NAME);
            Integer localityWeight = (Integer)eagAttrs.get(XdsAttributes.ATTR_LOCALITY_WEIGHT);
            if (locality == null) {
                Status unavailableStatus = Status.UNAVAILABLE.withDescription("wrr_locality error: no locality provided");
                this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError((Status)unavailableStatus)));
                return unavailableStatus;
            }
            if (localityWeight == null) {
                Status unavailableStatus = Status.UNAVAILABLE.withDescription("wrr_locality error: no weight provided for locality " + locality);
                this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError((Status)unavailableStatus)));
                return unavailableStatus;
            }
            if (!localityWeights.containsKey(locality)) {
                localityWeights.put(locality, localityWeight);
                continue;
            }
            if (((Integer)localityWeights.get(locality)).equals(localityWeight)) continue;
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Locality {0} has both weights {1} and {2}, using weight {1}", locality, localityWeights.get(locality), localityWeight);
        }
        HashMap<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection> weightedPolicySelections = new HashMap<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection>();
        for (String locality : localityWeights.keySet()) {
            weightedPolicySelections.put(locality, new WeightedTargetLoadBalancerProvider.WeightedPolicySelection((Integer)localityWeights.get(locality), wrrLocalityConfig.childConfig));
        }
        Object switchConfig = GracefulSwitchLoadBalancer.createLoadBalancingPolicyConfig((LoadBalancer.Factory)this.lbRegistry.getProvider("weighted_target_experimental"), (Object)new WeightedTargetLoadBalancerProvider.WeightedTargetConfig(weightedPolicySelections));
        this.switchLb.handleResolvedAddresses(resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(switchConfig).build());
        return Status.OK;
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        this.switchLb.handleNameResolutionError(error);
    }

    public void shutdown() {
        this.switchLb.shutdown();
    }

    static final class WrrLocalityConfig {
        final Object childConfig;

        WrrLocalityConfig(Object childConfig) {
            this.childConfig = childConfig;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WrrLocalityConfig that = (WrrLocalityConfig)o;
            return Objects.equals(this.childConfig, that.childConfig);
        }

        public int hashCode() {
            return Objects.hashCode(this.childConfig);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("childConfig", this.childConfig).toString();
        }
    }
}

