/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BitBuffer;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class Gl200BinaryProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_RSP_LCB = 3;
    public static final int MSG_RSP_GEO = 8;
    public static final int MSG_RSP_COMPRESSED = 100;
    public static final int MSG_EVT_BPL = 6;
    public static final int MSG_EVT_VGN = 45;
    public static final int MSG_EVT_VGF = 46;
    public static final int MSG_EVT_UPD = 15;
    public static final int MSG_EVT_IDF = 17;
    public static final int MSG_EVT_GSS = 21;
    public static final int MSG_EVT_GES = 26;
    public static final int MSG_EVT_GPJ = 31;
    public static final int MSG_EVT_RMD = 35;
    public static final int MSG_EVT_JDS = 33;
    public static final int MSG_EVT_CRA = 23;
    public static final int MSG_EVT_UPC = 34;
    public static final int MSG_INF_GPS = 2;
    public static final int MSG_INF_CID = 4;
    public static final int MSG_INF_CSQ = 5;
    public static final int MSG_INF_VER = 6;
    public static final int MSG_INF_BAT = 7;
    public static final int MSG_INF_TMZ = 9;
    public static final int MSG_INF_GIR = 10;

    public Gl200BinaryProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Date decodeTime(ByteBuf buf) {
        DateBuilder dateBuilder = new DateBuilder().setDate(buf.readUnsignedShort(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
        return dateBuilder.getDate();
    }

    private List<Position> decodeLocation(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        LinkedList<Position> positions = new LinkedList<Position>();
        short type = buf.readUnsignedByte();
        buf.readUnsignedInt();
        buf.readUnsignedShort();
        buf.readUnsignedByte();
        buf.readUnsignedShort();
        buf.readUnsignedShort();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, String.format("%015d", buf.readLong()));
        if (deviceSession == null) {
            return null;
        }
        short battery = buf.readUnsignedByte();
        int power = buf.readUnsignedShort();
        if (type == 8) {
            buf.readUnsignedByte();
            buf.readUnsignedByte();
        }
        buf.readUnsignedByte();
        short satellites = buf.readUnsignedByte();
        if (type != 100) {
            buf.readUnsignedByte();
        }
        if (type == 3) {
            buf.readUnsignedByte();
            short b = buf.readUnsignedByte();
            while ((b & 0xF) != 15 && (b & 0xF0) != 240) {
                b = buf.readUnsignedByte();
            }
        }
        if (type == 100) {
            count = buf.readUnsignedShort();
            int speed = 0;
            int heading = 0;
            int latitude = 0;
            int longitude = 0;
            long time = 0L;
            block5: for (int i = 0; i < count; ++i) {
                if (time > 0L) {
                    ++time;
                }
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                switch (BitUtil.from(buf.getUnsignedByte(buf.readerIndex()), 6)) {
                    case 1: {
                        BitBuffer bits = new BitBuffer(buf.readSlice(3));
                        bits.readUnsigned(2);
                        bits.readUnsigned(1);
                        speed = bits.readUnsigned(12);
                        heading = bits.readUnsigned(9);
                        longitude = buf.readInt();
                        latitude = buf.readInt();
                        if (time != 0L) break;
                        time = buf.readUnsignedInt();
                        break;
                    }
                    case 2: {
                        BitBuffer bits = new BitBuffer(buf.readSlice(5));
                        bits.readUnsigned(2);
                        bits.readUnsigned(1);
                        speed += bits.readSigned(7);
                        heading += bits.readSigned(7);
                        longitude += bits.readSigned(12);
                        latitude += bits.readSigned(11);
                        break;
                    }
                    default: {
                        buf.readUnsignedByte();
                        continue block5;
                    }
                }
                position.setValid(true);
                position.setTime(new Date(time * 1000L));
                position.setSpeed(UnitsConverter.knotsFromKph((double)speed * 0.1));
                position.setCourse(heading);
                position.setLongitude((double)longitude * 1.0E-6);
                position.setLatitude((double)latitude * 1.0E-6);
                positions.add(position);
            }
        } else {
            count = buf.readUnsignedByte();
            for (int i = 0; i < count; ++i) {
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                position.set("batteryLevel", Integer.valueOf(battery));
                position.set("power", power);
                position.set("sat", Integer.valueOf(satellites));
                short hdop = buf.readUnsignedByte();
                position.setValid(hdop > 0);
                position.set("hdop", Integer.valueOf(hdop));
                position.setSpeed(UnitsConverter.knotsFromKph((double)buf.readUnsignedMedium() * 0.1));
                position.setCourse(buf.readUnsignedShort());
                position.setAltitude(buf.readShort());
                position.setLongitude((double)buf.readInt() * 1.0E-6);
                position.setLatitude((double)buf.readInt() * 1.0E-6);
                position.setTime(this.decodeTime(buf));
                position.setNetwork(new Network(CellTower.from(buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedShort())));
                buf.readUnsignedByte();
                positions.add(position);
            }
        }
        return positions;
    }

    private Position decodeEvent(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        Position position = new Position(this.getProtocolName());
        short type = buf.readUnsignedByte();
        buf.readUnsignedInt();
        buf.readUnsignedShort();
        buf.readUnsignedByte();
        buf.readUnsignedShort();
        position.set("versionFw", String.valueOf(buf.readUnsignedShort()));
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, String.format("%015d", buf.readLong()));
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("batteryLevel", buf.readUnsignedByte());
        position.set("power", buf.readUnsignedShort());
        buf.readUnsignedByte();
        position.set("sat", buf.readUnsignedByte());
        switch (type) {
            case 6: {
                buf.readUnsignedShort();
                break;
            }
            case 45: 
            case 46: {
                buf.readUnsignedShort();
                buf.readUnsignedByte();
                buf.readUnsignedInt();
                break;
            }
            case 15: {
                buf.readUnsignedShort();
                buf.readUnsignedByte();
                break;
            }
            case 17: {
                buf.readUnsignedInt();
                break;
            }
            case 21: {
                buf.readUnsignedByte();
                buf.readUnsignedInt();
                break;
            }
            case 26: {
                buf.readUnsignedShort();
                buf.readUnsignedByte();
                buf.readUnsignedByte();
                buf.readUnsignedInt();
                buf.readUnsignedInt();
                break;
            }
            case 31: {
                buf.readUnsignedByte();
                buf.readUnsignedByte();
                break;
            }
            case 35: {
                buf.readUnsignedByte();
                break;
            }
            case 33: {
                buf.readUnsignedByte();
                break;
            }
            case 23: {
                buf.readUnsignedByte();
                break;
            }
            case 34: {
                buf.readUnsignedByte();
                buf.readUnsignedShort();
            }
        }
        buf.readUnsignedByte();
        short hdop = buf.readUnsignedByte();
        position.setValid(hdop > 0);
        position.set("hdop", Integer.valueOf(hdop));
        position.setSpeed(UnitsConverter.knotsFromKph((double)buf.readUnsignedMedium() * 0.1));
        position.setCourse(buf.readUnsignedShort());
        position.setAltitude(buf.readShort());
        position.setLongitude((double)buf.readInt() * 1.0E-6);
        position.setLatitude((double)buf.readInt() * 1.0E-6);
        position.setTime(this.decodeTime(buf));
        position.setNetwork(new Network(CellTower.from(buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedShort())));
        buf.readUnsignedByte();
        return position;
    }

    private Position decodeInformation(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        Position position = new Position(this.getProtocolName());
        short type = buf.readUnsignedByte();
        buf.readUnsignedInt();
        buf.readUnsignedShort();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, String.format("%015d", buf.readLong()));
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        buf.readUnsignedByte();
        buf.readUnsignedShort();
        position.set("versionFw", String.valueOf(buf.readUnsignedShort()));
        if (type == 6) {
            buf.readUnsignedShort();
            buf.readUnsignedShort();
            buf.readUnsignedShort();
        }
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        position.set("sat", buf.readUnsignedByte());
        buf.readUnsignedByte();
        buf.skipBytes(7);
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        buf.readUnsignedShort();
        buf.readUnsignedShort();
        buf.readUnsignedShort();
        buf.readUnsignedInt();
        buf.readUnsignedByte();
        if (type == 7) {
            position.set("charge", buf.readUnsignedByte() != 0);
            position.set("power", (double)buf.readUnsignedShort() * 0.001);
            position.set("battery", (double)buf.readUnsignedShort() * 0.001);
            position.set("batteryLevel", buf.readUnsignedByte());
        }
        buf.skipBytes(10);
        if (type == 5) {
            position.set("rssi", buf.readUnsignedByte());
            buf.readUnsignedByte();
        }
        buf.readUnsignedByte();
        buf.readUnsignedShort();
        if (type == 10) {
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            position.setNetwork(new Network(CellTower.from(buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedShort())));
            buf.readUnsignedByte();
            buf.readUnsignedByte();
        }
        this.getLastLocation(position, this.decodeTime(buf));
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        return switch (buf.readSlice(4).toString(StandardCharsets.US_ASCII)) {
            case "+RSP" -> this.decodeLocation(channel, remoteAddress, buf);
            case "+INF" -> this.decodeInformation(channel, remoteAddress, buf);
            case "+EVT" -> this.decodeEvent(channel, remoteAddress, buf);
            default -> null;
        };
    }
}

