;;;
;;; Copyright (c) 2010-2013 uim Project https://github.com/uim/uim
;;;
;;; All rights reserved.
;;;
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above copyright
;;;    notice, this list of conditions and the following disclaimer in the
;;;    documentation and/or other materials provided with the distribution.
;;; 3. Neither the name of authors nor the names of its contributors
;;;    may be used to endorse or promote products derived from this software
;;;    without specific prior written permission.
;;;
;;; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND
;;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE
;;; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
;;; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;;; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
;;; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
;;; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
;;; SUCH DAMAGE.
;;;;

;; Japanese EUC
(define ja-act-rule-basic
  '( 

((("a"). ())("" "" ""))
((("b" "a"). ())("" "" "ʎ"))
((("b" "e"). ())("" "" "͎"))
((("b" "i"). ())("" "" "ˎ"))
((("b" "o"). ())("" "" "Ύ"))
((("b" "u"). ())("" "" "̎"))
((("d" "a"). ())("" "" ""))
((("d" "e"). ())("" "" "Î"))
((("d" "i"). ())("" "" ""))
((("d" "o"). ())("" "" "Ď"))
((("d" "u"). ())("" "" ""))
((("e"). ())("" "" ""))
((("f" "a"). ())(("" "" "") ("" "" "")))
((("f" "e"). ())(("" "" "") ("" "" "")))
((("f" "i"). ())(("" "" "") ("" "" "")))
((("f" "o"). ())(("" "" "") ("" "" "")))
((("f" "u"). ())("" "" ""))
((("g" "a"). ())("" "" ""))
((("g" "e"). ())("" "" ""))
((("g" "i"). ())("" "" ""))
((("g" "o"). ())("" "" ""))
((("g" "u"). ())("" "" ""))
((("h" "a"). ())("" "" ""))
((("h" "e"). ())("" "" ""))
((("h" "i"). ())("" "" ""))
((("h" "o"). ())("" "" ""))
((("h" "u"). ())("" "" ""))
((("i"). ())("" "" ""))
((("m" "a"). ())("" "" ""))
((("m" "e"). ())("" "" ""))
((("m" "i"). ())("" "" ""))
((("m" "o"). ())("" "" ""))
((("m" "u"). ())("" "" ""))
((("n"). ())("" "" ""))
((("n" "a"). ())("" "" ""))
((("n" "e"). ())("" "" ""))
((("n" "i"). ())("" "" ""))
((("n" "n"). ())("" "" ""))
((("n" "o"). ())("" "" ""))
((("n" "u"). ())("" "" ""))
((("o"). ())("" "" ""))
((("p" "a"). ())("" "" "ʎ"))
((("p" "e"). ())("" "" "͎"))
((("p" "i"). ())("" "" "ˎ"))
((("p" "o"). ())("" "" "Ύ"))
((("p" "u"). ())("" "" "̎"))
((("r" "a"). ())("" "" ""))
((("r" "e"). ())("" "" ""))
((("r" "i"). ())("" "" ""))
((("r" "o"). ())("" "" ""))
((("r" "u"). ())("" "" ""))
((("s" "a"). ())("" "" ""))
((("s" "e"). ())("" "" ""))
((("s" "h" "a"). ())(("" "" "") ("" "" "")))
((("s" "h" "e"). ())(("" "" "") ("" "" "")))
((("s" "h" "i"). ())("" "" ""))
((("s" "h" "o"). ())(("" "" "") ("" "" "")))
((("s" "h" "u"). ())(("" "" "") ("" "" "")))
((("s" "i"). ())("" "" ""))
((("s" "o"). ())("" "" ""))
((("s" "u"). ())("" "" ""))
((("t" "a"). ())("" "" ""))
((("t" "e"). ())("" "" ""))
((("t" "i"). ())("" "" ""))
((("t" "o"). ())("" "" ""))
((("t" "u"). ())("" "" ""))
((("u"). ())("" "" ""))
((("v" "a"). ())(("" "" "") ("" "" "")))
((("v" "e"). ())(("" "" "") ("" "" "")))
((("v" "i"). ())(("" "" "") ("" "" "")))
((("v" "o"). ())(("" "" "") ("" "" "")))
((("v" "u"). ())("" "" ""))
((("w" "a"). ())("" "" ""))
((("w" "e"). ())(("" "" "") ("" "" "")))
((("w" "i"). ())(("" "" "") ("" "" "")))
((("w" "o"). ())("" "" ""))
((("w" "u"). ())("" "" ""))
((("y" "a"). ())("" "" ""))
((("y" "e"). ())(("" "" "") ("" "" "")))
((("y" "o"). ())("" "" ""))
((("y" "u"). ())("" "" ""))
((("z" "a"). ())("" "" ""))
((("z" "e"). ())("" "" ""))
((("z" "i"). ())("" "" ""))
((("z" "o"). ())("" "" ""))
((("z" "u"). ())("" "" ""))
((("'"). ())("" "" ""))
((("`" "a"). ())("" "" ""))
((("`" "i"). ())("" "" ""))
((("`" "u"). ())("" "" ""))
((("`" "e"). ())("" "" ""))
((("`" "o"). ())("" "" ""))
((("`" "c" "a"). ())("" "" ""))
((("`" "c" "e"). ())("" "" ""))
((("`" "w" "a"). ())("" "" ""))
((("`" "w" "e"). ())("" "" ""))
((("`" "w" "i"). ())("" "" ""))
((("`" "y" "a"). ())("" "" ""))
((("`" "y" "o"). ())("" "" ""))
((("`" "y" "u"). ())("" "" ""))
((("`" "y" "s"). ())("" "" ""))
((("`" "y" "n"). ())("" "" ""))
((("`" "y" "h"). ())("" "" ""))
((("c" "a"). ())("" "" ""))
((("c" "i"). ())("" "" ""))
((("c" "u"). ())("" "" ""))
((("c" "e"). ())("" "" ""))
((("c" "o"). ())("" "" ""))
(((";"). ())(("" "" "") ("" "" "")))
((("x"). ())(("" "" "") ("" "" "")))
((("k"). ())(("" "" "") ("" "" "")))
((("j"). ())(("" "" "") ("" "" "")))
((("q"). ())(("" "" "") ("" "" "")))
((("c" ";"). ())(("" "" "") ("" "" "")))
((("c" "x"). ())(("" "" "") ("" "" "")))
((("c" "k"). ())(("" "" "") ("" "" "")))
((("c" "j"). ())(("" "" "") ("" "" "")))
((("c" "q"). ())(("" "" "") ("" "" "")))
((("c" "'"). ())(("" "" "") ("" "" "")))
((("c" "p"). ())(("" "" "") ("" "" "")))
((("c" "."). ())(("" "" "") ("" "" "")))
((("c" ","). ())(("" "" "") ("" "" "")))
((("s" ";"). ())(("" "" "") ("" "" "")))
((("s" "x"). ())(("" "" "") ("" "" "")))
((("s" "k"). ())(("" "" "") ("" "" "")))
((("s" "j"). ())(("" "" "") ("" "" "")))
((("s" "q"). ())(("" "" "") ("" "" "")))
((("s" "'"). ())(("" "" "") ("" "" "")))
((("s" "p"). ())(("" "" "") ("" "" "")))
((("s" "."). ())(("" "" "") ("" "" "")))
((("s" ","). ())(("" "" "") ("" "" "")))
((("t" ";"). ())(("" "" "") ("" "" "")))
((("t" "x"). ())(("" "" "") ("" "" "")))
((("t" "k"). ())(("" "" "") ("" "" "")))
((("t" "j"). ())(("" "" "") ("" "" "")))
((("t" "q"). ())(("" "" "") ("" "" "")))
((("t" "'"). ())(("" "" "") ("" "" "")))
((("t" "p"). ())(("" "" "") ("" "" "")))
((("t" "."). ())(("" "" "") ("" "" "")))
((("t" ","). ())(("" "" "") ("" "" "")))
((("n" ";"). ())(("" "" "") ("" "" "")))
((("n" "x"). ())(("" "" "") ("" "" "")))
((("n" "k"). ())(("" "" "") ("" "" "")))
((("n" "j"). ())(("" "" "") ("" "" "")))
((("n" "q"). ())(("" "" "") ("" "" "")))
((("n" "'"). ())(("" "" "") ("" "" "")))
((("n" "p"). ())(("" "" "") ("" "" "")))
((("n" "."). ())(("" "" "") ("" "" "")))
((("n" ","). ())(("" "" "") ("" "" "")))
((("h" ";"). ())(("" "" "") ("" "" "")))
((("h" "x"). ())(("" "" "") ("" "" "")))
((("h" "k"). ())(("" "" "") ("" "" "")))
((("h" "j"). ())(("" "" "") ("" "" "")))
((("h" "q"). ())(("" "" "") ("" "" "")))
((("h" "'"). ())(("" "" "") ("" "" "")))
((("h" "p"). ())(("" "" "") ("" "" "")))
((("h" "."). ())(("" "" "") ("" "" "")))
((("h" ","). ())(("" "" "") ("" "" "")))
((("m" ";"). ())(("" "" "") ("" "" "")))
((("m" "x"). ())(("" "" "") ("" "" "")))
((("m" "k"). ())(("" "" "") ("" "" "")))
((("m" "j"). ())(("" "" "") ("" "" "")))
((("m" "q"). ())(("" "" "") ("" "" "")))
((("m" "'"). ())(("" "" "") ("" "" "")))
((("m" "p"). ())(("" "" "") ("" "" "")))
((("m" "."). ())(("" "" "") ("" "" "")))
((("m" ","). ())(("" "" "") ("" "" "")))
((("y" ";"). ())(("" "" "") ("" "" "")))
((("y" "k"). ())(("" "" "") ("" "" "")))
((("y" "q"). ())(("" "" "") ("" "" "")))
((("y" "'"). ())(("" "" "") ("" "" "")))
((("y" "p"). ())(("" "" "") ("" "" "")))
((("y" "."). ())(("" "" "") ("" "" "")))
((("y" ","). ())(("" "" "") ("" "" "")))
((("r" ";"). ())(("" "" "") ("" "" "")))
((("r" "x"). ())(("" "" "") ("" "" "")))
((("r" "k"). ())(("" "" "") ("" "" "")))
((("r" "j"). ())(("" "" "") ("" "" "")))
((("r" "q"). ())(("" "" "") ("" "" "")))
((("r" "'"). ())(("" "" "") ("" "" "")))
((("r" "p"). ())(("" "" "") ("" "" "")))
((("r" "."). ())(("" "" "") ("" "" "")))
((("r" ","). ())(("" "" "") ("" "" "")))
((("w" ";"). ())(("" "" "") ("" "" "")))
((("w" "x"). ())(("" "" "") ("" "" "") ("" "" "")))
((("w" "k"). ())(("" "" "") ("" "" "")))
((("w" "j"). ())(("" "" "") ("" "" "") ("" "" "")))
((("w" "q"). ())(("" "" "") ("" "" "") ("" "" "")))
((("w" "'"). ())(("" "" "") ("" "" "")))
((("w" "p"). ())(("" "" "") ("" "" "")))
((("w" "."). ())(("" "" "") ("" "" "") ("" "" "")))
((("w" ","). ())(("" "" "") ("" "" "") ("" "" "")))
((("g" ";"). ())(("" "" "") ("" "" "")))
((("g" "x"). ())(("" "" "") ("" "" "")))
((("g" "k"). ())(("" "" "") ("" "" "")))
((("g" "j"). ())(("" "" "") ("" "" "")))
((("g" "q"). ())(("" "" "") ("" "" "")))
((("g" "'"). ())(("" "" "") ("" "" "")))
((("g" "p"). ())(("" "" "") ("" "" "")))
((("g" "."). ())(("" "" "") ("" "" "")))
((("g" ","). ())(("" "" "") ("" "" "")))
((("z" ";"). ())(("" "" "") ("" "" "")))
((("z" "x"). ())(("" "" "") ("" "" "")))
((("z" "k"). ())(("" "" "") ("" "" "")))
((("z" "j"). ())(("" "" "") ("" "" "")))
((("z" "q"). ())(("" "" "") ("" "" "")))
((("z" "'"). ())(("" "" "") ("" "" "")))
((("z" "p"). ())(("" "" "") ("" "" "")))
((("z" "."). ())(("" "" "") ("" "" "")))
((("z" ","). ())(("" "" "") ("" "" "")))
((("d" ";"). ())(("" "" "") ("" "" "")))
((("d" "x"). ())(("" "" "") ("" "" "")))
((("d" "k"). ())(("" "" "") ("" "" "")))
((("d" "j"). ())(("" "" "Î") ("" "" "")))
((("d" "q"). ())(("" "" "Ď") ("" "" "")))
((("d" "'"). ())(("" "" "") ("" "" "")))
((("d" "p"). ())(("" "" "") ("" "" "")))
((("d" "."). ())(("" "" "Î") ("" "" "")))
((("d" ","). ())(("" "" "Ď") ("" "" "")))
((("b" ";"). ())(("" "" "ʎ") ("" "" "")))
((("b" "x"). ())(("" "" "ˎ") ("" "" "")))
((("b" "k"). ())(("" "" "̎") ("" "" "")))
((("b" "j"). ())(("" "" "͎") ("" "" "")))
((("b" "q"). ())(("" "" "Ύ") ("" "" "")))
((("b" "'"). ())(("" "" "ʎ") ("" "" "")))
((("b" "p"). ())(("" "" "̎") ("" "" "")))
((("b" "."). ())(("" "" "͎") ("" "" "")))
((("b" ","). ())(("" "" "Ύ") ("" "" "")))
((("p" ";"). ())(("" "" "ʎ") ("" "" "")))
((("p" "x"). ())(("" "" "ˎ") ("" "" "")))
((("p" "k"). ())(("" "" "̎") ("" "" "")))
((("p" "j"). ())(("" "" "͎") ("" "" "")))
((("p" "q"). ())(("" "" "Ύ") ("" "" "")))
((("p" "'"). ())(("" "" "ʎ") ("" "" "")))
((("p" "p"). ())(("" "" "̎") ("" "" "")))
((("p" "."). ())(("" "" "͎") ("" "" "")))
((("p" ","). ())(("" "" "Ύ") ("" "" "")))
((("c" "g" "a"). ())(("" "" "") ("" "" "")))
((("c" "g" "i"). ())(("" "" "") ("" "" "")))
((("c" "g" "u"). ())(("" "" "") ("" "" "")))
((("c" "g" "e"). ())(("" "" "") ("" "" "")))
((("c" "g" "o"). ())(("" "" "") ("" "" "")))
((("c" "g" ";"). ())(("" "" "") ("" "" "") ("" "" "")))
((("c" "g" "x"). ())(("" "" "") ("" "" "") ("" "" "")))
((("c" "g" "k"). ())(("" "" "") ("" "" "") ("" "" "")))
((("c" "g" "j"). ())(("" "" "") ("" "" "") ("" "" "")))
((("c" "g" "q"). ())(("" "" "") ("" "" "") ("" "" "")))
((("c" "g" "'"). ())(("" "" "") ("" "" "") ("" "" "")))
((("c" "g" "p"). ())(("" "" "") ("" "" "") ("" "" "")))
((("c" "g" "."). ())(("" "" "") ("" "" "") ("" "" "")))
((("c" "g" ","). ())(("" "" "") ("" "" "") ("" "" "")))
((("s" "h" "a"). ())(("" "" "") ("" "" "")))
((("s" "h" "i"). ())(("" "" "") ("" "" "")))
((("s" "h" "u"). ())(("" "" "") ("" "" "")))
((("s" "h" "e"). ())(("" "" "") ("" "" "")))
((("s" "h" "o"). ())(("" "" "") ("" "" "")))
((("s" "h" ";"). ())(("" "" "") ("" "" "") ("" "" "")))
((("s" "h" "x"). ())(("" "" "") ("" "" "") ("" "" "")))
((("s" "h" "k"). ())(("" "" "") ("" "" "") ("" "" "")))
((("s" "h" "j"). ())(("" "" "") ("" "" "") ("" "" "")))
((("s" "h" "q"). ())(("" "" "") ("" "" "") ("" "" "")))
((("s" "h" "'"). ())(("" "" "") ("" "" "") ("" "" "")))
((("s" "h" "p"). ())(("" "" "") ("" "" "") ("" "" "")))
((("s" "h" "."). ())(("" "" "") ("" "" "") ("" "" "")))
((("s" "h" ","). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "h" "a"). ())(("" "" "") ("" "" "")))
((("t" "h" "i"). ())(("" "" "") ("" "" "")))
((("t" "h" "u"). ())(("" "" "") ("" "" "")))
((("t" "h" "e"). ())(("" "" "") ("" "" "")))
((("t" "h" "o"). ())(("" "" "") ("" "" "")))
((("t" "h" ";"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "h" "x"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "h" "k"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "h" "j"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "h" "q"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "h" "'"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "h" "p"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "h" "."). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "h" ","). ())(("" "" "") ("" "" "") ("" "" "")))
((("n" "h" "a"). ())(("" "" "") ("" "" "")))
((("n" "h" "i"). ())(("" "" "") ("" "" "")))
((("n" "h" "u"). ())(("" "" "") ("" "" "")))
((("n" "h" "e"). ())(("" "" "") ("" "" "")))
((("n" "h" "o"). ())(("" "" "") ("" "" "")))
((("n" "h" ";"). ())(("" "" "") ("" "" "") ("" "" "")))
((("n" "h" "x"). ())(("" "" "") ("" "" "") ("" "" "")))
((("n" "h" "k"). ())(("" "" "") ("" "" "") ("" "" "")))
((("n" "h" "j"). ())(("" "" "") ("" "" "") ("" "" "")))
((("n" "h" "q"). ())(("" "" "") ("" "" "") ("" "" "")))
((("n" "h" "'"). ())(("" "" "") ("" "" "") ("" "" "")))
((("n" "h" "p"). ())(("" "" "") ("" "" "") ("" "" "")))
((("n" "h" "."). ())(("" "" "") ("" "" "") ("" "" "")))
((("n" "h" ","). ())(("" "" "") ("" "" "") ("" "" "")))
((("h" "n" "a"). ())(("" "" "") ("" "" "")))
((("h" "n" "i"). ())(("" "" "") ("" "" "")))
((("h" "n" "u"). ())(("" "" "") ("" "" "")))
((("h" "n" "e"). ())(("" "" "") ("" "" "")))
((("h" "n" "o"). ())(("" "" "") ("" "" "")))
((("h" "n" ";"). ())(("" "" "") ("" "" "") ("" "" "")))
((("h" "n" "x"). ())(("" "" "") ("" "" "") ("" "" "")))
((("h" "n" "k"). ())(("" "" "") ("" "" "") ("" "" "")))
((("h" "n" "j"). ())(("" "" "") ("" "" "") ("" "" "")))
((("h" "n" "q"). ())(("" "" "") ("" "" "") ("" "" "")))
((("h" "n" "'"). ())(("" "" "") ("" "" "") ("" "" "")))
((("h" "n" "p"). ())(("" "" "") ("" "" "") ("" "" "")))
((("h" "n" "."). ())(("" "" "") ("" "" "") ("" "" "")))
((("h" "n" ","). ())(("" "" "") ("" "" "") ("" "" "")))
((("m" "v" "a"). ())(("" "" "") ("" "" "")))
((("m" "v" "i"). ())(("" "" "") ("" "" "")))
((("m" "v" "u"). ())(("" "" "") ("" "" "")))
((("m" "v" "e"). ())(("" "" "") ("" "" "")))
((("m" "v" "o"). ())(("" "" "") ("" "" "")))
((("m" "v" ";"). ())(("" "" "") ("" "" "") ("" "" "")))
((("m" "v" "x"). ())(("" "" "") ("" "" "") ("" "" "")))
((("m" "v" "k"). ())(("" "" "") ("" "" "") ("" "" "")))
((("m" "v" "j"). ())(("" "" "") ("" "" "") ("" "" "")))
((("m" "v" "q"). ())(("" "" "") ("" "" "") ("" "" "")))
((("m" "v" "'"). ())(("" "" "") ("" "" "") ("" "" "")))
((("m" "v" "p"). ())(("" "" "") ("" "" "") ("" "" "")))
((("m" "v" "."). ())(("" "" "") ("" "" "") ("" "" "")))
((("m" "v" ","). ())(("" "" "") ("" "" "") ("" "" "")))
((("r" "g" "a"). ())(("" "" "") ("" "" "")))
((("r" "g" "i"). ())(("" "" "") ("" "" "")))
((("r" "g" "u"). ())(("" "" "") ("" "" "")))
((("r" "g" "e"). ())(("" "" "") ("" "" "")))
((("r" "g" "o"). ())(("" "" "") ("" "" "")))
((("r" "g" ";"). ())(("" "" "") ("" "" "") ("" "" "")))
((("r" "g" "x"). ())(("" "" "") ("" "" "") ("" "" "")))
((("r" "g" "k"). ())(("" "" "") ("" "" "") ("" "" "")))
((("r" "g" "j"). ())(("" "" "") ("" "" "") ("" "" "")))
((("r" "g" "q"). ())(("" "" "") ("" "" "") ("" "" "")))
((("r" "g" "'"). ())(("" "" "") ("" "" "") ("" "" "")))
((("r" "g" "p"). ())(("" "" "") ("" "" "") ("" "" "")))
((("r" "g" "."). ())(("" "" "") ("" "" "") ("" "" "")))
((("r" "g" ","). ())(("" "" "") ("" "" "") ("" "" "")))
((("g" "r" "a"). ())(("" "" "") ("" "" "")))
((("g" "r" "i"). ())(("" "" "") ("" "" "")))
((("g" "r" "u"). ())(("" "" "") ("" "" "")))
((("g" "r" "e"). ())(("" "" "") ("" "" "")))
((("g" "r" "o"). ())(("" "" "") ("" "" "")))
((("g" "r" ";"). ())(("" "" "") ("" "" "") ("" "" "")))
((("g" "r" "x"). ())(("" "" "") ("" "" "") ("" "" "")))
((("g" "r" "k"). ())(("" "" "") ("" "" "") ("" "" "")))
((("g" "r" "j"). ())(("" "" "") ("" "" "") ("" "" "")))
((("g" "r" "q"). ())(("" "" "") ("" "" "") ("" "" "")))
((("g" "r" "'"). ())(("" "" "") ("" "" "") ("" "" "")))
((("g" "r" "p"). ())(("" "" "") ("" "" "") ("" "" "")))
((("g" "r" "."). ())(("" "" "") ("" "" "") ("" "" "")))
((("g" "r" ","). ())(("" "" "") ("" "" "") ("" "" "")))
((("z" "m" "a"). ())(("" "" "") ("" "" "")))
((("z" "m" "i"). ())(("" "" "") ("" "" "")))
((("z" "m" "u"). ())(("" "" "") ("" "" "")))
((("z" "m" "e"). ())(("" "" "") ("" "" "")))
((("z" "m" "o"). ())(("" "" "") ("" "" "")))
((("z" "m" ";"). ())(("" "" "") ("" "" "") ("" "" "")))
((("z" "m" "x"). ())(("" "" "") ("" "" "") ("" "" "")))
((("z" "m" "k"). ())(("" "" "") ("" "" "") ("" "" "")))
((("z" "m" "j"). ())(("" "" "") ("" "" "") ("" "" "")))
((("z" "m" "q"). ())(("" "" "") ("" "" "") ("" "" "")))
((("z" "m" "'"). ())(("" "" "") ("" "" "") ("" "" "")))
((("z" "m" "p"). ())(("" "" "") ("" "" "") ("" "" "")))
((("z" "m" "."). ())(("" "" "") ("" "" "") ("" "" "")))
((("z" "m" ","). ())(("" "" "") ("" "" "") ("" "" "")))
((("d" "n" "a"). ())(("" "" "") ("" "" "")))
((("d" "n" "i"). ())(("" "" "") ("" "" "")))
((("d" "n" "u"). ())(("" "" "") ("" "" "")))
((("d" "n" "e"). ())(("" "" "") ("" "" "")))
((("d" "n" "o"). ())(("" "" "") ("" "" "")))
((("d" "n" ";"). ())(("" "" "") ("" "" "") ("" "" "")))
((("d" "n" "x"). ())(("" "" "") ("" "" "") ("" "" "")))
((("d" "n" "k"). ())(("" "" "") ("" "" "") ("" "" "")))
((("d" "n" "j"). ())(("" "" "") ("" "" "") ("" "" "")))
((("d" "n" "q"). ())(("" "" "") ("" "" "") ("" "" "")))
((("d" "n" "'"). ())(("" "" "") ("" "" "") ("" "" "")))
((("d" "n" "p"). ())(("" "" "") ("" "" "") ("" "" "")))
((("d" "n" "."). ())(("" "" "") ("" "" "") ("" "" "")))
((("d" "n" ","). ())(("" "" "") ("" "" "") ("" "" "")))
((("b" "v" "a"). ())(("" "" "ˎ") ("" "" "")))
((("b" "v" "i"). ())(("" "" "ˎ") ("" "" "")))
((("b" "v" "u"). ())(("" "" "ˎ") ("" "" "")))
((("b" "v" "e"). ())(("" "" "ˎ") ("" "" "")))
((("b" "v" "o"). ())(("" "" "ˎ") ("" "" "")))
((("b" "v" ";"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("b" "v" "x"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("b" "v" "k"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("b" "v" "j"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("b" "v" "q"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("b" "v" "'"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("b" "v" "p"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("b" "v" "."). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("b" "v" ","). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("p" "n" "a"). ())(("" "" "ˎ") ("" "" "")))
((("p" "n" "i"). ())(("" "" "ˎ") ("" "" "")))
((("p" "n" "u"). ())(("" "" "ˎ") ("" "" "")))
((("p" "n" "e"). ())(("" "" "ˎ") ("" "" "")))
((("p" "n" "o"). ())(("" "" "ˎ") ("" "" "")))
((("p" "n" ";"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("p" "n" "x"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("p" "n" "k"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("p" "n" "j"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("p" "n" "q"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("p" "n" "'"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("p" "n" "p"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("p" "n" "."). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("p" "n" ","). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("f" ";"). ())(("" "" "") ("" "" "") ("" "" "")))
((("f" "x"). ())(("" "" "") ("" "" "") ("" "" "")))
((("f" "k"). ())(("" "" "") ("" "" "")))
((("f" "j"). ())(("" "" "") ("" "" "") ("" "" "")))
((("f" "q"). ())(("" "" "") ("" "" "") ("" "" "")))
((("f" "'"). ())(("" "" "") ("" "" "") ("" "" "")))
((("f" "p"). ())(("" "" "") ("" "" "")))
((("f" "."). ())(("" "" "") ("" "" "") ("" "" "")))
((("f" ","). ())(("" "" "") ("" "" "") ("" "" "")))
((("v" ";"). ())(("" "" "") ("" "" "") ("" "" "")))
((("v" "x"). ())(("" "" "") ("" "" "") ("" "" "")))
((("v" "k"). ())(("" "" "") ("" "" "")))
((("v" "j"). ())(("" "" "") ("" "" "") ("" "" "")))
((("v" "q"). ())(("" "" "") ("" "" "") ("" "" "")))
((("v" "'"). ())(("" "" "") ("" "" "") ("" "" "")))
((("v" "p"). ())(("" "" "") ("" "" "")))
((("v" "."). ())(("" "" "") ("" "" "") ("" "" "")))
((("v" ","). ())(("" "" "") ("" "" "") ("" "" "")))
((("p" "c"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("p" "l"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("f" "c"). ())(("" "" "") ("" "" "") ("" "" "")))
((("f" "l"). ())(("" "" "") ("" "" "") ("" "" "")))
((("g" "c"). ())(("" "" "") ("" "" "") ("" "" "")))
((("g" "l"). ())(("" "" "") ("" "" "") ("" "" "")))
((("c" "c"). ())(("" "" "") ("" "" "") ("" "" "")))
((("c" "l"). ())(("" "" "") ("" "" "") ("" "" "")))
((("r" "c"). ())(("" "" "") ("" "" "") ("" "" "")))
((("r" "l"). ())(("" "" "") ("" "" "") ("" "" "")))
((("h" "t"). ())(("" "" "") ("" "" "") ("" "" "")))
((("h" "s"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "t"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "s"). ())(("" "" "") ("" "" "") ("" "" "")))
((("n" "t"). ())(("" "" "") ("" "" "") ("" "" "")))
((("n" "s"). ())(("" "" "") ("" "" "") ("" "" "")))
((("s" "t"). ())(("" "" "") ("" "" "") ("" "" "")))
((("s" "s"). ())(("" "" "") ("" "" "") ("" "" "")))
((("b" "w"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("b" "z"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("m" "w"). ())(("" "" "") ("" "" "") ("" "" "")))
((("m" "z"). ())(("" "" "") ("" "" "") ("" "" "")))
((("w" "z"). ())(("" "" "") ("" "" "") ("" "" "")))
((("v" "w"). ())(("" "" "") ("" "" "") ("" "" "")))
((("v" "z"). ())(("" "" "") ("" "" "") ("" "" "")))
((("z" "w"). ())(("" "" "") ("" "" "") ("" "" "")))
((("z" "z"). ())(("" "" "") ("" "" "") ("" "" "")))
((("g" "r" "r"). ())(("" "" "") ("" "" "") ("" "" "")))
((("g" "r" "l"). ())(("" "" "") ("" "" "") ("" "" "")))
((("c" "g" "r"). ())(("" "" "") ("" "" "") ("" "" "")))
((("c" "g" "l"). ())(("" "" "") ("" "" "") ("" "" "")))
((("r" "g" "r"). ())(("" "" "") ("" "" "") ("" "" "")))
((("r" "g" "l"). ())(("" "" "") ("" "" "") ("" "" "")))
((("h" "n" "s"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "h" "n"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "h" "s"). ())(("" "" "") ("" "" "") ("" "" "")))
((("n" "h" "n"). ())(("" "" "") ("" "" "") ("" "" "")))
((("n" "h" "s"). ())(("" "" "") ("" "" "") ("" "" "")))
((("s" "h" "n"). ())(("" "" "") ("" "" "") ("" "" "")))
((("s" "h" "s"). ())(("" "" "") ("" "" "") ("" "" "")))
((("s" "h" "t"). ())(("" "" "") ("" "" "") ("" "" "")))
((("p" "n" "s"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("b" "v" "v"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("b" "v" "z"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("m" "v" "v"). ())(("" "" "") ("" "" "") ("" "" "")))
((("m" "v" "z"). ())(("" "" "") ("" "" "") ("" "" "")))
((("z" "m" "v"). ())(("" "" "") ("" "" "") ("" "" "")))
((("z" "m" "z"). ())(("" "" "") ("" "" "") ("" "" "")))
((("z" "m" "w"). ())(("" "" "") ("" "" "") ("" "" "")))
((("s" "h" "h"). ())(("" "" "") ("" "" "") ("" "" "")))
((("z" "m" "m"). ())(("" "" "") ("" "" "") ("" "" "")))
((("y" "h"). ())("" "" ""))
((("y" "g"). ())(("" "" "") ("" "" "")))
((("y" "z"). ())(("" "" "") ("" "" "")))
((("y" "m"). ())(("" "" "") ("" "" "")))
((("y" "v"). ())(("" "" "") ("" "" "")))
((("p" "s"). ())("" "" "ʎ"))
((("p" "d"). ())("" "" "ˎ"))
((("p" "h"). ())("" "" "̎"))
((("p" "t"). ())("" "" "͎"))
((("p" "z"). ())(("" "" "ʎ") ("" "" "")))
((("p" "b"). ())(("" "" "ˎ") ("" "" "")))
((("p" "m"). ())(("" "" "̎") ("" "" "")))
((("p" "w"). ())(("" "" "͎") ("" "" "")))
((("p" "v"). ())(("" "" "Ύ") ("" "" "")))
((("y" "y"). ())(("" "" "") ("" "" "")))
((("y" "f"). ())(("" "" "") ("" "" "")))
((("y" "c"). ())(("" "" "") ("" "" "")))
((("y" "r"). ())(("" "" "") ("" "" "")))
((("y" "l"). ())(("" "" "") ("" "" "")))
((("y" "d"). ())(("" "" "") ("" "" "")))
((("y" "t"). ())(("" "" "") ("" "" "") ("" "" "")))
((("y" "n"). ())(("" "" "") ("" "" "")))
((("y" "s"). ())(("" "" "") ("" "" "")))
((("y" "b"). ())(("" "" "") ("" "" "ˎ")))
((("y" "w"). ())(("" "" "") ("" "" "") ("" "" "")))
((("f" "f"). ())(("" "" "") ("" "" "")))
((("f" "g"). ())(("" "" "") ("" "" "")))
((("f" "r"). ())(("" "" "") ("" "" "")))
((("f" "n"). ())(("" "" "") ("" "" "") ("" "" "")))
((("f" "m"). ())(("" "" "") ("" "" "")))
((("g" "t"). ())(("" "" "") ("" "" "")))
((("g" "n"). ())(("" "" "") ("" "" "")))
((("g" "s"). ())(("" "" "") ("" "" "")))
((("c" "r"). ())(("" "" "") ("" "" "")))
((("c" "d"). ())(("" "" "") ("" "" "")))
((("c" "t"). ())(("" "" "") ("" "" "")))
((("c" "b"). ())(("" "" "") ("" "" "") ("" "" "") ("" "" "")))
((("c" "n"). ())(("" "" "") ("" "" "")))
((("c" "s"). ())(("" "" "") ("" "" "")))
((("r" "r"). ())(("" "" "") ("" "" "")))
((("r" "n"). ())(("" "" "") ("" "" "")))
((("d" "g"). ())(("" "" "") ("" "" "")))
((("d" "c"). ())(("" "" "Î") ("" "" "")))
((("d" "r"). ())(("" "" "Î") ("" "" "") ("" "" "")))
((("d" "l"). ())(("" "" "Î") ("" "" "") ("" "" "") ("" "" "")))
((("d" "d"). ())(("" "" "") ("" "" "Î")))
((("d" "t"). ())(("" "" "") ("" "" "")))
((("d" "s"). ())(("" "" "Î") ("" "" "")))
((("d" "m"). ())(("" "" "Î") ("" "" "")))
((("h" "g"). ())(("" "" "") ("" "" "")))
((("h" "c"). ())(("" "" "") ("" "" "") ("" "" "")))
((("h" "r"). ())(("" "" "") ("" "" "") ("" "" "")))
((("h" "l"). ())(("" "" "") ("" "" "") ("" "" "")))
((("h" "d"). ())(("" "" "") ("" "" "Ď")))
((("h" "h"). ())(("" "" "") ("" "" "")))
((("h" "z"). ())(("" "" "") ("" "" "") ("" "" "") ("" "" "")))
((("t" "f"). ())(("" "" "") ("" "" "")))
((("t" "g"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "c"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "r"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "l"). ())(("" "" "") ("" "" "")))
((("t" "d"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "n"). ())(("" "" "") ("" "" "")))
((("t" "b"). ())(("" "" "") ("" "" "ˎ")))
((("t" "m"). ())(("" "" "") ("" "" "")))
((("t" "v"). ())(("" "" "") ("" "" "")))
((("t" "z"). ())(("" "" "") ("" "" "")))
((("n" "f"). ())(("" "" "") ("" "" "")))
((("n" "c"). ())(("" "" "") ("" "" "") ("" "" "") ("" "" "")))
((("n" "r"). ())(("" "" "") ("" "" "")))
((("n" "l"). ())(("" "" "") ("" "" "") ("" "" "")))
((("n" "d"). ())(("" "" "") ("" "" "Ď")))
((("n" "b"). ())(("" "" "") ("" "" "") ("" "" "") ("" "" "ʎ")))
((("n" "m"). ())(("" "" "") ("" "" "") ("" "" "") ("" "" "")))
((("n" "w"). ())(("" "" "") ("" "" "") ("" "" "") ("" "" "")))
((("n" "z"). ())(("" "" "") ("" "" "")))
((("s" "f"). ())(("" "" "") ("" "" "")))
((("s" "g"). ())(("" "" "") ("" "" "")))
((("s" "c"). ())(("" "" "") ("" "" "")))
((("s" "r"). ())(("" "" "") ("" "" "")))
((("s" "d"). ())(("" "" "") ("" "" "")))
((("s" "m"). ())(("" "" "") ("" "" "")))
((("s" "n" "b"). ())(("" "" "") ("" "" "") ("" "" "") ("" "" "") ("" "" "ʎ")))
((("s" "n" "m"). ())(("" "" "") ("" "" "") ("" "" "") ("" "" "") ("" "" "")))
((("s" "n" "t"). ())(("" "" "") ("" "" "") ("" "" "") ("" "" "")))
((("s" "n" "w"). ())(("" "" "") ("" "" "") ("" "" "") ("" "" "") ("" "" "")))
((("s" "z"). ())(("" "" "") ("" "" "") ("" "" "") ("" "" "")))
((("b" "c"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("b" "r"). ())(("" "" "ʎ") ("" "" "")))
((("b" "l"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("b" "h"). ())(("" "" "̎") ("" "" "")))
((("b" "t"). ())(("" "" "͎") ("" "" "")))
((("m" "c"). ())(("" "" "") ("" "" "") ("" "" "")))
((("m" "r"). ())(("" "" "") ("" "" "")))
((("m" "l"). ())(("" "" "") ("" "" "") ("" "" "")))
((("m" "d"). ())(("" "" "") ("" "" "Î")))
((("m" "t"). ())(("" "" "") ("" "" "")))
((("m" "n"). ())(("" "" "") ("" "" "")))
((("m" "s"). ())(("" "" "") ("" "" "")))
((("m" "m"). ())(("" "" "") ("" "" "")))
((("w" "r"). ())(("" "" "") ("" "" "")))
((("w" "t"). ())(("" "" "") ("" "" "") ("" "" "")))
((("w" "n"). ())(("" "" "") ("" "" "") ("" "" "") ("" "" "")))
((("v" "m"). ())(("" "" "") ("" "" "") ("" "" "")))
((("v" "v"). ())(("" "" "") ("" "" "") ("" "" "")))
((("z" "c"). ())(("" "" "") ("" "" "") ("" "" "")))
((("z" "r"). ())(("" "" "") ("" "" "")))
((("z" "t"). ())(("" "" "") ("" "" "")))
((("z" "n"). ())(("" "" "") ("" "" "")))
((("z" "s"). ())(("" "" "") ("" "" "")))
((("p" "f"). ())(("" "" "̎") ("" "" "")))
((("p" "g"). ())(("" "" "̎") ("" "" "")))
((("p" "r"). ())(("" "" "̎") ("" "" "")))
((("t" "w" "a"). ())(("" "" "") ("" "" "")))
((("t" "w" "i"). ())(("" "" "") ("" "" "")))
((("t" "w" "u"). ())(("" "" "") ("" "" "")))
((("t" "w" "e"). ())(("" "" "") ("" "" "")))
((("t" "w" "o"). ())(("" "" "") ("" "" "")))
((("t" "w" ";"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "w" "x"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "w" "k"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "w" "j"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "w" "q"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "w" "'"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "w" "p"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "w" "."). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "w" ","). ())(("" "" "") ("" "" "") ("" "" "")))
((("d" "b" "a"). ())(("" "" "Î") ("" "" "")))
((("d" "b" "i"). ())(("" "" "Î") ("" "" "")))
((("d" "b" "u"). ())(("" "" "Î") ("" "" "")))
((("d" "b" "e"). ())(("" "" "Î") ("" "" "")))
((("d" "b" "o"). ())(("" "" "Î") ("" "" "")))
((("d" "b" ";"). ())(("" "" "Î") ("" "" "") ("" "" "")))
((("d" "b" "x"). ())(("" "" "Î") ("" "" "") ("" "" "")))
((("d" "b" "k"). ())(("" "" "Î") ("" "" "") ("" "" "")))
((("d" "b" "j"). ())(("" "" "Î") ("" "" "") ("" "" "")))
((("d" "b" "q"). ())(("" "" "Î") ("" "" "") ("" "" "")))
((("d" "b" "'"). ())(("" "" "Î") ("" "" "") ("" "" "")))
((("d" "b" "p"). ())(("" "" "Î") ("" "" "") ("" "" "")))
((("d" "b" "."). ())(("" "" "Î") ("" "" "") ("" "" "")))
((("d" "b" ","). ())(("" "" "Î") ("" "" "") ("" "" "")))
((("w" "m" "a"). ())(("" "" "") ("" "" "")))
((("w" "m" "i"). ())(("" "" "") ("" "" "")))
((("w" "m" "u"). ())(("" "" "") ("" "" "")))
((("w" "m" "e"). ())(("" "" "") ("" "" "")))
((("w" "m" "o"). ())(("" "" "") ("" "" "")))
((("w" "m" ";"). ())(("" "" "") ("" "" "") ("" "" "")))
((("w" "m" "x"). ())(("" "" "") ("" "" "") ("" "" "")))
((("w" "m" "k"). ())(("" "" "") ("" "" "") ("" "" "")))
((("w" "m" "j"). ())(("" "" "") ("" "" "") ("" "" "")))
((("w" "m" "q"). ())(("" "" "") ("" "" "") ("" "" "")))
((("w" "m" "'"). ())(("" "" "") ("" "" "") ("" "" "")))
((("w" "m" "p"). ())(("" "" "") ("" "" "") ("" "" "")))
((("w" "m" "."). ())(("" "" "") ("" "" "") ("" "" "")))
((("w" "m" ","). ())(("" "" "") ("" "" "") ("" "" "")))
((("c" "y"). ())(("" "" "") ("" "" "")))
((("s" "y"). ())(("" "" "") ("" "" "")))
((("t" "y"). ())(("" "" "") ("" "" "")))
((("n" "y"). ())(("" "" "") ("" "" "")))
((("h" "y"). ())(("" "" "") ("" "" "")))
((("m" "y"). ())(("" "" "") ("" "" "")))
((("y" "y"). ())(("" "" "") ("" "" "")))
((("r" "y"). ())(("" "" "") ("" "" "")))
((("w" "y"). ())(("" "" "") ("" "" "")))
((("g" "y"). ())(("" "" "") ("" "" "")))
((("z" "y"). ())(("" "" "") ("" "" "")))
((("d" "y"). ())(("" "" "") ("" "" "")))
((("b" "y"). ())(("" "" "̎") ("" "" "")))
((("p" "y"). ())(("" "" "̎") ("" "" "")))
((("c" "g" "y"). ())(("" "" "") ("" "" "") ("" "" "")))
((("s" "h" "y"). ())(("" "" "") ("" "" "") ("" "" "")))
((("t" "h" "y"). ())(("" "" "") ("" "" "") ("" "" "")))
((("n" "h" "y"). ())(("" "" "") ("" "" "") ("" "" "")))
((("h" "n" "y"). ())(("" "" "") ("" "" "") ("" "" "")))
((("m" "v" "y"). ())(("" "" "") ("" "" "") ("" "" "")))
((("r" "g" "y"). ())(("" "" "") ("" "" "") ("" "" "")))
((("g" "r" "y"). ())(("" "" "") ("" "" "") ("" "" "")))
((("z" "m" "y"). ())(("" "" "") ("" "" "") ("" "" "")))
((("d" "n" "y"). ())(("" "" "") ("" "" "") ("" "" "")))
((("b" "v" "y"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("p" "n" "y"). ())(("" "" "ˎ") ("" "" "") ("" "" "")))
((("f" "y"). ())(("" "" "") ("" "" "")))
((("v" "y"). ())(("" "" "") ("" "" "")))
((("t" "w" "y"). ())(("" "" "") ("" "" "") ("" "" "")))
((("d" "b" "y"). ())(("" "" "Î") ("" "" "") ("" "" "")))
((("w" "m" "y"). ())(("" "" "") ("" "" "") ("" "" "")))

))


(define ja-act-rule (append ja-act-rule-basic (filter (lambda (x) (not (ichar-alphabetic? (string->charcode (caaar x))))) ja-rk-rule-basic)))

(define ja-act-skk-okuri-char-alist '(("c" . "k") ("'" . "t") (";" . "a") ("q" . "o") ("j" . "e") ("k" . "u") ("x" . "i")))
(define ja-act-skk-downcase-alist (alist->icharlist '(("\"" . "'") (":" . ";"))))
(define ja-act-skk-set-henkan-point-key (map string->charcode '("'" ";" "q" "j" "k" "x")))


