//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/devcenter/armdevcenter"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// AttachedNetworksServer is a fake server for instances of the armdevcenter.AttachedNetworksClient type.
type AttachedNetworksServer struct {
	// BeginCreateOrUpdate is the fake for method AttachedNetworksClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, devCenterName string, attachedNetworkConnectionName string, body armdevcenter.AttachedNetworkConnection, options *armdevcenter.AttachedNetworksClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armdevcenter.AttachedNetworksClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method AttachedNetworksClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, devCenterName string, attachedNetworkConnectionName string, options *armdevcenter.AttachedNetworksClientBeginDeleteOptions) (resp azfake.PollerResponder[armdevcenter.AttachedNetworksClientDeleteResponse], errResp azfake.ErrorResponder)

	// GetByDevCenter is the fake for method AttachedNetworksClient.GetByDevCenter
	// HTTP status codes to indicate success: http.StatusOK
	GetByDevCenter func(ctx context.Context, resourceGroupName string, devCenterName string, attachedNetworkConnectionName string, options *armdevcenter.AttachedNetworksClientGetByDevCenterOptions) (resp azfake.Responder[armdevcenter.AttachedNetworksClientGetByDevCenterResponse], errResp azfake.ErrorResponder)

	// GetByProject is the fake for method AttachedNetworksClient.GetByProject
	// HTTP status codes to indicate success: http.StatusOK
	GetByProject func(ctx context.Context, resourceGroupName string, projectName string, attachedNetworkConnectionName string, options *armdevcenter.AttachedNetworksClientGetByProjectOptions) (resp azfake.Responder[armdevcenter.AttachedNetworksClientGetByProjectResponse], errResp azfake.ErrorResponder)

	// NewListByDevCenterPager is the fake for method AttachedNetworksClient.NewListByDevCenterPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDevCenterPager func(resourceGroupName string, devCenterName string, options *armdevcenter.AttachedNetworksClientListByDevCenterOptions) (resp azfake.PagerResponder[armdevcenter.AttachedNetworksClientListByDevCenterResponse])

	// NewListByProjectPager is the fake for method AttachedNetworksClient.NewListByProjectPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByProjectPager func(resourceGroupName string, projectName string, options *armdevcenter.AttachedNetworksClientListByProjectOptions) (resp azfake.PagerResponder[armdevcenter.AttachedNetworksClientListByProjectResponse])
}

// NewAttachedNetworksServerTransport creates a new instance of AttachedNetworksServerTransport with the provided implementation.
// The returned AttachedNetworksServerTransport instance is connected to an instance of armdevcenter.AttachedNetworksClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAttachedNetworksServerTransport(srv *AttachedNetworksServer) *AttachedNetworksServerTransport {
	return &AttachedNetworksServerTransport{
		srv:                     srv,
		beginCreateOrUpdate:     newTracker[azfake.PollerResponder[armdevcenter.AttachedNetworksClientCreateOrUpdateResponse]](),
		beginDelete:             newTracker[azfake.PollerResponder[armdevcenter.AttachedNetworksClientDeleteResponse]](),
		newListByDevCenterPager: newTracker[azfake.PagerResponder[armdevcenter.AttachedNetworksClientListByDevCenterResponse]](),
		newListByProjectPager:   newTracker[azfake.PagerResponder[armdevcenter.AttachedNetworksClientListByProjectResponse]](),
	}
}

// AttachedNetworksServerTransport connects instances of armdevcenter.AttachedNetworksClient to instances of AttachedNetworksServer.
// Don't use this type directly, use NewAttachedNetworksServerTransport instead.
type AttachedNetworksServerTransport struct {
	srv                     *AttachedNetworksServer
	beginCreateOrUpdate     *tracker[azfake.PollerResponder[armdevcenter.AttachedNetworksClientCreateOrUpdateResponse]]
	beginDelete             *tracker[azfake.PollerResponder[armdevcenter.AttachedNetworksClientDeleteResponse]]
	newListByDevCenterPager *tracker[azfake.PagerResponder[armdevcenter.AttachedNetworksClientListByDevCenterResponse]]
	newListByProjectPager   *tracker[azfake.PagerResponder[armdevcenter.AttachedNetworksClientListByProjectResponse]]
}

// Do implements the policy.Transporter interface for AttachedNetworksServerTransport.
func (a *AttachedNetworksServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AttachedNetworksClient.BeginCreateOrUpdate":
		resp, err = a.dispatchBeginCreateOrUpdate(req)
	case "AttachedNetworksClient.BeginDelete":
		resp, err = a.dispatchBeginDelete(req)
	case "AttachedNetworksClient.GetByDevCenter":
		resp, err = a.dispatchGetByDevCenter(req)
	case "AttachedNetworksClient.GetByProject":
		resp, err = a.dispatchGetByProject(req)
	case "AttachedNetworksClient.NewListByDevCenterPager":
		resp, err = a.dispatchNewListByDevCenterPager(req)
	case "AttachedNetworksClient.NewListByProjectPager":
		resp, err = a.dispatchNewListByProjectPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AttachedNetworksServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := a.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/devcenters/(?P<devCenterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/attachednetworks/(?P<attachedNetworkConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armdevcenter.AttachedNetworkConnection](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		devCenterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("devCenterName")])
		if err != nil {
			return nil, err
		}
		attachedNetworkConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("attachedNetworkConnectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, devCenterNameParam, attachedNetworkConnectionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		a.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusCreated}, resp.StatusCode) {
		a.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		a.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (a *AttachedNetworksServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if a.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := a.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/devcenters/(?P<devCenterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/attachednetworks/(?P<attachedNetworkConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		devCenterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("devCenterName")])
		if err != nil {
			return nil, err
		}
		attachedNetworkConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("attachedNetworkConnectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginDelete(req.Context(), resourceGroupNameParam, devCenterNameParam, attachedNetworkConnectionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		a.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		a.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		a.beginDelete.remove(req)
	}

	return resp, nil
}

func (a *AttachedNetworksServerTransport) dispatchGetByDevCenter(req *http.Request) (*http.Response, error) {
	if a.srv.GetByDevCenter == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByDevCenter not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/devcenters/(?P<devCenterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/attachednetworks/(?P<attachedNetworkConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	devCenterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("devCenterName")])
	if err != nil {
		return nil, err
	}
	attachedNetworkConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("attachedNetworkConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.GetByDevCenter(req.Context(), resourceGroupNameParam, devCenterNameParam, attachedNetworkConnectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AttachedNetworkConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AttachedNetworksServerTransport) dispatchGetByProject(req *http.Request) (*http.Response, error) {
	if a.srv.GetByProject == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByProject not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/projects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/attachednetworks/(?P<attachedNetworkConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
	if err != nil {
		return nil, err
	}
	attachedNetworkConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("attachedNetworkConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.GetByProject(req.Context(), resourceGroupNameParam, projectNameParam, attachedNetworkConnectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AttachedNetworkConnection, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AttachedNetworksServerTransport) dispatchNewListByDevCenterPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListByDevCenterPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDevCenterPager not implemented")}
	}
	newListByDevCenterPager := a.newListByDevCenterPager.get(req)
	if newListByDevCenterPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/devcenters/(?P<devCenterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/attachednetworks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		devCenterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("devCenterName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armdevcenter.AttachedNetworksClientListByDevCenterOptions
		if topParam != nil {
			options = &armdevcenter.AttachedNetworksClientListByDevCenterOptions{
				Top: topParam,
			}
		}
		resp := a.srv.NewListByDevCenterPager(resourceGroupNameParam, devCenterNameParam, options)
		newListByDevCenterPager = &resp
		a.newListByDevCenterPager.add(req, newListByDevCenterPager)
		server.PagerResponderInjectNextLinks(newListByDevCenterPager, req, func(page *armdevcenter.AttachedNetworksClientListByDevCenterResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDevCenterPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListByDevCenterPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDevCenterPager) {
		a.newListByDevCenterPager.remove(req)
	}
	return resp, nil
}

func (a *AttachedNetworksServerTransport) dispatchNewListByProjectPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListByProjectPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByProjectPager not implemented")}
	}
	newListByProjectPager := a.newListByProjectPager.get(req)
	if newListByProjectPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/projects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/attachednetworks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armdevcenter.AttachedNetworksClientListByProjectOptions
		if topParam != nil {
			options = &armdevcenter.AttachedNetworksClientListByProjectOptions{
				Top: topParam,
			}
		}
		resp := a.srv.NewListByProjectPager(resourceGroupNameParam, projectNameParam, options)
		newListByProjectPager = &resp
		a.newListByProjectPager.add(req, newListByProjectPager)
		server.PagerResponderInjectNextLinks(newListByProjectPager, req, func(page *armdevcenter.AttachedNetworksClientListByProjectResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByProjectPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListByProjectPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByProjectPager) {
		a.newListByProjectPager.remove(req)
	}
	return resp, nil
}
