//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdevcenter

import "time"

// AllowedEnvironmentType - Represents an allowed environment type.
type AllowedEnvironmentType struct {
	// Properties of an allowed environment type.
	Properties *AllowedEnvironmentTypeProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AllowedEnvironmentTypeListResult - Result of the allowed environment type list operation.
type AllowedEnvironmentTypeListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string

	// READ-ONLY; Current page of results.
	Value []*AllowedEnvironmentType
}

// AllowedEnvironmentTypeProperties - Properties of an allowed environment type.
type AllowedEnvironmentTypeProperties struct {
	// READ-ONLY; The display name of the allowed environment type.
	DisplayName *string

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// AttachedNetworkConnection - Represents an attached NetworkConnection.
type AttachedNetworkConnection struct {
	// Attached NetworkConnection properties.
	Properties *AttachedNetworkConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AttachedNetworkConnectionProperties - Properties of an attached NetworkConnection.
type AttachedNetworkConnectionProperties struct {
	// REQUIRED; The resource ID of the NetworkConnection you want to attach.
	NetworkConnectionID *string

	// READ-ONLY; AAD Join type of the network. This is populated based on the referenced Network Connection.
	DomainJoinType *DomainJoinType

	// READ-ONLY; Health check status values
	HealthCheckStatus *HealthCheckStatus

	// READ-ONLY; The geo-location where the NetworkConnection resource specified in 'networkConnectionResourceId' property lives.
	NetworkConnectionLocation *string

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// AttachedNetworkListResult - Results of the Attached Networks list operation.
type AttachedNetworkListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string

	// READ-ONLY; Current page of results.
	Value []*AttachedNetworkConnection
}

// Capability - A name/value pair to describe a capability.
type Capability struct {
	// READ-ONLY; Name of the capability.
	Name *string

	// READ-ONLY; Value of the capability.
	Value *string
}

// Catalog - Represents a catalog.
type Catalog struct {
	// Catalog properties.
	Properties *CatalogProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CatalogConflictError - An individual conflict error.
type CatalogConflictError struct {
	// READ-ONLY; Name of the conflicting catalog item.
	Name *string

	// READ-ONLY; The path of the file that has a conflicting name.
	Path *string
}

// CatalogErrorDetails - Catalog error details
type CatalogErrorDetails struct {
	// An identifier for the error.
	Code *string

	// A message describing the error.
	Message *string
}

// CatalogListResult - Results of the catalog list operation.
type CatalogListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string

	// READ-ONLY; Current page of results.
	Value []*Catalog
}

// CatalogProperties - Properties of a catalog.
type CatalogProperties struct {
	// Properties for an Azure DevOps catalog type.
	AdoGit *GitCatalog

	// Properties for a GitHub catalog type.
	GitHub *GitCatalog

	// Indicates the type of sync that is configured for the catalog.
	SyncType *CatalogSyncType

	// READ-ONLY; The connection state of the catalog.
	ConnectionState *CatalogConnectionState

	// READ-ONLY; When the catalog was last connected.
	LastConnectionTime *time.Time

	// READ-ONLY; Stats of the latest synchronization.
	LastSyncStats *SyncStats

	// READ-ONLY; When the catalog was last synced.
	LastSyncTime *time.Time

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The synchronization state of the catalog.
	SyncState *CatalogSyncState
}

// CatalogResourceValidationErrorDetails - List of validator error details. Populated when changes are made to the resource
// or its dependent resources that impact the validity of the Catalog resource.
type CatalogResourceValidationErrorDetails struct {
	// READ-ONLY; Errors associated with resources synchronized from the catalog.
	Errors []*CatalogErrorDetails
}

// CatalogSyncError - An individual synchronization error.
type CatalogSyncError struct {
	// READ-ONLY; Errors associated with the file.
	ErrorDetails []*CatalogErrorDetails

	// READ-ONLY; The path of the file the error is associated with.
	Path *string
}

// CatalogUpdate - The catalog's properties for partial update. Properties not provided in the update request will not be
// changed.
type CatalogUpdate struct {
	// Catalog properties for update.
	Properties *CatalogUpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// CatalogUpdateProperties - Properties of a catalog. These properties can be updated after the resource has been created.
type CatalogUpdateProperties struct {
	// Properties for an Azure DevOps catalog type.
	AdoGit *GitCatalog

	// Properties for a GitHub catalog type.
	GitHub *GitCatalog

	// Indicates the type of sync that is configured for the catalog.
	SyncType *CatalogSyncType
}

// CheckNameAvailabilityRequest - The check availability request body.
type CheckNameAvailabilityRequest struct {
	// The name of the resource for which availability needs to be checked.
	Name *string

	// The resource type.
	Type *string
}

// CheckNameAvailabilityResponse - The check availability result.
type CheckNameAvailabilityResponse struct {
	// Detailed reason why the given name is available.
	Message *string

	// Indicates if the resource name is available.
	NameAvailable *bool

	// The reason why the given name is not available.
	Reason *CheckNameAvailabilityReason
}

// CustomerManagedKeyEncryption - All Customer-managed key encryption properties for the resource.
type CustomerManagedKeyEncryption struct {
	// All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
	KeyEncryptionKeyIdentity *CustomerManagedKeyEncryptionKeyIdentity

	// key encryption key Url, versioned or non-versioned. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78
	// or https://contosovault.vault.azure.net/keys/contosokek.
	KeyEncryptionKeyURL *string
}

// CustomerManagedKeyEncryptionKeyIdentity - All identity configuration for Customer-managed key settings defining which identity
// should be used to auth to Key Vault.
type CustomerManagedKeyEncryptionKeyIdentity struct {
	// delegated identity to use for accessing key encryption key Url. Ex: /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups//providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId.
	// Mutually exclusive with identityType systemAssignedIdentity and userAssignedIdentity - internal use only.
	DelegatedIdentityClientID *string

	// Values can be systemAssignedIdentity or userAssignedIdentity
	IdentityType *IdentityType

	// user assigned identity to use for accessing key encryption key Url. Ex: /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/
	// /providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId. Mutually exclusive with identityType systemAssignedIdentity
	// and delegatedResourceIdentity.
	UserAssignedIdentityResourceID *string
}

// CustomizationTask - Represents a Task to be used in customizing a Dev Box.
type CustomizationTask struct {
	// Task properties
	Properties *CustomizationTaskProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CustomizationTaskInput - Input for a Task.
type CustomizationTaskInput struct {
	// READ-ONLY; Description of the input.
	Description *string

	// READ-ONLY; Whether or not the input is required.
	Required *bool

	// READ-ONLY; Type of the input.
	Type *CustomizationTaskInputType
}

// CustomizationTaskListResult - Results of the Task list operation.
type CustomizationTaskListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string

	// READ-ONLY; Current page of results.
	Value []*CustomizationTask
}

// CustomizationTaskProperties - Properties of a Task.
type CustomizationTaskProperties struct {
	// READ-ONLY; Inputs to the task.
	Inputs map[string]*CustomizationTaskInput

	// READ-ONLY; The default timeout for the task.
	Timeout *int32

	// READ-ONLY; Validation status for the Task.
	ValidationStatus *CatalogResourceValidationStatus
}

// DevBoxDefinition - Represents a definition for a Developer Machine.
type DevBoxDefinition struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Dev Box definition properties
	Properties *DevBoxDefinitionProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DevBoxDefinitionListResult - Results of the Dev Box definition list operation.
type DevBoxDefinitionListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string

	// READ-ONLY; Current page of results.
	Value []*DevBoxDefinition
}

// DevBoxDefinitionProperties - Properties of a Dev Box definition.
type DevBoxDefinitionProperties struct {
	// Indicates whether Dev Boxes created with this definition are capable of hibernation. Not all images are capable of supporting
	// hibernation. To find out more see https://aka.ms/devbox/hibernate
	HibernateSupport *HibernateSupport

	// Image reference information.
	ImageReference *ImageReference

	// The storage type used for the Operating System disk of Dev Boxes created using this definition.
	OSStorageType *string

	// The SKU for Dev Boxes created using this definition.
	SKU *SKU

	// READ-ONLY; Image reference information for the currently active image (only populated during updates).
	ActiveImageReference *ImageReference

	// READ-ONLY; Details for image validator error. Populated when the image validation is not successful.
	ImageValidationErrorDetails *ImageValidationErrorDetails

	// READ-ONLY; Validation status of the configured image.
	ImageValidationStatus *ImageValidationStatus

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Validation status for the Dev Box Definition.
	ValidationStatus *CatalogResourceValidationStatus
}

// DevBoxDefinitionUpdate - Partial update of a Dev Box definition resource.
type DevBoxDefinitionUpdate struct {
	// The geo-location where the resource lives
	Location *string

	// Properties of a Dev Box definition to be updated.
	Properties *DevBoxDefinitionUpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// DevBoxDefinitionUpdateProperties - Properties of a Dev Box definition. These properties can be updated after the resource
// has been created.
type DevBoxDefinitionUpdateProperties struct {
	// Indicates whether Dev Boxes created with this definition are capable of hibernation. Not all images are capable of supporting
	// hibernation. To find out more see https://aka.ms/devbox/hibernate
	HibernateSupport *HibernateSupport

	// Image reference information.
	ImageReference *ImageReference

	// The storage type used for the Operating System disk of Dev Boxes created using this definition.
	OSStorageType *string

	// The SKU for Dev Boxes created using this definition.
	SKU *SKU
}

// DevCenter - Represents a devcenter resource.
type DevCenter struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Managed identity properties
	Identity *ManagedServiceIdentity

	// DevCenter properties
	Properties *Properties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type Encryption struct {
	// All Customer-managed key encryption properties for the resource.
	CustomerManagedKeyEncryption *CustomerManagedKeyEncryption
}

// EndpointDependency - A domain name and connection details used to access a dependency.
type EndpointDependency struct {
	// READ-ONLY; Human-readable supplemental information about the dependency and when it is applicable.
	Description *string

	// READ-ONLY; The domain name of the dependency. Domain names may be fully qualified or may contain a * wildcard.
	DomainName *string

	// READ-ONLY; The list of connection details for this endpoint.
	EndpointDetails []*EndpointDetail
}

// EndpointDetail - Details about the connection between the Batch service and the endpoint.
type EndpointDetail struct {
	// READ-ONLY; The port an endpoint is connected to.
	Port *int32
}

// EnvironmentDefinition - Represents an environment definition catalog item.
type EnvironmentDefinition struct {
	// Environment definition properties.
	Properties *EnvironmentDefinitionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// EnvironmentDefinitionListResult - Results of the environment definition list operation.
type EnvironmentDefinitionListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string

	// READ-ONLY; Current page of results.
	Value []*EnvironmentDefinition
}

// EnvironmentDefinitionParameter - Properties of an Environment Definition parameter
type EnvironmentDefinitionParameter struct {
	// READ-ONLY; Description of the parameter
	Description *string

	// READ-ONLY; Unique ID of the parameter
	ID *string

	// READ-ONLY; Display name of the parameter
	Name *string

	// READ-ONLY; Whether or not this parameter is read-only. If true, default should have a value.
	ReadOnly *bool

	// READ-ONLY; Whether or not this parameter is required
	Required *bool

	// READ-ONLY; A string of one of the basic JSON types (number, integer, array, object, boolean, string)
	Type *ParameterType
}

// EnvironmentDefinitionProperties - Properties of an environment definition.
type EnvironmentDefinitionProperties struct {
	// READ-ONLY; A short description of the environment definition.
	Description *string

	// READ-ONLY; Input parameters passed to an environment.
	Parameters []*EnvironmentDefinitionParameter

	// READ-ONLY; Path to the Environment Definition entrypoint file.
	TemplatePath *string

	// READ-ONLY; Validation status for the environment definition.
	ValidationStatus *CatalogResourceValidationStatus
}

// EnvironmentRole - A role that can be assigned to a user.
type EnvironmentRole struct {
	// READ-ONLY; This is a description of the Role Assignment.
	Description *string

	// READ-ONLY; The common name of the Role Assignment. This is a descriptive name such as 'AcrPush'.
	RoleName *string
}

// EnvironmentType - Represents an environment type.
type EnvironmentType struct {
	// Properties of an environment type.
	Properties *EnvironmentTypeProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// EnvironmentTypeListResult - Result of the environment type list operation.
type EnvironmentTypeListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string

	// READ-ONLY; Current page of results.
	Value []*EnvironmentType
}

// EnvironmentTypeProperties - Properties of an environment type.
type EnvironmentTypeProperties struct {
	// The display name of the environment type.
	DisplayName *string

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// EnvironmentTypeUpdate - The environment type for partial update. Properties not provided in the update request will not
// be changed.
type EnvironmentTypeUpdate struct {
	// Properties of an environment type to be updated.
	Properties *EnvironmentTypeUpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// EnvironmentTypeUpdateProperties - Properties of an environment type. These properties can be updated after the resource
// has been created.
type EnvironmentTypeUpdateProperties struct {
	// The display name of the environment type.
	DisplayName *string
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// Gallery - Represents a gallery.
type Gallery struct {
	// Gallery properties.
	Properties *GalleryProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GalleryListResult - Results of the gallery list operation.
type GalleryListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string

	// READ-ONLY; Current page of results.
	Value []*Gallery
}

// GalleryProperties - Properties of a gallery.
type GalleryProperties struct {
	// REQUIRED; The resource ID of the backing Azure Compute Gallery.
	GalleryResourceID *string

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// GitCatalog - Properties for a Git repository catalog.
type GitCatalog struct {
	// Git branch.
	Branch *string

	// The folder where the catalog items can be found inside the repository.
	Path *string

	// A reference to the Key Vault secret containing a security token to authenticate to a Git repository.
	SecretIdentifier *string

	// Git URI.
	URI *string
}

// HealthCheck - An individual health check item
type HealthCheck struct {
	// READ-ONLY; Additional details about the health check or the recommended action.
	AdditionalDetails *string

	// READ-ONLY; The display name of this health check item.
	DisplayName *string

	// READ-ONLY; End time of the health check item.
	EndDateTime *time.Time

	// READ-ONLY; The type of error that occurred during this health check.
	ErrorType *string

	// READ-ONLY; The recommended action to fix the corresponding error.
	RecommendedAction *string

	// READ-ONLY; Start time of health check item.
	StartDateTime *time.Time

	// READ-ONLY; The status of the health check item.
	Status *HealthCheckStatus
}

// HealthCheckStatusDetails - Health Check details.
type HealthCheckStatusDetails struct {
	// Health check status details properties.
	Properties *HealthCheckStatusDetailsProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// HealthCheckStatusDetailsListResult - Result of the network health check list operation.
type HealthCheckStatusDetailsListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string

	// READ-ONLY; Current page of results.
	Value []*HealthCheckStatusDetails
}

// HealthCheckStatusDetailsProperties - Health Check properties.
type HealthCheckStatusDetailsProperties struct {
	// READ-ONLY; End time of last execution of the health checks.
	EndDateTime *time.Time

	// READ-ONLY; Details for each health check item.
	HealthChecks []*HealthCheck

	// READ-ONLY; Start time of last execution of the health checks.
	StartDateTime *time.Time
}

// HealthStatusDetail - Pool health status detail.
type HealthStatusDetail struct {
	// READ-ONLY; An identifier for the issue.
	Code *string

	// READ-ONLY; A message describing the issue, intended to be suitable for display in a user interface
	Message *string
}

// Image - Represents an image.
type Image struct {
	// Image properties.
	Properties *ImageProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ImageListResult - Results of the image list operation.
type ImageListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string

	// READ-ONLY; Current page of results.
	Value []*Image
}

// ImageProperties - Properties of an image.
type ImageProperties struct {
	// READ-ONLY; The description of the image.
	Description *string

	// READ-ONLY; Indicates whether this image has hibernate enabled. Not all images are capable of supporting hibernation. To
	// find out more see https://aka.ms/devbox/hibernate
	HibernateSupport *HibernateSupport

	// READ-ONLY; The name of the image offer.
	Offer *string

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The publisher of the image.
	Publisher *string

	// READ-ONLY; The recommended machine configuration to use with the image.
	RecommendedMachineConfiguration *RecommendedMachineConfiguration

	// READ-ONLY; The SKU name for the image.
	SKU *string
}

// ImageReference - Image reference information
type ImageReference struct {
	// Image ID, or Image version ID. When Image ID is provided, its latest version will be used.
	ID *string

	// READ-ONLY; The actual version of the image after use. When id references a gallery image latest version, this will indicate
	// the actual version in use.
	ExactVersion *string
}

// ImageValidationErrorDetails - Image validation error details
type ImageValidationErrorDetails struct {
	// An identifier for the error.
	Code *string

	// A message describing the error.
	Message *string
}

// ImageVersion - Represents an image version.
type ImageVersion struct {
	// Image version properties.
	Properties *ImageVersionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ImageVersionListResult - Results of the image version list operation.
type ImageVersionListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string

	// READ-ONLY; Current page of results.
	Value []*ImageVersion
}

// ImageVersionProperties - Properties of an image version.
type ImageVersionProperties struct {
	// READ-ONLY; If the version should be excluded from being treated as the latest version.
	ExcludeFromLatest *bool

	// READ-ONLY; The semantic version string.
	Name *string

	// READ-ONLY; The size of the OS disk image, in GB.
	OSDiskImageSizeInGb *int32

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The datetime that the backing image version was published.
	PublishedDate *time.Time
}

// ListResult - Result of the list devcenters operation
type ListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string

	// READ-ONLY; Current page of results.
	Value []*DevCenter
}

// ListUsagesResult - List of Core Usages.
type ListUsagesResult struct {
	// READ-ONLY; The link to get the next page of Usage result.
	NextLink *string

	// READ-ONLY; The array page of Usages.
	Value []*Usage
}

// ManagedServiceIdentity - Managed service identity (system assigned and/or user assigned identities)
type ManagedServiceIdentity struct {
	// REQUIRED; Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
	Type *ManagedServiceIdentityType

	// The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
	// The dictionary values can be empty objects ({}) in
	// requests.
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string
}

// NetworkConnection - Network related settings
type NetworkConnection struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Properties of a Network Connection
	Properties *NetworkProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NetworkConnectionListResult - Result of the network connection list operation.
type NetworkConnectionListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string

	// READ-ONLY; Current page of results.
	Value []*NetworkConnection
}

// NetworkConnectionUpdate - The network connection properties for partial update. Properties not provided in the update request
// will not be changed.
type NetworkConnectionUpdate struct {
	// The geo-location where the resource lives
	Location *string

	// Properties of a network connection resource to be updated.
	Properties *NetworkConnectionUpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// NetworkConnectionUpdateProperties - Properties of network connection. These properties can be updated after the resource
// has been created.
type NetworkConnectionUpdateProperties struct {
	// Active Directory domain name
	DomainName *string

	// The password for the account used to join domain
	DomainPassword *string

	// The username of an Active Directory account (user or service account) that has permissions to create computer objects in
	// Active Directory. Required format: admin@contoso.com.
	DomainUsername *string

	// Active Directory domain Organization Unit (OU)
	OrganizationUnit *string

	// The subnet to attach Virtual Machines to
	SubnetID *string
}

// NetworkProperties - Network properties
type NetworkProperties struct {
	// REQUIRED; AAD Join type.
	DomainJoinType *DomainJoinType

	// Active Directory domain name
	DomainName *string

	// The password for the account used to join domain
	DomainPassword *string

	// The username of an Active Directory account (user or service account) that has permissions to create computer objects in
	// Active Directory. Required format: admin@contoso.com.
	DomainUsername *string

	// The name for resource group where NICs will be placed.
	NetworkingResourceGroupName *string

	// Active Directory domain Organization Unit (OU)
	OrganizationUnit *string

	// The subnet to attach Virtual Machines to
	SubnetID *string

	// READ-ONLY; Overall health status of the network connection. Health checks are run on creation, update, and periodically
	// to validate the network connection.
	HealthCheckStatus *HealthCheckStatus

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// OperationStatus - The current status of an async operation
type OperationStatus struct {
	// REQUIRED; Operation status.
	Status *string

	// The end time of the operation.
	EndTime *time.Time

	// If present, details of the operation error.
	Error *ErrorDetail

	// Fully qualified ID for the async operation.
	ID *string

	// Name of the async operation.
	Name *string

	// The operations list.
	Operations []*OperationStatusResult

	// Percent of the operation that is complete.
	PercentComplete *float32

	// The start time of the operation.
	StartTime *time.Time

	// READ-ONLY; Custom operation properties, populated only for a successful operation.
	Properties any

	// READ-ONLY; The id of the resource.
	ResourceID *string
}

// OperationStatusResult - The current status of an async operation.
type OperationStatusResult struct {
	// REQUIRED; Operation status.
	Status *string

	// The end time of the operation.
	EndTime *time.Time

	// If present, details of the operation error.
	Error *ErrorDetail

	// Fully qualified ID for the async operation.
	ID *string

	// Name of the async operation.
	Name *string

	// The operations list.
	Operations []*OperationStatusResult

	// Percent of the operation that is complete.
	PercentComplete *float32

	// The start time of the operation.
	StartTime *time.Time
}

// OutboundEnvironmentEndpoint - A collection of related endpoints from the same service for which the agent requires outbound
// access.
type OutboundEnvironmentEndpoint struct {
	// READ-ONLY; The type of service that the agent connects to.
	Category *string

	// READ-ONLY; The endpoints for this service for which the agent requires outbound access.
	Endpoints []*EndpointDependency
}

// OutboundEnvironmentEndpointCollection - Values returned by the List operation.
type OutboundEnvironmentEndpointCollection struct {
	// The continuation token.
	NextLink *string

	// READ-ONLY; The collection of outbound network dependency endpoints returned by the listing operation.
	Value []*OutboundEnvironmentEndpoint
}

// Pool - A pool of Virtual Machines.
type Pool struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Pool properties
	Properties *PoolProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PoolListResult - Results of the machine pool list operation.
type PoolListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string

	// READ-ONLY; Current page of results.
	Value []*Pool
}

// PoolProperties - Properties of a Pool
type PoolProperties struct {
	// Name of a Dev Box definition in parent Project of this Pool
	DevBoxDefinitionName *string

	// The display name of the pool.
	DisplayName *string

	// Specifies the license type indicating the caller has already acquired licenses for the Dev Boxes that will be created.
	LicenseType *LicenseType

	// Indicates whether owners of Dev Boxes in this pool are added as local administrators on the Dev Box.
	LocalAdministrator *LocalAdminStatus

	// The regions of the managed virtual network (required when managedNetworkType is Managed).
	ManagedVirtualNetworkRegions []*string

	// Name of a Network Connection in parent Project of this Pool
	NetworkConnectionName *string

	// Indicates whether Dev Boxes in this pool are created with single sign on enabled. The also requires that single sign on
	// be enabled on the tenant.
	SingleSignOnStatus *SingleSignOnStatus

	// Stop on disconnect configuration settings for Dev Boxes created in this pool.
	StopOnDisconnect *StopOnDisconnectConfiguration

	// Indicates whether the pool uses a Virtual Network managed by Microsoft or a customer provided network.
	VirtualNetworkType *VirtualNetworkType

	// READ-ONLY; Indicates the number of provisioned Dev Boxes in this pool.
	DevBoxCount *int32

	// READ-ONLY; Overall health status of the Pool. Indicates whether or not the Pool is available to create Dev Boxes.
	HealthStatus *HealthStatus

	// READ-ONLY; Details on the Pool health status to help diagnose issues. This is only populated when the pool status indicates
	// the pool is in a non-healthy state
	HealthStatusDetails []*HealthStatusDetail

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// PoolUpdate - The pool properties for partial update. Properties not provided in the update request will not be changed.
type PoolUpdate struct {
	// The geo-location where the resource lives
	Location *string

	// Properties of a pool to be updated.
	Properties *PoolUpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// PoolUpdateProperties - Properties of a Pool. These properties can be updated after the resource has been created.
type PoolUpdateProperties struct {
	// Name of a Dev Box definition in parent Project of this Pool
	DevBoxDefinitionName *string

	// The display name of the pool.
	DisplayName *string

	// Specifies the license type indicating the caller has already acquired licenses for the Dev Boxes that will be created.
	LicenseType *LicenseType

	// Indicates whether owners of Dev Boxes in this pool are added as local administrators on the Dev Box.
	LocalAdministrator *LocalAdminStatus

	// The regions of the managed virtual network (required when managedNetworkType is Managed).
	ManagedVirtualNetworkRegions []*string

	// Name of a Network Connection in parent Project of this Pool
	NetworkConnectionName *string

	// Indicates whether Dev Boxes in this pool are created with single sign on enabled. The also requires that single sign on
	// be enabled on the tenant.
	SingleSignOnStatus *SingleSignOnStatus

	// Stop on disconnect configuration settings for Dev Boxes created in this pool.
	StopOnDisconnect *StopOnDisconnectConfiguration

	// Indicates whether the pool uses a Virtual Network managed by Microsoft or a customer provided network.
	VirtualNetworkType *VirtualNetworkType
}

// Project - Represents a project resource.
type Project struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Properties of a project.
	Properties *ProjectProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ProjectEnvironmentType - Represents an environment type.
type ProjectEnvironmentType struct {
	// Managed identity properties
	Identity *ManagedServiceIdentity

	// The geo-location for the environment type
	Location *string

	// Properties of an environment type.
	Properties *ProjectEnvironmentTypeProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ProjectEnvironmentTypeListResult - Result of the project environment type list operation.
type ProjectEnvironmentTypeListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string

	// READ-ONLY; Current page of results.
	Value []*ProjectEnvironmentType
}

// ProjectEnvironmentTypeProperties - Properties of a project environment type.
type ProjectEnvironmentTypeProperties struct {
	// The role definition assigned to the environment creator on backing resources.
	CreatorRoleAssignment *ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment

	// Id of a subscription that the environment type will be mapped to. The environment's resources will be deployed into this
	// subscription.
	DeploymentTargetID *string

	// The display name of the project environment type.
	DisplayName *string

	// Defines whether this Environment Type can be used in this Project.
	Status *EnvironmentTypeEnableStatus

	// Role Assignments created on environment backing resources. This is a mapping from a user object ID to an object of role
	// definition IDs.
	UserRoleAssignments map[string]*UserRoleAssignmentValue

	// READ-ONLY; The number of environments of this type.
	EnvironmentCount *int32

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// ProjectEnvironmentTypeUpdate - The project environment type for partial update. Properties not provided in the update request
// will not be changed.
type ProjectEnvironmentTypeUpdate struct {
	// Managed identity properties
	Identity *ManagedServiceIdentity

	// Properties to configure an environment type.
	Properties *ProjectEnvironmentTypeUpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// ProjectEnvironmentTypeUpdateProperties - Properties of a project environment type. These properties can be updated after
// the resource has been created.
type ProjectEnvironmentTypeUpdateProperties struct {
	// The role definition assigned to the environment creator on backing resources.
	CreatorRoleAssignment *ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment

	// Id of a subscription that the environment type will be mapped to. The environment's resources will be deployed into this
	// subscription.
	DeploymentTargetID *string

	// Defines whether this Environment Type can be used in this Project.
	Status *EnvironmentTypeEnableStatus

	// Role Assignments created on environment backing resources. This is a mapping from a user object ID to an object of role
	// definition IDs.
	UserRoleAssignments map[string]*UserRoleAssignmentValue
}

// ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment - The role definition assigned to the environment creator on
// backing resources.
type ProjectEnvironmentTypeUpdatePropertiesCreatorRoleAssignment struct {
	// A map of roles to assign to the environment creator.
	Roles map[string]*EnvironmentRole
}

// ProjectListResult - Results of the project list operation.
type ProjectListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string

	// READ-ONLY; Current page of results.
	Value []*Project
}

// ProjectProperties - Properties of a project.
type ProjectProperties struct {
	// Description of the project.
	Description *string

	// Resource Id of an associated DevCenter
	DevCenterID *string

	// The display name of the project.
	DisplayName *string

	// When specified, limits the maximum number of Dev Boxes a single user can create across all pools in the project. This will
	// have no effect on existing Dev Boxes when reduced.
	MaxDevBoxesPerUser *int32

	// READ-ONLY; The URI of the Dev Center resource this project is associated with.
	DevCenterURI *string

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// ProjectUpdate - The project properties for partial update. Properties not provided in the update request will not be changed.
type ProjectUpdate struct {
	// The geo-location where the resource lives
	Location *string

	// Properties of a project to be updated.
	Properties *ProjectUpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// ProjectUpdateProperties - Properties of a project. These properties can be updated after the resource has been created.
type ProjectUpdateProperties struct {
	// Description of the project.
	Description *string

	// Resource Id of an associated DevCenter
	DevCenterID *string

	// The display name of the project.
	DisplayName *string

	// When specified, limits the maximum number of Dev Boxes a single user can create across all pools in the project. This will
	// have no effect on existing Dev Boxes when reduced.
	MaxDevBoxesPerUser *int32
}

// Properties of the devcenter.
type Properties struct {
	// The display name of the devcenter.
	DisplayName *string

	// Encryption settings to be used for server-side encryption for proprietary content (such as catalogs, logs, customizations).
	Encryption *Encryption

	// READ-ONLY; The URI of the Dev Center.
	DevCenterURI *string

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// RecommendedMachineConfiguration - Properties for a recommended machine configuration.
type RecommendedMachineConfiguration struct {
	// READ-ONLY; Recommended memory range.
	Memory *ResourceRange

	// READ-ONLY; Recommended vCPU range.
	VCPUs *ResourceRange
}

// ResourceRange - Properties for a range of values.
type ResourceRange struct {
	// READ-ONLY; Maximum value.
	Max *int32

	// READ-ONLY; Minimum value.
	Min *int32
}

// SKU - The resource model definition representing SKU
type SKU struct {
	// REQUIRED; The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string

	// If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the
	// resource this may be omitted.
	Capacity *int32

	// If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string

	// The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string

	// This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required
	// on a PUT.
	Tier *SKUTier
}

// SKUInfo - The resource model definition representing SKU for DevCenter resources
type SKUInfo struct {
	// REQUIRED; The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string

	// If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the
	// resource this may be omitted.
	Capacity *int32

	// If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string

	// The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string

	// This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required
	// on a PUT.
	Tier *SKUTier

	// READ-ONLY; Collection of name/value pairs to describe the SKU capabilities.
	Capabilities []*Capability

	// READ-ONLY; SKU supported locations.
	Locations []*string

	// READ-ONLY; The name of the resource type
	ResourceType *string
}

// SKUListResult - Results of the Microsoft.DevCenter SKU list operation.
type SKUListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string

	// READ-ONLY; Current page of results.
	Value []*SKUInfo
}

// Schedule - Represents a Schedule to execute a task.
type Schedule struct {
	// Properties of a Schedule resource
	Properties *ScheduleProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ScheduleListResult - Result of the schedule list operation.
type ScheduleListResult struct {
	// READ-ONLY; URL to get the next set of results if there are any.
	NextLink *string

	// READ-ONLY; Current page of results.
	Value []*Schedule
}

// ScheduleProperties - The Schedule properties defining when and what to execute.
type ScheduleProperties struct {
	// The frequency of this scheduled task.
	Frequency *ScheduledFrequency

	// Indicates whether or not this scheduled task is enabled.
	State *ScheduleEnableStatus

	// The target time to trigger the action. The format is HH:MM.
	Time *string

	// The IANA timezone id at which the schedule should execute.
	TimeZone *string

	// Supported type this scheduled task represents.
	Type *ScheduledType

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *ProvisioningState
}

// ScheduleUpdate - The schedule properties for partial update. Properties not provided in the update request will not be
// changed.
type ScheduleUpdate struct {
	// The geo-location where the resource lives
	Location *string

	// Properties of a schedule resource to be updated.
	Properties *ScheduleUpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// ScheduleUpdateProperties - Updatable properties of a Schedule.
type ScheduleUpdateProperties struct {
	// The frequency of this scheduled task.
	Frequency *ScheduledFrequency

	// Indicates whether or not this scheduled task is enabled.
	State *ScheduleEnableStatus

	// The target time to trigger the action. The format is HH:MM.
	Time *string

	// The IANA timezone id at which the schedule should execute.
	TimeZone *string

	// Supported type this scheduled task represents.
	Type *ScheduledType
}

// StopOnDisconnectConfiguration - Stop on disconnect configuration settings for Dev Boxes created in this pool.
type StopOnDisconnectConfiguration struct {
	// The specified time in minutes to wait before stopping a Dev Box once disconnect is detected.
	GracePeriodMinutes *int32

	// Whether the feature to stop the Dev Box on disconnect once the grace period has lapsed is enabled.
	Status *StopOnDisconnectEnableStatus
}

// SyncErrorDetails - Synchronization error details.
type SyncErrorDetails struct {
	// READ-ONLY; Catalog items that have conflicting names.
	Conflicts []*CatalogConflictError

	// READ-ONLY; Errors that occured during synchronization.
	Errors []*CatalogSyncError

	// READ-ONLY; Error information for the overall synchronization operation.
	OperationError *CatalogErrorDetails
}

// SyncStats - Stats of the synchronization.
type SyncStats struct {
	// READ-ONLY; Count of catalog items added during synchronization.
	Added *int32

	// READ-ONLY; Count of catalog items removed during synchronization.
	Removed *int32

	// READ-ONLY; Count of synchronization errors that occured during synchronization.
	SynchronizationErrors *int32

	// READ-ONLY; Count of catalog items that were unchanged during synchronization.
	Unchanged *int32

	// READ-ONLY; Count of catalog items updated during synchronization.
	Updated *int32

	// READ-ONLY; Count of catalog items that had validation errors during synchronization.
	ValidationErrors *int32
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// Update - The devcenter resource for partial updates. Properties not provided in the update request will not be changed.
type Update struct {
	// Managed identity properties
	Identity *ManagedServiceIdentity

	// The geo-location where the resource lives
	Location *string

	// Properties of a Dev Center to be updated.
	Properties *UpdateProperties

	// Resource tags.
	Tags map[string]*string
}

// UpdateProperties - Properties of the devcenter. These properties can be updated after the resource has been created.
type UpdateProperties struct {
	// The display name of the devcenter.
	DisplayName *string

	// Encryption settings to be used for server-side encryption for proprietary content (such as catalogs, logs, customizations).
	Encryption *Encryption
}

// Usage - The core usage details.
type Usage struct {
	// The current usage.
	CurrentValue *int64

	// The fully qualified arm resource id.
	ID *string

	// The limit integer.
	Limit *int64

	// The name.
	Name *UsageName

	// The unit details.
	Unit *UsageUnit
}

// UsageName - The Usage Names.
type UsageName struct {
	// The localized name of the resource.
	LocalizedValue *string

	// The name of the resource.
	Value *string
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string
}

// UserRoleAssignmentValue - Mapping of user object ID to role assignments.
type UserRoleAssignmentValue struct {
	// A map of roles to assign to the parent user.
	Roles map[string]*EnvironmentRole
}
